/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CustomizerDisplay
extends NbPropertyPanel.Single {
    private boolean noBundle;
    private JLabel category;
    private JComboBox categoryValue;
    private JPanel hackPanel;
    private JLabel longDesc;
    private JTextArea longDescValue;
    private JScrollPane longDescValueSP;
    private JLabel name;
    private JTextField nameValue;
    private JLabel shortDesc;
    private JTextField shortDescValue;

    CustomizerDisplay(SingleModuleProperties singleModuleProperties) {
        super(singleModuleProperties, CustomizerDisplay.class);
        this.initComponents();
        this.initAccesibility();
        this.refresh();
    }

    void refresh() {
        boolean bl = this.noBundle = this.getBundle() == null;
        if (this.noBundle) {
            this.nameValue.setEnabled(false);
            this.categoryValue.setEnabled(false);
            this.shortDescValue.setEnabled(false);
            this.longDescValue.setEnabled(false);
        } else {
            this.readFromProperties();
        }
    }

    protected void checkForm() {
        if (this.noBundle) {
            this.setWarning(CustomizerDisplay.getMessage("MSG_NoBundleForModule"));
        } else {
            this.setWarning(null);
        }
    }

    public void store() {
        if (!this.noBundle) {
            this.getBundle().setDisplayName(this.nameValue.getText());
            this.getBundle().setCategory(this.getSelectedCategory());
            this.getBundle().setShortDescription(this.shortDescValue.getText());
            this.getBundle().setLongDescription(this.longDescValue.getText());
        }
    }

    private LocalizedBundleInfo getBundle() {
        return this.getProperties().getBundleInfo();
    }

    private void readFromProperties() {
        UIUtil.setText(this.nameValue, this.getBundle().getDisplayName());
        UIUtil.setText(this.shortDescValue, this.getBundle().getShortDescription());
        this.longDescValue.setText(this.getBundle().getLongDescription());
        this.fillUpCategoryValue();
    }

    private void fillUpCategoryValue() {
        this.categoryValue.setEnabled(false);
        this.categoryValue.setModel(CustomizerComponentFactory.createComboWaitModel());
        this.categoryValue.setSelectedItem(CustomizerComponentFactory.WAIT_VALUE);
        ModuleProperties.RP.post(new Runnable(){

            public void run() {
                SortedSet sortedSet = CustomizerDisplay.this.getProperties().getModuleCategories();
                EventQueue.invokeLater(new Runnable(this, sortedSet){
                    private final /* synthetic */ SortedSet val$moduleCategories;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$moduleCategories = sortedSet;
                    }

                    public void run() {
                        DefaultComboBoxModel<E> defaultComboBoxModel = new DefaultComboBoxModel<E>();
                        CustomizerDisplay.access$100(1.access$000(this.this$1)).removeAllItems();
                        Iterator<E> iterator = this.val$moduleCategories.iterator();
                        while (iterator.hasNext()) {
                            defaultComboBoxModel.addElement(iterator.next());
                        }
                        if (!this.val$moduleCategories.contains(CustomizerDisplay.access$200(1.access$000(this.this$1)))) {
                            defaultComboBoxModel.insertElementAt(CustomizerDisplay.access$200(1.access$000(this.this$1)), 0);
                        }
                        CustomizerDisplay.access$100(1.access$000(this.this$1)).setModel(defaultComboBoxModel);
                        CustomizerDisplay.access$100(1.access$000(this.this$1)).setSelectedItem(CustomizerDisplay.access$200(1.access$000(this.this$1)));
                        CustomizerDisplay.access$100(1.access$000(this.this$1)).setEnabled(true);
                    }
                });
            }

            static /* synthetic */ CustomizerDisplay access$000(1 var0) {
                return var0.CustomizerDisplay.this;
            }
        });
    }

    private String getCategory() {
        LocalizedBundleInfo localizedBundleInfo = this.getBundle();
        String string = localizedBundleInfo != null ? localizedBundleInfo.getCategory() : null;
        return string != null ? string : "";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("nbPlatform" == propertyChangeEvent.getPropertyName()) {
            this.fillUpCategoryValue();
        }
    }

    private String getSelectedCategory() {
        String string = (String)this.categoryValue.getSelectedItem();
        return CustomizerComponentFactory.WAIT_VALUE == string ? this.getCategory() : string;
    }

    private void initComponents() {
        this.name = new JLabel();
        this.nameValue = new JTextField();
        this.category = new JLabel();
        this.categoryValue = new JComboBox();
        this.shortDesc = new JLabel();
        this.shortDescValue = new JTextField();
        this.longDesc = new JLabel();
        this.hackPanel = new JPanel();
        this.longDescValueSP = new JScrollPane();
        this.longDescValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.name.setLabelFor(this.nameValue);
        Mnemonics.setLocalizedText((JLabel)this.name, (String)NbBundle.getMessage((Class)CustomizerDisplay.class, (String)"LBL_DisplayName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.name, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.nameValue, gridBagConstraints);
        this.category.setLabelFor(this.categoryValue);
        Mnemonics.setLocalizedText((JLabel)this.category, (String)NbBundle.getMessage((Class)CustomizerDisplay.class, (String)"LBL_DisplayCategory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.category, gridBagConstraints);
        this.categoryValue.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.categoryValue, gridBagConstraints);
        this.shortDesc.setLabelFor(this.shortDescValue);
        Mnemonics.setLocalizedText((JLabel)this.shortDesc, (String)NbBundle.getMessage((Class)CustomizerDisplay.class, (String)"LBL_ShortDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.shortDesc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.shortDescValue, gridBagConstraints);
        this.longDesc.setLabelFor(this.longDescValue);
        Mnemonics.setLocalizedText((JLabel)this.longDesc, (String)NbBundle.getMessage((Class)CustomizerDisplay.class, (String)"LBL_LongDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 6);
        this.add((Component)this.longDesc, gridBagConstraints);
        this.hackPanel.setLayout(new BorderLayout());
        this.longDescValue.setLineWrap(true);
        this.longDescValue.setRows(10);
        this.longDescValue.setWrapStyleWord(true);
        this.longDescValueSP.setViewportView(this.longDescValue);
        this.hackPanel.add((Component)this.longDescValueSP, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.hackPanel, gridBagConstraints);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)CustomizerDisplay.class, (String)string);
    }

    private void initAccesibility() {
        this.longDescValue.getAccessibleContext().setAccessibleDescription(CustomizerDisplay.getMessage("ACSD_LongDescValue"));
        this.nameValue.getAccessibleContext().setAccessibleDescription(CustomizerDisplay.getMessage("ACSD_NameValue"));
        this.shortDescValue.getAccessibleContext().setAccessibleDescription(CustomizerDisplay.getMessage("ACSD_ShortDescValue"));
    }

    static /* synthetic */ JComboBox access$100(CustomizerDisplay customizerDisplay) {
        return customizerDisplay.categoryValue;
    }

    static /* synthetic */ String access$200(CustomizerDisplay customizerDisplay) {
        return customizerDisplay.getCategory();
    }
}

