/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerLibraries
extends NbPropertyPanel.Single {
    private JButton addDepButton;
    private JButton addTokenButton;
    private JPanel depButtonPanel;
    private JList dependencyList;
    private JScrollPane dependencySP;
    private JButton editDepButton;
    private JButton managePlafsButton;
    private JLabel modDepLabel;
    private JLabel platform;
    private JPanel platformPanel;
    private JComboBox platformValue;
    private JButton removeDepButton;
    private JButton removeTokenButton;
    private JList reqTokenList;
    private JScrollPane reqTokenSP;
    private JLabel reqTokens;
    private JLabel space1;
    private JPanel tokenButtonPanel;

    public CustomizerLibraries(SingleModuleProperties singleModuleProperties) {
        super(singleModuleProperties, CustomizerLibraries.class);
        this.initComponents();
        this.initAccesibility();
        this.refresh();
        this.dependencyList.setCellRenderer(CustomizerComponentFactory.getDependencyCellRenderer(false));
        this.platformValue.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActivePlatform((NbPlatform)CustomizerLibraries.this.platformValue.getSelectedItem());
                    CustomizerLibraries.this.dependencyList.setModel(CustomizerLibraries.this.getProperties().getDependenciesListModel());
                    CustomizerLibraries.this.updateEnabled();
                }
            }
        });
        this.dependencyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CustomizerLibraries.this.updateEnabled();
                }
            }
        });
    }

    void refresh() {
        this.refreshPlatforms();
        this.platformValue.setEnabled(this.getProperties().isStandalone());
        this.managePlafsButton.setEnabled(this.getProperties().isStandalone());
        this.updateEnabled();
        this.reqTokenList.setModel(this.getProperties().getRequiredTokenListModel());
        this.dependencyList.setModel(this.getProperties().getDependenciesListModel());
    }

    private void refreshPlatforms() {
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel());
        this.platformValue.setSelectedItem(this.getProperties().getActivePlatform());
        this.platformValue.requestFocus();
    }

    private void updateEnabled() {
        boolean bl = this.getProperties().isActivePlatformValid() && this.dependencyList.getSelectedIndex() != -1;
        this.editDepButton.setEnabled(bl);
        this.removeDepButton.setEnabled(bl);
        this.addDepButton.setEnabled(this.getProperties().isActivePlatformValid());
    }

    private CustomizerComponentFactory.DependencyListModel getDepListModel() {
        return (CustomizerComponentFactory.DependencyListModel)this.dependencyList.getModel();
    }

    private String getMessage(String string) {
        return NbBundle.getMessage((Class)CustomizerLibraries.class, (String)string);
    }

    private void initComponents() {
        this.modDepLabel = new JLabel();
        this.depButtonPanel = new JPanel();
        this.addDepButton = new JButton();
        this.removeDepButton = new JButton();
        this.space1 = new JLabel();
        this.editDepButton = new JButton();
        this.dependencySP = new JScrollPane();
        this.dependencyList = new JList();
        this.platformPanel = new JPanel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.platform = new JLabel();
        this.managePlafsButton = new JButton();
        this.reqTokens = new JLabel();
        this.reqTokenSP = new JScrollPane();
        this.reqTokenList = new JList();
        this.tokenButtonPanel = new JPanel();
        this.addTokenButton = new JButton();
        this.removeTokenButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.modDepLabel.setLabelFor(this.dependencyList);
        Mnemonics.setLocalizedText((JLabel)this.modDepLabel, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"LBL_ModuleDependencies"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 2, 0);
        this.add((Component)this.modDepLabel, gridBagConstraints);
        this.depButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_AddButton"));
        this.addDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.depButtonPanel.add((Component)this.addDepButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeDepButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.removeModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.depButtonPanel.add((Component)this.removeDepButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.depButtonPanel.add((Component)this.space1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editDepButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_EditButton"));
        this.editDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.editModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.depButtonPanel.add((Component)this.editDepButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.depButtonPanel, gridBagConstraints);
        this.dependencySP.setViewportView(this.dependencyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.dependencySP, gridBagConstraints);
        this.platformPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformPanel.add((Component)this.platform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_ManagePlatform"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.managePlatforms(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.platformPanel.add((Component)this.managePlafsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.platformPanel, gridBagConstraints);
        this.reqTokens.setLabelFor(this.reqTokenList);
        Mnemonics.setLocalizedText((JLabel)this.reqTokens, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"LBL_RequiredTokens"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.reqTokens, gridBagConstraints);
        this.reqTokenSP.setViewportView(this.reqTokenList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.reqTokenSP, gridBagConstraints);
        this.tokenButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addTokenButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_AddButton_NoMnem"));
        this.addTokenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addToken(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.tokenButtonPanel.add((Component)this.addTokenButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeTokenButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_RemoveButton_NoMnem"));
        this.removeTokenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.removeToken(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.tokenButtonPanel.add((Component)this.removeTokenButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tokenButtonPanel, gridBagConstraints);
    }

    private void removeToken(ActionEvent actionEvent) {
        CustomizerComponentFactory.RequiredTokenListModel requiredTokenListModel = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
        Object[] objectArray = this.reqTokenList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            requiredTokenListModel.removeToken((String)objectArray[i]);
        }
        if (requiredTokenListModel.getSize() > 0) {
            this.reqTokenList.setSelectedIndex(0);
        }
        this.reqTokenList.requestFocus();
    }

    private void addToken(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.setLayout(new BorderLayout(0, 2));
        JList<String> jList = new JList<String>(this.getProperties().getAllTokens());
        JScrollPane jScrollPane = new JScrollPane(jList);
        JLabel jLabel = new JLabel();
        jLabel.setLabelFor(jList);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)this.getMessage("LBL_ProvidedTokens_T"));
        jPanel.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_ProvidedTokensTitle"));
        jList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_LBL_ProvidedTokens"));
        jScrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleName(this.getMessage("ACS_CTL_ProvidedTokensVerticalScroll"));
        jScrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_ProvidedTokensVerticalScroll"));
        jScrollPane.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(this.getMessage("ACS_CTL_ProvidedTokensHorizontalScroll"));
        jScrollPane.getHorizontalScrollBar().getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_ProvidedTokensHorizontalScroll"));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, this.getMessage("LBL_ProvidedTokens_NoMnem"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            Object[] objectArray = jList.getSelectedValues();
            CustomizerComponentFactory.RequiredTokenListModel requiredTokenListModel = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
            for (int i = 0; i < objectArray.length; ++i) {
                requiredTokenListModel.addToken((String)objectArray[i]);
            }
        }
        this.reqTokenList.requestFocus();
    }

    private void managePlatforms(ActionEvent actionEvent) {
        NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
    }

    private void editModuleDependency(ActionEvent actionEvent) {
        ModuleDependency moduleDependency = this.getDepListModel().getDependency(this.dependencyList.getSelectedIndex());
        ModuleDependency moduleDependency2 = this.getDepListModel().findEdited(moduleDependency);
        EditDependencyPanel editDependencyPanel = new EditDependencyPanel(moduleDependency2 == null ? moduleDependency : moduleDependency2, this.getProperties().getActivePlatform());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editDependencyPanel, this.getMessage("CTL_EditModuleDependencyTitle"));
        dialogDescriptor.setHelpCtx(new HelpCtx(EditDependencyPanel.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.getDepListModel().editDependency(moduleDependency, editDependencyPanel.getEditedDependency());
        }
        dialog.dispose();
        this.dependencyList.requestFocus();
    }

    private void removeModuleDependency(ActionEvent actionEvent) {
        this.getDepListModel().removeDependencies(Arrays.asList(this.dependencyList.getSelectedValues()));
        if (this.dependencyList.getModel().getSize() > 0) {
            this.dependencyList.setSelectedIndex(0);
        }
        this.dependencyList.requestFocus();
    }

    private void addModuleDependency(ActionEvent actionEvent) {
        final AddModulePanel addModulePanel = new AddModulePanel(this.getProperties());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addModulePanel, this.getMessage("CTL_AddModuleDependencyTitle"));
        dialogDescriptor.setHelpCtx(new HelpCtx(AddModulePanel.class));
        dialogDescriptor.setClosingOptions(new Object[0]);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogDescriptor.setButtonListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogDescriptor.OK_OPTION.equals(actionEvent.getSource()) && addModulePanel.getSelectedDependencies().length == 0) {
                    return;
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            ModuleDependency[] moduleDependencyArray = addModulePanel.getSelectedDependencies();
            for (int i = 0; i < moduleDependencyArray.length; ++i) {
                if (this.getDepListModel().getDependencies().contains(moduleDependencyArray[i])) continue;
                this.getDepListModel().addDependency(moduleDependencyArray[i]);
                this.dependencyList.setSelectedValue(moduleDependencyArray[i], true);
            }
            this.dependencyList.requestFocus();
        }
        dialog.dispose();
        this.dependencyList.requestFocus();
    }

    private void initAccesibility() {
        this.addTokenButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_SrcLevelValue"));
        this.dependencyList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_DependencyList"));
        this.editDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_EditDepButton"));
        this.removeDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveDepButton"));
        this.removeTokenButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveTokenButton"));
        this.addDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AddDepButton"));
        this.reqTokenList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_ReqTokenList"));
    }
}

