/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CustomizerSources
extends NbPropertyPanel.Single {
    private JLabel filler;
    private JLabel moduleSuite;
    private JTextField moduleSuiteValue;
    private JLabel prjFolder;
    private JTextField prjFolderValue;
    private JLabel srcLevel;
    private JComboBox srcLevelValue;

    CustomizerSources(SingleModuleProperties singleModuleProperties) {
        super(singleModuleProperties, CustomizerSources.class);
        this.initComponents();
        this.initAccesibility();
        this.refresh();
    }

    void refresh() {
        if (this.getProperties().getSuiteDirectoryPath() == null) {
            this.moduleSuite.setVisible(false);
            this.moduleSuiteValue.setVisible(false);
        } else {
            UIUtil.setText(this.moduleSuiteValue, this.getProperties().getSuiteDirectoryPath());
        }
        this.srcLevelValue.removeAllItems();
        for (int i = 0; i < SingleModuleProperties.SOURCE_LEVELS.length; ++i) {
            this.srcLevelValue.addItem(SingleModuleProperties.SOURCE_LEVELS[i]);
        }
        this.srcLevelValue.setSelectedItem(this.getProperty("javac.source"));
        UIUtil.setText(this.prjFolderValue, this.getProperties().getProjectDirectory());
    }

    public void store() {
        this.setProperty("javac.source", (String)this.srcLevelValue.getSelectedItem());
    }

    private void initComponents() {
        this.prjFolder = new JLabel();
        this.srcLevel = new JLabel();
        this.srcLevelValue = new JComboBox();
        this.filler = new JLabel();
        this.prjFolderValue = new JTextField();
        this.moduleSuite = new JLabel();
        this.moduleSuiteValue = new JTextField();
        this.setLayout(new GridBagLayout());
        this.prjFolder.setLabelFor(this.prjFolderValue);
        Mnemonics.setLocalizedText((JLabel)this.prjFolder, (String)NbBundle.getMessage((Class)CustomizerSources.class, (String)"LBL_ProjectFolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.prjFolder, gridBagConstraints);
        this.srcLevel.setLabelFor(this.srcLevelValue);
        Mnemonics.setLocalizedText((JLabel)this.srcLevel, (String)NbBundle.getMessage((Class)CustomizerSources.class, (String)"LBL_SourceLevel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.srcLevel, gridBagConstraints);
        this.srcLevelValue.setPrototypeDisplayValue("mmm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.srcLevelValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.prjFolderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.prjFolderValue, gridBagConstraints);
        this.moduleSuite.setLabelFor(this.moduleSuiteValue);
        Mnemonics.setLocalizedText((JLabel)this.moduleSuite, (String)NbBundle.getMessage((Class)CustomizerSources.class, (String)"LBL_ModeleSuite"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.moduleSuite, gridBagConstraints);
        this.moduleSuiteValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.moduleSuiteValue, gridBagConstraints);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)CustomizerSources.class, (String)string);
    }

    private void initAccesibility() {
        this.srcLevelValue.getAccessibleContext().setAccessibleDescription(CustomizerSources.getMessage("ACS_SrcLevelValue"));
        this.moduleSuiteValue.getAccessibleContext().setAccessibleDescription(CustomizerSources.getMessage("ACS_ModuleSuiteValue"));
        this.prjFolderValue.getAccessibleContext().setAccessibleDescription(CustomizerSources.getMessage("ACS_PrjFolderValue"));
    }
}

