/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.spi.project.support.ant.PropertyUtils;

public final class ModuleDependency
implements Comparable {
    private String releaseVersion;
    private String specVersion;
    private boolean implDep;
    private boolean compileDep;
    private ModuleEntry me;
    private Set filterTokens;
    public static final Comparator CODE_NAME_BASE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((ModuleDependency)object).getModuleEntry().getCodeNameBase().compareTo(((ModuleDependency)object2).getModuleEntry().getCodeNameBase());
        }
    };
    private static final Collator LOC_COLLATOR = Collator.getInstance();

    public ModuleDependency(ModuleEntry moduleEntry) {
        this(moduleEntry, moduleEntry.getReleaseVersion(), moduleEntry.getSpecificationVersion(), true, false);
    }

    public ModuleDependency(ModuleEntry moduleEntry, String string, String string2, boolean bl, boolean bl2) {
        this.me = moduleEntry;
        this.compileDep = bl;
        this.implDep = bl2;
        this.releaseVersion = string;
        this.specVersion = string2;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public ModuleEntry getModuleEntry() {
        return this.me;
    }

    public int compareTo(Object object) {
        int n = LOC_COLLATOR.compare(this.getModuleEntry().getLocalizedName(), ((ModuleDependency)object).getModuleEntry().getLocalizedName());
        if (n != 0) {
            return n;
        }
        return this.getModuleEntry().getCodeNameBase().compareTo(((ModuleDependency)object).getModuleEntry().getCodeNameBase());
    }

    public boolean hasCompileDependency() {
        return this.compileDep;
    }

    public boolean hasImplementationDepedendency() {
        return this.implDep;
    }

    Set getFilterTokens() {
        if (this.filterTokens == null) {
            int n;
            this.filterTokens = new HashSet();
            this.filterTokens.add(this.me.getCodeNameBase());
            this.filterTokens.add(this.me.getLocalizedName());
            this.filterTokens.add(this.me.getJarLocation().getAbsolutePath());
            String[] stringArray = PropertyUtils.tokenizePath((String)this.me.getClassPathExtensions());
            for (n = 0; n < stringArray.length; ++n) {
                this.filterTokens.add(stringArray[n]);
            }
            n = 1;
            if (n != 0) {
                Iterator iterator = this.me.getPublicClassNames().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.filterTokens.add(string.replace('$', '.'));
                }
            }
        }
        return this.filterTokens;
    }

    public String toString() {
        return "ModuleDependency[me: " + this.getModuleEntry() + ", relVer: " + this.getReleaseVersion() + ", specVer: " + this.getSpecificationVersion() + ", implDep: " + this.hasImplementationDepedendency() + ", compDep: " + this.hasCompileDependency() + "]";
    }
}

