/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

abstract class ModuleProperties {
    public static final String PROPERTIES_REFRESHED = "propertiesRefreshed";
    static final RequestProcessor RP = new RequestProcessor(ModuleProperties.class.getName());
    static boolean runFromTests = false;
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private EditableProperties projectProperties;
    private EditableProperties privateProperties;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    ModuleProperties(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.reloadProperties();
    }

    protected void reloadProperties() {
        this.projectProperties = this.helper.getProperties("nbproject/project.properties");
        this.privateProperties = this.helper.getProperties("nbproject/private/private.properties");
    }

    abstract Map getDefaultValues();

    AntProjectHelper getHelper() {
        return this.helper;
    }

    PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    EditableProperties getProjectProperties() {
        return this.projectProperties;
    }

    EditableProperties getPrivateProperties() {
        return this.privateProperties;
    }

    final String getProperty(String string) {
        String string2 = this.getProjectProperties().getProperty(string);
        return string2 != null ? string2 : (String)this.getDefaultValues().get(string);
    }

    final boolean getBooleanProperty(String string) {
        String string2 = this.getProperty(string);
        return string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"));
    }

    final String removeProperty(String string) {
        return (String)this.getProjectProperties().remove((Object)string);
    }

    final String removePrivateProperty(String string) {
        return (String)this.getPrivateProperties().remove((Object)string);
    }

    final void setProperty(String string, String string2) {
        String string3 = (String)this.getDefaultValues().get(string);
        if (string3 == null) {
            string3 = "";
        }
        if (string3.equals(string2)) {
            this.getProjectProperties().remove((Object)string);
        } else {
            this.getProjectProperties().setProperty(string, string2);
        }
    }

    final void setPrivateProperty(String string, String string2) {
        String string3 = (String)this.getDefaultValues().get(string);
        if (string3 == null) {
            string3 = "";
        }
        if (string3.equals(string2)) {
            this.getPrivateProperties().remove((Object)string);
        } else {
            this.getPrivateProperties().setProperty(string, string2);
        }
    }

    void setProperty(String string, String[] stringArray) {
        this.getProjectProperties().setProperty(string, stringArray);
    }

    final void setBooleanProperty(String string, boolean bl) {
        this.setProperty(string, Boolean.toString(bl));
    }

    String getProjectDisplayName() {
        return Util.getDisplayName(this.getHelper().getProjectDirectory());
    }

    final File getProjectDirectoryFile() {
        return FileUtil.toFile((FileObject)this.getHelper().getProjectDirectory());
    }

    final String getProjectDirectory() {
        return this.getProjectDirectoryFile().getAbsolutePath();
    }

    void storeProperties() throws IOException {
        this.getHelper().putProperties("nbproject/project.properties", this.getProjectProperties());
        this.getHelper().putProperties("nbproject/private/private.properties", this.getPrivateProperties());
    }

    static void storePlatform(AntProjectHelper antProjectHelper, NbPlatform nbPlatform) {
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/platform.properties");
        editableProperties.put((Object)"nbplatform.active", (Object)nbPlatform.getID());
        antProjectHelper.putProperties("nbproject/platform.properties", editableProperties);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertiesRefreshed() {
        this.firePropertyChange(PROPERTIES_REFRESHED, null, null);
    }

    protected static void reportLostPlatform(NbPlatform nbPlatform) {
        String string = nbPlatform != null ? '\"' + nbPlatform.getLabel() + '\"' : NbBundle.getMessage((Class)ModuleProperties.class, (String)"MSG_PreviouslySet");
        String string2 = NbBundle.getMessage((Class)ModuleProperties.class, (String)"MSG_PlatformNotFound", (Object)string);
        if (!runFromTests) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
        } else {
            System.err.println(string2);
        }
    }
}

