/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Utilities;

public final class SingleModuleProperties
extends ModuleProperties {
    private static final String[] IDE_TOKENS;
    public static final String BUILD_COMPILER_DEBUG = "build.compiler.debug";
    public static final String BUILD_COMPILER_DEPRECATION = "build.compiler.deprecation";
    public static final String CLUSTER_DIR = "cluster.dir";
    public static final String IS_AUTOLOAD = "is.autoload";
    public static final String IS_EAGER = "is.eager";
    public static final String JAVAC_SOURCES = "javac.source";
    public static final String JAVADOC_TITLE = "javadoc.title";
    public static final String LICENSE_FILE = "license.file";
    public static final String NBM_HOMEPAGE = "nbm.homepage";
    public static final String NBM_IS_GLOBAL = "nbm.is.global";
    public static final String NBM_MODULE_AUTHOR = "nbm.module.author";
    public static final String NBM_NEEDS_RESTART = "nbm.needs.restart";
    public static final String SPEC_VERSION_BASE = "spec.version.base";
    static final String[] SOURCE_LEVELS;
    private static final Map DEFAULTS;
    private boolean majorReleaseVersionChanged;
    private boolean specificationVersionChanged;
    private boolean implementationVersionChange;
    private boolean providedTokensChanged;
    private NbModuleTypeProvider.NbModuleType moduleType;
    private SuiteProvider suiteProvider;
    private ProjectXMLManager projectXMLManager;
    private final LocalizedBundleInfo.Provider bundleInfoProvider;
    private LocalizedBundleInfo bundleInfo;
    private String majorReleaseVersion;
    private String specificationVersion;
    private String implementationVersion;
    private String provTokensString;
    private SortedSet requiredTokens;
    private NbPlatform activePlatform;
    private NbPlatform originalPlatform;
    private SortedSet availablePublicPackages;
    private String[] allTokens;
    private SortedSet modCategories;
    private SortedSet universeDependencies;
    private CustomizerComponentFactory.PublicPackagesTableModel publicPackagesModel;
    private CustomizerComponentFactory.DependencyListModel dependencyListModel;
    private CustomizerComponentFactory.FriendListModel friendListModel;
    private CustomizerComponentFactory.RequiredTokenListModel requiredTokensListModel;
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    public static final String DEPENDENCIES_PROPERTY = "moduleDependencies";
    static final /* synthetic */ boolean $assertionsDisabled;

    SingleModuleProperties(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SuiteProvider suiteProvider, NbModuleTypeProvider.NbModuleType nbModuleType, LocalizedBundleInfo.Provider provider) {
        super(antProjectHelper, propertyEvaluator);
        this.bundleInfoProvider = provider;
        this.refresh(nbModuleType, suiteProvider);
    }

    protected void refresh(NbModuleTypeProvider.NbModuleType nbModuleType, SuiteProvider suiteProvider) {
        this.reloadProperties();
        this.suiteProvider = suiteProvider;
        this.moduleType = nbModuleType;
        this.universeDependencies = null;
        this.modCategories = null;
        this.availablePublicPackages = null;
        this.dependencyListModel = null;
        this.friendListModel = null;
        this.requiredTokensListModel = null;
        this.projectXMLManager = null;
        if (this.isSuiteComponent()) {
            if (!$assertionsDisabled && this.getSuiteDirectory() == null) {
                throw new AssertionError();
            }
            ModuleList.refreshSuiteModuleList(this.getSuiteDirectory());
        }
        ManifestManager manifestManager = ManifestManager.getInstance(this.getManifestFile(), false);
        this.majorReleaseVersion = manifestManager.getReleaseVersion();
        this.specificationVersion = manifestManager.getSpecificationVersion();
        this.implementationVersion = manifestManager.getImplementationVersion();
        this.provTokensString = manifestManager.getProvidedTokensString();
        this.originalPlatform = this.activePlatform = NbPlatform.getPlatformByID(this.getEvaluator().getProperty("nbplatform.active"));
        this.getPublicPackagesModel().reloadData(this.loadPublicPackages());
        this.requiredTokens = Collections.unmodifiableSortedSet(new TreeSet<String>(Arrays.asList(manifestManager.getRequiredTokens())));
        this.bundleInfo = this.bundleInfoProvider.getLocalizedBundleInfo();
        if (this.bundleInfo != null) {
            try {
                this.bundleInfo.reload();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        this.firePropertiesRefreshed();
    }

    Map getDefaultValues() {
        return DEFAULTS;
    }

    LocalizedBundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    String getCodeNameBase() {
        return this.getProjectXMLManager().getCodeNameBase();
    }

    String getJarFile() {
        return this.getHelper().resolveFile(this.getEvaluator().evaluate("${cluster}/${module.jar}")).getAbsolutePath();
    }

    String getSuiteDirectoryPath() {
        return this.getSuiteDirectory() != null ? this.getSuiteDirectory().getPath() : null;
    }

    File getSuiteDirectory() {
        return this.suiteProvider != null ? this.suiteProvider.getSuiteDirectory() : null;
    }

    SuiteProject getSuite() {
        if (!$assertionsDisabled && !this.isSuiteComponent()) {
            throw new AssertionError();
        }
        SuiteProject suiteProject = null;
        try {
            suiteProject = (SuiteProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)this.getSuiteDirectory()));
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
        }
        return suiteProject;
    }

    boolean isActivePlatformValid() {
        NbPlatform nbPlatform = this.getActivePlatform();
        return nbPlatform == null || nbPlatform.isValid();
    }

    NbPlatform getActivePlatform() {
        if (!(this.moduleType == NbModuleTypeProvider.NETBEANS_ORG || this.activePlatform != null && NbPlatform.getPlatforms().contains(this.activePlatform))) {
            ModuleProperties.reportLostPlatform(this.activePlatform);
            this.activePlatform = NbPlatform.getDefaultPlatform();
        }
        return this.activePlatform;
    }

    void setActivePlatform(NbPlatform nbPlatform) {
        if (this.activePlatform != nbPlatform) {
            NbPlatform nbPlatform2 = this.activePlatform;
            this.activePlatform = nbPlatform;
            this.dependencyListModel = null;
            this.universeDependencies = null;
            this.modCategories = null;
            this.firePropertyChange(NB_PLATFORM_PROPERTY, nbPlatform2, nbPlatform);
        }
    }

    String getMajorReleaseVersion() {
        return this.majorReleaseVersion;
    }

    void setMajorReleaseVersion(String string) {
        if (this.majorReleaseVersion != string) {
            this.majorReleaseVersion = string;
            this.majorReleaseVersionChanged = true;
        }
    }

    String getSpecificationVersion() {
        return this.specificationVersion;
    }

    void setSpecificationVersion(String string) {
        if (this.specificationVersion != string) {
            this.specificationVersion = string;
            this.specificationVersionChanged = true;
        }
    }

    String getImplementationVersion() {
        return this.implementationVersion;
    }

    void setImplementationVersion(String string) {
        if (this.implementationVersion != string) {
            this.implementationVersion = string;
            this.implementationVersionChange = true;
        }
    }

    String getProvidedTokens() {
        return this.provTokensString;
    }

    void setProvidedTokens(String string) {
        if (this.provTokensString != string) {
            this.provTokensString = string;
            this.providedTokensChanged = true;
        }
    }

    boolean isStandalone() {
        return this.moduleType == NbModuleTypeProvider.STANDALONE;
    }

    boolean isNetBeansOrg() {
        return this.moduleType == NbModuleTypeProvider.NETBEANS_ORG;
    }

    boolean isSuiteComponent() {
        return this.moduleType == NbModuleTypeProvider.SUITE_COMPONENT;
    }

    boolean dependingOnImplDependency() {
        CustomizerComponentFactory.DependencyListModel dependencyListModel = this.getDependenciesListModel();
        if (dependencyListModel == CustomizerComponentFactory.INVALID_DEP_LIST_MODEL) {
            return false;
        }
        Set set = dependencyListModel.getDependencies();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
            if (!moduleDependency.hasImplementationDepedendency()) continue;
            return true;
        }
        return false;
    }

    private ProjectXMLManager getProjectXMLManager() {
        if (this.projectXMLManager == null) {
            this.projectXMLManager = new ProjectXMLManager(this.getHelper());
        }
        return this.projectXMLManager;
    }

    CustomizerComponentFactory.DependencyListModel getDependenciesListModel() {
        if (this.dependencyListModel == null) {
            if (this.isActivePlatformValid()) {
                try {
                    this.dependencyListModel = new CustomizerComponentFactory.DependencyListModel(this.getProjectXMLManager().getDirectDependencies(this.getActivePlatform()));
                    this.dependencyListModel.addListDataListener(new ListDataListener(){

                        public void contentsChanged(ListDataEvent listDataEvent) {
                            SingleModuleProperties.this.firePropertyChange(SingleModuleProperties.DEPENDENCIES_PROPERTY, null, SingleModuleProperties.this.getDependenciesListModel());
                        }

                        public void intervalAdded(ListDataEvent listDataEvent) {
                            this.contentsChanged(null);
                        }

                        public void intervalRemoved(ListDataEvent listDataEvent) {
                            this.contentsChanged(null);
                        }
                    });
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
                }
            } else {
                this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
            }
        }
        return this.dependencyListModel;
    }

    SortedSet getUniverseDependencies(boolean bl) {
        if (!$assertionsDisabled && SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"SingleModuleProperties.getUniverseDependencies() cannot be called from EDT");
        }
        if (this.universeDependencies == null) {
            this.reloadModuleListInfo();
        }
        SortedSet sortedSet = null;
        if (bl && this.isSuiteComponent()) {
            SuiteProject suiteProject = this.getSuite();
            String[] stringArray = SuiteProperties.getArrayProperty(suiteProject.getEvaluator(), "disabled.modules");
            String[] stringArray2 = SuiteProperties.getArrayProperty(suiteProject.getEvaluator(), "disabled.clusters");
            TreeSet treeSet = new TreeSet(this.universeDependencies);
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
                if (!SingleModuleProperties.isExcluded(moduleDependency.getModuleEntry(), stringArray, stringArray2)) continue;
                iterator.remove();
            }
            sortedSet = Collections.unmodifiableSortedSet(treeSet);
        }
        if (sortedSet == null) {
            sortedSet = this.universeDependencies;
        }
        return sortedSet;
    }

    private static boolean isExcluded(ModuleEntry moduleEntry, String[] stringArray, String[] stringArray2) {
        return Arrays.binarySearch(stringArray, moduleEntry.getCodeNameBase()) >= 0 || Arrays.binarySearch(stringArray2, moduleEntry.getClusterDirectory().getName()) >= 0;
    }

    String[] getAvailableFriends() {
        TreeSet<String> treeSet;
        block3: {
            block2: {
                treeSet = new TreeSet<String>();
                if (!this.isSuiteComponent()) break block2;
                Iterator iterator = SuiteUtils.getSubProjects(this.getSuite()).iterator();
                while (iterator.hasNext()) {
                    Project project = (Project)iterator.next();
                    String string = ProjectUtils.getInformation((Project)project).getName();
                    if (this.getCodeNameBase().equals(string)) continue;
                    treeSet.add(string);
                }
                break block3;
            }
            if (!this.isNetBeansOrg()) break block3;
            SortedSet sortedSet = this.getUniverseDependencies(false);
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
                treeSet.add(moduleDependency.getModuleEntry().getCodeNameBase());
            }
        }
        return treeSet.toArray(new String[0]);
    }

    CustomizerComponentFactory.FriendListModel getFriendListModel() {
        if (this.friendListModel == null) {
            this.friendListModel = new CustomizerComponentFactory.FriendListModel(this.getProjectXMLManager().getFriends());
        }
        return this.friendListModel;
    }

    CustomizerComponentFactory.RequiredTokenListModel getRequiredTokenListModel() {
        if (this.requiredTokensListModel == null) {
            this.requiredTokensListModel = new CustomizerComponentFactory.RequiredTokenListModel(this.requiredTokens);
        }
        return this.requiredTokensListModel;
    }

    String[] getAllTokens() {
        if (this.allTokens == null) {
            try {
                TreeSet<String> treeSet = new TreeSet<String>();
                treeSet.addAll(Arrays.asList(IDE_TOKENS));
                String[] stringArray = this.getModuleList().getAllEntriesSoft().iterator();
                while (stringArray.hasNext()) {
                    ModuleEntry moduleEntry = (ModuleEntry)stringArray.next();
                    treeSet.addAll(Arrays.asList(moduleEntry.getProvidedTokens()));
                }
                stringArray = new String[treeSet.size()];
                return treeSet.toArray(stringArray);
            }
            catch (IOException iOException) {
                this.allTokens = new String[0];
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return this.allTokens;
    }

    CustomizerComponentFactory.PublicPackagesTableModel getPublicPackagesModel() {
        if (this.publicPackagesModel == null) {
            this.publicPackagesModel = new CustomizerComponentFactory.PublicPackagesTableModel(this.loadPublicPackages());
        }
        return this.publicPackagesModel;
    }

    private Map loadPublicPackages() {
        Collection collection = this.getSelectedPackages();
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        Iterator iterator = this.getAvailablePublicPackages().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            treeMap.put(string, collection.contains(string));
        }
        return treeMap;
    }

    private Collection getSelectedPackages() {
        HashSet<String> hashSet = new HashSet<String>();
        ManifestManager.PackageExport[] packageExportArray = this.getProjectXMLManager().getPublicPackages();
        for (int i = 0; i < packageExportArray.length; ++i) {
            ManifestManager.PackageExport packageExport = packageExportArray[i];
            if (packageExport.isRecursive()) {
                Iterator iterator = this.getAvailablePublicPackages().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!string.startsWith(packageExport.getPackage())) continue;
                    hashSet.add(string);
                }
                continue;
            }
            hashSet.add(packageExport.getPackage());
        }
        return hashSet;
    }

    Set getAvailablePublicPackages() {
        if (this.availablePublicPackages == null) {
            this.availablePublicPackages = new TreeSet();
            File file = this.getHelper().resolveFile(this.getEvaluator().getProperty("src.dir"));
            HashSet hashSet = new HashSet();
            SingleModuleProperties.addNonEmptyPackages(hashSet, FileUtil.toFileObject((File)file), "java");
            String[] stringArray = hashSet.iterator();
            while (stringArray.hasNext()) {
                FileObject fileObject = (FileObject)stringArray.next();
                String string = PropertyUtils.relativizeFile((File)file, (File)FileUtil.toFile((FileObject)fileObject));
                this.availablePublicPackages.add(string.replace('/', '.'));
            }
            stringArray = this.getProjectXMLManager().getBinaryOrigins();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addNonEmptyPackagesFromJar(this.availablePublicPackages, this.getHelper().resolveFile(stringArray[i]));
            }
        }
        return this.availablePublicPackages;
    }

    void storeProperties() throws IOException {
        Object object;
        Object object2;
        CustomizerComponentFactory.DependencyListModel dependencyListModel;
        super.storeProperties();
        this.storeManifestChanges();
        if (this.bundleInfo != null && this.bundleInfo.isModified()) {
            this.bundleInfo.store();
        }
        if ((dependencyListModel = this.getDependenciesListModel()).isChanged()) {
            object2 = new TreeSet(ModuleDependency.CODE_NAME_BASE_COMPARATOR);
            object2.addAll(dependencyListModel.getDependencies());
            object2.removeAll(dependencyListModel.getRemovedDependencies());
            object2.addAll(dependencyListModel.getAddedDependencies());
            object = dependencyListModel.getEditedDependencies();
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                object2.remove(entry.getKey());
                object2.add(entry.getValue());
            }
            this.getProjectXMLManager().replaceDependencies((Set)object2);
        }
        object2 = this.getFriendListModel().getFriends();
        object = this.getPublicPackagesModel().getSelectedPackages();
        if (this.getPublicPackagesModel().isChanged() || this.getFriendListModel().isChanged()) {
            if (((Object)object2).length > 0) {
                this.getProjectXMLManager().replaceFriends((String[])object2, (String[])object);
            } else {
                this.getProjectXMLManager().replacePublicPackages((String[])object);
            }
        }
        if (this.isStandalone()) {
            ModuleProperties.storePlatform(this.getHelper(), this.getActivePlatform());
        }
    }

    private void storeManifestChanges() throws IOException {
        String[] stringArray;
        EditableManifest editableManifest;
        FileObject fileObject = FileUtil.toFileObject((File)this.getManifestFile());
        if (fileObject != null) {
            editableManifest = Util.loadManifest(fileObject);
        } else {
            editableManifest = new EditableManifest();
            fileObject = FileUtil.createData((FileObject)this.getHelper().getProjectDirectory(), (String)"manifest.mf");
        }
        boolean bl = false;
        if (this.majorReleaseVersionChanged) {
            stringArray = "".equals(this.getMajorReleaseVersion()) ? this.getCodeNameBase() : this.getCodeNameBase() + '/' + this.getMajorReleaseVersion();
            this.setManifestAttribute(editableManifest, "OpenIDE-Module", (String)stringArray);
            bl = true;
        }
        if (this.specificationVersionChanged) {
            this.setManifestAttribute(editableManifest, "OpenIDE-Module-Specification-Version", this.getSpecificationVersion());
            bl = true;
        }
        if (this.implementationVersionChange) {
            this.setManifestAttribute(editableManifest, "OpenIDE-Module-Implementation-Version", this.getImplementationVersion());
            bl = true;
        }
        if (this.providedTokensChanged) {
            this.setManifestAttribute(editableManifest, "OpenIDE-Module-Provides", this.getProvidedTokens());
            bl = true;
        }
        if (this.getRequiredTokenListModel().isChanged()) {
            stringArray = this.getRequiredTokenListModel().getTokens();
            StringBuffer stringBuffer = new StringBuffer(stringArray.length > 1 ? "\n  " : "");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",\n  ");
                }
                stringBuffer.append(stringArray[i]);
            }
            this.setManifestAttribute(editableManifest, "OpenIDE-Module-Requires", stringBuffer.toString());
            bl = true;
        }
        if (bl) {
            Util.storeManifest(fileObject, editableManifest);
        }
    }

    private void setManifestAttribute(EditableManifest editableManifest, String string, String string2) {
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        if ("".equals(string2)) {
            if (editableManifest.getAttribute(string, null) != null) {
                editableManifest.removeAttribute(string, null);
            }
        } else {
            editableManifest.setAttribute(string, string2, null);
        }
    }

    File getManifestFile() {
        return this.getHelper().resolveFile(this.getEvaluator().getProperty("manifest.mf"));
    }

    SortedSet getModuleCategories() {
        if (!$assertionsDisabled && SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"SingleModuleProperties.getModuleCategories() cannot be called from EDT");
        }
        if (this.modCategories == null && !this.reloadModuleListInfo()) {
            return new TreeSet();
        }
        return this.modCategories;
    }

    boolean reloadModuleListInfo() {
        if (!$assertionsDisabled && SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"SingleModuleProperties.reloadModuleListInfo() cannot be called from EDT");
        }
        if (this.isActivePlatformValid()) {
            try {
                TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
                TreeSet<ModuleDependency> treeSet2 = new TreeSet<ModuleDependency>();
                Iterator iterator = this.getModuleList().getAllEntriesSoft().iterator();
                while (iterator.hasNext()) {
                    String string;
                    ModuleEntry moduleEntry = (ModuleEntry)iterator.next();
                    if (!moduleEntry.getCodeNameBase().equals(this.getCodeNameBase())) {
                        treeSet2.add(new ModuleDependency(moduleEntry));
                    }
                    if ((string = moduleEntry.getCategory()) == null) continue;
                    treeSet.add(string);
                }
                this.modCategories = Collections.unmodifiableSortedSet(treeSet);
                this.universeDependencies = Collections.unmodifiableSortedSet(treeSet2);
                return true;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return false;
    }

    private void addNonEmptyPackagesFromJar(Set set, File file) {
        if (!file.isFile()) {
            return;
        }
        try {
            JarFileSystem jarFileSystem = new JarFileSystem();
            jarFileSystem.setJarFile(file);
            HashSet hashSet = new HashSet();
            SingleModuleProperties.addNonEmptyPackages(hashSet, jarFileSystem.getRoot(), "class");
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                String string = fileObject.getPath();
                set.add(string.replace('/', '.'));
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    static void addNonEmptyPackages(Set set, FileObject fileObject, String string) {
        FileObject fileObject2;
        if (fileObject == null) {
            return;
        }
        Enumeration enumeration = fileObject.getFolders(false);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            if (!VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
            SingleModuleProperties.addNonEmptyPackages(set, fileObject2, string);
        }
        enumeration = fileObject.getData(false);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.hasExt(string) || !Utilities.isJavaIdentifier((String)fileObject2.getName())) continue;
            set.add(fileObject);
            break;
        }
    }

    ModuleList getModuleList() throws IOException {
        if (this.getActivePlatform() != this.originalPlatform) {
            return ModuleList.getModuleList(FileUtil.toFile((FileObject)this.getHelper().getProjectDirectory()), this.getActivePlatform().getDestDir());
        }
        return ModuleList.getModuleList(FileUtil.toFile((FileObject)this.getHelper().getProjectDirectory()));
    }

    File evaluateFile(String string) {
        String string2 = this.getEvaluator().evaluate(string);
        return string2 == null ? null : this.getHelper().resolveFile(string2);
    }

    static {
        $assertionsDisabled = !SingleModuleProperties.class.desiredAssertionStatus();
        IDE_TOKENS = new String[]{"org.openide.modules.os.Windows", "org.openide.modules.os.Unix", "org.openide.modules.os.MacOSX", "org.openide.modules.os.PlainUnix", "org.openide.modules.os.OS2"};
        SOURCE_LEVELS = new String[]{"1.4", "1.5"};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(BUILD_COMPILER_DEBUG, "true");
        hashMap.put(BUILD_COMPILER_DEPRECATION, "true");
        hashMap.put(IS_AUTOLOAD, "false");
        hashMap.put(IS_EAGER, "false");
        hashMap.put(JAVAC_SOURCES, "1.4");
        hashMap.put(NBM_IS_GLOBAL, "false");
        hashMap.put(NBM_NEEDS_RESTART, "false");
        DEFAULTS = Collections.unmodifiableMap(hashMap);
    }
}

