/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicCustomizer;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class SuiteCustomizerBasicBranding
extends NbPropertyPanel.Suite
implements BasicCustomizer.SubCategoryProvider {
    private URL iconSource;
    private JRadioButton addOn;
    private JButton browse;
    private ButtonGroup buttonGroup1;
    private JLabel icon;
    private JLabel iconPreview;
    private JLabel name;
    private JTextField nameValue;
    private JRadioButton standaloneApp;
    private JLabel title;
    private JTextField titleValue;

    public SuiteCustomizerBasicBranding(SuiteProperties suiteProperties) {
        super(suiteProperties, SuiteCustomizerBasicBranding.class);
        this.initComponents();
        this.refresh();
        UIUtil.DocumentAdapter documentAdapter = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SuiteCustomizerBasicBranding.this.checkForm();
            }
        };
        this.nameValue.getDocument().addDocumentListener(documentAdapter);
        this.titleValue.getDocument().addDocumentListener(documentAdapter);
    }

    protected void checkForm() {
        boolean bl = true;
        if (bl && this.nameValue.getText().trim().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage((Class)SuiteCustomizerBasicBranding.class, (String)"ERR_EmptyName"));
            bl = false;
        }
        if (bl && !this.nameValue.getText().trim().matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
            this.setErrorMessage(NbBundle.getMessage((Class)SuiteCustomizerBasicBranding.class, (String)"ERR_InvalidName"));
            bl = false;
        }
        if (bl && this.titleValue.getText().trim().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage((Class)SuiteCustomizerBasicBranding.class, (String)"ERR_EmptyTitle"));
            bl = false;
        }
        if (bl) {
            this.setErrorMessage(null);
        }
    }

    void refresh() {
        this.getBrandingModel().brandingEnabledRefresh();
        this.getBrandingModel().initName(true);
        this.getBrandingModel().initTitle(true);
        this.standaloneApp.setSelected(this.getBrandingModel().isBrandingEnabled());
        this.addOn.setSelected(!this.getBrandingModel().isBrandingEnabled());
        this.nameValue.setText(this.getBrandingModel().getName());
        this.titleValue.setText(this.getBrandingModel().getTitle());
        this.iconSource = this.getBrandingModel().getIconSource();
        if (this.iconSource != null) {
            ((ImagePreview)this.iconPreview).setImage(new ImageIcon(this.iconSource));
        }
        this.enableOrDisableComponents();
    }

    public void store() {
        this.getBrandingModel().setName(this.nameValue.getText());
        this.getBrandingModel().setTitle(this.titleValue.getText());
        this.getBrandingModel().setIconSource(this.iconSource);
    }

    private void enableOrDisableComponents() {
        this.nameValue.setEnabled(this.standaloneApp.isSelected());
        this.name.setEnabled(this.standaloneApp.isSelected());
        this.titleValue.setEnabled(this.standaloneApp.isSelected());
        this.title.setEnabled(this.standaloneApp.isSelected());
        this.browse.setEnabled(this.standaloneApp.isSelected());
        this.icon.setEnabled(this.standaloneApp.isSelected());
        this.iconPreview.setEnabled(this.standaloneApp.isSelected());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.title = new JLabel();
        this.titleValue = new JTextField();
        this.iconPreview = new ImagePreview(48, 48);
        this.name = new JLabel();
        this.nameValue = new JTextField();
        this.browse = new JButton();
        this.icon = new JLabel();
        this.addOn = new JRadioButton();
        this.standaloneApp = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.title.setLabelFor(this.titleValue);
        Mnemonics.setLocalizedText((JLabel)this.title, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_AppTitle"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.title, gridBagConstraints);
        this.title.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_Title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.titleValue, gridBagConstraints);
        this.iconPreview.setLabelFor(this.iconPreview);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(23, 0, 0, 12);
        this.add((Component)this.iconPreview, gridBagConstraints);
        this.name.setLabelFor(this.nameValue);
        Mnemonics.setLocalizedText((JLabel)this.name, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_AppName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.name, gridBagConstraints);
        this.name.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.nameValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("CTL_Browse"));
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerBasicBranding.this.browseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(23, 0, 0, 0);
        this.add((Component)this.browse, gridBagConstraints);
        this.browse.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_Browse"));
        Mnemonics.setLocalizedText((JLabel)this.icon, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_AppIcon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(23, 0, 0, 12);
        this.add((Component)this.icon, gridBagConstraints);
        this.buttonGroup1.add(this.addOn);
        Mnemonics.setLocalizedText((AbstractButton)this.addOn, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_AppAddOn"));
        this.addOn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.addOn.setMargin(new Insets(0, 0, 0, 0));
        this.addOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerBasicBranding.this.addOnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.addOn, gridBagConstraints);
        this.addOn.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_AddOn"));
        this.buttonGroup1.add(this.standaloneApp);
        Mnemonics.setLocalizedText((AbstractButton)this.standaloneApp, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_AppStandAlone"));
        this.standaloneApp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.standaloneApp.setMargin(new Insets(0, 0, 0, 0));
        this.standaloneApp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerBasicBranding.this.standaloneAppActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.standaloneApp, gridBagConstraints);
        this.standaloneApp.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_StandAloneApp"));
    }

    private void standaloneAppActionPerformed(ActionEvent actionEvent) {
        this.enableOrDisableComponents();
        this.getBrandingModel().setBrandingEnabled(this.standaloneApp.isSelected());
    }

    private void addOnActionPerformed(ActionEvent actionEvent) {
        this.enableOrDisableComponents();
        this.getBrandingModel().setBrandingEnabled(this.standaloneApp.isSelected());
    }

    private void browseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = UIUtil.getIconFileChooser();
        int n = jFileChooser.showDialog(this, NbBundle.getMessage(this.getClass(), (String)"LBL_Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                this.iconSource = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
            ((ImagePreview)this.iconPreview).setImage(new ImageIcon(this.iconSource));
        }
    }

    private BasicBrandingModel getBrandingModel() {
        return this.getProperties().getBrandingModel();
    }

    public void showSubCategory(String string) {
        if (!string.equals("standaloneApp")) {
            throw new IllegalArgumentException(string);
        }
        this.standaloneApp.requestFocus();
    }

    static class ImagePreview
    extends JLabel {
        private ImageIcon image = null;
        private int width;
        private int height;

        ImagePreview(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (!this.isEnabled()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            }
            if (this.getWidth() > this.width && this.getHeight() > this.height && this.image != null) {
                int n = 0;
                int n2 = 0;
                graphics.drawImage(this.image.getImage(), n, n2, this.width, this.height, this.getBackground(), null);
            }
        }

        private void setImage(ImageIcon imageIcon) {
            this.image = imageIcon;
            this.repaint();
        }
    }
}

