/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerDisplay;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

final class SuiteCustomizerLibraries
extends NbPropertyPanel.Suite
implements Comparator,
ExplorerManager.Provider,
ChangeListener {
    private ExplorerManager manager;
    private JLabel filler;
    private JButton managePlafsButton;
    private JLabel platform;
    private JPanel platformPanel;
    private JComboBox platformValue;
    private TreeTableView view;
    private JLabel viewLabel;
    private static final Set DISABLED_PLATFORM_MODULES = new HashSet();

    public SuiteCustomizerLibraries(SuiteProperties suiteProperties) {
        super(suiteProperties, SuiteCustomizerLibraries.class);
        this.initComponents();
        this.initAccesibility();
        this.manager = new ExplorerManager();
        this.refresh();
        this.view.setProperties(new Node.Property[]{EnabledProp.TEMPLATE});
        this.view.setRootVisible(false);
        this.view.setDefaultActionAllowed(false);
        suiteProperties.getBrandingModel().addChangeListener(this);
        suiteProperties.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("nbPlatform".equals(propertyChangeEvent.getPropertyName())) {
                    SuiteCustomizerLibraries.this.refresh();
                }
            }
        });
    }

    void refresh() {
        this.refreshPlatforms();
        this.refreshModules();
    }

    private void refreshModules() {
        ModuleEntry[] moduleEntryArray = this.getProperties().getActivePlatform().getModules();
        Node node = this.createModuleNode(moduleEntryArray);
        this.manager.setRootContext(node);
    }

    private void refreshPlatforms() {
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel());
        this.platformValue.setSelectedItem(this.getProperties().getActivePlatform());
        this.platformValue.requestFocus();
    }

    public void store() {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        Node[] nodeArray = this.getExplorerManager().getRootContext().getChildren().getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!(nodeArray[i] instanceof Enabled)) continue;
            Enabled enabled = (Enabled)nodeArray[i];
            if (!enabled.isEnabled()) {
                treeSet.add(enabled.getName());
                continue;
            }
            Node[] nodeArray2 = enabled.getChildren().getNodes();
            for (int j = 0; j < nodeArray2.length; ++j) {
                Enabled enabled2;
                if (!(nodeArray2[j] instanceof Enabled) || (enabled2 = (Enabled)nodeArray2[j]).isEnabled()) continue;
                treeSet2.add(enabled2.getName());
            }
        }
        this.getProperties().setDisabledClusters(treeSet.toArray(new String[0]));
        this.getProperties().setDisabledModules(treeSet2.toArray(new String[0]));
    }

    private void initComponents() {
        this.platformPanel = new JPanel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.platform = new JLabel();
        this.managePlafsButton = new JButton();
        this.filler = new JLabel();
        this.view = new TreeTableView();
        this.viewLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.platformPanel.setLayout(new GridBagLayout());
        this.platformValue.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SuiteCustomizerLibraries.this.platformValueItemStateChanged(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage((Class)SuiteCustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformPanel.add((Component)this.platform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage((Class)SuiteCustomizerLibraries.class, (String)"CTL_ManagePlatform_a"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerLibraries.this.managePlatforms(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.platformPanel.add((Component)this.managePlafsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.platformPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.view.setBorder(UIManager.getBorder("ScrollPane.border"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.view, gridBagConstraints);
        this.viewLabel.setLabelFor((Component)this.view);
        Mnemonics.setLocalizedText((JLabel)this.viewLabel, (String)NbBundle.getMessage((Class)SuiteCustomizerLibraries.class, (String)"LBL_PlatformModules"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 0, 2, 0);
        this.add((Component)this.viewLabel, gridBagConstraints);
    }

    private void platformValueItemStateChanged(ItemEvent itemEvent) {
        this.getProperties().setActivePlatform((NbPlatform)this.platformValue.getSelectedItem());
        this.refreshModules();
    }

    private void managePlatforms(ActionEvent actionEvent) {
        NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
    }

    private Node createModuleNode(ModuleEntry[] moduleEntryArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.getProperties().getDisabledModules()));
        HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(this.getProperties().getDisabledClusters()));
        HashMap<File, Children.SortedArray> hashMap = new HashMap<File, Children.SortedArray>();
        Children.SortedArray sortedArray = new Children.SortedArray();
        sortedArray.setComparator((Comparator)this);
        AbstractNode abstractNode = new AbstractNode((Children)sortedArray);
        abstractNode.setName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClusters"));
        abstractNode.setDisplayName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClustersModules"));
        for (int i = 0; i < moduleEntryArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Children children = (Children)hashMap.get(moduleEntryArray[i].getClusterDirectory());
            if (children == null) {
                object3 = new Children.SortedArray();
                object3.setComparator((Comparator)this);
                children = object3;
                object2 = moduleEntryArray[i].getClusterDirectory().getName();
                object = new Enabled((Children)object3, !hashSet2.contains(object2));
                object.setName(object2);
                object.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/suite/resources/suite.gif");
                hashMap.put(moduleEntryArray[i].getClusterDirectory(), (Children.SortedArray)object3);
                abstractNode.getChildren().add(new Node[]{object});
            }
            object2 = new Enabled(Children.LEAF, !hashSet.contains(object3 = moduleEntryArray[i].getCodeNameBase()));
            object2.setName((String)object3);
            object2.setDisplayName(moduleEntryArray[i].getLocalizedName());
            object = moduleEntryArray[i].getShortDescription();
            String string = object != null ? (((String)object).startsWith("<html>") ? "<html>" + NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries == null ? SuiteCustomizerLibraries.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries") : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries), (String)"SuiteCustomizerLibraries.HINT_module_desc", (Object)object3, (Object)((String)object).substring(6)) : NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries == null ? SuiteCustomizerLibraries.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries") : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries), (String)"SuiteCustomizerLibraries.HINT_module_desc", (Object)object3, (Object)object)) : NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries == null ? SuiteCustomizerLibraries.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries") : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries), (String)"SuiteCustomizerLibraries.HINT_module_no_desc", (Object)object3);
            object2.setShortDescription(string);
            object2.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.gif");
            children.add(new Node[]{object2});
        }
        return abstractNode;
    }

    public int compare(Object object, Object object2) {
        Node node = (Node)object;
        Node node2 = (Node)object2;
        return node.getDisplayName().compareTo(node2.getDisplayName());
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getProperties().getBrandingModel().isBrandingEnabled()) {
            Node[] nodeArray;
            Object object;
            Node[] nodeArray2 = this.getExplorerManager().getRootContext().getChildren().getNodes();
            for (int i = 0; i < nodeArray2.length; ++i) {
                if (!(nodeArray2[i] instanceof Enabled)) continue;
                object = (Enabled)nodeArray2[i];
                if (!object.isEnabled()) {
                    return;
                }
                Node[] nodeArray3 = object.getChildren().getNodes();
                for (int j = 0; j < nodeArray3.length; ++j) {
                    if (!(nodeArray3[j] instanceof Enabled) || (nodeArray = (Node[])nodeArray3[j]).isEnabled()) continue;
                    return;
                }
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.text.exclude_ide_modules"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.title.exclude_ide_modules"));
            dialogDescriptor.setOptionType(2);
            dialogDescriptor.setModal(true);
            object = new JButton(SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.button.exclude"));
            ((JButton)object).setDefaultCapable(true);
            dialogDescriptor.setOptions(new Object[]{object, new JButton(SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.button.skip"))});
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(object)) {
                return;
            }
            for (int i = 0; i < nodeArray2.length; ++i) {
                if (!(nodeArray2[i] instanceof Enabled)) continue;
                Enabled enabled = (Enabled)nodeArray2[i];
                if (enabled.getName().startsWith("platform")) {
                    nodeArray = enabled.getChildren().getNodes();
                    for (int j = 0; j < nodeArray.length; ++j) {
                        Enabled enabled2;
                        if (!(nodeArray[j] instanceof Enabled) || !DISABLED_PLATFORM_MODULES.contains((enabled2 = (Enabled)nodeArray[j]).getName())) continue;
                        enabled2.setEnabled(false);
                    }
                    continue;
                }
                enabled.setEnabled(false);
            }
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)CustomizerDisplay.class, (String)string);
    }

    private void initAccesibility() {
        this.managePlafsButton.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_ManagePlafsButton"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_PlatformValue"));
    }

    static {
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.autoupdate");
        DISABLED_PLATFORM_MODULES.add("org.openide.execution");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.execution");
        DISABLED_PLATFORM_MODULES.add("org.openide.io");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.output2");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.multiview");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.favorites");
        DISABLED_PLATFORM_MODULES.add("org.openide.compat");
        DISABLED_PLATFORM_MODULES.add("org.openide.util.enumerations");
    }

    private static final class EnabledProp
    extends PropertySupport.ReadWrite {
        private static final EnabledProp TEMPLATE = new EnabledProp(null);
        private Enabled node;
        private PropertyEditor editor;

        public EnabledProp(Enabled enabled) {
            super("enabled", Boolean.TYPE, SuiteCustomizerLibraries.getMessage("LBL_ModuleListEnabled"), SuiteCustomizerLibraries.getMessage("LBL_ModuleListEnabledShortDescription"));
            this.node = enabled;
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.node.setEnabled((Boolean)object);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Children children = this.node.getChildren();
            if (children == Children.LEAF) {
                return this.node.isEnabled();
            }
            Node[] nodeArray = children.getNodes();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < nodeArray.length; ++i) {
                Enabled enabled = (Enabled)nodeArray[i];
                if (enabled.isEnabled()) {
                    bl = true;
                } else {
                    bl2 = true;
                }
                if (!bl || !bl2 || !this.node.isEnabled()) continue;
                return null;
            }
            return bl && this.node.isEnabled();
        }

        public boolean canWrite() {
            Node node = this.node.getParentNode();
            if (node instanceof Enabled) {
                return ((Enabled)node).isEnabled();
            }
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = super.getPropertyEditor();
            }
            return this.editor;
        }
    }

    static final class Enabled
    extends AbstractNode {
        private boolean enabled;
        private Children standard;

        public Enabled(Children children, boolean bl) {
            super(children);
            this.standard = children;
            this.enabled = bl;
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get("properties");
            set.put((Node.Property)new EnabledProp(this));
            this.setSheet(sheet);
        }

        public void setEnabled(boolean bl) {
            Object object;
            if (bl == this.enabled) {
                return;
            }
            this.enabled = bl;
            Node[] nodeArray = this.standard.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                object = nodeArray[i];
                if (!(object instanceof Enabled)) continue;
                Enabled enabled = (Enabled)((Object)object);
                enabled.firePropertyChange(null, null, null);
            }
            Node node = this.getParentNode();
            if (node instanceof Enabled) {
                object = (Enabled)node;
                object.firePropertyChange(null, null, null);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

