/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;

public final class SuiteProperties
extends ModuleProperties {
    public static final String DISABLED_MODULES_PROPERTY = "disabled.modules";
    public static final String DISABLED_CLUSTERS_PROPERTY = "disabled.clusters";
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    private NbPlatform activePlatform;
    private SuiteProject project;
    private Set origSubModules;
    private Set subModules;
    private CustomizerComponentFactory.SuiteSubModulesListModel moduleListModel;
    private String[] disabledModules;
    private String[] disabledClusters;
    private boolean changedDisabledModules;
    private boolean changedDisabledClusters;
    private final BasicBrandingModel brandingModel;

    public SuiteProperties(SuiteProject suiteProject, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, Set set) {
        super(antProjectHelper, propertyEvaluator);
        this.project = suiteProject;
        this.refresh(set);
        this.disabledModules = SuiteProperties.getArrayProperty(propertyEvaluator, DISABLED_MODULES_PROPERTY);
        this.disabledClusters = SuiteProperties.getArrayProperty(propertyEvaluator, DISABLED_CLUSTERS_PROPERTY);
        this.brandingModel = new BasicBrandingModel(this);
    }

    void refresh(Set set) {
        this.reloadProperties();
        this.origSubModules = Collections.unmodifiableSet(set);
        this.subModules = set;
        this.moduleListModel = null;
        this.activePlatform = this.project.getPlatform(true);
        this.firePropertiesRefreshed();
    }

    public SuiteProject getProject() {
        return this.project;
    }

    Map getDefaultValues() {
        return Collections.EMPTY_MAP;
    }

    public NbPlatform getActivePlatform() {
        return this.activePlatform;
    }

    void setActivePlatform(NbPlatform nbPlatform) {
        NbPlatform nbPlatform2 = this.activePlatform;
        this.activePlatform = nbPlatform;
        this.firePropertyChange(NB_PLATFORM_PROPERTY, nbPlatform2, nbPlatform);
    }

    String[] getDisabledModules() {
        return this.disabledModules;
    }

    String[] getDisabledClusters() {
        return this.disabledClusters;
    }

    void setDisabledClusters(String[] stringArray) {
        if (((Object)Arrays.asList(this.disabledClusters)).equals(Arrays.asList(stringArray))) {
            return;
        }
        this.disabledClusters = stringArray;
        this.changedDisabledClusters = true;
    }

    void setDisabledModules(String[] stringArray) {
        if (((Object)Arrays.asList(this.disabledModules)).equals(Arrays.asList(stringArray))) {
            return;
        }
        this.disabledModules = stringArray;
        this.changedDisabledModules = true;
    }

    public static String[] getArrayProperty(PropertyEvaluator propertyEvaluator, String string) {
        String string2 = propertyEvaluator.getProperty(string);
        String[] stringArray = null;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken().trim();
            }
        }
        return stringArray == null ? new String[]{} : stringArray;
    }

    void storeProperties() throws IOException {
        int n;
        String[] stringArray;
        ModuleProperties.storePlatform(this.getHelper(), this.getActivePlatform());
        this.getBrandingModel().store();
        CustomizerComponentFactory.SuiteSubModulesListModel suiteSubModulesListModel = this.getModulesListModel();
        if (suiteSubModulesListModel.isChanged()) {
            SuiteUtils.replaceSubModules(this);
        }
        if (this.changedDisabledModules) {
            stringArray = (String[])this.disabledModules.clone();
            for (n = 0; n < this.disabledModules.length - 1; ++n) {
                stringArray[n] = this.disabledModules[n] + ',';
            }
            this.setProperty(DISABLED_MODULES_PROPERTY, stringArray);
        }
        if (this.changedDisabledClusters) {
            stringArray = (String[])this.disabledClusters.clone();
            for (n = 0; n < this.disabledClusters.length - 1; ++n) {
                stringArray[n] = this.disabledClusters[n] + ',';
            }
            this.setProperty(DISABLED_CLUSTERS_PROPERTY, stringArray);
        }
        super.storeProperties();
    }

    Set getSubModules() {
        return this.getModulesListModel().getSubModules();
    }

    Set getOrigSubModules() {
        return this.origSubModules;
    }

    CustomizerComponentFactory.SuiteSubModulesListModel getModulesListModel() {
        if (this.moduleListModel == null) {
            this.moduleListModel = new CustomizerComponentFactory.SuiteSubModulesListModel(this.subModules);
        }
        return this.moduleListModel;
    }

    BasicBrandingModel getBrandingModel() {
        return this.brandingModel;
    }
}

