/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class SuiteUtils {
    private static final String ANT_PURE_PROPERTY_REFERENCE_REGEXP = "\\$\\{\\p{Graph}+\\}";
    private static final String PRIVATE_PLATFORM_PROPERTIES = "nbproject/private/platform-private.properties";
    static final String MODULES_PROPERTY = "modules";
    private final SuiteProperties suiteProps;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$SuiteProvider;

    private SuiteUtils(SuiteProperties suiteProperties) {
        this.suiteProps = suiteProperties;
    }

    public static void replaceSubModules(final SuiteProperties suiteProperties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    NbModuleProject nbModuleProject;
                    SuiteUtils suiteUtils = new SuiteUtils(suiteProperties);
                    Set set = suiteProperties.getSubModules();
                    Set set2 = suiteProperties.getOrigSubModules();
                    Iterator iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        nbModuleProject = (NbModuleProject)iterator.next();
                        if (set.contains(nbModuleProject)) continue;
                        Util.err.log("Removing module: " + nbModuleProject);
                        suiteUtils.removeModule(nbModuleProject);
                    }
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        nbModuleProject = (NbModuleProject)iterator.next();
                        if (SuiteUtils.contains(suiteProperties.getProject(), nbModuleProject)) {
                            Util.err.log("Module \"" + nbModuleProject + "\" or a module with the same CNB is already contained in the suite.");
                            continue;
                        }
                        suiteUtils.addModule(nbModuleProject);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void addModule(final SuiteProject suiteProject, final NbModuleProject nbModuleProject) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    SuiteProperties suiteProperties = new SuiteProperties(suiteProject, suiteProject.getHelper(), suiteProject.getEvaluator(), SuiteUtils.getSubProjects(suiteProject));
                    if (!SuiteUtils.contains(suiteProject, nbModuleProject)) {
                        SuiteUtils suiteUtils = new SuiteUtils(suiteProperties);
                        suiteUtils.addModule(nbModuleProject);
                        suiteProperties.storeProperties();
                    } else {
                        Util.err.log("Module \"" + nbModuleProject + "\" or a module with the same CNB is already contained in the suite.");
                    }
                    ProjectManager.getDefault().saveProject((Project)suiteProject);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void removeModuleFromSuite(final NbModuleProject nbModuleProject) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    SuiteProject suiteProject = SuiteUtils.findSuite(nbModuleProject);
                    if (suiteProject != null) {
                        SuiteProperties suiteProperties = new SuiteProperties(suiteProject, suiteProject.getHelper(), suiteProject.getEvaluator(), SuiteUtils.getSubProjects(suiteProject));
                        SuiteUtils suiteUtils = new SuiteUtils(suiteProperties);
                        suiteUtils.removeModule(nbModuleProject);
                        suiteProperties.storeProperties();
                        ProjectManager.getDefault().saveProject((Project)suiteProject);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private void addModule(NbModuleProject nbModuleProject) throws IOException, IllegalArgumentException {
        SuiteUtils.removeModuleFromSuite(nbModuleProject);
        this.attachSubModuleToSuite(nbModuleProject);
    }

    private void removeModule(final NbModuleProject nbModuleProject) {
        NbModuleTypeProvider nbModuleTypeProvider = (NbModuleTypeProvider)nbModuleProject.getLookup().lookup(NbModuleTypeProvider.class);
        if (!$assertionsDisabled && nbModuleTypeProvider.getModuleType() != NbModuleTypeProvider.SUITE_COMPONENT) {
            throw new AssertionError((Object)"Not a suite component");
        }
        try {
            nbModuleProject.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    nbModuleProject.setRunInAtomicAction(true);
                    try {
                        EditableProperties editableProperties;
                        FileObject fileObject = nbModuleProject.getProjectDirectory();
                        FileObject fileObject2 = fileObject.getFileObject("nbproject/suite.properties");
                        if (fileObject2 != null) {
                            fileObject2.delete();
                        }
                        if ((fileObject2 = fileObject.getFileObject("nbproject/private/suite-private.properties")) != null) {
                            fileObject2.delete();
                        }
                        FileObject fileObject3 = SuiteUtils.this.suiteProps.getProject().getProjectDirectory().getFileObject("nbproject/platform.properties");
                        FileObject fileObject4 = fileObject.getFileObject("nbproject");
                        if (fileObject4.getFileObject("platform.properties") == null) {
                            FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject4, (String)"platform");
                        }
                        if ((editableProperties = nbModuleProject.getHelper().getProperties(SuiteUtils.PRIVATE_PLATFORM_PROPERTIES)).getProperty("user.properties.file") == null) {
                            String string = System.getProperty("netbeans.user");
                            if (string != null) {
                                editableProperties.setProperty("user.properties.file", new File(string, "build.properties").getAbsolutePath());
                                nbModuleProject.getHelper().putProperties(SuiteUtils.PRIVATE_PLATFORM_PROPERTIES, editableProperties);
                            } else {
                                Util.err.log("netbeans.user system property is not defined. Skipping nbproject/private/platform-private.properties creation.");
                            }
                        }
                        SuiteUtils.setNbModuleType(nbModuleProject, NbModuleTypeProvider.STANDALONE);
                        ProjectManager.getDefault().saveProject((Project)nbModuleProject);
                    }
                    finally {
                        nbModuleProject.setRunInAtomicAction(false);
                    }
                }
            });
            this.removeFromProperties(nbModuleProject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private boolean removeFromProperties(NbModuleProject nbModuleProject) {
        String string = this.suiteProps.getProperty(MODULES_PROPERTY);
        boolean bl = false;
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)string)));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = this.suiteProps.getEvaluator().evaluate(string2);
                if (string3 == null) {
                    Util.err.log("Cannot evaluate " + string2 + " property.");
                    continue;
                }
                if (nbModuleProject.getProjectDirectory() != this.suiteProps.getHelper().resolveFileObject(string3)) continue;
                iterator.remove();
                String[] stringArray = this.getAntProperty(arrayList);
                this.suiteProps.setProperty(MODULES_PROPERTY, stringArray);
                bl = true;
                if (!string2.matches(ANT_PURE_PROPERTY_REFERENCE_REGEXP)) break;
                String string4 = string2.substring(2, string2.length() - 1);
                this.suiteProps.removeProperty(string4);
                this.suiteProps.removePrivateProperty(string4);
                break;
            }
        }
        if (!bl) {
            Util.err.log("Removing of " + nbModuleProject + " was unsuccessful.");
        }
        return bl;
    }

    private void attachSubModuleToSuite(Project project) throws IOException {
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
        File file2 = this.suiteProps.getProjectDirectoryFile();
        String string = this.generatePropertyKey(project);
        if (CollocationQuery.areCollocated((File)file, (File)file2)) {
            this.suiteProps.setProperty(string, PropertyUtils.relativizeFile((File)file2, (File)file));
        } else {
            this.suiteProps.setPrivateProperty(string, file.getAbsolutePath());
        }
        String string2 = this.suiteProps.getProperty(MODULES_PROPERTY);
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = string2 + ":";
        }
        string2 = string2 + "${" + string + "}";
        this.suiteProps.setProperty(MODULES_PROPERTY, string2.split("(?<=:)", -1));
        NbModuleProjectGenerator.createSuiteProperties(project.getProjectDirectory(), file2);
        SuiteUtils.setNbModuleType(project, NbModuleTypeProvider.SUITE_COMPONENT);
        ProjectManager.getDefault().saveProject(project);
    }

    private String generatePropertyKey(Project project) {
        String string = "project." + ProjectUtils.getInformation((Project)project).getName();
        Object[] objectArray = this.suiteProps.getProperty(MODULES_PROPERTY).split("(?<=:)", -1);
        int n = 0;
        while (Arrays.binarySearch(objectArray, "${" + string + "}") >= 0) {
            string = string + "_" + ++n;
        }
        return string;
    }

    private static void setNbModuleType(Project project, NbModuleTypeProvider.NbModuleType nbModuleType) throws IOException {
        ProjectXMLManager projectXMLManager = new ProjectXMLManager(((NbModuleProject)project).getHelper());
        projectXMLManager.setModuleType(nbModuleType);
    }

    private String[] getAntProperty(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = collection.iterator();
        while (stringArray.hasNext()) {
            String string = (String)stringArray.next() + (stringArray.hasNext() ? ":" : "");
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static SuiteProject findSuite(final Project project) throws IOException {
        try {
            return (SuiteProject)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(class$org$netbeans$modules$apisupport$project$SuiteProvider == null ? (class$org$netbeans$modules$apisupport$project$SuiteProvider = SuiteUtils.class$("org.netbeans.modules.apisupport.project.SuiteProvider")) : class$org$netbeans$modules$apisupport$project$SuiteProvider);
                    Project project2 = null;
                    if (suiteProvider != null && suiteProvider.getSuiteDirectory() != null) {
                        project2 = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)suiteProvider.getSuiteDirectory()));
                    }
                    return (SuiteProject)project2;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static boolean contains(SuiteProject suiteProject, NbModuleProject nbModuleProject) {
        Set set = SuiteUtils.getSubProjects(suiteProject);
        if (set.contains(nbModuleProject)) {
            return true;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            NbModuleProject nbModuleProject2 = (NbModuleProject)iterator.next();
            if (!nbModuleProject2.getCodeNameBase().equals(nbModuleProject.getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    public static Set getSubProjects(Project project) {
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        return subprojectProvider.getSubprojects();
    }

    static {
        $assertionsDisabled = !SuiteUtils.class.desiredAssertionStatus();
    }
}

