/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class LibrariesModel
extends AbstractListModel
implements ComboBoxModel,
PropertyChangeListener {
    private Library[] cache;
    private Object selectedLibrary = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static JComboBox getComboBox() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new LibrariesModel());
        jComboBox.setRenderer(new LibraryRenderer());
        return jComboBox;
    }

    private LibrariesModel() {
        LibraryManager libraryManager = LibraryManager.getDefault();
        libraryManager.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)PropertyChangeListener.class, (EventListener)this, (Object)libraryManager));
        Library[] libraryArray = this.getLibraries();
        if (libraryArray != null && libraryArray.length > 0) {
            this.selectedLibrary = libraryArray[0];
        }
    }

    public synchronized int getSize() {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        return this.cache.length;
    }

    public synchronized Object getElementAt(int n) {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        if (n >= 0 && n < this.cache.length) {
            return this.cache[n];
        }
        return null;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = this.cache == null ? 0 : this.cache.length;
        this.cache = this.createLibraries();
        int n2 = this.cache.length;
        this.fireContentsChanged(this, 0, Math.min(n - 1, n2 - 1));
        if (n > n2) {
            this.fireIntervalRemoved(this, n2, n - 1);
        } else if (n < n2) {
            this.fireIntervalAdded(this, n, n2 - 1);
        }
    }

    public synchronized Library[] getLibraries() {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        return this.cache;
    }

    private Library[] createLibraries() {
        Library[] libraryArray = LibraryManager.getDefault().getLibraries();
        Arrays.sort(libraryArray, new Comparator(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public int compare(Object object, Object object2) {
                if (!($assertionsDisabled || object instanceof Library && object2 instanceof Library)) {
                    throw new AssertionError();
                }
                String string = ((Library)object).getDisplayName();
                String string2 = ((Library)object2).getDisplayName();
                return string.compareToIgnoreCase(string2);
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$platform$LibrariesModel == null ? (class$org$netbeans$modules$apisupport$project$ui$platform$LibrariesModel = LibrariesModel.class$("org.netbeans.modules.apisupport.project.ui.platform.LibrariesModel")) : class$org$netbeans$modules$apisupport$project$ui$platform$LibrariesModel).desiredAssertionStatus();
            }
        });
        return libraryArray;
    }

    public void setSelectedItem(Object object) {
        if (!$assertionsDisabled && object != null && !(object instanceof Library)) {
            throw new AssertionError();
        }
        if (this.selectedLibrary != object) {
            this.selectedLibrary = object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedLibrary;
    }

    static {
        $assertionsDisabled = !LibrariesModel.class.desiredAssertionStatus();
    }

    private static final class LibraryRenderer
    extends DefaultListCellRenderer {
        private static final String LIBRARY_ICON = "org/netbeans/modules/apisupport/project/ui/resources/libraries.gif";
        private Icon cachedIcon;

        private LibraryRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            if (object instanceof Library) {
                Library library = (Library)object;
                string = library.getDisplayName();
            }
            super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            this.setIcon(this.createIcon());
            return this;
        }

        private synchronized Icon createIcon() {
            if (this.cachedIcon == null) {
                Image image = Utilities.loadImage((String)LIBRARY_ICON);
                this.cachedIcon = new ImageIcon(image);
            }
            return this.cachedIcon;
        }
    }
}

