/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerJavadoc;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerModules;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerSources;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformChooserWizardPanel;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformInfoWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardPanel;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class NbPlatformCustomizer
extends JPanel {
    static final String CHOOSER_STEP = NbPlatformCustomizer.getMessage("MSG_ChoosePlatfrom");
    static final String INFO_STEP = NbPlatformCustomizer.getMessage("MSG_PlatformName");
    static final String PLAF_DIR_PROPERTY = "selectedPlafDir";
    static final String PLAF_LABEL_PROPERTY = "selectedPlafLabel";
    private NbPlatformCustomizerSources sourcesTab;
    private NbPlatformCustomizerModules modulesTab;
    private NbPlatformCustomizerJavadoc javadocTab;
    private JButton addButton;
    private JTabbedPane detailPane;
    private JPanel infoPane;
    private JLabel pflFolder;
    private JLabel platformLbl;
    private JList platformsList;
    private JScrollPane platformsListSP;
    private JTextField plfFolderValue;
    private JLabel plfName;
    private JTextField plfNameValue;
    private JButton removeButton;

    public static void showCustomizer() {
        NbPlatformCustomizer nbPlatformCustomizer = new NbPlatformCustomizer();
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage((Class)NbPlatformCustomizer.class, (String)"CTL_Close"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)nbPlatformCustomizer, NbPlatformCustomizer.getMessage("CTL_NbPlatformManager_Title"), true, new Object[]{jButton}, (Object)jButton, 0, new HelpCtx(NbPlatformCustomizer.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
    }

    private NbPlatformCustomizer() {
        this.initComponents();
        this.initAccessibility();
        this.initTabs();
        this.platformsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                NbPlatformCustomizer.this.refreshPlatform();
            }
        });
        this.refreshPlatform();
    }

    private void initTabs() {
        if (this.platformsList.getModel().getSize() > 0) {
            this.platformsList.setSelectedIndex(0);
            this.sourcesTab = new NbPlatformCustomizerSources();
            this.modulesTab = new NbPlatformCustomizerModules();
            this.javadocTab = new NbPlatformCustomizerJavadoc();
            this.detailPane.addTab(NbPlatformCustomizer.getMessage("CTL_ModulesTab"), this.modulesTab);
            this.detailPane.addTab(NbPlatformCustomizer.getMessage("CTL_SourcesTab"), this.sourcesTab);
            this.detailPane.addTab(NbPlatformCustomizer.getMessage("CTL_JavadocTab"), this.javadocTab);
            Container container = this.getTopLevelAncestor();
            if (container != null && container instanceof Window) {
                ((Window)container).pack();
            }
        }
    }

    private void refreshPlatform() {
        NbPlatform nbPlatform = (NbPlatform)this.platformsList.getSelectedValue();
        if (nbPlatform == null) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.plfNameValue.setText(nbPlatform.getLabel());
        this.plfFolderValue.setText(nbPlatform.getDestDir().getAbsolutePath());
        boolean bl = nbPlatform.isValid();
        if (bl) {
            if (this.sourcesTab == null) {
                this.initTabs();
            }
            if (this.sourcesTab != null) {
                this.modulesTab.setPlatform(nbPlatform);
                this.sourcesTab.setPlatform(nbPlatform);
                this.javadocTab.setPlatform(nbPlatform);
            }
        } else {
            this.modulesTab.reset();
            this.detailPane.setSelectedIndex(0);
        }
        this.detailPane.setEnabledAt(0, bl);
        this.detailPane.setEnabledAt(1, bl);
        this.detailPane.setEnabledAt(2, bl);
        this.removeButton.setEnabled(!nbPlatform.isDefault());
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)NbPlatformCustomizer.class, (String)string);
    }

    private void initComponents() {
        this.platformLbl = new JLabel();
        this.platformsListSP = new JScrollPane();
        this.platformsList = PlatformComponentFactory.getNbPlatformsList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.infoPane = new JPanel();
        this.plfName = new JLabel();
        this.pflFolder = new JLabel();
        this.plfNameValue = new JTextField();
        this.plfFolderValue = new JTextField();
        this.detailPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        this.platformLbl.setLabelFor(this.platformsList);
        Mnemonics.setLocalizedText((JLabel)this.platformLbl, (String)NbBundle.getMessage((Class)NbPlatformCustomizer.class, (String)"LBL_Platforms"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.platformLbl, gridBagConstraints);
        this.platformsList.setSelectionMode(0);
        this.platformsListSP.setViewportView(this.platformsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 12, 6);
        this.add((Component)this.platformsListSP, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage((Class)NbPlatformCustomizer.class, (String)"CTL_AddPlatform"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizer.this.addPlatform(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage((Class)NbPlatformCustomizer.class, (String)"CTL_RemovePlatfrom"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizer.this.removePlatform(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.infoPane.setLayout(new GridBagLayout());
        this.plfName.setLabelFor(this.plfNameValue);
        Mnemonics.setLocalizedText((JLabel)this.plfName, (String)NbBundle.getMessage((Class)NbPlatformCustomizer.class, (String)"LBL_PlatformName_N"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.infoPane.add((Component)this.plfName, gridBagConstraints);
        this.pflFolder.setLabelFor(this.plfFolderValue);
        Mnemonics.setLocalizedText((JLabel)this.pflFolder, (String)NbBundle.getMessage((Class)NbPlatformCustomizer.class, (String)"LBL_PlatformFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.infoPane.add((Component)this.pflFolder, gridBagConstraints);
        this.plfNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.infoPane.add((Component)this.plfNameValue, gridBagConstraints);
        this.plfFolderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.infoPane.add((Component)this.plfFolderValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.infoPane.add((Component)this.detailPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 12, 0);
        this.add((Component)this.infoPane, gridBagConstraints);
    }

    private PlatformComponentFactory.NbPlatformListModel getPlafListModel() {
        return (PlatformComponentFactory.NbPlatformListModel)this.platformsList.getModel();
    }

    private void removePlatform(ActionEvent actionEvent) {
        NbPlatform nbPlatform = (NbPlatform)this.platformsList.getSelectedValue();
        if (nbPlatform != null) {
            this.getPlafListModel().removePlatform(nbPlatform);
            this.platformsList.setSelectedValue(NbPlatform.getDefaultPlatform(), true);
            this.refreshPlatform();
        }
    }

    private void addPlatform(ActionEvent actionEvent) {
        PlatformChooserWizardPanel platformChooserWizardPanel = new PlatformChooserWizardPanel(null);
        PlatformInfoWizardPanel platformInfoWizardPanel = new PlatformInfoWizardPanel(null);
        WizardDescriptor wizardDescriptor = new WizardDescriptor(new WizardDescriptor.Panel[]{platformChooserWizardPanel, platformInfoWizardPanel});
        this.initPanel(platformChooserWizardPanel, wizardDescriptor, 0);
        this.initPanel(platformInfoWizardPanel, wizardDescriptor, 1);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setTitle(NbPlatformCustomizer.getMessage("CTL_AddNetbeansPlatformTitle"));
        dialog.setVisible(true);
        dialog.toFront();
        if (wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION) {
            String string = (String)wizardDescriptor.getProperty(PLAF_DIR_PROPERTY);
            String string2 = (String)wizardDescriptor.getProperty(PLAF_LABEL_PROPERTY);
            String string3 = string2.replace(' ', '_');
            NbPlatform nbPlatform = this.getPlafListModel().addPlatform(string3, string, string2);
            if (nbPlatform != null) {
                this.platformsList.setSelectedValue(nbPlatform, true);
                this.refreshPlatform();
            }
        }
    }

    private void initPanel(BasicWizardPanel basicWizardPanel, WizardDescriptor wizardDescriptor, int n) {
        basicWizardPanel.setSettings(wizardDescriptor);
        JComponent jComponent = (JComponent)basicWizardPanel.getComponent();
        jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(n));
        jComponent.putClientProperty("WizardPanel_contentData", new String[]{CHOOSER_STEP, INFO_STEP});
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbPlatformCustomizer.getMessage("ACS_NbPlatformCustomizer"));
        this.platformsList.getAccessibleContext().setAccessibleDescription(NbPlatformCustomizer.getMessage("ACS_CTL_platformsList"));
        this.plfFolderValue.getAccessibleContext().setAccessibleDescription(NbPlatformCustomizer.getMessage("ACS_CTL_plfFolderValue"));
        this.plfNameValue.getAccessibleContext().setAccessibleDescription(NbPlatformCustomizer.getMessage("ACS_CTL_plfNameValue"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbPlatformCustomizer.getMessage("ACS_CTL_removeButton"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbPlatformCustomizer.getMessage("ACS_CTL_addButton"));
    }
}

