/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PlatformChooserVisualPanel
extends BasicVisualPanel
implements PropertyChangeListener {
    private JPanel infoPanel;
    private JPanel inner;
    private JLabel plafLabel;
    private JTextField plafLabelValue;
    private JFileChooser platformChooser;

    public PlatformChooserVisualPanel(WizardDescriptor wizardDescriptor) {
        super(wizardDescriptor);
        this.initComponents();
        this.initAccessibility();
        this.platformChooser.setAcceptAllFileFilterUsed(false);
        this.platformChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return PlatformChooserVisualPanel.getMessage("CTL_PlatformFolder");
            }
        });
        this.platformChooser.addPropertyChangeListener(this);
        this.setName(NbPlatformCustomizer.CHOOSER_STEP);
    }

    void storeData() {
        File file = this.platformChooser.getSelectedFile();
        if (file != null) {
            this.getSettings().putProperty("selectedPlafDir", (Object)file.getAbsolutePath());
            this.getSettings().putProperty("selectedPlafLabel", (Object)this.plafLabelValue.getText());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SelectedFileChangedProperty")) {
            File file = this.platformChooser.getSelectedFile();
            if (file != null && NbPlatform.isPlatformDirectory(file)) {
                try {
                    this.setPlafLabel(NbPlatform.computeDisplayName(file));
                }
                catch (IOException iOException) {
                    this.setPlafLabel(file.getAbsolutePath());
                }
                if (!NbPlatform.isSupportedPlatform(file)) {
                    this.setErrorMessage(PlatformChooserVisualPanel.getMessage("MSG_UnsupportedPlatform"));
                } else if (NbPlatform.contains(file)) {
                    this.setErrorMessage(PlatformChooserVisualPanel.getMessage("MSG_AlreadyAddedPlatform"));
                } else if (!NbPlatform.isLabelValid(this.plafLabelValue.getText())) {
                    this.setErrorMessage(PlatformChooserVisualPanel.getMessage("MSG_NameIsAlreadyUsedGoToNext"));
                    this.setValid(Boolean.TRUE);
                } else {
                    this.setErrorMessage(null);
                }
            } else {
                this.setErrorMessage(null);
                this.setValid(Boolean.FALSE);
                this.setPlafLabel(null);
                this.storeData();
            }
        }
    }

    private void setPlafLabel(String string) {
        this.plafLabelValue.setText(string);
        this.plafLabelValue.setCaretPosition(0);
        this.storeData();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)PlatformChooserVisualPanel.class, (String)string);
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.inner = new JPanel();
        this.plafLabel = new JLabel();
        this.plafLabelValue = new JTextField();
        this.platformChooser = new JFileChooser();
        this.infoPanel.setLayout(new FlowLayout(0, 6, 0));
        this.inner.setLayout(new GridLayout(2, 1, 0, 6));
        this.plafLabel.setLabelFor(this.plafLabelValue);
        Mnemonics.setLocalizedText((JLabel)this.plafLabel, (String)NbBundle.getMessage((Class)PlatformChooserVisualPanel.class, (String)"LBL_PlatformName_P"));
        this.inner.add(this.plafLabel);
        this.plafLabelValue.setColumns(15);
        this.plafLabelValue.setEditable(false);
        this.inner.add(this.plafLabelValue);
        this.infoPanel.add(this.inner);
        this.setLayout(new BorderLayout());
        this.platformChooser.setAccessory(this.infoPanel);
        this.platformChooser.setControlButtonsAreShown(false);
        this.platformChooser.setFileSelectionMode(1);
        this.add((Component)this.platformChooser, "Center");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(PlatformChooserVisualPanel.getMessage("ACS_PlatformChooserVisualPanel"));
        this.plafLabelValue.getAccessibleContext().setAccessibleDescription(PlatformChooserVisualPanel.getMessage("ACS_CTL_plafLabelValue"));
    }
}

