/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;

public final class PlatformComponentFactory {
    private static final Color INVALID_PLAF_COLOR = UIManager.getColor("nb.errorForeground");
    private static Set userSuites = new TreeSet<Object>(Collator.getInstance());
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$SuiteProvider;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory;

    private PlatformComponentFactory() {
    }

    public static JComboBox getNbPlatformsComboxBox() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new NbPlatformListModel());
        jComboBox.setRenderer(new NbPlatformListRenderer());
        return jComboBox;
    }

    public static JList getNbPlatformsList() {
        JList<Object> jList = new JList<Object>(new NbPlatformListModel());
        jList.setSelectionMode(0);
        jList.setCellRenderer(new NbPlatformListRenderer());
        return jList;
    }

    public static JComboBox getSuitesComboBox() {
        SuiteListModel suiteListModel = new SuiteListModel(userSuites);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            SuiteProvider suiteProvider = (SuiteProvider)projectArray[i].getLookup().lookup(class$org$netbeans$modules$apisupport$project$SuiteProvider == null ? PlatformComponentFactory.class$("org.netbeans.modules.apisupport.project.SuiteProvider") : class$org$netbeans$modules$apisupport$project$SuiteProvider);
            if (suiteProvider == null || suiteProvider.getSuiteDirectory() == null) continue;
            suiteListModel.addElement(suiteProvider.getSuiteDirectory().getAbsolutePath());
        }
        JComboBox jComboBox = new JComboBox(suiteListModel);
        if (suiteListModel.getSize() > 0) {
            jComboBox.setSelectedIndex(0);
        }
        return jComboBox;
    }

    public static void addUserSuite(String string) {
        userSuites.add(string);
    }

    public static ListCellRenderer getURLListRenderer() {
        return new URLListRenderer();
    }

    static final class URLListRenderer
    extends DefaultListCellRenderer {
        URLListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            URL uRL;
            URL uRL2 = (URL)object;
            String string = uRL2.toExternalForm();
            if (uRL2.getProtocol().equals("file")) {
                string = new File(URI.create(uRL2.toExternalForm())).getAbsolutePath();
            } else if (uRL2.getProtocol().equals("jar") && uRL2.equals(FileUtil.getArchiveRoot((URL)(uRL = FileUtil.getArchiveFile((URL)uRL2)))) && uRL.getProtocol().equals("file")) {
                string = new File(URI.create(uRL.toExternalForm())).getAbsolutePath();
            }
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }

    static final class NbPlatformJavadocRootsModel
    extends AbstractListModel {
        private NbPlatform plaf;
        private URL[] javadocRoots;

        NbPlatformJavadocRootsModel(NbPlatform nbPlatform) {
            this.plaf = nbPlatform;
            this.javadocRoots = nbPlatform.getJavadocRoots();
        }

        public Object getElementAt(int n) {
            return this.javadocRoots[n];
        }

        public int getSize() {
            return this.javadocRoots.length;
        }

        void removeJavadocRoots(URL[] uRLArray) {
            try {
                this.plaf.removeJavadocRoots(uRLArray);
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void addJavadocRoot(URL uRL) {
            try {
                this.plaf.addJavadocRoot(uRL);
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void moveJavadocRootsDown(int[] nArray) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    this.plaf.moveJavadocRootDown(nArray[i]);
                }
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void moveJavadocRootsUp(int[] nArray) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    this.plaf.moveJavadocRootUp(nArray[i]);
                }
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }
    }

    static final class NbPlatformSourceRootsModel
    extends AbstractListModel {
        private NbPlatform plaf;
        private URL[] srcRoots;

        NbPlatformSourceRootsModel(NbPlatform nbPlatform) {
            this.plaf = nbPlatform;
            this.srcRoots = nbPlatform.getSourceRoots();
        }

        public Object getElementAt(int n) {
            return this.srcRoots[n];
        }

        public int getSize() {
            return this.srcRoots.length;
        }

        void removeSourceRoot(URL[] uRLArray) {
            try {
                this.plaf.removeSourceRoots(uRLArray);
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, uRLArray.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void addSourceRoot(URL uRL) {
            try {
                this.plaf.addSourceRoot(uRL);
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void moveSourceRootsDown(int[] nArray) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    this.plaf.moveSourceRootDown(nArray[i]);
                }
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void moveSourceRootsUp(int[] nArray) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    this.plaf.moveSourceRootUp(nArray[i]);
                }
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }
    }

    private static class SuiteListModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private Set suites = new TreeSet<Object>(Collator.getInstance());
        private Object selectedSuite;
        static final /* synthetic */ boolean $assertionsDisabled;

        SuiteListModel(Set set) {
            this.suites.addAll(set);
        }

        public void setSelectedItem(Object object) {
            if (object == null) {
                return;
            }
            if (!$assertionsDisabled && !(object instanceof String)) {
                throw new AssertionError();
            }
            if (this.selectedSuite != object) {
                this.selectedSuite = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedSuite;
        }

        public int getSize() {
            return this.suites.size();
        }

        public Object getElementAt(int n) {
            return this.suites.toArray()[n];
        }

        public void addElement(Object object) {
            this.suites.add(object);
            this.fireIntervalAdded(this, 0, this.suites.size());
        }

        public void insertElementAt(Object object, int n) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Who needs to insertElementAt?");
            }
        }

        public void removeElement(Object object) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Who needs to removeElement?");
            }
        }

        public void removeElementAt(int n) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Who needs to call removeElementAt?");
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory == null ? (class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory = PlatformComponentFactory.class$("org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory")) : class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory).desiredAssertionStatus();
        }
    }

    static class ModuleEntryListModel
    extends AbstractListModel {
        private ModuleEntry[] mes;

        ModuleEntryListModel(ModuleEntry[] moduleEntryArray) {
            this.mes = moduleEntryArray;
        }

        public int getSize() {
            return this.mes.length;
        }

        public Object getElementAt(int n) {
            return this.mes[n].getLocalizedName();
        }
    }

    public static class NbPlatformListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private NbPlatform[] nbPlafs = NbPlatformListModel.getSortedPlatforms();
        private Object selectedPlaf;
        static final /* synthetic */ boolean $assertionsDisabled;

        private static NbPlatform[] getSortedPlatforms() {
            NbPlatform[] nbPlatformArray = NbPlatform.getPlatforms().toArray(new NbPlatform[0]);
            Arrays.sort(nbPlatformArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = Collator.getInstance().compare(((NbPlatform)object).getLabel(), ((NbPlatform)object2).getLabel());
                    if (n != 0) {
                        return n;
                    }
                    return System.identityHashCode(object) - System.identityHashCode(object2);
                }
            });
            return nbPlatformArray;
        }

        public NbPlatformListModel() {
            if (this.nbPlafs.length > 0) {
                this.selectedPlaf = this.nbPlafs[0];
            }
        }

        public int getSize() {
            return this.nbPlafs.length;
        }

        public Object getElementAt(int n) {
            return n < this.nbPlafs.length ? this.nbPlafs[n] : null;
        }

        public void setSelectedItem(Object object) {
            if (!$assertionsDisabled && object != null && !(object instanceof NbPlatform)) {
                throw new AssertionError();
            }
            if (this.selectedPlaf != object) {
                this.selectedPlaf = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedPlaf;
        }

        void removePlatform(NbPlatform nbPlatform) {
            try {
                NbPlatform.removePlatform(nbPlatform);
                this.nbPlafs = NbPlatformListModel.getSortedPlatforms();
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        NbPlatform addPlatform(String string, String string2, String string3) {
            try {
                NbPlatform nbPlatform = NbPlatform.addPlatform(string, new File(string2), string3);
                this.nbPlafs = NbPlatformListModel.getSortedPlatforms();
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
                return nbPlatform;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
                return null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory == null ? (class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory = PlatformComponentFactory.class$("org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory")) : class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory).desiredAssertionStatus();
        }
    }

    private static class NbPlatformListRenderer
    extends DefaultListCellRenderer {
        private NbPlatformListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            NbPlatform nbPlatform = (NbPlatform)object;
            String string = nbPlatform == null ? "" : nbPlatform.getLabel();
            Component component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            if (nbPlatform != null && !nbPlatform.isValid()) {
                component.setForeground(INVALID_PLAF_COLOR);
            }
            return component;
        }
    }
}

