/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PlatformInfoVisualPanel
extends BasicVisualPanel {
    private boolean attached;
    private JLabel filler;
    private JLabel plafName;
    private JTextField plafNameValue;

    public PlatformInfoVisualPanel(WizardDescriptor wizardDescriptor) {
        super(wizardDescriptor);
        this.initComponents();
        this.initAccessibility();
        this.setName(NbPlatformCustomizer.INFO_STEP);
    }

    void refreshData() {
        String string = (String)this.getSettings().getProperty("selectedPlafDir");
        try {
            this.plafNameValue.setText(NbPlatform.computeDisplayName(new File(string)));
        }
        catch (IOException iOException) {
            this.plafNameValue.setText(string);
        }
        this.checkForm();
    }

    private void checkForm() {
        String string = this.plafNameValue.getText().trim();
        if (string.equals("")) {
            this.setErrorMessage(PlatformInfoVisualPanel.getMessage("MSG_BlankPlatformName"));
        } else if (!NbPlatform.isLabelValid(string)) {
            this.setErrorMessage(PlatformInfoVisualPanel.getMessage("MSG_NameIsAlreadyUsed"));
        } else {
            this.setErrorMessage(null);
        }
    }

    void storeData() {
        this.getSettings().putProperty("selectedPlafLabel", (Object)this.plafNameValue.getText().trim());
    }

    public void addNotify() {
        super.addNotify();
        if (!this.attached) {
            this.plafNameValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    PlatformInfoVisualPanel.this.checkForm();
                }
            });
            this.attached = true;
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)PlatformInfoVisualPanel.class, (String)string);
    }

    private void initComponents() {
        this.plafName = new JLabel();
        this.plafNameValue = new JTextField();
        this.filler = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.plafName, (String)NbBundle.getMessage((Class)PlatformInfoVisualPanel.class, (String)"LBL_PlatformName_P"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.plafName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.plafNameValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(PlatformInfoVisualPanel.getMessage("ACS_PlatformInfoVisualPanel"));
        this.plafNameValue.getAccessibleContext().setAccessibleDescription(PlatformInfoVisualPanel.getMessage("ACS_CTL_plafNameValue"));
    }
}

