/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class BasicConfVisualPanel
extends BasicVisualPanel {
    static final String EXAMPLE_BASE_NAME = "org.yourorghere.";
    private NewModuleProjectData data;
    private boolean wasLayerUpdated;
    private boolean wasBundleUpdated;
    private boolean listenersAttached;
    private DocumentListener cnbDL;
    private DocumentListener layerDL;
    private DocumentListener bundleDL;
    private boolean libraryModule;
    private JLabel bundle;
    private JTextField bundleValue;
    private JLabel codeNameBase;
    private JTextField codeNameBaseValue;
    private JPanel confPanel;
    private JLabel displayName;
    private JTextField displayNameValue;
    private JLabel filler;
    private JLabel layer;
    private JTextField layerValue;

    public BasicConfVisualPanel(WizardDescriptor wizardDescriptor) {
        this(wizardDescriptor, false);
    }

    public BasicConfVisualPanel(WizardDescriptor wizardDescriptor, boolean bl) {
        super(wizardDescriptor);
        this.libraryModule = bl;
        this.initComponents();
        this.initAccessibility();
        this.data = NewModuleProjectData.getData(wizardDescriptor);
        this.cnbDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicConfVisualPanel.this.checkCodeNameBase();
            }
        };
        if (!this.libraryModule) {
            this.layerDL = new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    BasicConfVisualPanel.this.wasLayerUpdated = true;
                    BasicConfVisualPanel.this.checkLayer();
                }
            };
        } else {
            this.layer.setVisible(false);
            this.layerValue.setVisible(false);
        }
        this.bundleDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicConfVisualPanel.this.wasBundleUpdated = true;
                BasicConfVisualPanel.this.checkBundle();
            }
        };
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_BasicConfVisualPanel"));
        this.bundleValue.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_BundleValue"));
        this.codeNameBaseValue.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_CodeNameBaseValue"));
        this.displayNameValue.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_DisplayNameValue"));
        this.layerValue.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_LayerValue"));
    }

    private void checkCodeNameBase() {
        if (!Util.isValidCodeNameBase(this.getCodeNameBaseValue())) {
            this.setErrorMessage(BasicConfVisualPanel.getMessage("MSG_InvalidCNB"));
        } else if (this.data.isSuiteComponent() && this.cnbIsAlreadyInSuite(this.data.getSuiteRoot(), this.getCodeNameBaseValue())) {
            this.setErrorMessage(NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)"MSG_ComponentWithSuchCNBAlreadyInSuite", (Object)this.getCodeNameBaseValue()));
        } else {
            this.setErrorMessage(null);
            String string = this.getCodeNameBaseValue();
            String string2 = string.replace('.', '/');
            if (!this.wasBundleUpdated) {
                this.bundleValue.setText(string2 + "/Bundle.properties");
                this.wasBundleUpdated = false;
            }
            if (!this.wasLayerUpdated && !this.libraryModule) {
                this.layerValue.setText(string2 + "/layer.xml");
                this.wasLayerUpdated = false;
            }
        }
    }

    private void checkBundle() {
        this.checkEntry(this.getBundleValue(), "bundle", ".properties");
    }

    private void checkLayer() {
        this.checkEntry(this.getLayerValue(), "layer", ".xml");
    }

    private void checkEntry(String string, String string2, String string3) {
        if (string.length() == 0) {
            this.setErrorMessage(NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)("BasicConfVisualPanel_err_" + string2 + "_empty")));
            return;
        }
        if (string.indexOf(47) == -1) {
            this.setErrorMessage(NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)("BasicConfVisualPanel_err_" + string2 + "_def_pkg")));
            return;
        }
        if (!string.endsWith(string3)) {
            this.setErrorMessage(NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)("BasicConfVisualPanel_err_" + string2 + "_ext"), (Object)string3));
            return;
        }
        this.setErrorMessage(null);
    }

    void refreshData() {
        String string = this.data.getCodeNameBase();
        this.codeNameBaseValue.setText(string);
        if (string.startsWith(EXAMPLE_BASE_NAME)) {
            this.codeNameBaseValue.select(0, EXAMPLE_BASE_NAME.length() - 1);
        }
        String string2 = this.data.getProjectDisplayName();
        this.displayNameValue.setText(string2);
        this.checkCodeNameBase();
    }

    void storeData() {
        this.data.setCodeNameBase(this.getCodeNameBaseValue());
        this.data.setProjectDisplayName(this.displayNameValue.getText());
        this.data.setBundle(this.getBundleValue());
        if (!this.libraryModule) {
            this.data.setLayer(this.getLayerValue());
        }
    }

    private String getCodeNameBaseValue() {
        return this.codeNameBaseValue.getText().trim();
    }

    private String getBundleValue() {
        return this.bundleValue.getText().trim();
    }

    private String getLayerValue() {
        return this.layerValue.getText().trim();
    }

    private boolean cnbIsAlreadyInSuite(String string, String string2) {
        boolean bl = false;
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        try {
            Project project = ProjectManager.getDefault().findProject(fileObject);
            Iterator iterator = SuiteUtils.getSubProjects(project).iterator();
            while (iterator.hasNext()) {
                Project project2 = (Project)iterator.next();
                if (!ProjectUtils.getInformation((Project)project2).getName().equals(string2)) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
        }
        return bl;
    }

    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
    }

    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.codeNameBaseValue.getDocument().addDocumentListener(this.cnbDL);
            this.bundleValue.getDocument().addDocumentListener(this.bundleDL);
            this.layerValue.getDocument().addDocumentListener(this.layerDL);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.codeNameBaseValue.getDocument().removeDocumentListener(this.cnbDL);
            this.bundleValue.getDocument().removeDocumentListener(this.bundleDL);
            this.layerValue.getDocument().removeDocumentListener(this.layerDL);
            this.listenersAttached = false;
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)string);
    }

    private void initComponents() {
        this.confPanel = new JPanel();
        this.codeNameBase = new JLabel();
        this.displayName = new JLabel();
        this.bundle = new JLabel();
        this.layer = new JLabel();
        this.codeNameBaseValue = new JTextField();
        this.displayNameValue = new JTextField();
        this.bundleValue = new JTextField();
        this.layerValue = new JTextField();
        this.filler = new JLabel();
        this.setLayout(new GridBagLayout());
        this.confPanel.setLayout(new GridBagLayout());
        this.codeNameBase.setLabelFor(this.codeNameBaseValue);
        Mnemonics.setLocalizedText((JLabel)this.codeNameBase, (String)NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)"LBL_CodeNameBase"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.confPanel.add((Component)this.codeNameBase, gridBagConstraints);
        this.displayName.setLabelFor(this.displayNameValue);
        Mnemonics.setLocalizedText((JLabel)this.displayName, (String)NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)"LBL_ModuleDisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.confPanel.add((Component)this.displayName, gridBagConstraints);
        this.bundle.setLabelFor(this.bundleValue);
        Mnemonics.setLocalizedText((JLabel)this.bundle, (String)NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)"LBL_LocalizingBundle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.confPanel.add((Component)this.bundle, gridBagConstraints);
        this.layer.setLabelFor(this.layerValue);
        Mnemonics.setLocalizedText((JLabel)this.layer, (String)NbBundle.getMessage((Class)BasicConfVisualPanel.class, (String)"LBL_XMLLayer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.confPanel.add((Component)this.layer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.confPanel.add((Component)this.codeNameBaseValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.confPanel.add((Component)this.displayNameValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.confPanel.add((Component)this.bundleValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.confPanel.add((Component)this.layerValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        this.confPanel.add((Component)this.filler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.confPanel, gridBagConstraints);
    }
}

