/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class BasicWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private transient int position = 0;
    private transient PrivateWizardPanel[] wizardPanels;
    static /* synthetic */ Class class$org$netbeans$api$project$Sources;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BasicWizardIterator() {
    }

    protected abstract Panel[] createPanels(WizardDescriptor var1);

    public void initialize(WizardDescriptor wizardDescriptor) {
        String[] stringArray = null;
        Object object = wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        this.position = 0;
        Panel[] panelArray = this.createPanels(wizardDescriptor);
        String[] stringArray2 = BasicWizardIterator.createSteps(stringArray, panelArray);
        this.wizardPanels = new PrivateWizardPanel[panelArray.length];
        for (int i = 0; i < panelArray.length; ++i) {
            this.wizardPanels[i] = new PrivateWizardPanel(panelArray[i], stringArray2, i);
        }
    }

    private static String[] createSteps(String[] stringArray, Panel[] panelArray) {
        if (!$assertionsDisabled && panelArray == null) {
            throw new AssertionError();
        }
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getPanelName();
        }
        return stringArray2;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizardPanels = null;
    }

    public String name() {
        return ((PrivateWizardPanel)this.current()).getPanel().getPanelName();
    }

    public boolean hasNext() {
        return this.position < this.wizardPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.position;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.position;
    }

    public WizardDescriptor.Panel current() {
        return this.wizardPanels[this.position];
    }

    protected final String getMessage(String string) {
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    protected Set getCreatedFiles(CreatedModifiedFiles createdModifiedFiles, Project project) throws IOException {
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        String[] stringArray = createdModifiedFiles.getCreatedPaths();
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        for (int i = 0; i < stringArray.length; ++i) {
            FileObject fileObject = project.getProjectDirectory().getFileObject(stringArray[i]);
            BasicWizardIterator.formatFile(fileObject);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject == null || hashSet.size() >= 10 || !hashSet.add(dataObject)) continue;
            hashSet2.add(fileObject);
        }
        return hashSet2;
    }

    private static BaseDocument getDocument(FileObject fileObject) throws DataObjectNotFoundException, IOException {
        EditorCookie editorCookie;
        BaseDocument baseDocument = null;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
            baseDocument = (BaseDocument)editorCookie.openDocument();
        }
        return baseDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void formatFile(FileObject var0) {
        if (!BasicWizardIterator.$assertionsDisabled && var0 == null) {
            throw new AssertionError();
        }
        var1_1 = null;
        var2_2 = false;
        try {
            block14: {
                var1_1 = BasicWizardIterator.getDocument(var0);
                if (var1_1 != null) break block14;
                var10_3 = null;
                if (var1_1 == null) return;
                ** GOTO lbl57
            }
            var3_11 = var1_1 instanceof GuardedDocument != false ? (GuardedDocument)var1_1 : null;
            var1_1.atomicLock();
            var4_13 = 0;
            var5_14 = var1_1.createPosition(var1_1.getLength());
            var6_15 = var4_13;
            if (var3_11 != null) {
                var6_15 = var3_11.getGuardedBlockChain().adjustToBlockEnd(var6_15);
            }
            while (var6_15 < var5_14.getOffset()) {
                var7_16 = var5_14.getOffset();
                if (var3_11 != null && (var7_16 = var3_11.getGuardedBlockChain().adjustToNextBlockStart(var6_15)) == -1) {
                    var7_16 = var5_14.getOffset();
                }
                var8_17 = var1_1.getFormatter().reformat(var1_1, var6_15, var7_16);
                var6_15 += var8_17;
                if (var3_11 == null) continue;
                var6_15 = var3_11.getGuardedBlockChain().adjustToBlockEnd(var6_15);
            }
            var2_2 = true;
            ** GOTO lbl65
        }
        catch (Exception var3_12) {
            ErrorManager.getDefault().log(16, "Cannot reformat the file: " + var0.getPath());
            var10_5 = null;
            if (var1_1 == null) return;
            var1_1.atomicUnlock();
            if (var2_2 == false) return;
            try {
                ((EditorCookie)DataObject.find((FileObject)var0).getCookie(EditorCookie.class)).saveDocument();
                return;
            }
            catch (IOException var11_9) {
                Util.err.notify(1, (Throwable)var11_9);
                return;
            }
        }
        {
            catch (Throwable var9_18) {
                var10_6 = null;
                if (var1_1 == null) throw var9_18;
                var1_1.atomicUnlock();
                if (var2_2 == false) throw var9_18;
                ** try [egrp 2[TRYBLOCK] [6 : 244->283)] { 
lbl52:
                // 1 sources

                ((EditorCookie)DataObject.find((FileObject)var0).getCookie(EditorCookie.class)).saveDocument();
                throw var9_18;
lbl54:
                // 1 sources

                catch (IOException var11_10) {
                    Util.err.notify(1, (Throwable)var11_10);
                }
                throw var9_18;
            }
lbl57:
            // 1 sources

            var1_1.atomicUnlock();
            if (var2_2 == false) return;
            ** try [egrp 2[TRYBLOCK] [6 : 244->283)] { 
lbl60:
            // 1 sources

            ((EditorCookie)DataObject.find((FileObject)var0).getCookie(EditorCookie.class)).saveDocument();
            return;
lbl62:
            // 1 sources

            catch (IOException var11_7) {
                Util.err.notify(1, (Throwable)var11_7);
            }
            return;
lbl65:
            // 1 sources

            var10_4 = null;
            if (var1_1 == null) return;
            var1_1.atomicUnlock();
            if (var2_2 == false) return;
            try {}
            catch (IOException var11_8) {}
            Util.err.notify(1, (Throwable)var11_8);
            return;
            ((EditorCookie)DataObject.find((FileObject)var0).getCookie(EditorCookie.class)).saveDocument();
            return;
        }
    }

    static {
        $assertionsDisabled = !BasicWizardIterator.class.desiredAssertionStatus();
    }

    private static final class PrivateWizardPanel
    extends BasicWizardPanel {
        private Panel panel;

        PrivateWizardPanel(Panel panel, String[] stringArray, int n) {
            super(panel.getSettings());
            panel.addPropertyChangeListener(this);
            panel.setName(panel.getPanelName());
            this.panel = panel;
            if (panel instanceof JComponent) {
                Panel panel2 = panel;
                panel2.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(n));
                panel2.putClientProperty("WizardPanel_contentData", stringArray);
            }
        }

        private Panel getPanel() {
            return this.panel;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        public void storeSettings(Object object) {
            WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
            if (WizardDescriptor.NEXT_OPTION.equals(wizardDescriptor.getValue()) || WizardDescriptor.FINISH_OPTION.equals(wizardDescriptor.getValue())) {
                this.panel.storeToDataModel();
            }
            ((WizardDescriptor)object).putProperty("NewFileWizard_Title", null);
        }

        public void readSettings(Object object) {
            WizardDescriptor wizardDescriptor;
            Object object2 = this.getPanel().getClientProperty("NewFileWizard_Title");
            if (object2 != null) {
                ((WizardDescriptor)object).putProperty("NewFileWizard_Title", object2);
            }
            if (WizardDescriptor.NEXT_OPTION.equals((wizardDescriptor = (WizardDescriptor)object).getValue()) || wizardDescriptor.getValue() == null) {
                this.panel.readFromDataModel();
            }
        }

        public HelpCtx getHelp() {
            return this.getPanel().getHelp();
        }
    }

    public static class BasicDataModel {
        private NbModuleProject project;
        private SourceGroup sourceRootGroup;
        private String packageName;
        static final /* synthetic */ boolean $assertionsDisabled;

        public BasicDataModel(WizardDescriptor wizardDescriptor) {
            Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
            if (project == null) {
                throw new IllegalArgumentException();
            }
            if (!(project instanceof NbModuleProject)) {
                throw new IllegalArgumentException(this.project.getClass().toString());
            }
            this.project = (NbModuleProject)project;
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
            if (fileObject != null) {
                Sources sources = (Sources)this.project.getLookup().lookup(class$org$netbeans$api$project$Sources == null ? (class$org$netbeans$api$project$Sources = BasicWizardIterator.class$("org.netbeans.api.project.Sources")) : class$org$netbeans$api$project$Sources);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
                    String string = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
                    string = string.replace('/', '.');
                    this.setPackageName(string);
                    break;
                }
            }
        }

        public NbModuleProject getProject() {
            return this.project;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String string) {
            this.packageName = string;
        }

        public SourceGroup getSourceRootGroup() {
            if (this.sourceRootGroup == null) {
                FileObject fileObject = this.getProject().getSourceDirectory();
                if (!$assertionsDisabled && fileObject == null) {
                    throw new AssertionError();
                }
                Sources sources = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                for (int i = 0; this.sourceRootGroup == null && i < sourceGroupArray.length; ++i) {
                    if (!sourceGroupArray[i].getRootFolder().equals(fileObject)) continue;
                    this.sourceRootGroup = sourceGroupArray[i];
                }
            }
            return this.sourceRootGroup;
        }

        public String getDefaultPackagePath(String string) {
            return this.getProject().getSourceDirectoryPath() + '/' + this.getPackageName().replace('.', '/') + '/' + string;
        }

        public String addCreateIconOperation(CreatedModifiedFiles createdModifiedFiles, String string) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(string));
            String string2 = null;
            if (!FileUtil.isParentOf((FileObject)this.getProject().getSourceDirectory(), (FileObject)fileObject)) {
                String string3 = this.getDefaultPackagePath(fileObject.getNameExt());
                try {
                    createdModifiedFiles.add(createdModifiedFiles.createFile(string3, fileObject.getURL()));
                    string2 = this.getPackageName().replace('.', '/') + '/' + fileObject.getNameExt();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Util.err.notify((Throwable)fileStateInvalidException);
                }
            } else {
                string2 = FileUtil.getRelativePath((FileObject)this.getProject().getSourceDirectory(), (FileObject)fileObject);
            }
            return string2;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$wizard$BasicWizardIterator == null ? (class$org$netbeans$modules$apisupport$project$ui$wizard$BasicWizardIterator = BasicWizardIterator.class$("org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator")) : class$org$netbeans$modules$apisupport$project$ui$wizard$BasicWizardIterator).desiredAssertionStatus();
        }
    }

    public static abstract class Panel
    extends BasicVisualPanel {
        protected Panel(WizardDescriptor wizardDescriptor) {
            super(wizardDescriptor);
        }

        protected abstract String getPanelName();

        protected abstract void storeToDataModel();

        protected abstract void readFromDataModel();

        protected abstract HelpCtx getHelp();
    }
}

