/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class LibraryStartVisualPanel
extends BasicVisualPanel {
    static final String PROP_LIBRARY_PATH = "LIBRARY_PATH_VALUE";
    static final String PROP_LICENSE_PATH = "LICENSE_PATH_VALUE";
    private NewModuleProjectData data;
    private boolean listenersAttached;
    private DocumentListener libraryDL;
    private DocumentListener licenseDL;
    private JButton browseLibraryButton;
    private JButton browseLicenceButton;
    private JPanel confPanel;
    private JPanel filler;
    private JLabel lblLibrary;
    private JLabel lblLicense;
    private JTextField txtLibrary;
    private JTextField txtLicense;

    public LibraryStartVisualPanel(WizardDescriptor wizardDescriptor) {
        super(wizardDescriptor);
        this.initComponents();
        this.initAccessibility();
        this.data = NewModuleProjectData.getData(wizardDescriptor);
        this.libraryDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                LibraryStartVisualPanel.this.checkLibraryAndLicense();
            }
        };
        this.licenseDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                LibraryStartVisualPanel.this.checkLibraryAndLicense();
            }
        };
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_LibraryStartVisualPanel"));
        this.browseLibraryButton.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_BrowseLibraries"));
        this.browseLicenceButton.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_BrowseLicense"));
        this.txtLibrary.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_Library"));
        this.txtLicense.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_License"));
    }

    private void checkLibraryAndLicense() {
        Object object;
        String string = this.txtLibrary.getText().trim();
        if (string.length() > 0) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                File file = new File(string2);
                if (!file.exists()) {
                    this.setErrorMessage(LibraryStartVisualPanel.getMessage("MSG_Invalid_Library_Path"));
                    return;
                }
                try {
                    new JarFile(file);
                }
                catch (IOException iOException) {
                    this.setErrorMessage(LibraryStartVisualPanel.getMessage("MSG_Invalid_Library_Path"));
                    return;
                }
                String string3 = LibraryStartVisualPanel.populateProjectData(this.data, string, false);
                if (string3 == null) continue;
                this.setErrorMessage(NbBundle.getMessage((Class)LibraryStartVisualPanel.class, (String)"MSG_ClassInDefaultPackage", (Object)string3), true);
                this.setValid(Boolean.TRUE);
                return;
            }
        } else {
            this.setErrorMessage(LibraryStartVisualPanel.getMessage("MSG_Library_Path_Not_Defined"));
            return;
        }
        string = this.txtLicense.getText().trim();
        if (string.length() > 0 && !((File)(object = new File(string))).exists()) {
            this.setErrorMessage(LibraryStartVisualPanel.getMessage("MSG_Invalid_License_Path"));
            return;
        }
        this.setErrorMessage(null);
    }

    void refreshData() {
    }

    void storeData() {
        String string = this.txtLibrary.getText().trim();
        this.getSettings().putProperty(PROP_LIBRARY_PATH, (Object)string);
        this.getSettings().putProperty(PROP_LICENSE_PATH, (Object)this.txtLicense.getText().trim());
        LibraryStartVisualPanel.populateProjectData(this.data, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String populateProjectData(NewModuleProjectData var0, String var1_1, boolean var2_2) {
        block17: {
            if (var0.getProjectName() != null && var0.getCodeNameBase() != null && var2_2) {
                return null;
            }
            var3_3 = null;
            var4_4 = new StringTokenizer(var1_1, File.pathSeparator);
            var5_5 = false;
            var6_6 = false;
            if (var4_4.hasMoreTokens() == false) return var3_3;
            var6_6 = false;
            var7_7 = new File(var4_4.nextToken());
            if (!var7_7.exists()) {
                return var3_3;
            }
            var8_8 = var7_7.getName();
            var9_9 = var8_8.lastIndexOf(46);
            if (var9_9 > -1) {
                var8_8 = var8_8.substring(0, var9_9);
            }
            var8_8 = var8_8.replaceAll("[0-9._-]+$", "");
            if (var2_2) {
                var0.setProjectName(var8_8);
            }
            var10_10 = null;
            var11_11 = null;
            try {
                var10_10 = new JarFile(var7_7);
                var12_12 = var10_10.entries();
                while (var12_12.hasMoreElements()) {
                    var13_15 = var12_12.nextElement();
                    if (var13_15.isDirectory() || !var13_15.getName().endsWith(".class")) continue;
                    var14_16 = var13_15.getName();
                    var15_17 = var14_16.lastIndexOf(47);
                    if (var15_17 > -1) {
                        var16_18 = var14_16.substring(0, var15_17);
                        if (var11_11 != null && var16_18.length() == var11_11.length() && !var16_18.equals(var11_11)) {
                            var5_5 = true;
                        }
                        if (var11_11 != null && var16_18.length() >= var11_11.length()) continue;
                        var11_11 = var16_18;
                        var5_5 = false;
                        continue;
                    }
                    if (var6_6) continue;
                    var3_3 = var3_3 == null ? var7_7.getName() : var3_3 + "," + var7_7.getName();
                    var6_6 = true;
                }
                var18_19 = null;
                if (var10_10 == null) break block17;
                ** GOTO lbl66
            }
            catch (IOException var12_13) {
                ErrorManager.getDefault().notify(16, (Throwable)var12_13);
                var18_20 = null;
                if (var10_10 != null) {
                    try {
                        var10_10.close();
                    }
                    catch (IOException var19_23) {
                        Util.err.notify(1, (Throwable)var19_23);
                    }
                }
                break block17;
            }
            {
                catch (Throwable var17_25) {
                    var18_21 = null;
                    if (var10_10 == null) throw var17_25;
                    ** try [egrp 2[TRYBLOCK] [4 : 377->385)] { 
lbl61:
                    // 1 sources

                    var10_10.close();
                    throw var17_25;
lbl63:
                    // 1 sources

                    catch (IOException var19_24) {
                        Util.err.notify(1, (Throwable)var19_24);
                    }
                    throw var17_25;
                }
lbl66:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 377->385)] { 
lbl67:
                // 1 sources

                var10_10.close();
lbl69:
                // 1 sources

                catch (IOException var19_22) {}
                Util.err.notify(1, (Throwable)var19_22);
            }
        }
        if (var11_11 == null) return var3_3;
        if (var2_2 == false) return var3_3;
        var11_11 = var11_11.replace('/', '.');
        if (var5_5 && var11_11.indexOf(46) != var11_11.lastIndexOf(46)) {
            var12_14 = var11_11.lastIndexOf(46);
            var11_11 = var11_11.substring(0, var12_14);
        }
        var0.setCodeNameBase(var11_11);
        return var3_3;
    }

    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
    }

    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.txtLibrary.getDocument().addDocumentListener(this.libraryDL);
            this.txtLicense.getDocument().addDocumentListener(this.licenseDL);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.txtLibrary.getDocument().removeDocumentListener(this.libraryDL);
            this.txtLicense.getDocument().removeDocumentListener(this.licenseDL);
            this.listenersAttached = false;
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)LibraryStartVisualPanel.class, (String)string);
    }

    private void initComponents() {
        this.confPanel = new JPanel();
        this.lblLibrary = new JLabel();
        this.txtLibrary = new JTextField();
        this.lblLicense = new JLabel();
        this.txtLicense = new JTextField();
        this.browseLibraryButton = new JButton();
        this.browseLicenceButton = new JButton();
        this.filler = new JPanel();
        this.setLayout(new GridBagLayout());
        this.confPanel.setLayout(new GridBagLayout());
        this.lblLibrary.setLabelFor(this.txtLibrary);
        Mnemonics.setLocalizedText((JLabel)this.lblLibrary, (String)NbBundle.getMessage((Class)LibraryStartVisualPanel.class, (String)"LBL_Library_path"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.confPanel.add((Component)this.lblLibrary, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.confPanel.add((Component)this.txtLibrary, gridBagConstraints);
        this.lblLicense.setLabelFor(this.txtLicense);
        Mnemonics.setLocalizedText((JLabel)this.lblLicense, (String)NbBundle.getMessage((Class)LibraryStartVisualPanel.class, (String)"LBL_License_Path"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.confPanel.add((Component)this.lblLicense, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.confPanel.add((Component)this.txtLicense, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseLibraryButton, (String)NbBundle.getMessage((Class)LibraryStartVisualPanel.class, (String)"CTL_BrowseButton_o"));
        this.browseLibraryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryStartVisualPanel.this.browseLibraryButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.confPanel.add((Component)this.browseLibraryButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseLicenceButton, (String)NbBundle.getMessage((Class)LibraryStartVisualPanel.class, (String)"CTL_BrowseButton_w"));
        this.browseLicenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryStartVisualPanel.this.browseLicenceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.confPanel.add((Component)this.browseLicenceButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.confPanel.add((Component)this.filler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.confPanel, gridBagConstraints);
    }

    private void browseLicenceButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        JFileChooser jFileChooser = new JFileChooser(ModuleUISettings.getDefault().getLastChosenLibraryLocation());
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        if (this.txtLicense.getText().trim().length() > 0) {
            jFileChooser.setSelectedFile(new File(this.txtLicense.getText().trim()));
        }
        if ((n = jFileChooser.showDialog(this, LibraryStartVisualPanel.getMessage("LBL_Select"))) == 0) {
            this.txtLicense.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            ModuleUISettings.getDefault().setLastChosenLibraryLocation(this.txtLicense.getText());
        }
    }

    private void browseLibraryButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(ModuleUISettings.getDefault().getLastChosenLibraryLocation());
        File[] fileArray = LibraryStartVisualPanel.convertStringToFiles(this.txtLibrary.getText().trim());
        jFileChooser.setSelectedFiles(fileArray);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.addChoosableFileFilter(new JarZipFilter());
        int n = jFileChooser.showDialog(this, LibraryStartVisualPanel.getMessage("LBL_Select"));
        if (n == 0) {
            File[] fileArray2 = jFileChooser.getSelectedFiles();
            String string = "";
            for (int i = 0; i < fileArray2.length; ++i) {
                string = string + fileArray2[i] + (i == fileArray2.length - 1 ? "" : File.pathSeparator);
            }
            this.txtLibrary.setText(string);
            ModuleUISettings.getDefault().setLastChosenLibraryLocation(fileArray2[0].getParentFile().getAbsolutePath());
        }
    }

    static File[] convertStringToFiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        File[] fileArray = new File[stringTokenizer.countTokens()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringTokenizer.nextToken());
        }
        return fileArray;
    }

    private static final class JarZipFilter
    extends FileFilter {
        private JarZipFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith("zip") || file.getName().endsWith("jar");
        }

        public String getDescription() {
            return LibraryStartVisualPanel.getMessage("LibraryStartVisualPanel_jar_zip_filter");
        }
    }
}

