/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.suite.SuiteProjectGenerator;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicConfWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicInfoWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryConfWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryStartVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryStartWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewNbModuleWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    static final int TYPE_MODULE = 1;
    static final int TYPE_SUITE = 2;
    static final int TYPE_LIBRARY_MODULE = 3;
    static final String PROP_NAME_INDEX = "nameIndex";
    private transient int position;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor settings;
    private transient int type;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NewNbModuleWizardIterator(int n) {
        this.type = n;
    }

    public static NewNbModuleWizardIterator createModuleIterator() {
        return new NewNbModuleWizardIterator(1);
    }

    public static NewNbModuleWizardIterator createSuiteIterator() {
        return new NewNbModuleWizardIterator(2);
    }

    public static NewNbModuleWizardIterator createLibraryModuleIterator() {
        return new NewNbModuleWizardIterator(3);
    }

    public Set instantiate() throws IOException {
        Serializable serializable;
        FileObject fileObject;
        NewModuleProjectData newModuleProjectData = NewModuleProjectData.getData(this.settings);
        File file = new File(newModuleProjectData.getProjectFolder());
        ModuleUISettings.getDefault().setLastUsedModuleLocation(newModuleProjectData.getProjectLocation());
        ModuleUISettings.getDefault().setLastUsedPlatformID(newModuleProjectData.getPlatformID());
        if (this.type == 1) {
            ModuleUISettings.getDefault().setNewModuleCounter(newModuleProjectData.getModuleCounter());
            if (newModuleProjectData.isNetBeansOrg()) {
                NbModuleProjectGenerator.createNetBeansOrgModule(file, newModuleProjectData.getCodeNameBase(), newModuleProjectData.getProjectDisplayName(), newModuleProjectData.getBundle(), newModuleProjectData.getLayer());
            } else if (newModuleProjectData.isStandalone()) {
                NbModuleProjectGenerator.createStandAloneModule(file, newModuleProjectData.getCodeNameBase(), newModuleProjectData.getProjectDisplayName(), newModuleProjectData.getBundle(), newModuleProjectData.getLayer(), newModuleProjectData.getPlatformID());
            } else {
                NbModuleProjectGenerator.createSuiteComponentModule(file, newModuleProjectData.getCodeNameBase(), newModuleProjectData.getProjectDisplayName(), newModuleProjectData.getBundle(), newModuleProjectData.getLayer(), new File(newModuleProjectData.getSuiteRoot()));
            }
        } else if (this.type == 3) {
            fileObject = LibraryStartVisualPanel.convertStringToFiles((String)this.settings.getProperty("LIBRARY_PATH_VALUE"));
            serializable = null;
            String string = (String)this.settings.getProperty("LICENSE_PATH_VALUE");
            if (string != null && string.length() > 0) {
                serializable = new File(string);
            }
            NbModuleProjectGenerator.createSuiteLibraryModule(file, newModuleProjectData.getCodeNameBase(), newModuleProjectData.getProjectDisplayName(), newModuleProjectData.getBundle(), new File(newModuleProjectData.getSuiteRoot()), serializable, (File[])fileObject);
        } else if (this.type == 2) {
            ModuleUISettings.getDefault().setNewSuiteCounter(newModuleProjectData.getSuiteCounter());
            SuiteProjectGenerator.createSuiteProject(file, newModuleProjectData.getPlatformID());
        } else {
            throw new IllegalStateException("Uknown wizard type: " + this.type);
        }
        fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        serializable = new HashSet<FileObject>();
        serializable.add(fileObject);
        UIUtil.setProjectChooserDirParent(file);
        this.settings.putProperty("setAsMain", (Object)newModuleProjectData.isMainProject());
        return serializable;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.settings = wizardDescriptor;
        this.position = 0;
        String[] stringArray = null;
        switch (this.type) {
            case 1: {
                stringArray = this.initModuleWizard();
                break;
            }
            case 2: {
                stringArray = this.initSuiteModuleWizard();
                break;
            }
            case 3: {
                stringArray = this.initLibraryModuleWizard();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Should never get here. type: " + this.type));
                }
                break;
            }
        }
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.settings = null;
        this.panels = null;
    }

    private String[] initModuleWizard() {
        this.panels = new WizardDescriptor.Panel[]{new BasicInfoWizardPanel(this.settings, 1), new BasicConfWizardPanel(this.settings)};
        String[] stringArray = new String[]{NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_BasicConfigPanel_Title")};
        return stringArray;
    }

    private String[] initSuiteModuleWizard() {
        this.panels = new WizardDescriptor.Panel[]{new BasicInfoWizardPanel(this.settings, 2)};
        String[] stringArray = new String[]{NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title")};
        return stringArray;
    }

    private String[] initLibraryModuleWizard() {
        this.panels = new WizardDescriptor.Panel[]{new LibraryStartWizardPanel(this.settings), new BasicInfoWizardPanel(this.settings, 3), new LibraryConfWizardPanel(this.settings)};
        String[] stringArray = new String[]{NewNbModuleWizardIterator.getMessage("LBL_LibraryStartPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_PlatformSelectionPanel_Title")};
        return stringArray;
    }

    public String name() {
        return null;
    }

    public boolean hasNext() {
        return this.position < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.position;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.position;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.position];
    }

    static String getMessage(String string) {
        return NbBundle.getMessage((Class)NewNbModuleWizardIterator.class, (String)string);
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    static {
        $assertionsDisabled = !NewNbModuleWizardIterator.class.desiredAssertionStatus();
    }
}

