/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.action.DataModel;
import org.netbeans.modules.apisupport.project.ui.wizard.action.ShortcutEnterPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class GUIRegistrationPanel
extends BasicWizardIterator.Panel {
    private final RequestProcessor SFS_RP = new RequestProcessor(GUIRegistrationPanel.class.getName());
    private static final String ACTIONS_DIR = "Actions";
    private FileSystem sfs;
    private final ListCellRenderer POSITION_RENDERER = new PositionRenderer();
    private static final String POSITION_HERE;
    private static final String POSITION_SEPARATOR = " - ";
    private DataModel data;
    private final JComponent[] gmiGroup;
    private final JComponent[] toolbarGroup;
    private final JComponent[] shortcutGroup;
    private final JComponent[] fileTypeGroup;
    private final JComponent[] editorGroup;
    private JComboBox category;
    private JLabel categoryTxt;
    private JComboBox edContentType;
    private JLabel edContentTypeTxt;
    private JComboBox edPosition;
    private JLabel edPositionTxt;
    private JCheckBox edSeparatorAfter;
    private JCheckBox edSeparatorBefore;
    private JPanel edSeparatorPanel;
    JCheckBox editorContext;
    JCheckBox fileTypeContext;
    private JLabel filler;
    private JComboBox ftContentType;
    private JLabel ftContentTypeTxt;
    private JComboBox ftPosition;
    private JLabel ftPositionTxt;
    private JCheckBox ftSeparatorAfter;
    private JCheckBox ftSeparatorBefore;
    private JPanel ftSeparatorPanel;
    private JCheckBox globalKeyboardShortcut;
    JCheckBox globalMenuItem;
    JCheckBox globalToolbarButton;
    private JLabel keyStroke;
    private JButton keyStrokeChange;
    private JLabel keyStrokeTxt;
    private JComboBox menu;
    private JComboBox menuPosition;
    private JLabel menuPositionTxt;
    private JCheckBox menuSeparatorAfter;
    private JCheckBox menuSeparatorBefore;
    private JPanel menuSeparatorPanel;
    private JLabel menuTxt;
    private JComboBox toolbar;
    private JComboBox toolbarPosition;
    private JLabel toolbarPositionTxt;
    private JLabel toolbarTxt;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GUIRegistrationPanel(WizardDescriptor wizardDescriptor, DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccesibility();
        this.putClientProperty("NewFileWizard_Title", GUIRegistrationPanel.getMessage("LBL_ActionWizardTitle"));
        this.menu.addPopupMenuListener(new PML(this.menu, this.menuPosition));
        this.toolbar.addPopupMenuListener(new PML(this.toolbar, this.toolbarPosition));
        this.ftContentType.addPopupMenuListener(new PML(this.ftContentType, this.ftPosition));
        this.edContentType.addPopupMenuListener(new PML(this.edContentType, this.edPosition));
        this.gmiGroup = new JComponent[]{this.menu, this.menuTxt, this.menuPosition, this.menuPositionTxt, this.menuSeparatorAfter, this.menuSeparatorBefore};
        this.toolbarGroup = new JComponent[]{this.toolbar, this.toolbarTxt, this.toolbarPosition, this.toolbarPositionTxt};
        this.shortcutGroup = new JComponent[]{this.keyStroke, this.keyStrokeTxt, this.keyStrokeChange};
        this.fileTypeGroup = new JComponent[]{this.ftContentType, this.ftContentTypeTxt, this.ftPosition, this.ftPositionTxt, this.ftSeparatorAfter, this.ftSeparatorBefore};
        this.editorGroup = new JComponent[]{this.edContentType, this.edContentTypeTxt, this.edPosition, this.edPositionTxt, this.edSeparatorAfter, this.edSeparatorBefore};
        this.readSFS();
    }

    private void setEditable(final JComboBox jComboBox) {
        jComboBox.setEditable(true);
        if (jComboBox.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
            jTextField.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    if (!CustomizerComponentFactory.hasOnlyValue(jComboBox.getModel(), CustomizerComponentFactory.WAIT_VALUE)) {
                        GUIRegistrationPanel.this.checkValidity();
                    }
                }
            });
        }
    }

    protected String getPanelName() {
        return GUIRegistrationPanel.getMessage("LBL_GUIRegistration_Title");
    }

    private String getCategoryPath() {
        String string = UIUtil.getSFSPath(this.category, ACTIONS_DIR);
        return string == null ? "Actions/Tools" : string;
    }

    protected void storeToDataModel() {
        if (!this.checkValidity()) {
            return;
        }
        this.data.setCategory(this.getCategoryPath());
        this.data.setGlobalMenuItemEnabled(this.globalMenuItem.isSelected());
        if (this.globalMenuItem.isSelected()) {
            this.data.setGMIParentMenu(GUIRegistrationPanel.getSelectedLayerPresenter(this.menu).getFullPath());
            this.data.setGMIPosition((DataModel.Position)this.menuPosition.getSelectedItem());
            this.data.setGMISeparatorAfter(this.menuSeparatorAfter.isSelected());
            this.data.setGMISeparatorBefore(this.menuSeparatorBefore.isSelected());
        }
        this.data.setToolbarEnabled(this.globalToolbarButton.isSelected());
        if (this.globalToolbarButton.isSelected()) {
            this.data.setToolbar(GUIRegistrationPanel.getSelectedLayerPresenter(this.toolbar).getFullPath());
            this.data.setToolbarPosition((DataModel.Position)this.toolbarPosition.getSelectedItem());
        }
        this.data.setKeyboardShortcutEnabled(this.globalKeyboardShortcut.isSelected());
        this.data.setFileTypeContextEnabled(this.fileTypeContext.isSelected());
        if (this.fileTypeContext.isSelected()) {
            this.data.setFTContextType(GUIRegistrationPanel.getSelectedLayerPresenter(this.ftContentType).getFullPath());
            this.data.setFTContextPosition((DataModel.Position)this.ftPosition.getSelectedItem());
            this.data.setFTContextSeparatorBefore(this.ftSeparatorBefore.isSelected());
            this.data.setFTContextSeparatorAfter(this.ftSeparatorAfter.isSelected());
        }
        this.data.setEditorContextEnabled(this.editorContext.isSelected());
        if (this.editorContext.isSelected()) {
            this.data.setEdContextType(GUIRegistrationPanel.getSelectedLayerPresenter(this.edContentType).getFullPath());
            this.data.setEdContextPosition((DataModel.Position)this.edPosition.getSelectedItem());
            this.data.setEdContextSeparatorBefore(this.edSeparatorBefore.isSelected());
            this.data.setEdContextSeparatorAfter(this.edSeparatorAfter.isSelected());
        }
    }

    protected void readFromDataModel() {
        this.initializeGlobalAction();
        this.checkValidity();
    }

    private void initializeGlobalAction() {
        this.globalMenuItem.setSelected(true);
        this.globalMenuItem.setEnabled(true);
        this.setGroupEnabled(this.gmiGroup, this.globalMenuItem.isSelected());
        this.globalToolbarButton.setEnabled(true);
        this.setGroupEnabled(this.toolbarGroup, this.globalToolbarButton.isSelected());
        boolean bl = this.data.isAlwaysEnabled();
        this.globalKeyboardShortcut.setEnabled(bl);
        this.setGroupEnabled(this.shortcutGroup, this.globalKeyboardShortcut.isSelected());
        if (bl) {
            this.fileTypeContext.setSelected(false);
            this.editorContext.setSelected(false);
        }
        this.fileTypeContext.setEnabled(!bl);
        this.setGroupEnabled(this.fileTypeGroup, this.fileTypeContext.isSelected());
        this.editorContext.setEnabled(!bl);
        this.setGroupEnabled(this.editorGroup, this.editorContext.isSelected());
    }

    boolean checkValidity() {
        boolean bl = false;
        if (this.globalKeyboardShortcut.isSelected() && this.keyStroke.getText().equals("")) {
            this.setErrorMessage(GUIRegistrationPanel.getMessage("MSG_YouMustSpecifyShortcut"));
        } else if (!(this.check(this.globalMenuItem, this.menu, this.menuPosition) && this.check(this.globalToolbarButton, this.toolbar, this.toolbarPosition) && this.check(this.fileTypeContext, this.ftContentType, this.ftPosition) && this.check(this.editorContext, this.edContentType, this.edPosition))) {
            this.setValid(Boolean.FALSE);
        } else if (!Util.isValidSFSPath(this.getCategoryPath())) {
            this.setErrorMessage(GUIRegistrationPanel.getMessage("ERR_Category_Invalid"));
        } else {
            this.setErrorMessage(null);
            bl = true;
        }
        return bl;
    }

    private boolean check(JCheckBox jCheckBox, JComboBox jComboBox, JComboBox jComboBox2) {
        boolean bl = !jCheckBox.isSelected() || GUIRegistrationPanel.getSelectedItem(jComboBox) != null && GUIRegistrationPanel.getSelectedItem(jComboBox2) != null;
        return bl;
    }

    private void setGroupEnabled(JComponent[] jComponentArray, boolean bl) {
        for (int i = 0; i < jComponentArray.length; ++i) {
            if (jComponentArray[i] == null) continue;
            jComponentArray[i].setEnabled(bl && !this.isEmptyCombo(jComponentArray[i]));
        }
    }

    private boolean isEmptyCombo(JComponent jComponent) {
        return jComponent instanceof JComboBox && CustomizerComponentFactory.hasOnlyValue(((JComboBox)jComponent).getModel(), CustomizerComponentFactory.EMPTY_VALUE);
    }

    private void readSFS() {
        this.setValid(Boolean.FALSE);
        this.loadComboAndPositions(ACTIONS_DIR, this.category, null, null, true);
        this.loadComboAndPositions("Menu", this.menu, this.menuPosition, null);
        this.loadComboAndPositions("Toolbars", this.toolbar, this.toolbarPosition, null);
        this.loadComboAndPositions("Loaders", this.ftContentType, this.ftPosition, ACTIONS_DIR);
        this.loadComboAndPositions("Editors", this.edContentType, this.edPosition, "Popup");
    }

    private void loadComboAndPositions(String string, JComboBox jComboBox, JComboBox jComboBox2, String string2) {
        this.loadComboAndPositions(string, jComboBox, jComboBox2, string2, false);
    }

    private void loadComboAndPositions(final String string, final JComboBox jComboBox, final JComboBox jComboBox2, final String string2, final boolean bl) {
        jComboBox.setModel(CustomizerComponentFactory.createComboWaitModel());
        this.SFS_RP.post(new Runnable(){

            public void run() {
                DataFolder dataFolder;
                Util.err.log("Loading " + string + " from SFS....");
                FileObject fileObject = GUIRegistrationPanel.this.getSFS().getRoot().getFileObject(string);
                DataFolder dataFolder2 = dataFolder = fileObject != null ? DataFolder.findFolder((FileObject)fileObject) : null;
                if (dataFolder == null) {
                    Util.err.log("Could not find " + string);
                    GUIRegistrationPanel.this.setEmptyModel(jComboBox);
                    GUIRegistrationPanel.this.setEmptyModel(jComboBox2);
                    return;
                }
                Enumeration enumeration = string2 == null ? GUIRegistrationPanel.this.getFolders(dataFolder) : GUIRegistrationPanel.this.getFoldersByName(dataFolder, string2);
                EventQueue.invokeLater(new Runnable(this, enumeration, fileObject){
                    private final /* synthetic */ Enumeration val$folders;
                    private final /* synthetic */ FileObject val$parent;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$folders = enumeration;
                        this.val$parent = fileObject;
                    }

                    public void run() {
                        Object object;
                        LinkedHashSet<UIUtil.LayerItemPresenter> linkedHashSet = new LinkedHashSet<UIUtil.LayerItemPresenter>();
                        while (this.val$folders.hasMoreElements()) {
                            object = (DataFolder)this.val$folders.nextElement();
                            linkedHashSet.add(new UIUtil.LayerItemPresenter(object.getPrimaryFile(), this.val$parent, 2.access$500(this.this$1) != null));
                        }
                        if (linkedHashSet.size() == 0) {
                            GUIRegistrationPanel.access$200(2.access$700(this.this$1), 2.access$600(this.this$1));
                            GUIRegistrationPanel.access$200(2.access$700(this.this$1), 2.access$800(this.this$1));
                        } else {
                            object = new DefaultComboBoxModel<E>();
                            Iterator<E> iterator = linkedHashSet.iterator();
                            while (iterator.hasNext()) {
                                ((DefaultComboBoxModel)object).addElement(iterator.next());
                            }
                            2.access$600(this.this$1).setModel(object);
                            if (2.access$900(this.this$1)) {
                                GUIRegistrationPanel.access$1000(2.access$700(this.this$1), 2.access$600(this.this$1));
                            }
                            if (2.access$800(this.this$1) != null) {
                                GUIRegistrationPanel.access$1100(2.access$700(this.this$1), (UIUtil.LayerItemPresenter)2.access$600(this.this$1).getSelectedItem(), 2.access$800(this.this$1));
                            }
                        }
                    }
                });
            }

            static /* synthetic */ String access$500(2 var0) {
                return var0.string2;
            }

            static /* synthetic */ JComboBox access$600(2 var0) {
                return var0.jComboBox;
            }

            static /* synthetic */ GUIRegistrationPanel access$700(2 var0) {
                return var0.GUIRegistrationPanel.this;
            }

            static /* synthetic */ JComboBox access$800(2 var0) {
                return var0.jComboBox2;
            }

            static /* synthetic */ boolean access$900(2 var0) {
                return var0.bl;
            }
        });
    }

    private void loadPositionsCombo(final UIUtil.LayerItemPresenter layerItemPresenter, final JComboBox jComboBox) {
        if (!$assertionsDisabled && layerItemPresenter == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && jComboBox == null) {
            throw new AssertionError();
        }
        jComboBox.setModel(CustomizerComponentFactory.createComboWaitModel());
        this.SFS_RP.post(new Runnable(){

            public void run() {
                Enumeration enumeration = layerItemPresenter.getFileObject().getData(false);
                EventQueue.invokeLater(new Runnable(this, enumeration){
                    private final /* synthetic */ Enumeration val$filesEn;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$filesEn = enumeration;
                    }

                    public void run() {
                        GUIRegistrationPanel.access$1500(4.access$1400(this.this$1), 4.access$1200(this.this$1), this.val$filesEn, 4.access$1300(this.this$1));
                    }
                });
            }

            static /* synthetic */ JComboBox access$1200(4 var0) {
                return var0.jComboBox;
            }

            static /* synthetic */ UIUtil.LayerItemPresenter access$1300(4 var0) {
                return var0.layerItemPresenter;
            }

            static /* synthetic */ GUIRegistrationPanel access$1400(4 var0) {
                return var0.GUIRegistrationPanel.this;
            }
        });
    }

    private void createPositionModel(JComboBox jComboBox, Enumeration enumeration, UIUtil.LayerItemPresenter layerItemPresenter) {
        DefaultComboBoxModel<DataModel.Position> defaultComboBoxModel = new DefaultComboBoxModel<DataModel.Position>();
        UIUtil.LayerItemPresenter layerItemPresenter2 = null;
        while (enumeration.hasMoreElements()) {
            UIUtil.LayerItemPresenter layerItemPresenter3 = new UIUtil.LayerItemPresenter((FileObject)enumeration.nextElement(), layerItemPresenter.getFileObject());
            defaultComboBoxModel.addElement(GUIRegistrationPanel.createPosition(layerItemPresenter2, layerItemPresenter3));
            layerItemPresenter2 = layerItemPresenter3;
        }
        defaultComboBoxModel.addElement(GUIRegistrationPanel.createPosition(layerItemPresenter2, null));
        jComboBox.setModel(defaultComboBoxModel);
        this.checkValidity();
    }

    private static Object getSelectedItem(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        return object == CustomizerComponentFactory.WAIT_VALUE || object == CustomizerComponentFactory.EMPTY_VALUE ? null : object;
    }

    private static UIUtil.LayerItemPresenter getSelectedLayerPresenter(JComboBox jComboBox) {
        return (UIUtil.LayerItemPresenter)GUIRegistrationPanel.getSelectedItem(jComboBox);
    }

    private static DataModel.Position createPosition(UIUtil.LayerItemPresenter layerItemPresenter, UIUtil.LayerItemPresenter layerItemPresenter2) {
        return new DataModel.Position(layerItemPresenter == null ? null : layerItemPresenter.getFileObject().getNameExt(), layerItemPresenter2 == null ? null : layerItemPresenter2.getFileObject().getNameExt(), layerItemPresenter == null ? null : layerItemPresenter.getDisplayName(), layerItemPresenter2 == null ? null : layerItemPresenter2.getDisplayName());
    }

    private void setEmptyModel(JComboBox jComboBox) {
        if (jComboBox != null) {
            jComboBox.setModel(CustomizerComponentFactory.createComboEmptyModel());
            jComboBox.setEnabled(false);
            jComboBox.setEditable(false);
            this.checkValidity();
        }
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(GUIRegistrationPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)string);
    }

    private void initComponents() {
        this.categoryTxt = new JLabel();
        this.category = new JComboBox();
        this.globalMenuItem = new JCheckBox();
        this.menuTxt = new JLabel();
        this.menu = new JComboBox();
        this.menuPositionTxt = new JLabel();
        this.menuPosition = new JComboBox();
        this.menuSeparatorPanel = new JPanel();
        this.menuSeparatorBefore = new JCheckBox();
        this.menuSeparatorAfter = new JCheckBox();
        this.globalToolbarButton = new JCheckBox();
        this.toolbarTxt = new JLabel();
        this.toolbar = new JComboBox();
        this.toolbarPositionTxt = new JLabel();
        this.toolbarPosition = new JComboBox();
        this.globalKeyboardShortcut = new JCheckBox();
        this.keyStrokeTxt = new JLabel();
        this.keyStroke = new JLabel();
        this.keyStrokeChange = new JButton();
        this.filler = new JLabel();
        this.fileTypeContext = new JCheckBox();
        this.ftContentTypeTxt = new JLabel();
        this.ftContentType = new JComboBox();
        this.ftPositionTxt = new JLabel();
        this.ftPosition = new JComboBox();
        this.ftSeparatorPanel = new JPanel();
        this.ftSeparatorBefore = new JCheckBox();
        this.ftSeparatorAfter = new JCheckBox();
        this.editorContext = new JCheckBox();
        this.edContentTypeTxt = new JLabel();
        this.edContentType = new JComboBox();
        this.edPositionTxt = new JLabel();
        this.edPosition = new JComboBox();
        this.edSeparatorPanel = new JPanel();
        this.edSeparatorBefore = new JCheckBox();
        this.edSeparatorAfter = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.categoryTxt.setLabelFor(this.category);
        Mnemonics.setLocalizedText((JLabel)this.categoryTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Category"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.categoryTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.category, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.globalMenuItem, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_GlobalMenuItem"));
        this.globalMenuItem.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalMenuItem.setMargin(new Insets(0, 0, 0, 0));
        this.globalMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.globalMenuItemActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalMenuItem, gridBagConstraints);
        this.menuTxt.setLabelFor(this.menu);
        Mnemonics.setLocalizedText((JLabel)this.menuTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Menu"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.menuTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.menu, gridBagConstraints);
        this.menuPositionTxt.setLabelFor(this.menuPosition);
        Mnemonics.setLocalizedText((JLabel)this.menuPositionTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.menuPositionTxt, gridBagConstraints);
        this.menuPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.menuPosition, gridBagConstraints);
        this.menuSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.menuSeparatorBefore, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.menuSeparatorBefore.setMargin(new Insets(0, 0, 0, 0));
        this.menuSeparatorPanel.add(this.menuSeparatorBefore);
        Mnemonics.setLocalizedText((AbstractButton)this.menuSeparatorAfter, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.menuSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.menuSeparatorAfter.setMargin(new Insets(0, 0, 0, 0));
        this.menuSeparatorPanel.add(this.menuSeparatorAfter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.menuSeparatorPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.globalToolbarButton, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_GlobalToolbarButton"));
        this.globalToolbarButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalToolbarButton.setMargin(new Insets(0, 0, 0, 0));
        this.globalToolbarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.globalToolbarButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalToolbarButton, gridBagConstraints);
        this.toolbarTxt.setLabelFor(this.toolbar);
        Mnemonics.setLocalizedText((JLabel)this.toolbarTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Toolbar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.toolbarTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.toolbar, gridBagConstraints);
        this.toolbarPositionTxt.setLabelFor(this.toolbarPosition);
        Mnemonics.setLocalizedText((JLabel)this.toolbarPositionTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.toolbarPositionTxt, gridBagConstraints);
        this.toolbarPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.toolbarPosition, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.globalKeyboardShortcut, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_GlobalKeyboardShortcut"));
        this.globalKeyboardShortcut.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalKeyboardShortcut.setMargin(new Insets(0, 0, 0, 0));
        this.globalKeyboardShortcut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.globalKeyboardShortcutActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalKeyboardShortcut, gridBagConstraints);
        this.keyStrokeTxt.setLabelFor(this.menuPosition);
        Mnemonics.setLocalizedText((JLabel)this.keyStrokeTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_KeyStroke"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.keyStrokeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.keyStroke, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.keyStrokeChange, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"CTL_Change"));
        this.keyStrokeChange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.keyStrokeChangeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.keyStrokeChange, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.fileTypeContext, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_FileTypeContextMenuItem"));
        this.fileTypeContext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileTypeContext.setMargin(new Insets(0, 0, 0, 0));
        this.fileTypeContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.fileTypeContextActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.fileTypeContext, gridBagConstraints);
        this.ftContentTypeTxt.setLabelFor(this.ftContentType);
        Mnemonics.setLocalizedText((JLabel)this.ftContentTypeTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_ContentType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.ftContentTypeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.ftContentType, gridBagConstraints);
        this.ftPositionTxt.setLabelFor(this.ftPosition);
        Mnemonics.setLocalizedText((JLabel)this.ftPositionTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.ftPositionTxt, gridBagConstraints);
        this.ftPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.ftPosition, gridBagConstraints);
        this.ftSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.ftSeparatorBefore, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.ftSeparatorBefore.setMargin(new Insets(0, 0, 0, 0));
        this.ftSeparatorPanel.add(this.ftSeparatorBefore);
        Mnemonics.setLocalizedText((AbstractButton)this.ftSeparatorAfter, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.ftSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.ftSeparatorAfter.setMargin(new Insets(0, 0, 0, 0));
        this.ftSeparatorPanel.add(this.ftSeparatorAfter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.ftSeparatorPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editorContext, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_EditorContextMenuItem"));
        this.editorContext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.editorContext.setMargin(new Insets(0, 0, 0, 0));
        this.editorContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.editorContextActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.editorContext, gridBagConstraints);
        this.edContentTypeTxt.setLabelFor(this.edContentType);
        Mnemonics.setLocalizedText((JLabel)this.edContentTypeTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_ContentType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.edContentTypeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.edContentType, gridBagConstraints);
        this.edPositionTxt.setLabelFor(this.edPosition);
        Mnemonics.setLocalizedText((JLabel)this.edPositionTxt, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.edPositionTxt, gridBagConstraints);
        this.edPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.edPosition, gridBagConstraints);
        this.edSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.edSeparatorBefore, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.edSeparatorBefore.setMargin(new Insets(0, 0, 0, 0));
        this.edSeparatorPanel.add(this.edSeparatorBefore);
        Mnemonics.setLocalizedText((AbstractButton)this.edSeparatorAfter, (String)NbBundle.getMessage((Class)GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.edSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.edSeparatorAfter.setMargin(new Insets(0, 0, 0, 0));
        this.edSeparatorPanel.add(this.edSeparatorAfter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.edSeparatorPanel, gridBagConstraints);
    }

    private void editorContextActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.editorGroup, this.editorContext.isSelected());
        this.checkValidity();
    }

    private void fileTypeContextActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.fileTypeGroup, this.fileTypeContext.isSelected());
        this.checkValidity();
    }

    private void globalMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.gmiGroup, this.globalMenuItem.isSelected());
        this.checkValidity();
    }

    private void globalToolbarButtonActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.toolbarGroup, this.globalToolbarButton.isSelected());
        this.checkValidity();
    }

    private void globalKeyboardShortcutActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.shortcutGroup, this.globalKeyboardShortcut.isSelected());
        this.checkValidity();
    }

    private void keyStrokeChangeActionPerformed(ActionEvent actionEvent) {
        ShortcutEnterPanel shortcutEnterPanel = new ShortcutEnterPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)shortcutEnterPanel, GUIRegistrationPanel.getMessage("LBL_AddShortcutTitle"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.keyStroke.setText(shortcutEnterPanel.getKeyText());
            this.data.setKeyStroke(UIUtil.keyToLogicalString(shortcutEnterPanel.getKeyStroke()));
            this.checkValidity();
        }
    }

    private void initAccesibility() {
        this.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_GuiRegistrationPanel"));
        this.category.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_Category"));
        this.edContentType.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_edContentType"));
        this.edPosition.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_edPosition"));
        this.edSeparatorAfter.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_edSeparatorAfter"));
        this.edSeparatorBefore.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_edSeparatorBefore"));
        this.editorContext.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_EditorContext"));
        this.fileTypeContext.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_FileTypeContext"));
        this.ftContentType.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_ftContentType"));
        this.ftPosition.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_ftPosition"));
        this.ftSeparatorAfter.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_ftSeparatorAfter"));
        this.ftSeparatorBefore.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_ftSeparatorBefore"));
        this.globalKeyboardShortcut.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_globalKeyboardShortcut"));
        this.globalMenuItem.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_globalMenuItem"));
        this.globalToolbarButton.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_globalToolbarButton"));
        this.keyStrokeChange.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_keyStrokeChange"));
        this.menu.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_menu"));
        this.menuPosition.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_menuPosition"));
        this.menuSeparatorAfter.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_menuSeparatorAfter"));
        this.menuSeparatorBefore.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_menuSeparatorBefore"));
        this.toolbar.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_toolbar"));
        this.toolbarPosition.getAccessibleContext().setAccessibleDescription(GUIRegistrationPanel.getMessage("ACS_CTL_toolbarPosition"));
    }

    private FileSystem getSFS() {
        if (!$assertionsDisabled && EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)"Called from ETD!");
        }
        if (this.sfs == null) {
            try {
                this.sfs = LayerUtils.getEffectiveSystemFilesystem(this.data.getProject());
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
                this.sfs = FileUtil.createMemoryFileSystem();
            }
        }
        return this.sfs;
    }

    private Enumeration getFoldersByName(DataFolder dataFolder, String string) {
        Enumeration enumeration = this.getFolders(dataFolder);
        Vector<DataFolder> vector = new Vector<DataFolder>();
        while (enumeration.hasMoreElements()) {
            DataFolder dataFolder2 = (DataFolder)enumeration.nextElement();
            if (!(dataFolder2 instanceof DataFolder) || !string.equals(dataFolder2.getName()) || dataFolder2.getPrimaryFile().getParent() == dataFolder.getPrimaryFile()) continue;
            vector.add(dataFolder2);
        }
        return vector.elements();
    }

    private Enumeration getFolders(DataFolder dataFolder) {
        Enumeration enumeration = dataFolder.children(true);
        Vector<DataObject> vector = new Vector<DataObject>();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (!(dataObject instanceof DataFolder)) continue;
            vector.add(dataObject);
        }
        return vector.elements();
    }

    static /* synthetic */ void access$1000(GUIRegistrationPanel gUIRegistrationPanel, JComboBox jComboBox) {
        gUIRegistrationPanel.setEditable(jComboBox);
    }

    static /* synthetic */ void access$1500(GUIRegistrationPanel gUIRegistrationPanel, JComboBox jComboBox, Enumeration enumeration, UIUtil.LayerItemPresenter layerItemPresenter) {
        gUIRegistrationPanel.createPositionModel(jComboBox, enumeration, layerItemPresenter);
    }

    static {
        $assertionsDisabled = !GUIRegistrationPanel.class.desiredAssertionStatus();
        POSITION_HERE = GUIRegistrationPanel.getMessage("CTL_PositionHere");
    }

    private class PML
    implements PopupMenuListener {
        private JComboBox menu;
        private JComboBox position;

        PML(JComboBox jComboBox, JComboBox jComboBox2) {
            this.menu = jComboBox;
            this.position = jComboBox2;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            UIUtil.LayerItemPresenter layerItemPresenter = GUIRegistrationPanel.getSelectedLayerPresenter(this.menu);
            if (layerItemPresenter != null) {
                GUIRegistrationPanel.this.loadPositionsCombo(layerItemPresenter, this.position);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.popupMenuWillBecomeInvisible(null);
        }
    }

    private static class PositionRenderer
    extends DefaultListCellRenderer {
        private PositionRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            String string;
            if (object == null || object == CustomizerComponentFactory.WAIT_VALUE) {
                string = CustomizerComponentFactory.WAIT_VALUE;
            } else if (object == CustomizerComponentFactory.EMPTY_VALUE) {
                string = CustomizerComponentFactory.EMPTY_VALUE;
            } else {
                object2 = (DataModel.Position)object;
                String string2 = ((DataModel.Position)object2).getBeforeName() == null ? "" : ((DataModel.Position)object2).getBeforeName() + GUIRegistrationPanel.POSITION_SEPARATOR;
                String string3 = ((DataModel.Position)object2).getAfterName() == null ? "" : GUIRegistrationPanel.POSITION_SEPARATOR + ((DataModel.Position)object2).getAfterName();
                string = string2 + POSITION_HERE + string3;
            }
            object2 = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            return object2;
        }
    }
}

