/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.action.DataModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NameIconLocationPanel
extends BasicWizardIterator.Panel {
    private static final String ENTER_LABEL = NameIconLocationPanel.getMessage("CTL_EnterLabel");
    private static final String NONE_LABEL = NameIconLocationPanel.getMessage("CTL_None");
    private DataModel data;
    private DocumentListener updateListener;
    private JTextField className;
    private JLabel classNameTxt;
    private JTextArea createdFiles;
    private JLabel createdFilesTxt;
    private JTextField displayName;
    private JLabel displayNameTxt;
    private JTextField icon;
    private JButton iconButton;
    private JLabel iconTxt;
    private JTextArea modifiedFiles;
    private JLabel modifiedFilesTxt;
    private JComboBox packageName;
    private JLabel packageNameTxt;
    private JTextField project;
    private JLabel projectTxt;

    public NameIconLocationPanel(WizardDescriptor wizardDescriptor, DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        if (dataModel.getPackageName() != null) {
            this.packageName.setSelectedItem(dataModel.getPackageName());
        }
        this.putClientProperty("NewFileWizard_Title", NameIconLocationPanel.getMessage("LBL_ActionWizardTitle"));
        this.className.select(0, this.className.getText().length());
        this.updateListener = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NameIconLocationPanel.this.updateData();
            }
        };
    }

    private void addListeners() {
        this.className.getDocument().addDocumentListener(this.updateListener);
        this.displayName.getDocument().addDocumentListener(this.updateListener);
        Component component = this.packageName.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(this.updateListener);
        }
    }

    private void removeListeners() {
        this.className.getDocument().removeDocumentListener(this.updateListener);
        this.displayName.getDocument().removeDocumentListener(this.updateListener);
        Component component = this.packageName.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().removeDocumentListener(this.updateListener);
        }
    }

    protected String getPanelName() {
        return NameIconLocationPanel.getMessage("LBL_NameIconLocation_Title");
    }

    protected void storeToDataModel() {
        this.removeListeners();
        this.storeBaseData();
    }

    protected void readFromDataModel() {
        this.updateData();
        this.addListeners();
    }

    private void updateData() {
        this.storeBaseData();
        CreatedModifiedFiles createdModifiedFiles = this.data.getCreatedModifiedFiles();
        this.createdFiles.setText(UIUtil.generateTextAreaContent(createdModifiedFiles.getCreatedPaths()));
        this.modifiedFiles.setText(UIUtil.generateTextAreaContent(createdModifiedFiles.getModifiedPaths()));
        this.checkValidity();
    }

    private void storeBaseData() {
        this.data.setClassName(this.getClassName());
        this.data.setPackageName(this.packageName.getEditor().getItem().toString());
        this.data.setIconPath(this.getIconPath());
        this.data.setDisplayName(this.displayName.getText());
    }

    private String getIconPath() {
        return this.icon.getText().equals(NONE_LABEL) ? null : this.icon.getText();
    }

    private void checkValidity() {
        String string;
        String string2 = string = this.packageName.getEditor().getItem() == null ? "" : this.packageName.getEditor().getItem().toString().trim();
        if (!Utilities.isJavaIdentifier((String)this.getClassName())) {
            this.setErrorMessage(NameIconLocationPanel.getMessage("MSG_ClassNameMustBeValidJavaIdentifier"));
        } else if (this.getDisplayName().equals("") || this.getDisplayName().equals(ENTER_LABEL)) {
            this.setErrorMessage(NameIconLocationPanel.getMessage("MSG_DisplayNameMustBeEntered"));
        } else if (this.classAlreadyExists()) {
            this.setErrorMessage(NameIconLocationPanel.getMessage("MSG_ClassAlreadyExists"));
        } else if (this.data.isToolbarEnabled() && this.getIconPath() == null) {
            this.setErrorMessage(NameIconLocationPanel.getMessage("MSG_IconRequiredForToolbar"));
        } else if (string.length() == 0 || !UIUtil.isValidPackageName(string)) {
            this.setErrorMessage(NameIconLocationPanel.getMessage("ERR_Package_Invalid"));
        } else {
            this.setErrorMessage(null);
        }
    }

    private boolean classAlreadyExists() {
        return this.data.classExists();
    }

    private String getDisplayName() {
        return this.displayName.getText().trim();
    }

    private String getClassName() {
        return this.className.getText().trim();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(NameIconLocationPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)string);
    }

    private void initComponents() {
        this.classNameTxt = new JLabel();
        this.className = new JTextField();
        this.displayNameTxt = new JLabel();
        this.displayName = new JTextField();
        this.iconTxt = new JLabel();
        this.icon = new JTextField();
        this.iconButton = new JButton();
        this.projectTxt = new JLabel();
        this.project = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.packageNameTxt = new JLabel();
        this.packageName = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.createdFilesTxt = new JLabel();
        this.createdFiles = new JTextArea();
        this.modifiedFilesTxt = new JLabel();
        this.modifiedFiles = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.classNameTxt.setLabelFor(this.className);
        Mnemonics.setLocalizedText((JLabel)this.classNameTxt, (String)NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"LBL_ClassName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.classNameTxt, gridBagConstraints);
        this.className.setText(NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"CTL_SampleClassName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.className, gridBagConstraints);
        this.displayNameTxt.setLabelFor(this.displayName);
        Mnemonics.setLocalizedText((JLabel)this.displayNameTxt, (String)NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"LBL_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.displayNameTxt, gridBagConstraints);
        this.displayName.setText(NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"CTL_EnterLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.displayName, gridBagConstraints);
        this.iconTxt.setLabelFor(this.icon);
        Mnemonics.setLocalizedText((JLabel)this.iconTxt, (String)NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"LBL_Icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.iconTxt, gridBagConstraints);
        this.icon.setEditable(false);
        this.icon.setText(NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"CTL_None"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.icon, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.iconButton, (String)NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"LBL_Icon_Browse"));
        this.iconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameIconLocationPanel.this.iconButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.iconButton, gridBagConstraints);
        this.projectTxt.setLabelFor(this.project);
        Mnemonics.setLocalizedText((JLabel)this.projectTxt, (String)NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.projectTxt, gridBagConstraints);
        this.project.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.project, gridBagConstraints);
        this.packageNameTxt.setLabelFor(this.packageName);
        Mnemonics.setLocalizedText((JLabel)this.packageNameTxt, (String)NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.packageNameTxt, gridBagConstraints);
        this.packageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.packageName, gridBagConstraints);
        this.createdFilesTxt.setLabelFor(this.createdFiles);
        Mnemonics.setLocalizedText((JLabel)this.createdFilesTxt, (String)NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFilesTxt, gridBagConstraints);
        this.createdFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFiles.setColumns(20);
        this.createdFiles.setEditable(false);
        this.createdFiles.setRows(5);
        this.createdFiles.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.modifiedFilesTxt.setLabelFor(this.modifiedFiles);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFilesTxt, (String)NbBundle.getMessage((Class)NameIconLocationPanel.class, (String)"LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFilesTxt, gridBagConstraints);
        this.modifiedFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFiles.setColumns(20);
        this.modifiedFiles.setEditable(false);
        this.modifiedFiles.setRows(5);
        this.modifiedFiles.setToolTipText("modifiedFilesValue");
        this.modifiedFiles.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.modifiedFiles, gridBagConstraints);
    }

    private void iconButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = UIUtil.getIconFileChooser(this.icon.getText());
        int n = jFileChooser.showDialog(this, NameIconLocationPanel.getMessage("LBL_Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.icon.setText(file.getAbsolutePath());
            this.updateData();
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_NameAndLocationPanel"));
        this.className.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_ClassName"));
        this.createdFiles.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_CreatedFiles"));
        this.displayName.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_DisplayName"));
        this.icon.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_Icon"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_IconButton"));
        this.modifiedFiles.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_ModifiedFiles"));
        this.packageName.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_PackageName"));
        this.project.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_Project"));
    }
}

