/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class ShortcutEnterPanel
extends JPanel {
    private JLabel shortcutLabel;
    private JTextField shortcut = new JTextField();
    private int currentKeyCode;
    private int currentModifiers;

    ShortcutEnterPanel() {
        this.shortcutLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.shortcutLabel, (String)NbBundle.getMessage((Class)ShortcutEnterPanel.class, (String)"LBL_Shortcut"));
        this.shortcutLabel.setLabelFor(this.shortcut);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.add((Component)this.shortcutLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.shortcut, gridBagConstraints);
        this.shortcutLabel.setLabelFor(this.shortcut);
        this.shortcut.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                keyEvent.consume();
                ShortcutEnterPanel.this.currentKeyCode = keyEvent.getKeyCode();
                ShortcutEnterPanel.this.currentModifiers = keyEvent.getModifiers();
                ShortcutEnterPanel.this.shortcut.setText(ShortcutEnterPanel.getKeyText(keyEvent.getKeyCode(), keyEvent.getModifiers()));
            }

            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
                switch (ShortcutEnterPanel.this.currentKeyCode) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 157: 
                    case 65406: {
                        ShortcutEnterPanel.this.shortcut.setText("");
                    }
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 50);
    }

    KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(this.currentKeyCode, this.currentModifiers);
    }

    String getKeyText() {
        return ShortcutEnterPanel.getKeyText(this.currentKeyCode, this.currentModifiers);
    }

    static String getKeyText(int n, int n2) {
        String string = KeyEvent.getKeyModifiersText(n2);
        if ("".equals(string)) {
            return KeyEvent.getKeyText(n);
        }
        if (n == 18 || n == 65406 || n == 17 || n == 16) {
            return string + "+";
        }
        return string + "+" + KeyEvent.getKeyText(n);
    }
}

