/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.CreatedModifiedFilesFactory;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NewLibraryDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

final class CreatedModifiedFilesProvider {
    private static final String VOLUME_CLASS = "classpath";
    private static final String VOLUME_SRC = "src";
    private static final String VOLUME_JAVADOC = "javadoc";
    private static final String LIBRARY_LAYER_ENTRY = "org-netbeans-api-project-libraries/Libraries";
    static final /* synthetic */ boolean $assertionsDisabled;

    CreatedModifiedFilesProvider() {
    }

    static CreatedModifiedFiles createInstance(NewLibraryDescriptor.DataModel dataModel) {
        CreatedModifiedFiles createdModifiedFiles = new CreatedModifiedFiles(dataModel.getProject());
        CreatedModifiedFilesProvider.addOperations(createdModifiedFiles, dataModel);
        return createdModifiedFiles;
    }

    private static void addOperations(CreatedModifiedFiles createdModifiedFiles, NewLibraryDescriptor.DataModel dataModel) {
        URL uRL = CreatedModifiedFilesProvider.class.getResource("libdescriptemplate.xml");
        Map map = CreatedModifiedFilesProvider.getTokens(createdModifiedFiles, dataModel.getProject(), dataModel);
        String string = CreatedModifiedFilesProvider.getLibraryDescriptorEntryPath(dataModel.getLibraryName());
        createdModifiedFiles.add(createdModifiedFiles.createLayerEntry(string, uRL, map, null, null));
        createdModifiedFiles.add(createdModifiedFiles.bundleKeyDefaultBundle(dataModel.getLibraryName(), dataModel.getLibraryDisplayName()));
    }

    private static String getPackagePlusBundle(NbModuleProject nbModuleProject) {
        ManifestManager manifestManager = ManifestManager.getInstance(nbModuleProject.getManifest(), false);
        String string = manifestManager.getLocalizingBundle().replace('/', '.');
        if (string.endsWith(".properties")) {
            string = string.substring(0, string.length() - 11);
        }
        return string;
    }

    private static String getLibraryDescriptorRelativePath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append("/").append(string2).append(".xml");
        return stringBuffer.toString();
    }

    static String getLibraryDescriptorEntryPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LIBRARY_LAYER_ENTRY).append("/").append(string).append(".xml");
        return stringBuffer.toString();
    }

    private static String transformURL(URL uRL, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jar:nbinst:///").append(string).append(string2).append("!/");
        return stringBuffer.toString();
    }

    private static Map getTokens(CreatedModifiedFiles createdModifiedFiles, NbModuleProject nbModuleProject, NewLibraryDescriptor.DataModel dataModel) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Library library = dataModel.getLibrary();
        hashMap.put("name_to_substitute", dataModel.getLibraryName());
        hashMap.put("bundle_to_substitute", CreatedModifiedFilesProvider.getPackagePlusBundle(nbModuleProject).replace('/', '.'));
        Iterator iterator = library.getContent(VOLUME_CLASS).iterator();
        hashMap.put("classpath_to_substitute", CreatedModifiedFilesProvider.getTokenSubstitution(iterator, createdModifiedFiles, dataModel, "libs/"));
        iterator = library.getContent(VOLUME_SRC).iterator();
        hashMap.put("src_to_substitute", CreatedModifiedFilesProvider.getTokenSubstitution(iterator, createdModifiedFiles, dataModel, "sources/"));
        iterator = library.getContent(VOLUME_JAVADOC).iterator();
        hashMap.put("javadoc_to_substitute", CreatedModifiedFilesProvider.getTokenSubstitution(iterator, createdModifiedFiles, dataModel, "docs/"));
        return hashMap;
    }

    private static String getTokenSubstitution(Iterator iterator, CreatedModifiedFiles createdModifiedFiles, NewLibraryDescriptor.DataModel dataModel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            String string2 = CreatedModifiedFilesProvider.addArchiveToCopy(createdModifiedFiles, dataModel, uRL, "release/" + string);
            if (string2 == null) continue;
            String string3 = CreatedModifiedFilesProvider.transformURL(uRL, string, string2);
            stringBuffer.append("<resource>");
            stringBuffer.append(string3);
            if (iterator.hasNext()) {
                stringBuffer.append("</resource>\n");
                continue;
            }
            stringBuffer.append("</resource>");
        }
        return stringBuffer.toString();
    }

    private static String addArchiveToCopy(CreatedModifiedFiles createdModifiedFiles, NewLibraryDescriptor.DataModel dataModel, URL uRL, String string) {
        FileObject fileObject;
        String string2 = null;
        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
        if (uRL2 != null && FileUtil.isArchiveFile((URL)uRL2)) {
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL2);
            if (!$assertionsDisabled && fileObject2 == null) {
                throw new AssertionError();
            }
            string2 = fileObject2.getNameExt();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append(string2);
            createdModifiedFiles.add(createdModifiedFiles.createFile(stringBuffer.toString(), uRL2));
        } else if ("file".equals(uRL.getProtocol()) && (fileObject = URLMapper.findFileObject((URL)uRL)) != null) {
            string2 = dataModel.getLibraryName() + ".zip";
            string = string + string2;
            createdModifiedFiles.add(new ZipAndCopyOperation(dataModel.getProject(), fileObject, string));
        }
        return string2;
    }

    static {
        $assertionsDisabled = !CreatedModifiedFilesProvider.class.desiredAssertionStatus();
    }

    private static class ZipAndCopyOperation
    extends CreatedModifiedFilesFactory.OperationBase {
        private FileObject folderToZip;
        private String relativePath;
        static final /* synthetic */ boolean $assertionsDisabled;

        ZipAndCopyOperation(NbModuleProject nbModuleProject, FileObject fileObject, String string) {
            super(nbModuleProject);
            this.folderToZip = fileObject;
            this.relativePath = string;
            this.addCreatedOrModifiedPath(string, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock fileLock;
            block9: {
                ArrayList arrayList = Collections.list(this.folderToZip.getChildren(true));
                if (arrayList.isEmpty()) {
                    return;
                }
                FileObject fileObject = this.getProject().getProjectDirectory();
                if (!$assertionsDisabled && fileObject == null) {
                    throw new AssertionError();
                }
                FileObject fileObject2 = fileObject.getFileObject(this.relativePath);
                if (fileObject2 == null) {
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)this.relativePath);
                }
                if (!$assertionsDisabled && fileObject2 == null) {
                    throw new AssertionError();
                }
                fileLock = null;
                OutputStream outputStream = null;
                try {
                    fileLock = fileObject2.lock();
                    outputStream = fileObject2.getOutputStream(fileLock);
                    ZipAndCopyOperation.createZipFile(outputStream, this.folderToZip, arrayList);
                    Object var7_6 = null;
                    if (outputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    throw throwable;
                }
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createZipFile(OutputStream outputStream, FileObject fileObject, Collection collection) throws IOException {
            ZipOutputStream zipOutputStream = null;
            try {
                zipOutputStream = new ZipOutputStream(outputStream);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    FileObject fileObject2 = (FileObject)iterator.next();
                    String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                    if (fileObject2.isFolder()) {
                        if (fileObject2.getChildren().length > 0) continue;
                        if (!string.endsWith("/")) {
                            string = string + "/";
                        }
                    }
                    ZipEntry zipEntry = new ZipEntry(string);
                    zipOutputStream.putNextEntry(zipEntry);
                    if (fileObject2.isData()) {
                        InputStream inputStream = null;
                        try {
                            inputStream = fileObject2.getInputStream();
                            FileUtil.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    zipOutputStream.closeEntry();
                }
            }
            finally {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$wizard$librarydescriptor$CreatedModifiedFilesProvider == null ? (class$org$netbeans$modules$apisupport$project$ui$wizard$librarydescriptor$CreatedModifiedFilesProvider = CreatedModifiedFilesProvider.class$("org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.CreatedModifiedFilesProvider")) : class$org$netbeans$modules$apisupport$project$ui$wizard$librarydescriptor$CreatedModifiedFilesProvider).desiredAssertionStatus();
        }
    }
}

