/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.CreatedModifiedFilesProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NewLibraryDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class NameAndLocationPanel
extends BasicWizardIterator.Panel {
    private NewLibraryDescriptor.DataModel data;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel libraryDisplayName;
    private JTextField libraryDisplayNameValue;
    private JLabel libraryName;
    private JTextField libraryNameVale;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JLabel projectName;
    private JTextField projectNameValue;

    public NameAndLocationPanel(WizardDescriptor wizardDescriptor, NewLibraryDescriptor.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", NbBundle.getMessage((Class)NameAndLocationPanel.class, (String)"LBL_LibraryWizardTitle"));
        UIUtil.DocumentAdapter documentAdapter = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NewLibraryDescriptor.DataModel dataModel = NameAndLocationPanel.this.getTemporaryDataModel();
                NameAndLocationPanel.this.setEnabledForFilesInfo(NameAndLocationPanel.this.checkValidity(dataModel));
                NameAndLocationPanel.this.setFilesInfoIntoTextAreas(dataModel);
            }
        };
        this.libraryNameVale.getDocument().addDocumentListener(documentAdapter);
        this.libraryDisplayNameValue.getDocument().addDocumentListener(documentAdapter);
    }

    protected void storeToDataModel() {
        NewLibraryDescriptor.DataModel dataModel = this.getTemporaryDataModel();
        this.data.setLibraryName(dataModel.getLibraryName());
        this.data.setLibraryDisplayName(dataModel.getLibraryDisplayName());
        this.data.setCreatedModifiedFiles(dataModel.getCreatedModifiedFiles());
    }

    private NewLibraryDescriptor.DataModel getTemporaryDataModel() {
        NewLibraryDescriptor.DataModel dataModel = this.data.cloneMe(this.getSettings());
        dataModel.setLibraryName(this.libraryNameVale.getText());
        dataModel.setLibraryDisplayName(this.libraryDisplayNameValue.getText());
        if (dataModel.isValidLibraryDisplayName() && dataModel.isValidLibraryName()) {
            CreatedModifiedFiles createdModifiedFiles = CreatedModifiedFilesProvider.createInstance(dataModel);
            dataModel.setCreatedModifiedFiles(createdModifiedFiles);
        }
        return dataModel;
    }

    private void setEnabledForFilesInfo(boolean bl) {
        this.createdFilesValue.setEnabled(bl);
        this.modifiedFilesValue.setEnabled(bl);
    }

    private void setFilesInfoIntoTextAreas(NewLibraryDescriptor.DataModel dataModel) {
        if (dataModel.getCreatedModifiedFiles() != null) {
            this.createdFilesValue.setText(UIUtil.generateTextAreaContent(dataModel.getCreatedModifiedFiles().getCreatedPaths()));
            this.modifiedFilesValue.setText(UIUtil.generateTextAreaContent(dataModel.getCreatedModifiedFiles().getModifiedPaths()));
        }
    }

    protected void readFromDataModel() {
        this.libraryNameVale.setText(this.data.getLibrary().getName());
        this.libraryDisplayNameValue.setText(this.data.getLibrary().getDisplayName());
        this.checkValidity(this.getTemporaryDataModel());
    }

    protected String getPanelName() {
        return NbBundle.getMessage((Class)NameAndLocationPanel.class, (String)"LBL_NameAndLocation_Title");
    }

    private boolean checkValidity(NewLibraryDescriptor.DataModel dataModel) {
        if (!dataModel.isValidLibraryName()) {
            this.setErrorMessage(NbBundle.getMessage((Class)NameAndLocationPanel.class, (String)"ERR_EmptyName"));
            return false;
        }
        if (!dataModel.isValidLibraryDisplayName()) {
            this.setErrorMessage(NbBundle.getMessage((Class)NameAndLocationPanel.class, (String)"ERR_EmptyDescName"));
            return false;
        }
        if (dataModel.libraryAlreadyExists()) {
            this.setErrorMessage(NbBundle.getMessage((Class)NameAndLocationPanel.class, (String)"ERR_LibraryExists", (Object)dataModel.getLibraryName()));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(NameAndLocationPanel.class);
    }

    public void addNotify() {
        super.addNotify();
        this.checkValidity(this.getTemporaryDataModel());
    }

    private void initComponents() {
        this.libraryName = new JLabel();
        this.libraryNameVale = new JTextField();
        this.libraryDisplayName = new JLabel();
        this.libraryDisplayNameValue = new JTextField();
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.libraryName.setLabelFor(this.libraryNameVale);
        Mnemonics.setLocalizedText((JLabel)this.libraryName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_LibraryName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add((Component)this.libraryName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.add((Component)this.libraryNameVale, gridBagConstraints);
        this.libraryDisplayName.setLabelFor(this.libraryDisplayNameValue);
        Mnemonics.setLocalizedText((JLabel)this.libraryDisplayName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_LibraryDisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.libraryDisplayName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.libraryDisplayNameValue, gridBagConstraints);
        this.projectName.setLabelFor(this.projectNameValue);
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.projectNameValue, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.modifiedFilesValueS, gridBagConstraints);
    }
}

