/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.project.NameAndLocationPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.project.SelectProjectPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

final class NewProjectIterator
extends BasicWizardIterator {
    private static final long serialVersionUID = 1L;
    private DataModel data;
    public static String[] MODULES = new String[]{"org.openide.filesystems", "org.openide.loaders", "org.openide.dialogs", "org.openide.util", "org.netbeans.modules.projectuiapi", "org.netbeans.modules.projectapi", "org.openide.awt"};

    NewProjectIterator() {
    }

    public static NewProjectIterator createIterator() {
        return new NewProjectIterator();
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles createdModifiedFiles = this.data.getCreatedModifiedFiles();
        createdModifiedFiles.run();
        return this.getCreatedFiles(createdModifiedFiles, this.data.getProject());
    }

    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        this.data = new DataModel(wizardDescriptor);
        return new BasicWizardIterator.Panel[]{new SelectProjectPanel(wizardDescriptor, this.data), new NameAndLocationPanel(wizardDescriptor, this.data)};
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        super.uninitialize(wizardDescriptor);
        this.data = null;
    }

    public static void generateFileChanges(DataModel dataModel) {
        Object object;
        Object object2;
        FileObject fileObject;
        SortedSet sortedSet;
        CreatedModifiedFiles createdModifiedFiles = new CreatedModifiedFiles(dataModel.getProject());
        NbModuleProject nbModuleProject = dataModel.getProject();
        String string = dataModel.getCategory();
        String string2 = dataModel.getDisplayName();
        String string3 = dataModel.getName();
        String string4 = dataModel.getPackageName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("@@CATEGORY@@", string);
        hashMap.put("@@DISPLAYNAME@@", string2);
        hashMap.put("@@TEMPLATENAME@@", string3);
        hashMap.put("@@PACKAGENAME@@", string4);
        String string5 = NewProjectIterator.getRelativePath(nbModuleProject, string4, string3, "Description.html");
        URL uRL = NewProjectIterator.class.getResource("templateDescription.html");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string5, uRL, hashMap));
        ProjectXMLManager projectXMLManager = new ProjectXMLManager(nbModuleProject.getHelper());
        try {
            sortedSet = projectXMLManager.getDirectDependencies(nbModuleProject.getPlatform(false));
            fileObject = new HashSet(Arrays.asList(MODULES));
            object2 = sortedSet.iterator();
            while (object2.hasNext()) {
                object = (ModuleDependency)object2.next();
                fileObject.remove(((ModuleDependency)object).getModuleEntry().getCodeNameBase());
                if (fileObject.size() != 0) continue;
            }
            object2 = fileObject.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                createdModifiedFiles.add(createdModifiedFiles.addModuleDependency((String)object, -1, null, true));
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        sortedSet = LayerUtils.layerForProject(nbModuleProject).getLayerFile();
        fileObject = sortedSet != null ? sortedSet.getParent() : null;
        object2 = Collections.singleton(LayerUtils.findGeneratedName(fileObject, string3 + "Project.zip"));
        createdModifiedFiles.add(createdModifiedFiles.layerModifications(new CreateProjectZipOperation(nbModuleProject, dataModel.getTemplate(), string3, string4, string), (Set)object2));
        createdModifiedFiles.add(createdModifiedFiles.bundleKeyDefaultBundle(string + "/" + string3 + "Project.zip", string2));
        createdModifiedFiles.add(createdModifiedFiles.bundleKeyDefaultBundle("LBL_CreateProjectStep", "Create a new " + string2 + " project"));
        object = NewProjectIterator.getRelativePath(nbModuleProject, string4, string3, "WizardIterator.java");
        uRL = NewProjectIterator.class.getResource("templateWizardIterator.javx");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions((String)object, uRL, hashMap));
        String string6 = NewProjectIterator.getRelativePath(nbModuleProject, string4, string3, "WizardPanel.java");
        uRL = NewProjectIterator.class.getResource("templateWizardPanel.javx");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string6, uRL, hashMap));
        String string7 = NewProjectIterator.getRelativePath(nbModuleProject, string4, string3, "PanelVisual.form");
        uRL = NewProjectIterator.class.getResource("templatePanelVisual.frmx");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string7, uRL, hashMap));
        String string8 = NewProjectIterator.getRelativePath(nbModuleProject, string4, string3, "PanelVisual.java");
        uRL = NewProjectIterator.class.getResource("templatePanelVisual.javx");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string8, uRL, hashMap));
        dataModel.setCreatedModifiedFiles(createdModifiedFiles);
    }

    private static String getRelativePath(NbModuleProject nbModuleProject, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nbModuleProject.getSourceDirectoryPath()).append("/").append(string.replace('.', '/')).append("/").append(string2).append(string3);
        return stringBuffer.toString();
    }

    private static void createProjectZip(OutputStream outputStream, Project project) throws IOException {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        SourceGroup sourceGroup = sourceGroupArray[0];
        ArrayList arrayList = new ArrayList();
        NewProjectIterator.collectFiles(sourceGroup.getRootFolder(), arrayList, SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)sourceGroup.getRootFolder())));
        NewProjectIterator.createZipFile(outputStream, sourceGroup.getRootFolder(), arrayList);
    }

    private static void collectFiles(FileObject fileObject, Collection collection, int n) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
            int n2 = n == 0 || n == 3 ? SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)fileObjectArray[i])) : n;
            if (fileObjectArray[i].isData() && !fileObjectArray[i].isVirtual() && n2 == 1) {
                collection.add(fileObjectArray[i]);
                continue;
            }
            if (!fileObjectArray[i].isFolder() || n2 == 2) continue;
            collection.add(fileObjectArray[i]);
            NewProjectIterator.collectFiles(fileObjectArray[i], collection, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createZipFile(OutputStream outputStream, FileObject fileObject, Collection collection) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(outputStream);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject2 = (FileObject)iterator.next();
                String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                if (fileObject2.isFolder() && !string.endsWith("/")) {
                    string = string + "/";
                }
                ZipEntry zipEntry = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry);
                if (fileObject2.isData()) {
                    InputStream inputStream = null;
                    try {
                        inputStream = fileObject2.getInputStream();
                        FileUtil.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                zipOutputStream.closeEntry();
            }
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    static class CreateProjectZipOperation
    implements CreatedModifiedFiles.LayerOperation {
        private String name;
        private String packageName;
        private Project templateProject;
        private String category;

        public CreateProjectZipOperation(NbModuleProject nbModuleProject, Project project, String string, String string2, String string3) {
            this.packageName = string2;
            this.name = string;
            this.category = string3;
            this.templateProject = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(FileSystem fileSystem) throws IOException {
            FileObject fileObject = fileSystem.getRoot().getFileObject(this.category);
            if (fileObject == null) {
                fileObject = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)this.category);
            }
            FileObject fileObject2 = fileObject.createData(this.name + "Project", "zip");
            FileLock fileLock = fileObject2.lock();
            try {
                NewProjectIterator.createProjectZip(fileObject2.getOutputStream(fileLock), this.templateProject);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                fileLock.releaseLock();
            }
            fileObject2.setAttribute("template", (Object)Boolean.TRUE);
            fileObject2.setAttribute("SystemFileSystem.localizingBundle", (Object)(this.packageName + ".Bundle"));
            URL uRL = new URL("nbresloc:/" + this.packageName.replace('.', '/') + "/" + this.name + "Description.html");
            fileObject2.setAttribute("instantiatingWizardURL", (Object)uRL);
            fileObject2.setAttribute("instantiatingIterator", (Object)("methodvalue:" + this.packageName + "." + this.name + "WizardIterator.createIterator"));
        }
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private Project template;
        private String name;
        private String displayName;
        private String category;
        private CreatedModifiedFiles files;

        DataModel(WizardDescriptor wizardDescriptor) {
            super(wizardDescriptor);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.getFiles();
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles createdModifiedFiles) {
            this.setFiles(createdModifiedFiles);
        }

        public Project getTemplate() {
            return this.template;
        }

        public void setTemplate(Project project) {
            this.template = project;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String string) {
            this.displayName = string;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String string) {
            this.category = string;
        }

        public CreatedModifiedFiles getFiles() {
            return this.files;
        }

        public void setFiles(CreatedModifiedFiles createdModifiedFiles) {
            this.files = createdModifiedFiles;
        }
    }
}

