/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.spi.project.support.ant.PropertyUtils;

abstract class AbstractEntry
implements ModuleEntry {
    private String localizedName;
    private Set publicClassNames;

    AbstractEntry() {
    }

    protected abstract LocalizedBundleInfo getBundleInfo();

    public String getLocalizedName() {
        if (this.localizedName == null) {
            this.localizedName = this.getBundleInfo().getDisplayName();
            if (this.localizedName == null) {
                this.localizedName = this.getCodeNameBase();
            }
        }
        return this.localizedName;
    }

    public String getCategory() {
        return this.getBundleInfo().getCategory();
    }

    public String getShortDescription() {
        return this.getBundleInfo().getShortDescription();
    }

    public String getLongDescription() {
        return this.getBundleInfo().getLongDescription();
    }

    public int compareTo(Object object) {
        return this.getLocalizedName().compareTo(((ModuleEntry)object).getLocalizedName());
    }

    public Set getPublicClassNames() {
        if (this.publicClassNames == null) {
            try {
                this.publicClassNames = this.computePublicClassNamesInMainModule();
                String[] stringArray = PropertyUtils.tokenizePath((String)this.getClassPathExtensions());
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]);
                    if (!file.isFile()) {
                        Util.err.log(16, "Could not find Class-Path extension " + file + " of " + this);
                        continue;
                    }
                    this.scanJarForPublicClassNames(this.publicClassNames, file);
                }
            }
            catch (IOException iOException) {
                this.publicClassNames = Collections.EMPTY_SET;
                Util.err.annotate((Throwable)iOException, 0, "While scanning for public classes in " + this, null, null, null);
                Util.err.notify(1, (Throwable)iOException);
            }
        }
        return this.publicClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scanJarForPublicClassNames(Set set, File file) throws IOException {
        Object object;
        ManifestManager.PackageExport[] packageExportArray = this.getPublicPackages();
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < packageExportArray.length; ++i) {
            object = packageExportArray[i].getPackage().replace('.', '/') + '/';
            if (packageExportArray[i].isRecursive()) {
                arrayList.add(object);
                continue;
            }
            hashSet.add(object);
        }
        JarFile jarFile = new JarFile(file);
        try {
            object = jarFile.entries();
            block4: while (object.hasMoreElements()) {
                Object object2;
                int n;
                JarEntry jarEntry = object.nextElement();
                String string = jarEntry.getName();
                if (!string.endsWith(".class") || (n = string.lastIndexOf(47)) == -1) continue;
                String string2 = string.substring(0, n + 1);
                if (!hashSet.contains(string2)) {
                    boolean bl = false;
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        if (!string2.startsWith((String)object2.next())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken();
                    char c = ((String)object2).charAt(0);
                    if (c < '0' || c > '9') continue;
                    continue block4;
                }
                set.add(string.substring(0, string.length() - 6).replace('/', '.'));
            }
        }
        finally {
            jarFile.close();
        }
    }

    protected abstract Set computePublicClassNamesInMainModule() throws IOException;
}

