/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;

final class BinaryEntry
extends AbstractEntry {
    private final String cnb;
    private final File jar;
    private final String cpext;
    private final File nbdestdir;
    private final File clusterDir;
    private final String releaseVersion;
    private final String specVersion;
    private final String[] providedTokens;
    private LocalizedBundleInfo bundleInfo;
    private final ManifestManager.PackageExport[] publicPackages;
    private final boolean deprecated;

    public BinaryEntry(String string, File file, File[] fileArray, File file2, File file3, String string2, String string3, String[] stringArray, ManifestManager.PackageExport[] packageExportArray, boolean bl) {
        this.cnb = string;
        this.jar = file;
        this.nbdestdir = file2;
        this.clusterDir = file3;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(':');
            stringBuffer.append(fileArray[i].getAbsolutePath());
        }
        this.cpext = stringBuffer.toString();
        this.releaseVersion = string2;
        this.specVersion = string3;
        this.providedTokens = stringArray;
        this.publicPackages = packageExportArray;
        this.deprecated = bl;
    }

    public File getSourceLocation() {
        NbPlatform nbPlatform = NbPlatform.getPlatformByDestDir(this.getDestDir());
        return nbPlatform.getSourceLocationOfModule(this.getJarLocation());
    }

    public String getNetBeansOrgPath() {
        return null;
    }

    public File getJarLocation() {
        return this.jar;
    }

    public File getDestDir() {
        return this.nbdestdir;
    }

    public String getCodeNameBase() {
        return this.cnb;
    }

    public File getClusterDirectory() {
        return this.clusterDir;
    }

    public String getClassPathExtensions() {
        return this.cpext;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String[] getProvidedTokens() {
        return this.providedTokens;
    }

    protected LocalizedBundleInfo getBundleInfo() {
        if (this.bundleInfo == null) {
            this.bundleInfo = Util.findLocalizedBundleInfoFromJAR(this.getJarLocation());
            if (this.bundleInfo == null) {
                this.bundleInfo = LocalizedBundleInfo.EMPTY;
            }
        }
        return this.bundleInfo;
    }

    public ManifestManager.PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        File file = this.getSourceLocation();
        return "BinaryEntry[" + this.getJarLocation() + (file != null ? "," + file : "") + "]";
    }

    protected Set computePublicClassNamesInMainModule() throws IOException {
        HashSet hashSet = new HashSet();
        this.scanJarForPublicClassNames(hashSet, this.jar);
        return hashSet;
    }
}

