/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.BinaryEntry;
import org.netbeans.modules.apisupport.project.universe.ExternalEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NetBeansOrgEntry;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ModuleList {
    static long timeSpentInXmlParsing;
    static int xmlFilesParsed;
    static int directoriesChecked;
    static int jarsOpened;
    public static final String DEST_DIR_IN_NETBEANS_ORG;
    public static final int DEPTH_NB_ALL = 3;
    private static final Map sourceLists;
    private static final Map binaryLists;
    private static final Map clusterPropertiesFiles;
    private static final Map clusterLocations;
    private static final Map knownEntries;
    public static final Set EXCLUDED_DIR_NAMES;
    private static final Map DIR_SCAN_CACHE;
    private static final String[] MODULE_DIRS;
    private static final String PROJECT_XML;
    private Map entries;
    private final File home;
    private boolean lazyNetBeansOrgList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ModuleList getModuleList(File file) throws IOException {
        return ModuleList.getModuleList(file, null);
    }

    public static ModuleList getModuleList(final File file, final File file2) throws IOException {
        try {
            return (ModuleList)ProjectManager.mutex().readAccess(new Mutex.ExceptionAction(){
                static final /* synthetic */ boolean $assertionsDisabled;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    Map map = binaryLists;
                    synchronized (map) {
                        boolean bl;
                        timeSpentInXmlParsing = 0L;
                        xmlFilesParsed = 0;
                        directoriesChecked = 0;
                        jarsOpened = 0;
                        Element element = ModuleList.parseData(file);
                        if (element == null) {
                            throw new IOException("Not an NBM project in " + file);
                        }
                        boolean bl2 = Util.findElement(element, "suite-component", "http://www.netbeans.org/ns/nb-module-project/2") != null;
                        boolean bl3 = bl = Util.findElement(element, "standalone", "http://www.netbeans.org/ns/nb-module-project/2") != null;
                        if (!$assertionsDisabled && bl2 && bl) {
                            throw new AssertionError(file);
                        }
                        if (bl2) {
                            PropertyEvaluator propertyEvaluator = ModuleList.parseProperties(file, null, true, false, "irrelevant");
                            String string = propertyEvaluator.getProperty("suite.dir");
                            if (string == null) {
                                throw new IOException("No suite.dir defined from " + file);
                            }
                            File file3 = PropertyUtils.resolveFile((File)file, (String)string);
                            return ModuleList.findOrCreateModuleListFromSuite(file3, file2);
                        }
                        if (bl) {
                            return ModuleList.findOrCreateModuleListFromStandaloneModule(file, file2);
                        }
                        File file4 = ModuleList.findNetBeansOrg(file);
                        if (file4 == null) {
                            throw new IOException("Could not find netbeans.org CVS root from " + file + "; note that 3rd-level modules (a/b/c) are permitted at the maximum");
                        }
                        return ModuleList.findOrCreateModuleListFromNetBeansOrgSources(file4);
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$universe$ModuleList == null ? (class$org$netbeans$modules$apisupport$project$universe$ModuleList = ModuleList.class$("org.netbeans.modules.apisupport.project.universe.ModuleList")) : class$org$netbeans$modules$apisupport$project$universe$ModuleList).desiredAssertionStatus();
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existKnownEntries() {
        Map map = knownEntries;
        synchronized (map) {
            return !knownEntries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getKnownEntries(File file) {
        Map map = knownEntries;
        synchronized (map) {
            Set set = (Set)knownEntries.get(file);
            if (set != null) {
                return new HashSet(set);
            }
            return Collections.EMPTY_SET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerEntry(ModuleEntry moduleEntry, Set set) {
        Map map = knownEntries;
        synchronized (map) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                HashSet<ModuleEntry> hashSet = (HashSet<ModuleEntry>)knownEntries.get(file);
                if (hashSet == null) {
                    hashSet = new HashSet<ModuleEntry>();
                    knownEntries.put(file, hashSet);
                }
                hashSet.add(moduleEntry);
            }
        }
    }

    static ModuleList findOrCreateModuleListFromNetBeansOrgSources(File file) throws IOException {
        ModuleList moduleList = (ModuleList)sourceLists.get(file);
        if (moduleList == null) {
            moduleList = ModuleList.createModuleListFromNetBeansOrgSources(file);
            sourceLists.put(file, moduleList);
        }
        return moduleList;
    }

    private static ModuleList createModuleListFromNetBeansOrgSources(File file) throws IOException {
        Util.err.log("ModuleList.createModuleListFromSources: " + file);
        File file2 = new File(file, DEST_DIR_IN_NETBEANS_ORG);
        HashMap hashMap = new HashMap();
        ModuleList.scanNetBeansOrgStableSources(hashMap, file, file2);
        return new ModuleList(hashMap, file, true);
    }

    private static void scanNetBeansOrgStableSources(Map map, File file, File file2) throws IOException {
        Map map2 = ModuleList.getClusterProperties(file);
        String string = (String)map2.get("clusters.list");
        if (string == null) {
            throw new IOException("No ${nb.clusters.list} found in " + file);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = (String)map2.get(string2);
            if (string3 == null) {
                throw new IOException("No ${" + string2 + "} found in " + file);
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ", ");
            while (stringTokenizer2.hasMoreTokens()) {
                String string4 = stringTokenizer2.nextToken();
                ModuleList.scanPossibleProject(new File(file, string4.replace('/', File.separatorChar)), map, false, false, file, file2, string4, true);
            }
        }
    }

    private static void doScanNetBeansOrgSources(Map map, File file, int n, File file2, File file3, String string, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            if (!fileArray[i].isDirectory() || EXCLUDED_DIR_NAMES.contains(string2 = fileArray[i].getName())) continue;
            String string3 = string != null ? string + "/" + string2 : string2;
            try {
                ModuleList.scanPossibleProject(fileArray[i], map, false, false, file2, file3, string3, bl);
            }
            catch (IOException iOException) {
                Util.err.annotate((Throwable)iOException, 0, "Malformed project metadata in " + fileArray[i] + ", skipping...", null, null, null);
                Util.err.notify(1, (Throwable)iOException);
            }
            if (n <= 1) continue;
            ModuleList.doScanNetBeansOrgSources(map, fileArray[i], n - 1, file2, file3, string3, bl);
        }
    }

    private static void scanPossibleProject(File file, Map map, boolean bl, boolean bl2, File file2, File file3, String string, boolean bl3) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ++directoriesChecked;
        Element element = ModuleList.parseData(file);
        if (element == null) {
            return;
        }
        if (!$assertionsDisabled && !(file2 != null ^ (bl2 || bl))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(string != null ^ (bl2 || bl))) {
            throw new AssertionError();
        }
        String string2 = Util.findText(Util.findElement(element, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2"));
        PropertyEvaluator propertyEvaluator = ModuleList.parseProperties(file, file2, bl, bl2, string2);
        String string3 = propertyEvaluator.getProperty("module.jar");
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = Util.findSubElements(element).iterator();
        while (iterator.hasNext()) {
            Object object5;
            object4 = (Element)iterator.next();
            if (!object4.getLocalName().equals("class-path-extension")) continue;
            object3 = Util.findElement((Element)object4, "binary-origin", "http://www.netbeans.org/ns/nb-module-project/2");
            if (object3 != null) {
                object2 = Util.findText((Element)object3);
            } else {
                object = Util.findElement((Element)object4, "runtime-relative-path", "http://www.netbeans.org/ns/nb-module-project/2");
                if (!$assertionsDisabled && object == null) {
                    throw new AssertionError((Object)("Malformed <class-path-extension> in " + file));
                }
                object5 = Util.findText((Element)object);
                object2 = "${cluster}/${module.jar.dir}/" + (String)object5;
            }
            object = propertyEvaluator.evaluate((String)object2);
            if (object == null) continue;
            object5 = PropertyUtils.resolveFile((File)file, (String)object);
            stringBuffer.append(':');
            stringBuffer.append(((File)object5).getAbsolutePath());
        }
        object4 = new File(file, "manifest.mf");
        object3 = ((File)object4).isFile() ? ManifestManager.getInstance((File)object4, false) : ManifestManager.NULL_INSTANCE;
        object2 = PropertyUtils.resolveFile((File)file, (String)propertyEvaluator.evaluate("${cluster}"));
        object = !bl && !bl2 ? new NetBeansOrgEntry(file2, string2, string, (File)object2, string3, stringBuffer.toString(), ((ManifestManager)object3).getReleaseVersion(), ((ManifestManager)object3).getSpecificationVersion(), ((ManifestManager)object3).getProvidedTokens(), ProjectXMLManager.findPublicPackages(element), ((ManifestManager)object3).isDeprecated()) : new ExternalEntry(file, string2, (File)object2, PropertyUtils.resolveFile((File)object2, (String)string3), stringBuffer.toString(), file3, ((ManifestManager)object3).getReleaseVersion(), ((ManifestManager)object3).getSpecificationVersion(), ((ManifestManager)object3).getProvidedTokens(), ProjectXMLManager.findPublicPackages(element), ((ManifestManager)object3).isDeprecated());
        if (map.containsKey(string2)) {
            if (bl3) {
                Util.err.log(16, "Warning: two modules found with the same code name base (" + string2 + "): " + map.get(string2) + " and " + object);
            }
        } else {
            map.put(string2, object);
        }
        ModuleList.registerEntry((ModuleEntry)object, ModuleList.findSourceNBMFiles((ModuleEntry)object, propertyEvaluator));
    }

    private static Set findSourceNBMFiles(ModuleEntry moduleEntry, PropertyEvaluator propertyEvaluator) throws IOException {
        Object object;
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(moduleEntry.getJarLocation());
        File file = moduleEntry.getClusterDirectory();
        String string = moduleEntry.getCodeNameBase().replace('.', '-');
        String[] stringArray = new String[]{"update_tracking/*.xml", "config/Modules/*.xml", "config/ModuleAutoDeps/*.xml", "ant/nblib/*.jar", "modules/docs/*.jar"};
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(42);
            ModuleList.findSourceNBMFilesMaybeAdd(hashSet, file, stringArray[i].substring(0, n) + string + stringArray[i].substring(n + 1));
        }
        String string2 = propertyEvaluator.getProperty("extra.module.files");
        if (string2 != null) {
            String[] stringArray2 = string2.split(" *, *");
            for (int i = 0; i < stringArray2.length; ++i) {
                object = stringArray2[i];
                if (((String)object).endsWith("/")) {
                    object = (String)object + "**";
                }
                if (((String)object).indexOf(42) == -1) {
                    ModuleList.findSourceNBMFilesMaybeAdd(hashSet, file, (String)object);
                    continue;
                }
                String string3 = "\\Q" + ((String)object).replaceAll("\\*\\*", "__DBLASTERISK__").replaceAll("\\*", "\\\\E[^/]*\\\\Q").replaceAll("__DBLASTERISK__", "\\\\E.*\\\\Q") + "\\E";
                Pattern pattern = Pattern.compile(string3);
                String[] stringArray3 = ModuleList.scanDirForFiles(file);
                for (int j = 0; j < stringArray3.length; ++j) {
                    if (!pattern.matcher(stringArray3[j]).matches()) continue;
                    ModuleList.findSourceNBMFilesMaybeAdd(hashSet, file, stringArray3[j]);
                }
            }
        }
        File file2 = moduleEntry.getSourceLocation();
        if (!($assertionsDisabled || file2 != null && file2.isDirectory())) {
            throw new AssertionError(moduleEntry);
        }
        File file3 = new File(file2, "release");
        if (file3.isDirectory()) {
            object = ModuleList.scanDirForFiles(file3);
            for (int i = 0; i < ((String[])object).length; ++i) {
                ModuleList.findSourceNBMFilesMaybeAdd(hashSet, file, object[i]);
            }
        }
        return hashSet;
    }

    private static void findSourceNBMFilesMaybeAdd(Set set, File file, String string) {
        File file2 = new File(file, string.replace('/', File.separatorChar));
        set.add(file2);
    }

    private static String[] scanDirForFiles(File file) {
        String[] stringArray = (String[])DIR_SCAN_CACHE.get(file);
        if (stringArray == null) {
            ArrayList arrayList = new ArrayList(250);
            ModuleList.doScanDirForFiles(file, arrayList, "");
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    private static void doScanDirForFiles(File file, List list, String string) {
        ++directoriesChecked;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isFile()) {
                    list.add(string + file2.getName());
                    continue;
                }
                if (!file2.isDirectory()) continue;
                ModuleList.doScanDirForFiles(file2, list, string + file2.getName() + '/');
            }
        }
    }

    public static ModuleList findOrCreateModuleListFromSuite(File file, File file2) throws IOException {
        File file3;
        PropertyEvaluator propertyEvaluator = ModuleList.parseSuiteProperties(file);
        if (file2 == null) {
            String string = propertyEvaluator.getProperty("netbeans.dest.dir");
            if (string == null) {
                throw new IOException("No netbeans.dest.dir defined in " + file);
            }
            file3 = PropertyUtils.resolveFile((File)file, (String)string);
        } else {
            file3 = file2;
        }
        return ModuleList.merge(new ModuleList[]{ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(file, file3, propertyEvaluator), ModuleList.findOrCreateModuleListFromBinaries(file3)}, file);
    }

    private static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File file, File file2, PropertyEvaluator propertyEvaluator) throws IOException {
        ModuleList moduleList = (ModuleList)sourceLists.get(file);
        if (moduleList == null) {
            HashMap hashMap = new HashMap();
            File[] fileArray = ModuleList.findModulesInSuite(file, propertyEvaluator);
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    ModuleList.scanPossibleProject(fileArray[i], hashMap, true, false, null, file2, null, true);
                    continue;
                }
                catch (IOException iOException) {
                    Util.err.annotate((Throwable)iOException, 0, "Malformed project metadata in " + fileArray[i] + ", skipping...", null, null, null);
                    Util.err.notify(1, (Throwable)iOException);
                }
            }
            moduleList = new ModuleList(hashMap, file, false);
            sourceLists.put(file, moduleList);
        }
        return moduleList;
    }

    static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File file) throws IOException {
        PropertyEvaluator propertyEvaluator = ModuleList.parseSuiteProperties(file);
        String string = propertyEvaluator.getProperty("netbeans.dest.dir");
        if (string == null) {
            throw new IOException("No netbeans.dest.dir defined in " + file);
        }
        File file2 = PropertyUtils.resolveFile((File)file, (String)string);
        return ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(file, file2, propertyEvaluator);
    }

    private static PropertyEvaluator parseSuiteProperties(File file) throws IOException {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(System.getProperties());
        hashMap.put("basedir", file.getAbsolutePath());
        PropertyProvider propertyProvider = PropertyUtils.fixedPropertyProvider(hashMap);
        ArrayList<PropertyProvider> arrayList = new ArrayList<PropertyProvider>();
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "platform.properties")));
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
        String string = propertyEvaluator.getProperty("user.properties.file");
        if (string != null) {
            arrayList.add(ModuleList.loadPropertiesFile(PropertyUtils.resolveFile((File)file, (String)string)));
        } else {
            arrayList.add(PropertyUtils.globalPropertyProvider());
        }
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties")));
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "project.properties")));
        propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
        String string2 = propertyEvaluator.getProperty("nbplatform.active");
        if (string2 != null) {
            arrayList.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + string2 + ".netbeans.dest.dir}")));
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
    }

    static File[] findModulesInSuite(File file) throws IOException {
        return ModuleList.findModulesInSuite(file, ModuleList.parseSuiteProperties(file));
    }

    private static File[] findModulesInSuite(File file, PropertyEvaluator propertyEvaluator) throws IOException {
        String string = propertyEvaluator.getProperty("modules");
        if (string == null) {
            string = "";
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string);
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = PropertyUtils.resolveFile((File)file, (String)stringArray[i]);
        }
        return fileArray;
    }

    private static ModuleList findOrCreateModuleListFromStandaloneModule(File file, File file2) throws IOException {
        File file3;
        Object object;
        PropertyEvaluator propertyEvaluator = ModuleList.parseProperties(file, null, false, true, "irrelevant");
        if (file2 == null) {
            object = propertyEvaluator.getProperty("netbeans.dest.dir");
            if (object == null) {
                throw new IOException("No netbeans.dest.dir defined in " + file);
            }
            if (((String)object).indexOf("${") != -1) {
                throw new IOException("Unevaluated properties in " + (String)object + " from " + file + "; probably means platform definitions not loaded correctly");
            }
            file3 = PropertyUtils.resolveFile((File)file, (String)object);
        } else {
            file3 = file2;
        }
        object = ModuleList.findOrCreateModuleListFromBinaries(file3);
        ModuleList moduleList = (ModuleList)sourceLists.get(file);
        if (moduleList == null) {
            HashMap hashMap = new HashMap();
            ModuleList.scanPossibleProject(file, hashMap, false, true, null, file3, null, true);
            if (hashMap.isEmpty()) {
                throw new IOException("No module in " + file);
            }
            moduleList = new ModuleList(hashMap, file, false);
            sourceLists.put(file, moduleList);
        }
        return ModuleList.merge(new ModuleList[]{moduleList, object}, file);
    }

    static ModuleList findOrCreateModuleListFromBinaries(File file) throws IOException {
        ModuleList moduleList = (ModuleList)binaryLists.get(file);
        if (moduleList == null) {
            moduleList = ModuleList.createModuleListFromBinaries(file);
            binaryLists.put(file, moduleList);
        }
        return moduleList;
    }

    private static ModuleList createModuleListFromBinaries(File file) throws IOException {
        Util.err.log("ModuleList.createModuleListFromBinaries: " + file);
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Cannot examine dir " + file);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            for (int j = 0; j < MODULE_DIRS.length; ++j) {
                File file2 = new File(fileArray[i], MODULE_DIRS[j].replace('/', File.separatorChar));
                if (!file2.isDirectory()) continue;
                File[] fileArray2 = file2.listFiles();
                if (fileArray2 == null) {
                    throw new IOException("Cannot examine dir " + file2);
                }
                for (int k = 0; k < fileArray2.length; ++k) {
                    Object object;
                    File[] fileArray3;
                    File file3 = fileArray2[k];
                    if (!file3.getName().endsWith(".jar")) continue;
                    ++jarsOpened;
                    ManifestManager manifestManager = ManifestManager.getInstanceFromJAR(file3);
                    String string = manifestManager.getCodeNameBase();
                    if (string == null) continue;
                    String string2 = manifestManager.getClassPath();
                    if (string2 == null) {
                        fileArray3 = new File[]{};
                    } else {
                        object = string2.trim().split(" +");
                        fileArray3 = new File[((String[])object).length];
                        for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                            fileArray3[i2] = new File(file2, object[i2].replace('/', File.separatorChar));
                        }
                    }
                    object = new BinaryEntry(string, file3, fileArray3, file, fileArray[i], manifestManager.getReleaseVersion(), manifestManager.getSpecificationVersion(), manifestManager.getProvidedTokens(), manifestManager.getPublicPackages(), manifestManager.isDeprecated());
                    if (hashMap.containsKey(string)) {
                        Util.err.log(16, "Warning: two modules found with the same code name base (" + string + "): " + hashMap.get(string) + " and " + object);
                    } else {
                        hashMap.put(string, (String[])object);
                    }
                    ModuleList.registerEntry((ModuleEntry)object, ModuleList.findBinaryNBMFiles(fileArray[i], string, file3));
                }
            }
        }
        return new ModuleList(hashMap, file, false);
    }

    private static Set findBinaryNBMFiles(File file, String string, File file2) throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(file2);
        File file3 = new File(new File(file, "update_tracking"), string.replace('.', '-') + ".xml");
        if (file3.isFile()) {
            Document document;
            hashSet.add(file3);
            try {
                ++xmlFilesParsed;
                timeSpentInXmlParsing -= System.currentTimeMillis();
                document = XMLUtil.parse((InputSource)new InputSource(file3.toURI().toString()), (boolean)false, (boolean)false, null, null);
                timeSpentInXmlParsing += System.currentTimeMillis();
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException(sAXException.toString()).initCause(sAXException);
            }
            Iterator iterator = Util.findSubElements(document.getDocumentElement()).iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!element.getTagName().equals("module_version") || !element.getAttribute("last").equals("true")) continue;
                Iterator iterator2 = Util.findSubElements(element).iterator();
                while (iterator2.hasNext()) {
                    String string2;
                    File file4;
                    Element element2 = (Element)iterator2.next();
                    if (!element2.getTagName().equals("file") || !(file4 = new File(file, (string2 = element2.getAttribute("name")).replace('/', File.separatorChar))).isFile()) continue;
                    hashSet.add(file4);
                }
            }
        }
        return hashSet;
    }

    static Element parseData(File file) throws IOException {
        Document document;
        File file2 = new File(file, PROJECT_XML);
        if (!file2.exists() || !file2.isFile()) {
            return null;
        }
        try {
            ++xmlFilesParsed;
            timeSpentInXmlParsing -= System.currentTimeMillis();
            document = XMLUtil.parse((InputSource)new InputSource(file2.toURI().toString()), (boolean)false, (boolean)true, null, null);
            timeSpentInXmlParsing += System.currentTimeMillis();
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException(file2 + ": " + sAXException.toString()).initCause(sAXException);
        }
        Element element = document.getDocumentElement();
        Element element2 = Util.findElement(element, "type", "http://www.netbeans.org/ns/project/1");
        if (!Util.findText(element2).equals("org.netbeans.modules.apisupport.project")) {
            return null;
        }
        Element element3 = Util.findElement(element, "configuration", "http://www.netbeans.org/ns/project/1");
        return Util.findElement(element3, "data", "http://www.netbeans.org/ns/nb-module-project/2");
    }

    static PropertyEvaluator parseProperties(File file, File file2, boolean bl, boolean bl2, String string) throws IOException {
        boolean bl3;
        Object object;
        String string2;
        Object object2;
        if (!$assertionsDisabled && bl && bl2) {
            throw new AssertionError(file);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(System.getProperties());
        hashMap.put("basedir", file.getAbsolutePath());
        PropertyProvider propertyProvider = PropertyUtils.fixedPropertyProvider(hashMap);
        ArrayList<PropertyProvider> arrayList = new ArrayList<PropertyProvider>();
        if (bl) {
            arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "suite-private.properties")));
            arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "suite.properties")));
            object2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
            string2 = object2.getProperty("suite.dir");
            if (string2 != null) {
                object = PropertyUtils.resolveFile((File)file, (String)string2);
                arrayList.add(ModuleList.loadPropertiesFile(new File((File)object, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
                arrayList.add(ModuleList.loadPropertiesFile(new File((File)object, "nbproject" + File.separatorChar + "platform.properties")));
            }
        } else if (bl2) {
            arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
            arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "platform.properties")));
        }
        if (bl || bl2) {
            object2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
            string2 = object2.getProperty("user.properties.file");
            if (string2 != null) {
                arrayList.add(ModuleList.loadPropertiesFile(PropertyUtils.resolveFile((File)file, (String)string2)));
            } else {
                arrayList.add(PropertyUtils.globalPropertyProvider());
            }
            object2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
            object = object2.getProperty("nbplatform.active");
            if (object != null) {
                arrayList.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + (String)object + ".netbeans.dest.dir}")));
            }
        }
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties")));
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "project.properties")));
        object2 = new HashMap();
        boolean bl4 = bl3 = !bl && !bl2;
        if (bl3) {
            object2.put("nb_all", file2.getAbsolutePath());
            object2.put("netbeans.dest.dir", new File(file2, DEST_DIR_IN_NETBEANS_ORG).getAbsolutePath());
        }
        object2.put("code.name.base.dashes", string.replace('.', '-'));
        object2.put("module.jar.dir", "modules");
        object2.put("module.jar.basename", "${code.name.base.dashes}.jar");
        object2.put("module.jar", "${module.jar.dir}/${module.jar.basename}");
        arrayList.add(PropertyUtils.fixedPropertyProvider((Map)object2));
        if (bl) {
            object2.put("cluster", "${suite.dir}/build/cluster");
        } else if (bl2) {
            object2.put("cluster", "build/cluster");
        } else {
            object = ModuleList.findClusterLocation(file, file2);
            if (object == null) {
                object = "extra";
            }
            object2.put("cluster", "${netbeans.dest.dir}/" + (String)object);
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyProvider loadPropertiesFile(File file) throws IOException {
        if (!file.isFile()) {
            return PropertyUtils.fixedPropertyProvider((Map)Collections.EMPTY_MAP);
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties.load(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return PropertyUtils.fixedPropertyProvider((Map)properties);
    }

    public static void refresh() {
        sourceLists.clear();
        binaryLists.clear();
    }

    public static void refreshSuiteModuleList(File file) {
        sourceLists.remove(file);
    }

    public static boolean isNetBeansOrg(File file) {
        return new File(file, "nbbuild").isDirectory() && new File(file, "openide").isDirectory();
    }

    public static File findNetBeansOrg(File file) {
        File file2 = file;
        for (int i = 0; i < 3; ++i) {
            if ((file2 = file2.getParentFile()) == null) {
                return null;
            }
            if (!ModuleList.isNetBeansOrg(file2)) continue;
            return file2;
        }
        return null;
    }

    private static Map getClusterProperties(File file) throws IOException {
        Map map = (Map)clusterPropertiesFiles.get(file);
        if (map == null) {
            PropertyProvider propertyProvider = ModuleList.loadPropertiesFile(new File(file, "nbbuild" + File.separatorChar + "cluster.properties"));
            PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.fixedPropertyProvider((Map)Collections.EMPTY_MAP), (PropertyProvider[])new PropertyProvider[]{propertyProvider});
            map = propertyEvaluator.getProperties();
            if (map == null) {
                map = Collections.EMPTY_MAP;
            }
        }
        return map;
    }

    private static String findClusterLocation(File file, File file2) throws IOException {
        String string = PropertyUtils.relativizeFile((File)file2, (File)file);
        if (!$assertionsDisabled && string.indexOf("..") != -1) {
            throw new AssertionError((Object)string);
        }
        HashMap<String, String> hashMap = (HashMap<String, String>)clusterLocations.get(file2);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            Map map = ModuleList.getClusterProperties(file2);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                String string3 = (String)map.get(string2 + ".dir");
                if (string3 == null) continue;
                String string4 = (String)entry.getValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ", ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    hashMap.put(string5, string3);
                }
            }
            clusterLocations.put(file2, hashMap);
        }
        return (String)hashMap.get(string);
    }

    private ModuleList(Map map, File file, boolean bl) {
        this.entries = map;
        this.home = file;
        this.lazyNetBeansOrgList = bl;
    }

    public String toString() {
        return "ModuleList[" + this.home + "]" + (this.lazyNetBeansOrgList ? "[lazy]" : "") + this.entries.values();
    }

    private static ModuleList merge(ModuleList[] moduleListArray, File file) {
        HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>();
        for (int i = 0; i < moduleListArray.length; ++i) {
            moduleListArray[i].maybeRescanNetBeansOrgSources();
            Iterator iterator = moduleListArray[i].entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, (ModuleEntry)entry.getValue());
            }
        }
        return new ModuleList(hashMap, file, false);
    }

    private void maybeRescanNetBeansOrgSources() {
        if (this.lazyNetBeansOrgList) {
            this.lazyNetBeansOrgList = false;
            File file = new File(this.home, DEST_DIR_IN_NETBEANS_ORG);
            HashMap hashMap = new HashMap(this.entries);
            ModuleList.doScanNetBeansOrgSources(hashMap, this.home, 3, this.home, file, null, false);
            this.entries = hashMap;
        }
    }

    public ModuleEntry getEntry(String string) {
        ModuleEntry moduleEntry = (ModuleEntry)this.entries.get(string);
        if (moduleEntry != null) {
            return moduleEntry;
        }
        this.maybeRescanNetBeansOrgSources();
        return (ModuleEntry)this.entries.get(string);
    }

    public Set getAllEntries() {
        this.maybeRescanNetBeansOrgSources();
        return new HashSet(this.entries.values());
    }

    public Set getAllEntriesSoft() {
        return new HashSet(this.entries.values());
    }

    public static LocalizedBundleInfo loadBundleInfo(File file) {
        LocalizedBundleInfo localizedBundleInfo = Util.findLocalizedBundleInfo(file);
        return localizedBundleInfo == null ? LocalizedBundleInfo.EMPTY : localizedBundleInfo;
    }

    static {
        $assertionsDisabled = !ModuleList.class.desiredAssertionStatus();
        DEST_DIR_IN_NETBEANS_ORG = "nbbuild" + File.separatorChar + "netbeans";
        sourceLists = new HashMap();
        binaryLists = new HashMap();
        clusterPropertiesFiles = new HashMap();
        clusterLocations = new HashMap();
        knownEntries = new HashMap();
        EXCLUDED_DIR_NAMES = new HashSet();
        EXCLUDED_DIR_NAMES.add("CVS");
        EXCLUDED_DIR_NAMES.add("nbproject");
        EXCLUDED_DIR_NAMES.add("www");
        EXCLUDED_DIR_NAMES.add("test");
        EXCLUDED_DIR_NAMES.add("build");
        EXCLUDED_DIR_NAMES.add("src");
        EXCLUDED_DIR_NAMES.add("org");
        DIR_SCAN_CACHE = new HashMap();
        MODULE_DIRS = new String[]{"modules", "modules/eager", "modules/autoload", "lib", "core"};
        PROJECT_XML = "nbproject" + File.separatorChar + "project.xml";
    }
}

