/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public final class NbPlatform {
    private static final String PLATFORM_PREFIX = "nbplatform.";
    private static final String PLATFORM_DEST_DIR_SUFFIX = ".netbeans.dest.dir";
    private static final String PLATFORM_LABEL_SUFFIX = ".label";
    private static final String PLATFORM_SOURCES_SUFFIX = ".sources";
    private static final String PLATFORM_JAVADOC_SUFFIX = ".javadoc";
    private static final String PLATFORM_HARNESS_DIR_SUFFIX = ".harness.dir";
    public static final String PLATFORM_ID_DEFAULT = "default";
    private static Set platforms;
    private final String id;
    private String label;
    private File nbdestdir;
    private URL[] sourceRoots;
    private URL[] javadocRoots;
    private List listsForSources;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void reset() {
        platforms = null;
    }

    public static Set getPlatforms() {
        if (platforms == null) {
            Object object;
            platforms = new HashSet();
            Map map = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.globalPropertyProvider(), (PropertyProvider[])new PropertyProvider[0]).getProperties();
            boolean bl = false;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!((String)object).startsWith(PLATFORM_PREFIX) || !((String)object).endsWith(PLATFORM_DEST_DIR_SUFFIX)) continue;
                String string = ((String)object).substring(PLATFORM_PREFIX.length(), ((String)object).length() - PLATFORM_DEST_DIR_SUFFIX.length());
                String string2 = (String)map.get(PLATFORM_PREFIX + string + PLATFORM_LABEL_SUFFIX);
                String string3 = (String)map.get(object);
                String string4 = (String)map.get(PLATFORM_PREFIX + string + PLATFORM_SOURCES_SUFFIX);
                String string5 = (String)map.get(PLATFORM_PREFIX + string + PLATFORM_JAVADOC_SUFFIX);
                platforms.add(new NbPlatform(string, string2, FileUtil.normalizeFile((File)new File(string3)), NbPlatform.findURLs(string4), NbPlatform.findURLs(string5)));
                bl |= string.equals(PLATFORM_ID_DEFAULT);
            }
            if (!bl && (object = NbPlatform.defaultPlatformLocation()) != null) {
                platforms.add(new NbPlatform(PLATFORM_ID_DEFAULT, null, (File)object, new URL[0], new URL[0]));
            }
        }
        return platforms;
    }

    public static NbPlatform getDefaultPlatform() {
        return NbPlatform.getPlatformByID(PLATFORM_ID_DEFAULT);
    }

    public static File defaultPlatformLocation() {
        File file = InstalledFileLocator.getDefault().locate("core/core.jar", "org.netbeans.core.startup", false);
        if (file == null) {
            return null;
        }
        File file2 = InstalledFileLocator.getDefault().locate("suite.xml", "org.netbeans.modules.apisupport.harness", false);
        if (file2 == null) {
            ErrorManager.getDefault().log(16, "Cannot resolve default platform. Probably either \"org.netbeans.modules.apisupport.harness\" module is missing or is corrupted.");
            return null;
        }
        File file3 = file2.getParentFile().getParentFile();
        if (!file3.equals(file.getParentFile().getParentFile().getParentFile())) {
            return null;
        }
        return FileUtil.normalizeFile((File)file3);
    }

    private static URL[] defaultPlatformSources(File file) {
        block3: {
            if (file.getName().equals("netbeans") && file.getParentFile().getName().equals("nbbuild")) {
                try {
                    return new URL[]{file.getParentFile().getParentFile().toURI().toURL()};
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)malformedURLException);
                }
            }
        }
        return new URL[0];
    }

    private static URL[] defaultPlatformJavadoc() {
        File file = InstalledFileLocator.getDefault().locate("docs/NetBeansAPIs.zip", "org.netbeans.modules.apisupport.apidocs", true);
        if (file != null) {
            return new URL[]{Util.urlForJar(file)};
        }
        return new URL[0];
    }

    public static NbPlatform getPlatformByID(String string) {
        Iterator iterator = NbPlatform.getPlatforms().iterator();
        while (iterator.hasNext()) {
            NbPlatform nbPlatform = (NbPlatform)iterator.next();
            if (!nbPlatform.getID().equals(string)) continue;
            return nbPlatform;
        }
        return null;
    }

    public static NbPlatform getPlatformByDestDir(File file) {
        File file2;
        File file3;
        Object object;
        Iterator iterator = NbPlatform.getPlatforms().iterator();
        while (iterator.hasNext()) {
            object = (NbPlatform)iterator.next();
            if (!((NbPlatform)object).getDestDir().equals(file)) continue;
            return object;
        }
        object = new URL[]{};
        if (file.getName().equals("netbeans") && (file3 = file.getParentFile()) != null && file3.getName().equals("nbbuild") && (file2 = file3.getParentFile()) != null && ModuleList.isNetBeansOrg(file2)) {
            object = new URL[]{Util.urlForDir(file2)};
        }
        return new NbPlatform(null, null, file, (URL[])object, new URL[0]);
    }

    public static boolean contains(File file) {
        boolean bl = false;
        Iterator iterator = NbPlatform.getPlatforms().iterator();
        while (iterator.hasNext()) {
            NbPlatform nbPlatform = (NbPlatform)iterator.next();
            if (!nbPlatform.getDestDir().equals(file)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static NbPlatform addPlatform(final String string, final File file, final String string2) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    String string3 = NbPlatform.PLATFORM_PREFIX + string + NbPlatform.PLATFORM_DEST_DIR_SUFFIX;
                    editableProperties.setProperty(string3, file.getAbsolutePath());
                    if (!file.isDirectory()) {
                        throw new FileNotFoundException(file.getAbsolutePath());
                    }
                    String string22 = NbPlatform.PLATFORM_PREFIX + string + NbPlatform.PLATFORM_HARNESS_DIR_SUFFIX;
                    if (new File(file, "harness").isDirectory()) {
                        editableProperties.setProperty(string22, "${" + string3 + "}/harness");
                    } else {
                        editableProperties.setProperty(string22, "${nbplatform.default.harness.dir}");
                    }
                    editableProperties.setProperty(NbPlatform.PLATFORM_PREFIX + string + NbPlatform.PLATFORM_LABEL_SUFFIX, string2);
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        NbPlatform nbPlatform = new NbPlatform(string, string2, FileUtil.normalizeFile((File)file), NbPlatform.findURLs(null), NbPlatform.findURLs(null));
        NbPlatform.getPlatforms().add(nbPlatform);
        return nbPlatform;
    }

    public static void removePlatform(final NbPlatform nbPlatform) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_DEST_DIR_SUFFIX));
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_HARNESS_DIR_SUFFIX));
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_LABEL_SUFFIX));
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_SOURCES_SUFFIX));
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_JAVADOC_SUFFIX));
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        NbPlatform.getPlatforms().remove(nbPlatform);
    }

    private NbPlatform(String string, String string2, File file, URL[] uRLArray, URL[] uRLArray2) {
        this.id = string;
        this.label = string2;
        this.nbdestdir = file;
        this.sourceRoots = uRLArray;
        this.javadocRoots = uRLArray2;
    }

    static URL[] findURLs(String string) {
        if (string == null) {
            return new URL[0];
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string);
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            uRLArray[i] = Util.urlForDirOrJar(FileUtil.normalizeFile((File)new File(stringArray[i])));
        }
        return uRLArray;
    }

    public String getID() {
        return this.id;
    }

    public boolean isDefault() {
        return PLATFORM_ID_DEFAULT.equals(this.id);
    }

    public String getLabel() {
        if (this.label == null) {
            try {
                this.label = this.isValid() ? NbPlatform.computeDisplayName(this.nbdestdir) : NbBundle.getMessage((Class)NbPlatform.class, (String)"MSG_InvalidPlatform", (Object)this.getDestDir().getAbsolutePath());
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
                this.label = this.nbdestdir.getAbsolutePath();
            }
        }
        if (this.isDefault()) {
            return NbBundle.getMessage((Class)NbPlatform.class, (String)"LBL_default_platform", (Object)this.label);
        }
        return this.label;
    }

    public File getDestDir() {
        return this.nbdestdir;
    }

    public void setDestDir(File file) {
        this.nbdestdir = file;
    }

    public URL[] getSourceRoots() {
        if (this.sourceRoots.length == 0 && this.isDefault()) {
            return NbPlatform.defaultPlatformSources(this.getDestDir());
        }
        return this.sourceRoots;
    }

    private void maybeUpdateDefaultPlatformSources() {
        if (this.sourceRoots.length == 0 && this.isDefault()) {
            this.sourceRoots = NbPlatform.defaultPlatformSources(this.getDestDir());
        }
    }

    public void addSourceRoot(URL uRL) throws IOException {
        this.maybeUpdateDefaultPlatformSources();
        URL[] uRLArray = new URL[this.sourceRoots.length + 1];
        System.arraycopy(this.sourceRoots, 0, uRLArray, 0, this.sourceRoots.length);
        uRLArray[this.sourceRoots.length] = uRL;
        this.setSourceRoots(uRLArray);
    }

    public void removeSourceRoots(URL[] uRLArray) throws IOException {
        this.maybeUpdateDefaultPlatformSources();
        ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(this.sourceRoots));
        arrayList.removeAll(Arrays.asList(uRLArray));
        URL[] uRLArray2 = new URL[arrayList.size()];
        this.setSourceRoots(arrayList.toArray(uRLArray2));
    }

    public void moveSourceRootUp(int n) throws IOException {
        this.maybeUpdateDefaultPlatformSources();
        if (n <= 0) {
            return;
        }
        URL[] uRLArray = new URL[this.sourceRoots.length];
        System.arraycopy(this.sourceRoots, 0, uRLArray, 0, this.sourceRoots.length);
        uRLArray[n - 1] = this.sourceRoots[n];
        uRLArray[n] = this.sourceRoots[n - 1];
        this.setSourceRoots(uRLArray);
    }

    public void moveSourceRootDown(int n) throws IOException {
        this.maybeUpdateDefaultPlatformSources();
        if (n >= this.sourceRoots.length - 1) {
            return;
        }
        URL[] uRLArray = new URL[this.sourceRoots.length];
        System.arraycopy(this.sourceRoots, 0, uRLArray, 0, this.sourceRoots.length);
        uRLArray[n + 1] = this.sourceRoots[n];
        uRLArray[n] = this.sourceRoots[n + 1];
        this.setSourceRoots(uRLArray);
    }

    public void setSourceRoots(URL[] uRLArray) throws IOException {
        this.putGlobalProperty(PLATFORM_PREFIX + this.getID() + PLATFORM_SOURCES_SUFFIX, NbPlatform.urlsToAntPath(uRLArray));
        this.sourceRoots = uRLArray;
        this.listsForSources = null;
    }

    public URL[] getJavadocRoots() {
        if (this.javadocRoots.length == 0 && this.isDefault()) {
            return NbPlatform.defaultPlatformJavadoc();
        }
        return this.javadocRoots;
    }

    private void maybeUpdateDefaultPlatformJavadoc() {
        if (this.javadocRoots.length == 0 && this.isDefault()) {
            this.javadocRoots = NbPlatform.defaultPlatformJavadoc();
        }
    }

    public void addJavadocRoot(URL uRL) throws IOException {
        this.maybeUpdateDefaultPlatformJavadoc();
        URL[] uRLArray = new URL[this.javadocRoots.length + 1];
        System.arraycopy(this.javadocRoots, 0, uRLArray, 0, this.javadocRoots.length);
        uRLArray[this.javadocRoots.length] = uRL;
        this.setJavadocRoots(uRLArray);
    }

    public void removeJavadocRoots(URL[] uRLArray) throws IOException {
        this.maybeUpdateDefaultPlatformJavadoc();
        ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(this.javadocRoots));
        arrayList.removeAll(Arrays.asList(uRLArray));
        URL[] uRLArray2 = new URL[arrayList.size()];
        this.setJavadocRoots(arrayList.toArray(uRLArray2));
    }

    public void moveJavadocRootUp(int n) throws IOException {
        this.maybeUpdateDefaultPlatformJavadoc();
        if (n <= 0) {
            return;
        }
        URL[] uRLArray = new URL[this.javadocRoots.length];
        System.arraycopy(this.javadocRoots, 0, uRLArray, 0, this.javadocRoots.length);
        uRLArray[n - 1] = this.javadocRoots[n];
        uRLArray[n] = this.javadocRoots[n - 1];
        this.setJavadocRoots(uRLArray);
    }

    public void moveJavadocRootDown(int n) throws IOException {
        this.maybeUpdateDefaultPlatformJavadoc();
        if (n >= this.javadocRoots.length - 1) {
            return;
        }
        URL[] uRLArray = new URL[this.javadocRoots.length];
        System.arraycopy(this.javadocRoots, 0, uRLArray, 0, this.javadocRoots.length);
        uRLArray[n + 1] = this.javadocRoots[n];
        uRLArray[n] = this.javadocRoots[n + 1];
        this.setJavadocRoots(uRLArray);
    }

    public void setJavadocRoots(URL[] uRLArray) throws IOException {
        this.putGlobalProperty(PLATFORM_PREFIX + this.getID() + PLATFORM_JAVADOC_SUFFIX, NbPlatform.urlsToAntPath(uRLArray));
        this.javadocRoots = uRLArray;
    }

    public boolean isValid() {
        return NbPlatform.isPlatformDirectory(this.getDestDir());
    }

    static String urlsToAntPath(URL[] uRLArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < uRLArray.length; ++i) {
            if (uRLArray[i].getProtocol().equals("jar")) {
                stringBuffer.append(NbPlatform.urlToAntPath(FileUtil.getArchiveFile((URL)uRLArray[i])));
            } else {
                stringBuffer.append(NbPlatform.urlToAntPath(uRLArray[i]));
            }
            if (i == uRLArray.length - 1) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    private static String urlToAntPath(URL uRL) {
        return new File(URI.create(uRL.toExternalForm())).getAbsolutePath();
    }

    private void putGlobalProperty(final String string, final String string2) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    if ("".equals(string2)) {
                        editableProperties.remove((Object)string);
                    } else {
                        editableProperties.setProperty(string, string2);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public File getSourceLocationOfModule(File file) {
        Object object;
        Object object2;
        URL[] uRLArray;
        if (this.listsForSources == null) {
            this.listsForSources = new ArrayList();
            uRLArray = this.getSourceRoots();
            for (int i = 0; i < uRLArray.length; ++i) {
                object2 = uRLArray[i];
                if (!((URL)object2).getProtocol().equals("file") || !((File)(object = new File(URI.create(((URL)object2).toExternalForm())))).isDirectory()) continue;
                try {
                    if (ModuleList.isNetBeansOrg((File)object)) {
                        this.listsForSources.add(ModuleList.findOrCreateModuleListFromNetBeansOrgSources((File)object));
                        continue;
                    }
                    this.listsForSources.add(ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries((File)object));
                    continue;
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                }
            }
        }
        uRLArray = this.listsForSources.iterator();
        while (uRLArray.hasNext()) {
            File file2;
            ModuleEntry moduleEntry;
            ModuleList moduleList = (ModuleList)uRLArray.next();
            object2 = moduleList.getAllEntriesSoft();
            object = object2.iterator();
            while (object.hasNext()) {
                moduleEntry = (ModuleEntry)object.next();
                if (!moduleEntry.getJarLocation().getName().equals(file.getName()) || (file2 = moduleEntry.getSourceLocation()) == null || !file2.isDirectory()) continue;
                return file2;
            }
            object2 = moduleList.getAllEntries();
            object = object2.iterator();
            while (object.hasNext()) {
                moduleEntry = (ModuleEntry)object.next();
                if (!moduleEntry.getJarLocation().getName().equals(file.getName()) || (file2 = moduleEntry.getSourceLocation()) == null || !file2.isDirectory()) continue;
                return file2;
            }
        }
        return null;
    }

    public ModuleEntry[] getModules() {
        try {
            TreeSet treeSet = new TreeSet(ModuleList.findOrCreateModuleListFromBinaries(this.getDestDir()).getAllEntriesSoft());
            ModuleEntry[] moduleEntryArray = new ModuleEntry[treeSet.size()];
            treeSet.toArray(moduleEntryArray);
            return moduleEntryArray;
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
            return new ModuleEntry[0];
        }
    }

    private static File findCoreJar(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2;
                if (!fileArray[i].isDirectory() || !fileArray[i].getName().startsWith("platform") || !(file2 = new File(fileArray[i], "core" + File.separatorChar + "core.jar")).isFile()) continue;
                return file2;
            }
        }
        return null;
    }

    public static boolean isPlatformDirectory(File file) {
        return NbPlatform.findCoreJar(file) != null;
    }

    public static boolean isSupportedPlatform(File file) {
        boolean bl = false;
        File file2 = NbPlatform.findCoreJar(file);
        if (file2 != null) {
            String string = file2.getParentFile().getParentFile().getName();
            if (!$assertionsDisabled && !string.startsWith("platform")) {
                throw new AssertionError();
            }
            int n = Integer.parseInt(string.substring(8));
            bl = n >= 6;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeDisplayName(File file) throws IOException {
        String string;
        String string2;
        File file2 = NbPlatform.findCoreJar(file);
        if (file2 == null) {
            throw new IllegalArgumentException(file.getAbsolutePath());
        }
        JarFile jarFile = new JarFile(file2);
        try {
            string2 = NbPlatform.findCurrVer(jarFile, "");
            if (string2 == null) {
                throw new IOException(file2.getAbsolutePath());
            }
            string = jarFile.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
            if (string == null) {
                throw new IOException(file2.getAbsolutePath());
            }
        }
        finally {
            jarFile.close();
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            block6: for (int i = 0; i < fileArray.length; ++i) {
                String[] stringArray;
                File file3 = new File(fileArray[i], "core" + File.separatorChar + "locale");
                if (!file3.isDirectory() || (stringArray = file3.list()) == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    String string3;
                    int n;
                    String string4 = stringArray[j];
                    String string5 = "core";
                    String string6 = ".jar";
                    if (!string4.startsWith(string5) || !string4.endsWith(string6) || (n = (string3 = string4.substring(string5.length(), string4.length() - string6.length())).lastIndexOf(95)) == -1) continue;
                    String string7 = string3.substring(n + 1);
                    if (Arrays.asList(Locale.getISOCountries()).contains(string7) || !string7.equals("nb") && Arrays.asList(Locale.getISOLanguages()).contains(string7)) continue;
                    jarFile = new JarFile(new File(file3, string4));
                    try {
                        String string8 = NbPlatform.findCurrVer(jarFile, string3);
                        if (string8 == null) continue;
                        string2 = string8;
                        break block6;
                    }
                    finally {
                        jarFile.close();
                    }
                }
            }
        }
        return MessageFormat.format(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findCurrVer(JarFile jarFile, String string) throws IOException {
        ZipEntry zipEntry = jarFile.getEntry("org/netbeans/core/startup/Bundle" + string + ".properties");
        if (zipEntry == null) {
            zipEntry = jarFile.getEntry("org/netbeans/core/Bundle" + string + ".properties");
        }
        if (zipEntry == null) {
            return null;
        }
        Properties properties = new Properties();
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return properties.getProperty("currentVersion");
    }

    public static boolean isLabelValid(String string) {
        if (string == null) {
            return false;
        }
        Iterator iterator = NbPlatform.getPlatforms().iterator();
        while (iterator.hasNext()) {
            String string2 = ((NbPlatform)iterator.next()).getLabel();
            if (!string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "NbPlatform[" + this.getID() + ":" + this.getDestDir() + "]";
    }

    static {
        $assertionsDisabled = !NbPlatform.class.desiredAssertionStatus();
    }
}

