/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;

public class JarWithModuleAttributes
extends Jar {
    private static final Pattern COMMA_SPACE = Pattern.compile(", *");
    private static final Pattern IMPL_DEP = Pattern.compile(" *([a-zA-Z0-9_.]+)(/[0-9]+)? *= *(.+) *");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManifest(File manifestFile) throws BuildException {
        Manifest added = new Manifest();
        try {
            String ownCnb;
            String implVers;
            Manifest staticManifest;
            String moduleDeps;
            String ideDeps;
            String pubPkgs = this.getProject().getProperty("public.packages");
            if (pubPkgs == null) {
                throw new BuildException("Must have defined 'public.packages'", this.getLocation());
            }
            added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Public-Packages", pubPkgs));
            String friends = this.getProject().getProperty("friends");
            if (friends != null) {
                added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Friends", friends));
            }
            String javahelpClassPathExtension = this.getProject().getProperty("javahelp.class.path.extension");
            String classPathExtensions = this.getProject().getProperty("class.path.extensions");
            String cp = javahelpClassPathExtension != null ? (classPathExtensions != null ? classPathExtensions + " " + javahelpClassPathExtension : javahelpClassPathExtension) : (classPathExtensions != null ? classPathExtensions : null);
            if (cp != null) {
                added.addConfiguredAttribute(new Manifest.Attribute("Class-Path", cp));
            }
            if ((ideDeps = this.getProject().getProperty("ide.dependencies")) != null) {
                added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-IDE-Dependencies", ideDeps));
            }
            if ((moduleDeps = this.getProject().getProperty("module.dependencies")) != null) {
                added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Module-Dependencies", moduleDeps));
            }
            FileInputStream is = new FileInputStream(manifestFile);
            try {
                String cnbDots;
                staticManifest = new Manifest((Reader)new InputStreamReader((InputStream)is, "UTF-8"));
                Manifest.Section mainSection = staticManifest.getMainSection();
                implVers = mainSection.getAttributeValue("OpenIDE-Module-Implementation-Version");
                String myself = mainSection.getAttributeValue("OpenIDE-Module");
                int slash = myself.indexOf(47);
                ownCnb = slash == -1 ? myself : myself.substring(0, slash);
                String cnbs = this.getProject().getProperty("code.name.base.slashes");
                String string = cnbDots = cnbs != null ? cnbs.replace('/', '.') : null;
                if (!ownCnb.equals(cnbDots)) {
                    throw new BuildException("Mismatch in module code name base: manifest says " + ownCnb + " but project.xml says " + cnbDots, this.getLocation());
                }
            }
            finally {
                ((InputStream)is).close();
            }
            String buildNumber = this.getProject().getProperty("buildnumber");
            if (buildNumber == null) {
                throw new BuildException("Must have defined 'buildnumber'", this.getLocation());
            }
            String attrToAdd = implVers != null ? "OpenIDE-Module-Build-Version" : "OpenIDE-Module-Implementation-Version";
            added.addConfiguredAttribute(new Manifest.Attribute(attrToAdd, buildNumber));
            String specVersBase = this.getProject().getProperty("spec.version.base");
            if (specVersBase != null) {
                boolean edited = false;
                if (implVers != null) {
                    try {
                        Integer implVersI = new Integer(implVers);
                        specVersBase = specVersBase + "." + implVersI;
                        edited = true;
                    }
                    catch (NumberFormatException e) {
                        this.getProject().log(manifestFile + ": warning: use of spec.version.base with non-integer OpenIDE-Module-Implementation-Version", 1);
                    }
                }
                TreeMap<String, Integer> additions = new TreeMap<String, Integer>();
                String[] deps = new String[]{ideDeps, moduleDeps};
                for (int i = 0; i < 2; ++i) {
                    String dep = deps[i];
                    if (dep == null) continue;
                    String[] individualDeps = COMMA_SPACE.split(dep);
                    for (int j = 0; j < individualDeps.length; ++j) {
                        Matcher m = IMPL_DEP.matcher(individualDeps[j]);
                        if (!m.matches()) continue;
                        String cnb = m.group(1);
                        String version = m.group(3);
                        try {
                            if (version.length() > 1 && version.charAt(0) == '0') {
                                throw new NumberFormatException(version);
                            }
                            Integer versionI = new Integer(version);
                            additions.put(cnb, versionI);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            this.getProject().log("Warning: in " + ownCnb + ", use of spec.version.base with non-integer OpenIDE-Module-Implementation-Version from " + cnb, 1);
                        }
                    }
                }
                Iterator versions = additions.values().iterator();
                while (versions.hasNext()) {
                    Integer version = (Integer)versions.next();
                    specVersBase = specVersBase + "." + version;
                    edited = true;
                }
                if (!edited) {
                    this.getProject().log("Warning: in " + ownCnb + ", using spec.version.base for no reason; could just use OpenIDE-Module-Specification-Version statically in the manifest", 1);
                }
                if (staticManifest.getMainSection().getAttributeValue("OpenIDE-Module-Specification-Version") != null) {
                    this.getProject().log("Warning: in " + ownCnb + ", attempting to use spec.version.base while some OpenIDE-Module-Specification-Version is statically defined in manifest.mf; this cannot work", 1);
                } else {
                    added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Specification-Version", specVersBase));
                }
            } else if (ideDeps != null && ideDeps.indexOf(61) != -1 || moduleDeps != null && moduleDeps.indexOf(61) != -1) {
                this.getProject().log("Warning: in " + ownCnb + ", not using spec.version.base, yet declaring implementation dependencies; may lead to problems with Auto Update", 1);
            } else if (implVers != null) {
                try {
                    new Integer(implVers);
                }
                catch (NumberFormatException e) {
                    this.getProject().log(manifestFile + ": warning: use of non-integer OpenIDE-Module-Implementation-Version may be problematic for clients trying to use spec.version.base", 1);
                }
            }
            added.merge(staticManifest);
            if (!"lib".equals(this.getProject().getProperty("module.jar.dir"))) {
                String newRequires;
                String key = "OpenIDE-Module-Requires";
                String token = "org.openide.modules.ModuleFormat1";
                String requires = staticManifest.getMainSection().getAttributeValue(key);
                if (requires != null) {
                    added.getMainSection().removeAttribute(key);
                    newRequires = requires + ", " + token;
                } else {
                    newRequires = token;
                }
                added.addConfiguredAttribute(new Manifest.Attribute(key, newRequires));
            }
            this.addConfiguredManifest(added);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }
}

