/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

final class ModuleListParser {
    private static final int DEPTH_NB_ALL = 3;
    private static Map SOURCE_SCAN_CACHE;
    private static Map SUITE_SCAN_CACHE;
    private static Map STANDALONE_SCAN_CACHE;
    private static Map BINARY_SCAN_CACHE;
    private static final String[] EXCLUDED_DIR_NAMES;
    private static final String[] MODULE_DIRS;
    private final Map entries;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Map scanNetBeansOrgSources(File root, Hashtable properties, Project project) throws IOException {
        HashMap entries = (HashMap)SOURCE_SCAN_CACHE.get(root);
        if (entries == null) {
            if (project != null) {
                project.log("Scanning for modules in " + root);
            }
            entries = new HashMap();
            ModuleListParser.doScanNetBeansOrgSources(entries, root, 3, properties, null, project);
            if (project != null) {
                project.log("Found modules: " + entries.keySet(), 3);
            }
            SOURCE_SCAN_CACHE.put(root, entries);
        }
        return entries;
    }

    private static void doScanNetBeansOrgSources(Map entries, File dir, int depth, Hashtable properties, String pathPrefix, Project project) throws IOException {
        if (depth == 0) {
            return;
        }
        File[] kids = dir.listFiles();
        if (kids == null) {
            return;
        }
        block0: for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isDirectory()) continue;
            String name = kids[i].getName();
            for (int j = 0; j < EXCLUDED_DIR_NAMES.length; ++j) {
                if (name.equals(EXCLUDED_DIR_NAMES[j])) continue block0;
            }
            String newPathPrefix = pathPrefix != null ? pathPrefix + "/" + name : name;
            ModuleListParser.scanPossibleProject(kids[i], entries, properties, newPathPrefix, 0, project);
            ModuleListParser.doScanNetBeansOrgSources(entries, kids[i], depth - 1, properties, newPathPrefix, project);
        }
    }

    private static boolean scanPossibleProject(File dir, Map entries, Hashtable properties, String path, int moduleType, Project project) throws IOException {
        Document doc;
        File nbproject = new File(dir, "nbproject");
        File projectxml = new File(nbproject, "project.xml");
        if (!projectxml.isFile()) {
            return false;
        }
        try {
            doc = XMLUtil.parse(new InputSource(projectxml.toURI().toString()), false, true, null, null);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error parsing project file\n" + projectxml + ": " + e.getMessage()).initCause(e);
        }
        Element typeEl = XMLUtil.findElement(doc.getDocumentElement(), "type", "http://www.netbeans.org/ns/project/1");
        if (!XMLUtil.findText(typeEl).equals("org.netbeans.modules.apisupport.project")) {
            return false;
        }
        Element configEl = XMLUtil.findElement(doc.getDocumentElement(), "configuration", "http://www.netbeans.org/ns/project/1");
        Element dataEl = XMLUtil.findElement(configEl, "data", "http://www.netbeans.org/ns/nb-module-project/2");
        if (dataEl == null) {
            if (project != null) {
                project.log(projectxml.toString() + ": warning: module claims to be a NBM project but is missing <data xmlns=\"" + "http://www.netbeans.org/ns/nb-module-project/2" + "\">; maybe an old NB 4.[01] project?", 1);
            }
            return false;
        }
        Element cnbEl = XMLUtil.findElement(dataEl, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2");
        String cnb = XMLUtil.findText(cnbEl);
        Project fakeproj = new Project();
        if (project != null) {
            Iterator it = project.getBuildListeners().iterator();
            while (it.hasNext()) {
                fakeproj.addBuildListener((BuildListener)it.next());
            }
        }
        fakeproj.setBaseDir(dir);
        Property faketask = new Property();
        faketask.setProject(fakeproj);
        switch (moduleType) {
            case 0: {
                break;
            }
            case 1: {
                faketask.setFile(new File(nbproject, "private/suite-private.properties"));
                faketask.execute();
                faketask.setFile(new File(nbproject, "suite.properties"));
                faketask.execute();
                faketask.setFile(new File(fakeproj.replaceProperties("${suite.dir}/nbproject/private/platform-private.properties")));
                faketask.execute();
                faketask.setFile(new File(fakeproj.replaceProperties("${suite.dir}/nbproject/platform.properties")));
                faketask.execute();
                break;
            }
            case 2: {
                faketask.setFile(new File(nbproject, "private/platform-private.properties"));
                faketask.execute();
                faketask.setFile(new File(nbproject, "platform.properties"));
                faketask.execute();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(moduleType);
                }
                break;
            }
        }
        faketask.setFile(new File(nbproject, "private/private.properties".replace('/', File.separatorChar)));
        faketask.execute();
        faketask.setFile(new File(nbproject, "project.properties"));
        faketask.execute();
        faketask.setFile(null);
        faketask.setName("module.jar.dir");
        faketask.setValue("modules");
        faketask.execute();
        if (!$assertionsDisabled && fakeproj.getProperty("module.jar.dir") == null) {
            throw new AssertionError(fakeproj.getProperties());
        }
        faketask.setName("module.jar.basename");
        faketask.setValue(cnb.replace('.', '-') + ".jar");
        faketask.execute();
        faketask.setName("module.jar");
        faketask.setValue(fakeproj.replaceProperties("${module.jar.dir}/${module.jar.basename}"));
        faketask.execute();
        switch (moduleType) {
            case 0: {
                if (!$assertionsDisabled && path == null) {
                    throw new AssertionError();
                }
                Iterator it = properties.entrySet().iterator();
                while (it.hasNext()) {
                    String key;
                    String clusterDir;
                    Map.Entry entry = it.next();
                    String val = (String)entry.getValue();
                    String[] modules = val.split(", *");
                    if (!Arrays.asList(modules).contains(path) || (clusterDir = (String)properties.get((key = (String)entry.getKey()) + ".dir")) == null) continue;
                    faketask.setName("cluster.dir");
                    faketask.setValue(clusterDir);
                    faketask.execute();
                    break;
                }
                faketask.setName("cluster.dir");
                faketask.setValue("extra");
                faketask.execute();
                faketask.setName("netbeans.dest.dir");
                faketask.setValue((String)properties.get("netbeans.dest.dir"));
                faketask.execute();
                faketask.setName("cluster");
                faketask.setValue(fakeproj.replaceProperties("${netbeans.dest.dir}/${cluster.dir}"));
                faketask.execute();
                break;
            }
            case 1: {
                if (!$assertionsDisabled && path != null) {
                    throw new AssertionError();
                }
                faketask.setName("suite.dir");
                faketask.setValue((String)properties.get("suite.dir"));
                faketask.execute();
                faketask.setName("cluster");
                faketask.setValue(fakeproj.replaceProperties("${suite.dir}/build/cluster"));
                faketask.execute();
                break;
            }
            case 2: {
                if (!$assertionsDisabled && path != null) {
                    throw new AssertionError();
                }
                faketask.setName("cluster");
                faketask.setValue(fakeproj.replaceProperties("${basedir}/build/cluster"));
                faketask.execute();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(moduleType);
                }
                break;
            }
        }
        File jar = fakeproj.resolveFile(fakeproj.replaceProperties("${cluster}/${module.jar}"));
        ArrayList<File> exts = new ArrayList<File>();
        Iterator extEls = XMLUtil.findSubElements(dataEl).iterator();
        while (extEls.hasNext()) {
            Element ext = (Element)extEls.next();
            if (!ext.getLocalName().equals("class-path-extension")) continue;
            Element binaryOrigin = XMLUtil.findElement(ext, "binary-origin", "http://www.netbeans.org/ns/nb-module-project/2");
            File origBin = null;
            if (binaryOrigin != null) {
                String reltext = XMLUtil.findText(binaryOrigin);
                String nball = (String)properties.get("nb_all");
                if (nball != null) {
                    faketask.setName("nb_all");
                    faketask.setValue(nball);
                    faketask.execute();
                }
                fakeproj.setBaseDir(dir);
                origBin = fakeproj.resolveFile(fakeproj.replaceProperties(reltext));
            }
            File resultBin = null;
            if (origBin == null || !origBin.exists()) {
                Element runtimeRelativePath = XMLUtil.findElement(ext, "runtime-relative-path", "http://www.netbeans.org/ns/nb-module-project/2");
                if (runtimeRelativePath == null) {
                    throw new IOException("Have malformed <class-path-extension> in " + projectxml);
                }
                String reltext = XMLUtil.findText(runtimeRelativePath);
                resultBin = new File(jar.getParentFile(), reltext.replace('/', File.separatorChar));
            }
            if (origBin != null) {
                exts.add(origBin);
            }
            if (resultBin == null) continue;
            exts.add(resultBin);
        }
        ArrayList<String> prereqs = new ArrayList<String>();
        Element depsEl = XMLUtil.findElement(dataEl, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/2");
        if (depsEl == null) {
            throw new IOException("Malformed project file " + projectxml);
        }
        Iterator deps = XMLUtil.findSubElements(depsEl).iterator();
        while (deps.hasNext()) {
            Element dep = (Element)deps.next();
            if (XMLUtil.findElement(dep, "build-prerequisite", "http://www.netbeans.org/ns/nb-module-project/2") == null) continue;
            Element cnbEl2 = XMLUtil.findElement(dep, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2");
            if (cnbEl2 == null) {
                throw new IOException("Malformed project file " + projectxml);
            }
            String cnb2 = XMLUtil.findText(cnbEl2);
            prereqs.add(cnb2);
        }
        Entry entry = new Entry(cnb, jar, exts.toArray(new File[exts.size()]), dir, path, prereqs.toArray(new String[prereqs.size()]));
        if (entries.containsKey(cnb)) {
            throw new IOException("Duplicated module " + cnb + ": found in " + entries.get(cnb) + " and " + entry);
        }
        entries.put(cnb, entry);
        return true;
    }

    private static Map scanBinaries(Hashtable properties, Project project) throws IOException {
        String buildS = (String)properties.get("netbeans.dest.dir");
        File basedir = new File((String)properties.get("basedir"));
        if (buildS == null) {
            throw new IOException("No definition of netbeans.dest.dir in " + basedir);
        }
        File build = FileUtils.newFileUtils().normalize(FileUtils.newFileUtils().resolveFile(basedir, buildS).getAbsolutePath());
        if (!build.isDirectory()) {
            throw new IOException("No such netbeans.dest.dir: " + build);
        }
        HashMap entries = (HashMap)BINARY_SCAN_CACHE.get(build);
        if (entries == null) {
            if (project != null) {
                project.log("Scanning for modules in " + build);
            }
            entries = new HashMap();
            ModuleListParser.doScanBinaries(build, entries);
            if (project != null) {
                project.log("Found modules: " + entries.keySet());
            }
            BINARY_SCAN_CACHE.put(build, entries);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doScanBinaries(File build, Map entries) throws IOException {
        File[] clusters = build.listFiles();
        if (clusters == null) {
            throw new IOException("Cannot examine dir " + build);
        }
        for (int i = 0; i < clusters.length; ++i) {
            for (int j = 0; j < MODULE_DIRS.length; ++j) {
                File dir = new File(clusters[i], MODULE_DIRS[j].replace('/', File.separatorChar));
                if (!dir.isDirectory()) continue;
                File[] jars = dir.listFiles();
                if (jars == null) {
                    throw new IOException("Cannot examine dir " + dir);
                }
                for (int k = 0; k < jars.length; ++k) {
                    File m = jars[k];
                    if (!m.getName().endsWith(".jar")) continue;
                    JarFile jf = new JarFile(m);
                    try {
                        File[] exts;
                        Attributes attr = jf.getManifest().getMainAttributes();
                        String codename = attr.getValue("OpenIDE-Module");
                        if (codename == null) continue;
                        int slash = codename.lastIndexOf(47);
                        String codenamebase = slash == -1 ? codename : codename.substring(0, slash);
                        String cp = attr.getValue("Class-Path");
                        if (cp == null) {
                            exts = new File[]{};
                        } else {
                            String[] pieces = cp.split(" +");
                            exts = new File[pieces.length];
                            for (int l = 0; l < pieces.length; ++l) {
                                exts[l] = new File(dir, pieces[l].replace('/', File.separatorChar));
                            }
                        }
                        Entry entry = new Entry(codenamebase, m, exts, dir, null, null);
                        if (entries.containsKey(codenamebase)) {
                            throw new IOException("Duplicated module " + codenamebase + ": found in " + entries.get(codenamebase) + " and " + entry);
                        }
                        entries.put(codenamebase, entry);
                        continue;
                    }
                    finally {
                        jf.close();
                    }
                }
            }
        }
    }

    private static Map scanSuiteSources(Hashtable properties, Project project) throws IOException {
        File basedir = new File((String)properties.get("basedir"));
        String suiteDir = (String)properties.get("suite.dir");
        if (suiteDir == null) {
            throw new IOException("No definition of suite.dir in " + basedir);
        }
        File suite = FileUtils.newFileUtils().resolveFile(basedir, suiteDir);
        if (!suite.isDirectory()) {
            throw new IOException("No such suite " + suite);
        }
        HashMap entries = (HashMap)SUITE_SCAN_CACHE.get(suite);
        if (entries == null) {
            if (project != null) {
                project.log("Scanning for modules in suite " + suite);
            }
            entries = new HashMap();
            ModuleListParser.doScanSuite(entries, suite, properties, project);
            if (project != null) {
                project.log("Found modules: " + entries.keySet(), 3);
            }
            SUITE_SCAN_CACHE.put(suite, entries);
        }
        return entries;
    }

    private static void doScanSuite(Map entries, File suite, Hashtable properties, Project project) throws IOException {
        Project fakeproj = new Project();
        fakeproj.setBaseDir(suite);
        Property faketask = new Property();
        faketask.setProject(fakeproj);
        faketask.setFile(new File(suite, "nbproject/private/private.properties".replace('/', File.separatorChar)));
        faketask.execute();
        faketask.setFile(new File(suite, "nbproject/project.properties".replace('/', File.separatorChar)));
        faketask.execute();
        String modulesS = fakeproj.getProperty("modules");
        if (modulesS == null) {
            throw new IOException("No definition of modules in " + suite);
        }
        String[] modules = Path.translatePath((Project)fakeproj, (String)modulesS);
        for (int i = 0; i < modules.length; ++i) {
            File module = new File(modules[i]);
            if (!module.isDirectory()) {
                throw new IOException("No such module " + module + " referred to from " + suite);
            }
            if (ModuleListParser.scanPossibleProject(module, entries, properties, null, 1, project)) continue;
            throw new IOException("No valid module found in " + module + " referred to from " + suite);
        }
    }

    private static Entry scanStandaloneSource(Hashtable properties, Project project) throws IOException {
        File basedir = new File((String)properties.get("project"));
        Entry entry = (Entry)STANDALONE_SCAN_CACHE.get(basedir);
        if (entry == null) {
            HashMap entries = new HashMap();
            if (!ModuleListParser.scanPossibleProject(basedir, entries, properties, null, 2, project)) {
                throw new IOException("No valid module found in " + basedir);
            }
            if (!$assertionsDisabled && entries.size() != 1) {
                throw new AssertionError();
            }
            entry = (Entry)entries.values().iterator().next();
            STANDALONE_SCAN_CACHE.put(basedir, entry);
        }
        return entry;
    }

    public ModuleListParser(Hashtable properties, int type, Project project) throws IOException {
        String nball = (String)properties.get("nb_all");
        if (type != 0) {
            File basedir = new File((String)properties.get("basedir"));
            if (nball != null) {
                throw new IOException("You must *not* declare <suite-component/> or <standalone/> for a netbeans.org module in " + basedir + "; fix project.xml to use the /2 schema");
            }
            this.entries = ModuleListParser.scanBinaries(properties, project);
            if (type == 1) {
                this.entries.putAll(ModuleListParser.scanSuiteSources(properties, project));
            } else {
                if (!$assertionsDisabled && type != 2) {
                    throw new AssertionError();
                }
                Entry e = ModuleListParser.scanStandaloneSource(properties, project);
                this.entries.put(e.getCnb(), e);
            }
        } else {
            if (nball == null) {
                throw new IOException("You must declare either <suite-component/> or <standalone/> for an external module in " + new File((String)properties.get("basedir")));
            }
            if (properties.get("scan.binaries") != null || properties.get("xtest.home") != null && properties.get("xtest.testtype") != null) {
                this.entries = ModuleListParser.scanBinaries(properties, project);
                Entry e = ModuleListParser.scanStandaloneSource(properties, project);
                this.entries.put(e.getCnb(), e);
            } else {
                this.entries = ModuleListParser.scanNetBeansOrgSources(new File(nball), properties, project);
            }
        }
    }

    public Set findAll() {
        return new HashSet(this.entries.values());
    }

    public Entry findByCodeNameBase(String cnb) {
        return (Entry)this.entries.get(cnb);
    }

    static {
        $assertionsDisabled = !ModuleListParser.class.desiredAssertionStatus();
        SOURCE_SCAN_CACHE = new HashMap();
        SUITE_SCAN_CACHE = new HashMap();
        STANDALONE_SCAN_CACHE = new HashMap();
        BINARY_SCAN_CACHE = new HashMap();
        EXCLUDED_DIR_NAMES = new String[]{"CVS", "nbproject", "www", "test", "build", "src", "org"};
        MODULE_DIRS = new String[]{"modules", "modules/eager", "modules/autoload", "lib", "core"};
    }

    public static final class Entry {
        private final String cnb;
        private final File jar;
        private final File[] classPathExtensions;
        private final File sourceLocation;
        private final String netbeansOrgPath;
        private final String[] buildPrerequisites;

        Entry(String cnb, File jar, File[] classPathExtensions, File sourceLocation, String netbeansOrgPath, String[] buildPrerequisites) {
            this.cnb = cnb;
            this.jar = jar;
            this.classPathExtensions = classPathExtensions;
            this.sourceLocation = sourceLocation;
            this.netbeansOrgPath = netbeansOrgPath;
            this.buildPrerequisites = buildPrerequisites;
        }

        public String getCnb() {
            return this.cnb;
        }

        public File getJar() {
            return this.jar;
        }

        public File[] getClassPathExtensions() {
            return this.classPathExtensions;
        }

        public String getNetbeansOrgPath() {
            return this.netbeansOrgPath;
        }

        public String[] getBuildPrerequisites() {
            return this.buildPrerequisites;
        }

        public String toString() {
            return (this.sourceLocation != null ? this.sourceLocation : this.jar).getAbsolutePath();
        }
    }
}

