/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.ModuleListParser;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ParseProjectXml
extends Task {
    static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    static final String NBM_NS = "http://www.netbeans.org/ns/nb-module-project/2";
    static final int TYPE_NB_ORG = 0;
    static final int TYPE_SUITE = 1;
    static final int TYPE_STANDALONE = 2;
    private File project;
    private File projectFile;
    private String publicPackagesProperty;
    private String friendsProperty;
    private String javadocPackagesProperty;
    private String ideDependenciesProperty;
    private String moduleDependenciesProperty;
    private String codeNameBaseDashesProperty;
    private String codeNameBaseSlashesProperty;
    private String domainProperty;
    private String moduleClassPathProperty;
    private String classPathExtensionsProperty;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setProject(File f) {
        this.project = f;
    }

    public void setProjectFile(File f) {
        this.projectFile = f;
    }

    private File getProjectFile() {
        if (this.projectFile != null) {
            return this.projectFile;
        }
        return new File(new File(this.project, "nbproject"), "project.xml");
    }

    public void setPublicPackagesProperty(String s) {
        this.publicPackagesProperty = s;
    }

    public void setFriendsProperty(String s) {
        this.friendsProperty = s;
    }

    public void setJavadocPackagesProperty(String s) {
        this.javadocPackagesProperty = s;
    }

    public void setIdeDependenciesProperty(String s) {
        this.ideDependenciesProperty = s;
    }

    public void setModuleDependenciesProperty(String s) {
        this.moduleDependenciesProperty = s;
    }

    public void setCodeNameBaseDashesProperty(String s) {
        this.codeNameBaseDashesProperty = s;
    }

    public void setCodeNameBaseSlashesProperty(String s) {
        this.codeNameBaseSlashesProperty = s;
    }

    public void setDomainProperty(String s) {
        this.domainProperty = s;
    }

    public void setModuleClassPathProperty(String s) {
        this.moduleClassPathProperty = s;
    }

    public void setClassPathExtensionsProperty(String s) {
        this.classPathExtensionsProperty = s;
    }

    private void define(String prop, String val) {
        this.log("Setting " + prop + "=" + val, 3);
        String old = this.getProject().getProperty(prop);
        if (old != null && !old.equals(val)) {
            this.getProject().log("Warning: " + prop + " was already set to " + old, 1);
        }
        this.getProject().setNewProperty(prop, val);
    }

    public void execute() throws BuildException {
        try {
            String cp;
            String cnb;
            Object nball;
            String[] friends;
            String val;
            Document pDoc;
            block38: {
                if (this.getProjectFile() == null) {
                    throw new BuildException("You must set 'project' or 'projectfile'", this.getLocation());
                }
                pDoc = XMLUtil.parse(new InputSource(this.getProjectFile().toURI().toString()), false, true, null, null);
                if (this.publicPackagesProperty != null || this.javadocPackagesProperty != null) {
                    PublicPackage[] pkgs = this.getPublicPackages(pDoc);
                    if (this.publicPackagesProperty != null) {
                        if (pkgs.length > 0) {
                            String sep = "";
                            StringBuffer b = new StringBuffer();
                            for (int i = 0; i < pkgs.length; ++i) {
                                b.append(sep);
                                String name = pkgs[i].name;
                                if (name.indexOf(44) >= 0) {
                                    throw new BuildException("Package name cannot contain ',' as " + pkgs[i], this.getLocation());
                                }
                                if (name.indexOf(42) >= 0) {
                                    throw new BuildException("Package name cannot contain '*' as " + pkgs[i], this.getLocation());
                                }
                                b.append(name);
                                if (pkgs[i].subpackages) {
                                    b.append(".**");
                                } else {
                                    b.append(".*");
                                }
                                sep = ", ";
                            }
                            val = b.toString();
                        } else {
                            val = "-";
                        }
                        this.define(this.publicPackagesProperty, val);
                    }
                    if (this.javadocPackagesProperty != null && pkgs.length > 0) {
                        String sep = ", ";
                        StringBuffer b = new StringBuffer();
                        for (int i = 0; i < pkgs.length; ++i) {
                            b.append(sep);
                            if (pkgs[i].subpackages) {
                                if (this.getProject().getProperty(this.javadocPackagesProperty) == null) {
                                    String msg = this.javadocPackagesProperty + " cannot be set as <subpackages> does not work for Javadoc (see <subpackages>" + pkgs[i].name + "</subpackages> tag in " + this.getProjectFile() + "). Set the property in project.properties if you want to build Javadoc.";
                                    this.getProject().log("Warning: " + msg, 1);
                                }
                                break block38;
                            }
                            b.append(pkgs[i].name);
                            sep = ", ";
                        }
                        this.define(this.javadocPackagesProperty, b.toString());
                    }
                }
            }
            if (this.friendsProperty != null && (friends = this.getFriends(pDoc)) != null) {
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < friends.length; ++i) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append(friends[i]);
                }
                this.define(this.friendsProperty, b.toString());
            }
            ModuleListParser modules = null;
            if (this.moduleDependenciesProperty != null || this.moduleClassPathProperty != null) {
                nball = this.getProject().getProperty("nb_all");
                Hashtable properties = this.getProject().getProperties();
                properties.put("project", this.project.getAbsolutePath());
                modules = new ModuleListParser(properties, this.getModuleType(pDoc), this.getProject());
            }
            if (this.ideDependenciesProperty != null || this.moduleDependenciesProperty != null) {
                Dep[] deps = this.getDeps(pDoc);
                if (this.ideDependenciesProperty != null) {
                    Dep ide = null;
                    for (int i = 0; i < deps.length; ++i) {
                        if (!deps[i].codenamebase.equals("IDE")) continue;
                        ide = deps[i];
                        break;
                    }
                    if (ide != null) {
                        this.define(this.ideDependenciesProperty, ide.toString(modules));
                    }
                }
                if (this.moduleDependenciesProperty != null) {
                    StringBuffer b = new StringBuffer();
                    for (int i = 0; i < deps.length; ++i) {
                        if (deps[i].codenamebase.equals("IDE")) continue;
                        if (b.length() > 0) {
                            b.append(", ");
                        }
                        b.append(deps[i].toString(modules));
                    }
                    if (b.length() > 0) {
                        this.define(this.moduleDependenciesProperty, b.toString());
                    }
                }
            }
            if (this.codeNameBaseDashesProperty != null) {
                cnb = this.getCodeNameBase(pDoc);
                this.define(this.codeNameBaseDashesProperty, cnb.replace('.', '-'));
            }
            if (this.codeNameBaseSlashesProperty != null) {
                cnb = this.getCodeNameBase(pDoc);
                this.define(this.codeNameBaseSlashesProperty, cnb.replace('.', '/'));
            }
            if (this.moduleClassPathProperty != null && (cp = this.computeClasspath(pDoc, modules)) != null) {
                this.define(this.moduleClassPathProperty, cp);
            }
            if (this.domainProperty != null) {
                File basedir;
                if (this.getModuleType(pDoc) != 0) {
                    throw new BuildException("Cannot set " + this.domainProperty + " for a non-netbeans.org module", this.getLocation());
                }
                nball = new File(this.getProject().getProperty("nb_all"));
                File dir = basedir = this.getProject().getBaseDir();
                while (true) {
                    File parent;
                    if ((parent = dir.getParentFile()) == null) {
                        throw new BuildException("Could not find " + basedir + " inside " + nball + " for purposes of defining " + this.domainProperty);
                    }
                    if (parent.equals(nball)) {
                        this.define(this.domainProperty, dir.getName());
                        break;
                    }
                    dir = parent;
                }
            }
            if (this.classPathExtensionsProperty != null && (val = this.computeClassPathExtensions(pDoc)) != null) {
                this.define(this.classPathExtensionsProperty, val);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private Element getConfig(Document pDoc) throws BuildException {
        Element e = pDoc.getDocumentElement();
        Element c = XMLUtil.findElement(e, "configuration", PROJECT_NS);
        if (c == null) {
            throw new BuildException("No <configuration>", this.getLocation());
        }
        Element d = XMLUtil.findElement(c, "data", NBM_NS);
        if (d == null) {
            throw new BuildException("No <data>", this.getLocation());
        }
        return d;
    }

    private PublicPackage[] getPublicPackages(Document d) throws BuildException {
        Element cfg = this.getConfig(d);
        Element pp = XMLUtil.findElement(cfg, "public-packages", NBM_NS);
        if (pp == null) {
            pp = XMLUtil.findElement(cfg, "friend-packages", NBM_NS);
        }
        if (pp == null) {
            throw new BuildException("No <public-packages>", this.getLocation());
        }
        List l = XMLUtil.findSubElements(pp);
        ArrayList<PublicPackage> pkgs = new ArrayList<PublicPackage>();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            String t;
            Element p = (Element)it.next();
            boolean sub = false;
            if ("friend".equals(p.getNodeName())) continue;
            if (!"package".equals(p.getNodeName())) {
                if (!"subpackages".equals(p.getNodeName())) {
                    throw new BuildException("Strange element name, should be package or subpackages: " + p.getNodeName(), this.getLocation());
                }
                sub = true;
            }
            if ((t = XMLUtil.findText(p)) == null) {
                throw new BuildException("No text in <package>", this.getLocation());
            }
            pkgs.add(new PublicPackage(t, sub));
        }
        return pkgs.toArray(new PublicPackage[pkgs.size()]);
    }

    private String[] getFriends(Document d) throws BuildException {
        Element cfg = this.getConfig(d);
        Element pp = XMLUtil.findElement(cfg, "friend-packages", NBM_NS);
        if (pp == null) {
            return null;
        }
        ArrayList<String> friends = new ArrayList<String>();
        List l = XMLUtil.findSubElements(pp);
        Iterator it = l.iterator();
        boolean other = false;
        while (it.hasNext()) {
            Element p = (Element)it.next();
            if ("friend".equals(p.getNodeName())) {
                String t = XMLUtil.findText(p);
                if (t == null) {
                    throw new BuildException("No text in <friend>", this.getLocation());
                }
                friends.add(t);
                continue;
            }
            other = true;
        }
        if (friends.isEmpty()) {
            throw new BuildException("Must have at least one <friend> in <friend-packages>", this.getLocation());
        }
        if (!other) {
            throw new BuildException("Must have at least one <package> in <friend-packages>", this.getLocation());
        }
        return friends.toArray(new String[friends.size()]);
    }

    private Dep[] getDeps(Document pDoc) throws BuildException {
        Element cfg = this.getConfig(pDoc);
        Element md = XMLUtil.findElement(cfg, "module-dependencies", NBM_NS);
        if (md == null) {
            throw new BuildException("No <module-dependencies>", this.getLocation());
        }
        List l = XMLUtil.findSubElements(md);
        ArrayList<Dep> deps = new ArrayList<Dep>();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Element iv;
            Element sv;
            Element dep = (Element)it.next();
            Dep d = new Dep();
            Element cnb = XMLUtil.findElement(dep, "code-name-base", NBM_NS);
            if (cnb == null) {
                throw new BuildException("No <code-name-base>", this.getLocation());
            }
            String t = XMLUtil.findText(cnb);
            if (t == null) {
                throw new BuildException("No text in <code-name-base>", this.getLocation());
            }
            if (t.equals("org.openide")) {
                t = "IDE";
            }
            d.codenamebase = t;
            Element rd = XMLUtil.findElement(dep, "run-dependency", NBM_NS);
            if (rd == null) continue;
            Element rv = XMLUtil.findElement(rd, "release-version", NBM_NS);
            if (rv != null) {
                t = XMLUtil.findText(rv);
                if (t == null) {
                    throw new BuildException("No text in <release-version>", this.getLocation());
                }
                d.release = t;
            }
            if ((sv = XMLUtil.findElement(rd, "specification-version", NBM_NS)) != null) {
                t = XMLUtil.findText(sv);
                if (t == null) {
                    throw new BuildException("No text in <specification-version>", this.getLocation());
                }
                d.spec = t;
            }
            if ((iv = XMLUtil.findElement(rd, "implementation-version", NBM_NS)) != null) {
                d.impl = true;
            }
            deps.add(d);
        }
        return deps.toArray(new Dep[deps.size()]);
    }

    private String getCodeNameBase(Document d) throws BuildException {
        Element data = this.getConfig(d);
        Element name = XMLUtil.findElement(data, "code-name-base", NBM_NS);
        if (name == null) {
            throw new BuildException("No <code-name-base>", this.getLocation());
        }
        String t = XMLUtil.findText(name);
        if (t == null) {
            throw new BuildException("No text in <code-name-base>", this.getLocation());
        }
        return t;
    }

    private int getModuleType(Document d) throws BuildException {
        Element data = this.getConfig(d);
        if (XMLUtil.findElement(data, "suite-component", NBM_NS) != null) {
            return 1;
        }
        if (XMLUtil.findElement(data, "standalone", NBM_NS) != null) {
            return 2;
        }
        return 0;
    }

    private String computeClasspath(Document pDoc, ModuleListParser modules) throws BuildException, IOException, SAXException {
        Element data = this.getConfig(pDoc);
        Element moduleDependencies = XMLUtil.findElement(data, "module-dependencies", NBM_NS);
        List deps = XMLUtil.findSubElements(moduleDependencies);
        StringBuffer cp = new StringBuffer();
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            Element cnbEl;
            String cnb;
            Element dep = (Element)it.next();
            if (XMLUtil.findElement(dep, "compile-dependency", NBM_NS) == null) continue;
            if (cp.length() > 0) {
                cp.append(':');
            }
            if ("org.openide".equals(cnb = XMLUtil.findText(cnbEl = XMLUtil.findElement(dep, "code-name-base", NBM_NS)))) {
                Project project = this.getProject();
                String string = "Do not depend on org.openide anymore, depend on its libraries. Update " + this.getProjectFile();
                this.getProject();
                project.log(string, 1);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.util").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.util.enumerations").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.filesystems").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.modules").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.awt").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.dialogs").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.loaders").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.nodes").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.explorer").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.actions").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.text").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.windows").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.options").getAbsolutePath());
                cp.append(File.pathSeparatorChar);
                cp.append(this.computeClasspathModuleLocation(modules, "org.openide.compat").getAbsolutePath());
                continue;
            }
            cp.append(this.computeClasspathModuleLocation(modules, cnb).getAbsolutePath());
            ModuleListParser.Entry entry = modules.findByCodeNameBase(cnb);
            if (entry == null) continue;
            File[] exts = entry.getClassPathExtensions();
            for (int i = 0; i < exts.length; ++i) {
                cp.append(':');
                cp.append(exts[i].getAbsolutePath());
            }
        }
        String cnb = this.getCodeNameBase(pDoc);
        ModuleListParser.Entry entry = modules.findByCodeNameBase(cnb);
        if (!$assertionsDisabled && entry == null) {
            throw new AssertionError();
        }
        File[] exts = entry.getClassPathExtensions();
        for (int i = 0; i < exts.length; ++i) {
            cp.append(':');
            cp.append(exts[i].getAbsolutePath());
        }
        return cp.toString();
    }

    private File computeClasspathModuleLocation(ModuleListParser modules, String cnb) throws BuildException {
        ModuleListParser.Entry module = modules.findByCodeNameBase(cnb);
        if (module == null) {
            throw new BuildException("No dependent module " + cnb, this.getLocation());
        }
        return module.getJar();
    }

    private String computeClassPathExtensions(Document pDoc) {
        Element data = this.getConfig(pDoc);
        StringBuffer list = null;
        List exts = XMLUtil.findSubElements(data);
        Iterator it = exts.iterator();
        while (it.hasNext()) {
            Element ext = (Element)it.next();
            if (!ext.getLocalName().equals("class-path-extension")) continue;
            Element runtimeRelativePath = XMLUtil.findElement(ext, "runtime-relative-path", NBM_NS);
            if (runtimeRelativePath == null) {
                throw new BuildException("Have malformed <class-path-extension> in " + this.getProjectFile(), this.getLocation());
            }
            String reltext = XMLUtil.findText(runtimeRelativePath);
            if (list == null) {
                list = new StringBuffer();
            } else {
                list.append(' ');
            }
            list.append(reltext);
        }
        return list != null ? list.toString() : null;
    }

    static {
        $assertionsDisabled = !ParseProjectXml.class.desiredAssertionStatus();
    }

    private final class Dep {
        public String codenamebase;
        public String release = null;
        public String spec = null;
        public boolean impl = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Dep() {
        }

        public String toString(ModuleListParser modules) throws IOException, BuildException {
            StringBuffer b = new StringBuffer(this.codenamebase);
            if (this.release != null) {
                b.append('/');
                b.append(this.release);
            }
            if (this.spec != null) {
                b.append(" > ");
                b.append(this.spec);
                if (!$assertionsDisabled && this.impl) {
                    throw new AssertionError();
                }
            }
            if (this.impl) {
                b.append(" = ");
                String implVers = this.implementationVersionOf(modules, this.codenamebase);
                if (implVers == null) {
                    throw new BuildException("No OpenIDE-Module-Implementation-Version found in " + this.codenamebase);
                }
                b.append(implVers);
            }
            return b.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String implementationVersionOf(ModuleListParser modules, String cnb) throws IOException {
            File jar = ParseProjectXml.this.computeClasspathModuleLocation(modules, cnb);
            if (!jar.isFile()) {
                throw new BuildException("No such classpath entry: " + jar, ParseProjectXml.this.getLocation());
            }
            JarFile jarFile = new JarFile(jar, false);
            try {
                String string = jarFile.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
                return string;
            }
            finally {
                jarFile.close();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$nbbuild$ParseProjectXml == null ? (class$org$netbeans$nbbuild$ParseProjectXml = ParseProjectXml.class$("org.netbeans.nbbuild.ParseProjectXml")) : class$org$netbeans$nbbuild$ParseProjectXml).desiredAssertionStatus();
        }
    }

    private static final class PublicPackage {
        public final String name;
        public boolean subpackages;

        public PublicPackage(String name, boolean subpackages) {
            this.name = name;
            this.subpackages = subpackages;
        }
    }
}

