/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class UpdateTracking {
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAME = "codename";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_VERSION = "specification_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_INSTALL = "install_time";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_FILE_NAME = "name";
    private static final String ATTR_CRC = "crc";
    private static final String NBM_ORIGIN = "nbm";
    private static final String INST_ORIGIN = "installer";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String TRACKING_DIRECTORY = "update_tracking";
    private boolean pError = false;
    private File trackingFile = null;
    private String origin = "nbm";
    private String nbPath = null;
    private Module module = null;
    protected InputStream is = null;
    protected OutputStream os = null;

    public UpdateTracking(String nbPath) {
        this.nbPath = nbPath;
        this.origin = INST_ORIGIN;
    }

    public UpdateTracking() {
        this.nbPath = null;
        this.origin = INST_ORIGIN;
    }

    public Version addNewModuleVersion(String codename, String spec_version) {
        this.module = new Module();
        this.module.setCodename(codename);
        Version version = new Version();
        version.setVersion(spec_version);
        version.setOrigin(this.origin);
        version.setLast(true);
        version.setInstall_time(System.currentTimeMillis());
        this.module.setVersion(version);
        return version;
    }

    public String getVersionFromFile(File utf) throws BuildException {
        this.setTrackingFile(utf.getParentFile(), utf.getName());
        this.read();
        if (this.module.getVersions().size() != 1) {
            throw new BuildException("Module described in update tracking file " + utf.getAbsolutePath() + " has got " + this.module.getVersions().size() + " specification versions. Correct number is 1.");
        }
        return ((Version)this.module.getVersions().get(0)).getVersion();
    }

    public String getCodenameFromFile(File utf) throws BuildException {
        this.setTrackingFile(utf.getParentFile(), utf.getName());
        this.read();
        if (this.module.getVersions().size() != 1) {
            throw new BuildException("Module described in update tracking file " + utf.getAbsolutePath() + " has got " + this.module.getVersions().size() + " specification versions. Correct number is 1.");
        }
        return this.module.getCodename();
    }

    public String getVersionForCodeName(String codeName) throws BuildException {
        this.module = new Module();
        this.module.setCodename(codeName);
        File directory = new File(this.nbPath + FILE_SEPARATOR + TRACKING_DIRECTORY);
        this.setTrackingFile(directory, this.getTrackingFileName());
        if (!this.trackingFile.exists() || !this.trackingFile.isFile()) {
            throw new BuildException("Tracking file " + this.trackingFile.getAbsolutePath() + " cannot be found for module codenamebase " + codeName);
        }
        this.read();
        if (this.module.getVersions().size() != 1) {
            throw new BuildException("Module with codenamebase " + codeName + " has got " + this.module.getVersions().size() + " specification versions. Correct number is 1.");
        }
        return ((Version)this.module.getVersions().get(0)).getVersion();
    }

    public String[] getListOfNBM(String codeName) throws BuildException {
        this.module = new Module();
        this.module.setCodename(codeName);
        if (this.is == null) {
            File directory = new File(this.nbPath + FILE_SEPARATOR + TRACKING_DIRECTORY);
            this.setTrackingFile(directory, this.getTrackingFileName());
            if (!this.trackingFile.exists() || !this.trackingFile.isFile()) {
                throw new BuildException("Tracking file " + this.trackingFile.getAbsolutePath() + " cannot be found for module codenamebase " + codeName);
            }
        }
        this.read();
        if (this.module.getVersions().size() != 1) {
            throw new BuildException("Module with codenamebase " + codeName + " has got " + this.module.getVersions().size() + " specification versions. Correct number is 1.");
        }
        List files = ((Version)this.module.getVersions().get(0)).getFiles();
        String[] listFiles = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            listFiles[i] = ((ModuleFile)files.get(i)).getName().replace(File.separatorChar, '/');
        }
        return listFiles;
    }

    public void removeLocalized(String locale) {
        File updateDirectory = new File(this.nbPath, TRACKING_DIRECTORY);
        File[] trackingFiles = updateDirectory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".xml");
            }
        });
        if (trackingFiles != null) {
            for (int i = trackingFiles.length - 1; i >= 0; --i) {
                this.trackingFile = trackingFiles[i];
                this.read();
                this.module.removeLocalized(locale);
                this.write();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() throws BuildException {
        Document document = XMLUtil.createDocument(ELEMENT_MODULE);
        Element e_module = document.getDocumentElement();
        e_module.setAttribute(ATTR_CODENAME, this.module.getCodename());
        Iterator it2 = this.module.getVersions().iterator();
        while (it2.hasNext()) {
            Version ver = (Version)it2.next();
            Element e_version = document.createElement(ELEMENT_VERSION);
            e_version.setAttribute(ATTR_VERSION, ver.getVersion());
            e_version.setAttribute(ATTR_ORIGIN, ver.getOrigin());
            e_version.setAttribute(ATTR_LAST, "true");
            e_version.setAttribute(ATTR_INSTALL, Long.toString(ver.getInstall_time()));
            e_module.appendChild(e_version);
            Iterator it3 = ver.getFiles().iterator();
            while (it3.hasNext()) {
                ModuleFile file = (ModuleFile)it3.next();
                Element e_file = document.createElement(ELEMENT_FILE);
                e_file.setAttribute(ATTR_FILE_NAME, file.getName().replace(File.separatorChar, '/'));
                e_file.setAttribute(ATTR_CRC, file.getCrc());
                e_version.appendChild(e_file);
            }
        }
        if (this.os == null) {
            File directory = new File(this.nbPath + FILE_SEPARATOR + TRACKING_DIRECTORY);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            this.setTrackingFile(directory, this.getTrackingFileName());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(directory, this.getTrackingFileName()));
            }
            catch (Exception e) {
                throw new BuildException("Could not get outputstream to write update tracking", (Throwable)e);
            }
            this.setTrackingOutputStream(fos);
        }
        try {
            try {
                XMLUtil.write(document, this.os);
            }
            finally {
                this.os.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.trackingFile != null && this.trackingFile.exists()) {
                this.trackingFile.delete();
            }
            throw new BuildException("Could not write update tracking", (Throwable)e);
        }
    }

    protected void setTrackingFile(File dir, String tFname) throws BuildException {
        this.trackingFile = new File(dir, tFname);
        try {
            if (this.trackingFile.exists()) {
                this.setTrackingInputStream(new FileInputStream(this.trackingFile));
            }
        }
        catch (FileNotFoundException fnf) {
            throw new BuildException("Unable to find tracking file " + this.trackingFile.getAbsolutePath(), (Throwable)fnf);
        }
    }

    public void setTrackingOutputStream(OutputStream tos) {
        this.os = tos;
    }

    public OutputStream getTrackingOutputStream() {
        return this.os;
    }

    public void setTrackingInputStream(InputStream tis) {
        this.is = tis;
    }

    public String getTrackingFileName() throws BuildException {
        String trackingFileName = this.module.getCodenamebase();
        if (trackingFileName == null || trackingFileName.length() == 0) {
            throw new BuildException("Empty codenamebase, unable to locate tracking file");
        }
        trackingFileName = trackingFileName.replace('.', '-') + ".xml";
        return trackingFileName;
    }

    private void read() throws BuildException {
        Document document;
        if (this.is == null) {
            File directory = new File(this.nbPath + FILE_SEPARATOR + TRACKING_DIRECTORY);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            this.setTrackingFile(directory, this.getTrackingFileName());
        }
        try {
            InputSource xmlInputSource = new InputSource(this.is);
            document = XMLUtil.parse(xmlInputSource, false, false, new ErrorCatcher(), null);
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            if (this.trackingFile == null) {
                throw new BuildException("Update tracking data in external InputStream is not well formatted XML document.", (Throwable)e);
            }
            throw new BuildException("Update tracking file " + this.trackingFile.getAbsolutePath() + " is not well formatted XML document.", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            if (this.trackingFile == null) {
                throw new BuildException("I/O error while accessing tracking data in InputStream", (Throwable)e);
            }
            throw new BuildException("I/O error while accessing tracking file " + this.trackingFile.getAbsolutePath(), (Throwable)e);
        }
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals(ELEMENT_MODULE)) {
            this.scanElement_module(element);
        }
    }

    void scanElement_module(Element element) {
        this.module = new Module();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals(ATTR_CODENAME)) continue;
            this.module.setCodename(attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_VERSION)) continue;
            this.scanElement_module_version(nodeElement, this.module);
        }
    }

    void scanElement_module_version(Element element, Module module) {
        Version version = new Version();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_VERSION)) {
                version.setVersion(attr.getValue());
            }
            if (attr.getName().equals(ATTR_ORIGIN)) {
                version.setOrigin(attr.getValue());
            }
            if (attr.getName().equals(ATTR_LAST)) {
                version.setLast(Boolean.getBoolean(attr.getValue()));
            }
            if (!attr.getName().equals(ATTR_INSTALL)) continue;
            long li = 0L;
            try {
                li = Long.parseLong(attr.getValue());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            version.setInstall_time(li);
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_FILE)) continue;
            this.scanElement_file(nodeElement, version);
        }
        module.addVersion(version);
    }

    void scanElement_file(Element element, Version version) {
        ModuleFile file = new ModuleFile();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_FILE_NAME)) {
                file.setName(attr.getValue().replace(File.separatorChar, '/'));
            }
            if (!attr.getName().equals(ATTR_CRC)) continue;
            file.setCrc(attr.getValue());
        }
        version.addFile(file);
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            UpdateTracking.this.pError = true;
        }

        public void error(SAXParseException e) {
            UpdateTracking.this.pError = true;
        }

        public void warning(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            UpdateTracking.this.pError = true;
        }
    }

    class ModuleFile {
        private String name;
        private String crc;

        ModuleFile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name.replace(File.separatorChar, '/');
        }

        String getCrc() {
            return this.crc;
        }

        void setCrc(String crc) {
            this.crc = crc;
        }
    }

    public class Version {
        private String version;
        private String origin;
        private boolean last;
        private long install_time = 0L;
        private List files = new ArrayList();

        String getVersion() {
            return this.version;
        }

        void setVersion(String version) {
            this.version = version;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String origin) {
            this.origin = origin;
        }

        boolean isLast() {
            return this.last;
        }

        void setLast(boolean last) {
            this.last = last;
        }

        long getInstall_time() {
            return this.install_time;
        }

        void setInstall_time(long install_time) {
            this.install_time = install_time;
        }

        List getFiles() {
            return this.files;
        }

        void setFiles(List files) {
            this.files = files;
        }

        void addFile(ModuleFile file) {
            this.files.add(file);
        }

        public void addFileWithCrc(String filename, String crc) {
            ModuleFile file = new ModuleFile();
            file.setName(filename);
            file.setCrc(crc);
            this.files.add(file);
        }

        public void removeLocalized(String locale) {
            ArrayList<ModuleFile> newFiles = new ArrayList<ModuleFile>();
            Iterator it = this.files.iterator();
            while (it.hasNext()) {
                ModuleFile file = (ModuleFile)it.next();
                if (file.getName().indexOf("_" + locale + ".") != -1 || file.getName().indexOf("_" + locale + "/") != -1 || file.getName().endsWith("_" + locale)) continue;
                newFiles.add(file);
            }
            this.files = newFiles;
        }
    }

    class Module {
        private String codename;
        private List versions = new ArrayList();

        Module() {
        }

        String getCodenamebase() {
            String codenamebase = new String(this.codename);
            int idx = codenamebase.lastIndexOf(47);
            if (idx != -1) {
                codenamebase = codenamebase.substring(0, idx);
            }
            return codenamebase;
        }

        String getCodename() {
            return this.codename;
        }

        void setCodename(String codename) {
            this.codename = codename;
        }

        List getVersions() {
            return this.versions;
        }

        void setVersions(List versions) {
            this.versions = versions;
        }

        void addVersion(Version version) {
            this.versions = new ArrayList();
            this.versions.add(version);
        }

        void setVersion(Version version) {
            this.versions = new ArrayList();
            this.versions.add(version);
        }

        void removeLocalized(String locale) {
            Iterator it = this.versions.iterator();
            while (it.hasNext()) {
                Version ver = (Version)it.next();
                ver.removeLocalized(locale);
            }
        }
    }
}

