/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.editor.settings.storage.SimpleAttributeSet;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ColoringStorage {
    ColoringStorage() {
    }

    static Map loadColorings(String[] stringArray, String string, String string2, boolean bl) {
        FileObject fileObject;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        String string3 = Utils.getFileName(stringArray, string, null);
        FileObject fileObject2 = fileSystem.findResource(Utils.getFileName(stringArray, string, "Defaults/" + string2));
        FileObject fileObject3 = fileObject = bl ? null : fileSystem.findResource(string3 + "/" + string2);
        if (fileObject == null) {
            fileObject = fileObject2;
        }
        if (fileObject == null) {
            return null;
        }
        List list = (List)XMLStorage.load(fileObject, new ColoringsReader());
        FileObject fileObject4 = fileSystem.findResource(Utils.getFileName(stringArray, "NetBeans", "Defaults/" + string2));
        String string4 = fileObject4 != null ? (String)fileObject4.getAttribute("SystemFileSystem.localizingBundle") : null;
        ResourceBundle resourceBundle = null;
        if (string4 != null) {
            resourceBundle = NbBundle.getBundle((String)string4);
        }
        HashMap<String, SimpleAttributeSet> hashMap = new HashMap<String, SimpleAttributeSet>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5;
            SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)iterator.next();
            String string6 = string5 = (String)simpleAttributeSet.getAttribute(StyleConstants.NameAttribute);
            if (resourceBundle != null) {
                try {
                    string6 = resourceBundle.getString(string5);
                }
                catch (MissingResourceException missingResourceException) {
                    System.out.println("ColoringStorage.not localized: " + fileObject4 + " : " + string4 + " : " + string5);
                }
            }
            simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string6);
            hashMap.put(string5, simpleAttributeSet);
        }
        return hashMap;
    }

    static void deleteColorings(String[] stringArray, String string, String string2) {
        Utils.deleteFileObject(stringArray, string, string2);
    }

    static void saveColorings(String[] stringArray, String string, String string2, Collection collection) {
        FileObject fileObject = Utils.createFileObject(stringArray, string, string2);
        ColoringStorage.saveColorings(fileObject, collection);
    }

    private static void saveColorings(FileObject fileObject, Collection collection) {
        StringBuffer stringBuffer = XMLStorage.generateHeader();
        XMLStorage.generateFolderStart(stringBuffer, "fontscolors", null, "");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            attribs.add("name", (String)attributeSet.getAttribute(StyleConstants.NameAttribute));
            if (attributeSet.isDefined(StyleConstants.Foreground)) {
                attribs.add("foreColor", XMLStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Foreground)));
            }
            if (attributeSet.isDefined(StyleConstants.Background)) {
                attribs.add("bgColor", XMLStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Background)));
            }
            if (attributeSet.isDefined(StyleConstants.StrikeThrough)) {
                attribs.add("strikeThrough", XMLStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.StrikeThrough)));
            }
            if (attributeSet.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                attribs.add("waveUnderlined", XMLStorage.colorToString((Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor)));
            }
            if (attributeSet.isDefined(StyleConstants.Underline)) {
                attribs.add("underline", XMLStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Underline)));
            }
            if (attributeSet.isDefined(EditorStyleConstants.Default)) {
                attribs.add("default", (String)attributeSet.getAttribute(EditorStyleConstants.Default));
            }
            if (attributeSet.isDefined(StyleConstants.FontFamily) || attributeSet.isDefined(StyleConstants.FontSize) || attributeSet.isDefined(StyleConstants.Bold) || attributeSet.isDefined(StyleConstants.Italic)) {
                XMLStorage.generateFolderStart(stringBuffer, "fontcolor", attribs, "    ");
                attribs = new XMLStorage.Attribs(true);
                if (attributeSet.isDefined(StyleConstants.FontFamily)) {
                    attribs.add("name", (String)attributeSet.getAttribute(StyleConstants.FontFamily));
                }
                if (attributeSet.isDefined(StyleConstants.FontSize)) {
                    attribs.add("size", "" + attributeSet.getAttribute(StyleConstants.FontSize));
                }
                if (attributeSet.isDefined(StyleConstants.Bold) || attributeSet.isDefined(StyleConstants.Italic)) {
                    Boolean bl = Boolean.FALSE;
                    Boolean bl2 = Boolean.FALSE;
                    if (attributeSet.isDefined(StyleConstants.Bold)) {
                        bl = (Boolean)attributeSet.getAttribute(StyleConstants.Bold);
                    }
                    if (attributeSet.isDefined(StyleConstants.Italic)) {
                        bl2 = (Boolean)attributeSet.getAttribute(StyleConstants.Italic);
                    }
                    attribs.add("style", bl.booleanValue() ? (bl2.booleanValue() ? "bold+italic" : "bold") : (bl2 != false ? "italic" : "plain"));
                }
                XMLStorage.generateLeaf(stringBuffer, "font", attribs, "        ");
                XMLStorage.generateFolderEnd(stringBuffer, "fontcolor", "    ");
                continue;
            }
            XMLStorage.generateLeaf(stringBuffer, "fontcolor", attribs, "    ");
        }
        XMLStorage.generateFolderEnd(stringBuffer, "fontscolors", "");
        XMLStorage.save(fileObject, new String(stringBuffer));
    }

    private static class ColoringsReader
    extends XMLStorage.Handler {
        private List colorings = new ArrayList();

        private ColoringsReader() {
        }

        Object getResult() {
            return this.colorings;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block14: {
                try {
                    if (string3.equals("fontscolors")) break block14;
                    if (string3.equals("fontcolor")) {
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, attributes.getValue("name"));
                        if (attributes.getValue("bgColor") != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Background, XMLStorage.stringToColor(attributes.getValue("bgColor")));
                        }
                        if (attributes.getValue("foreColor") != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Foreground, XMLStorage.stringToColor(attributes.getValue("foreColor")));
                        }
                        if (attributes.getValue("underline") != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Underline, XMLStorage.stringToColor(attributes.getValue("underline")));
                        }
                        if (attributes.getValue("strikeThrough") != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.StrikeThrough, XMLStorage.stringToColor(attributes.getValue("strikeThrough")));
                        }
                        if (attributes.getValue("waveUnderlined") != null) {
                            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, XMLStorage.stringToColor(attributes.getValue("waveUnderlined")));
                        }
                        if (attributes.getValue("default") != null) {
                            simpleAttributeSet.addAttribute(EditorStyleConstants.Default, attributes.getValue("default"));
                        }
                        this.colorings.add(simpleAttributeSet);
                        break block14;
                    }
                    if (!string3.equals("font")) break block14;
                    SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)this.colorings.get(this.colorings.size() - 1);
                    if (attributes.getValue("name") != null) {
                        simpleAttributeSet.addAttribute(StyleConstants.FontFamily, attributes.getValue("name"));
                    }
                    if (attributes.getValue("size") != null) {
                        try {
                            simpleAttributeSet.addAttribute(StyleConstants.FontSize, Integer.decode(attributes.getValue("size")));
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (attributes.getValue("style") != null) {
                        simpleAttributeSet.addAttribute(StyleConstants.Bold, attributes.getValue("style").indexOf("bold") >= 0);
                        simpleAttributeSet.addAttribute(StyleConstants.Italic, attributes.getValue("style").indexOf("italic") >= 0);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

