/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public class EditorSettingsImpl
extends EditorSettings {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    static final String HIGHLIGHTING_FILE_NAME = "editorColoring.xml";
    static final String KEYBINDING_FILE_NAME = "keybindings.xml";
    static final String ALL_LANGUAGES_FILE_NAME = "defaultColoring.xml";
    static final String CURRENT_FONT_COLOR_PROFILE = "currentFontColorProfile";
    static final String CURRENT_KEYMAP_PROFILE = "currentKeymap";
    static final String KEYMAPS_FOLDER = "Keymaps";
    private Set systemFontColorProfiles;
    private String currentFontColorProfile;
    private Map defaultColors = new HashMap();
    private Map defaultColorDefaults = new HashMap();
    private Map highlightings = new HashMap();
    private Map highlightingDefaults = new HashMap();
    private Set systemKeymapProfiles;
    private String currentKeyMapProfile;
    private Map fontColorProfiles;
    private Map keyMapProfiles;
    private Map mimeToLanguage;
    private Map keyBindingsMap = new HashMap();
    private Map fontColorsMap = new HashMap();

    public Set getMimeTypes() {
        if (this.mimeToLanguage == null) {
            this.init();
        }
        return Collections.unmodifiableSet(this.mimeToLanguage.keySet());
    }

    public String getLanguageName(String string) {
        if (this.mimeToLanguage == null) {
            this.init();
        }
        return (String)this.mimeToLanguage.get(string);
    }

    public Set getFontColorProfiles() {
        if (this.fontColorProfiles == null) {
            this.init();
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.fontColorProfiles.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.startsWith("test")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public boolean isCustomFontColorProfile(String string) {
        if (this.systemFontColorProfiles == null) {
            this.init();
        }
        return !this.systemFontColorProfiles.contains(string);
    }

    public String getCurrentFontColorProfile() {
        if (this.currentFontColorProfile == null) {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("Editors");
            this.currentFontColorProfile = (String)fileObject.getAttribute(CURRENT_FONT_COLOR_PROFILE);
            if (this.currentFontColorProfile == null) {
                this.currentFontColorProfile = "NetBeans";
            }
        }
        if (!this.getFontColorProfiles().contains(this.currentFontColorProfile)) {
            this.currentFontColorProfile = "NetBeans";
        }
        return this.currentFontColorProfile;
    }

    public void setCurrentFontColorProfile(String string) {
        String string2 = this.getCurrentFontColorProfile();
        if (string2.equals(string)) {
            return;
        }
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors");
        try {
            fileObject.setAttribute(CURRENT_FONT_COLOR_PROFILE, (Object)string);
            this.currentFontColorProfile = string;
            this.pcs.firePropertyChange(CURRENT_FONT_COLOR_PROFILE, string2, this.currentFontColorProfile);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public Collection getDefaultFontColors(String string) {
        if (!this.defaultColors.containsKey(string = this.getInternalFontColorProfile(string))) {
            if (string.startsWith("test")) {
                this.defaultColors.put(string, this.getDefaultFontColors("NetBeans"));
            } else {
                Map map = ColoringStorage.loadColorings(new String[0], string, ALL_LANGUAGES_FILE_NAME, false);
                if (map != null) {
                    Collection collection = map.values();
                    this.defaultColors.put(string, collection);
                } else {
                    this.defaultColors.put(string, null);
                }
            }
        }
        if (this.defaultColors.get(string) == null) {
            return null;
        }
        return Collections.unmodifiableCollection((Collection)this.defaultColors.get(string));
    }

    public Collection getDefaultFontColorDefaults(String string) {
        if (!this.defaultColorDefaults.containsKey(string = this.getInternalFontColorProfile(string))) {
            Map map = ColoringStorage.loadColorings(new String[0], string, ALL_LANGUAGES_FILE_NAME, true);
            if (map != null) {
                Collection collection = map.values();
                this.defaultColorDefaults.put(string, collection);
            } else {
                this.defaultColorDefaults.put(string, null);
            }
        }
        if (this.defaultColorDefaults.get(string) == null) {
            return null;
        }
        return Collections.unmodifiableCollection((Collection)this.defaultColorDefaults.get(string));
    }

    public void setDefaultFontColors(String string, Collection collection) {
        String string2 = this.getInternalFontColorProfile(string);
        if (collection == null) {
            ColoringStorage.deleteColorings(new String[0], string2, ALL_LANGUAGES_FILE_NAME);
            this.defaultColors.remove(string2);
            this.init();
            this.pcs.firePropertyChange("defaultFontColors", null, null);
            return;
        }
        if (((Object)collection).equals(this.defaultColors.get(string2))) {
            return;
        }
        this.defaultColors.put(string2, collection);
        if (!string2.startsWith("test")) {
            ColoringStorage.saveColorings(new String[0], string2, ALL_LANGUAGES_FILE_NAME, collection);
            if (this.fontColorProfiles.get(string) == null) {
                this.fontColorProfiles.put(string, string);
            }
        }
        if (string2.startsWith("test")) {
            this.pcs.firePropertyChange(string2, null, null);
        } else {
            this.pcs.firePropertyChange("defaultFontColors", null, null);
        }
    }

    public Map getHighlightings(String string) {
        if (!this.highlightings.containsKey(string = this.getInternalFontColorProfile(string))) {
            if (string.startsWith("test")) {
                this.highlightings.put(string, this.getHighlightings("NetBeans"));
            } else {
                Map map = ColoringStorage.loadColorings(new String[0], string, HIGHLIGHTING_FILE_NAME, false);
                this.highlightings.put(string, map);
            }
        }
        if (this.highlightings.get(string) == null) {
            return null;
        }
        return Collections.unmodifiableMap((Map)this.highlightings.get(string));
    }

    public Map getHighlightingDefaults(String string) {
        if (!this.highlightingDefaults.containsKey(string = this.getInternalFontColorProfile(string))) {
            Map map = ColoringStorage.loadColorings(new String[0], string, HIGHLIGHTING_FILE_NAME, true);
            this.highlightingDefaults.put(string, map);
        }
        if (this.highlightingDefaults.get(string) == null) {
            return null;
        }
        return Collections.unmodifiableMap((Map)this.highlightingDefaults.get(string));
    }

    public void setHighlightings(String string, Map map) {
        String string2 = this.getInternalFontColorProfile(string);
        if (map == null) {
            ColoringStorage.deleteColorings(new String[0], string2, HIGHLIGHTING_FILE_NAME);
            this.highlightings.remove(string2);
            this.init();
            this.pcs.firePropertyChange("editorFontColors", null, null);
            return;
        }
        if (((Object)map).equals(this.highlightings.get(string2))) {
            return;
        }
        this.highlightings.put(string2, map);
        if (!string2.startsWith("test")) {
            ColoringStorage.saveColorings(new String[0], string2, HIGHLIGHTING_FILE_NAME, map.values());
            if (this.fontColorProfiles.get(string) == null) {
                this.fontColorProfiles.put(string, string);
            }
        }
        if (string2.startsWith("test")) {
            this.pcs.firePropertyChange(string2, null, null);
        } else {
            this.pcs.firePropertyChange("editorFontColors", null, null);
        }
    }

    public Set getKeyMapProfiles() {
        if (this.keyMapProfiles == null) {
            this.init();
        }
        return Collections.unmodifiableSet(this.keyMapProfiles.keySet());
    }

    public boolean isCustomKeymapProfile(String string) {
        if (this.systemKeymapProfiles == null) {
            this.init();
        }
        return !this.systemKeymapProfiles.contains(string);
    }

    public String getCurrentKeyMapProfile() {
        if (this.currentKeyMapProfile == null) {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(KEYMAPS_FOLDER);
            this.currentKeyMapProfile = (String)fileObject.getAttribute(CURRENT_KEYMAP_PROFILE);
            if (this.currentKeyMapProfile == null) {
                this.currentKeyMapProfile = "NetBeans";
            }
        }
        return this.currentKeyMapProfile;
    }

    public void setCurrentKeyMapProfile(String string) {
        String string2 = this.getCurrentKeyMapProfile();
        if (string2.equals(string)) {
            return;
        }
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(KEYMAPS_FOLDER);
            if (fileObject == null) {
                fileObject = fileSystem.getRoot().createFolder(KEYMAPS_FOLDER);
            }
            fileObject.setAttribute(CURRENT_KEYMAP_PROFILE, (Object)string);
            this.currentKeyMapProfile = string;
            this.pcs.firePropertyChange("currentKeyMapProfile", string2, this.currentKeyMapProfile);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private void init() {
        this.fontColorProfiles = new HashMap();
        this.keyMapProfiles = new HashMap();
        this.keyMapProfiles.put("NetBeans", "NetBeans");
        this.mimeToLanguage = new HashMap();
        this.systemFontColorProfiles = new HashSet();
        this.systemKeymapProfiles = new HashSet();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors");
        Enumeration enumeration = fileObject.getFolders(false);
        while (enumeration.hasMoreElements()) {
            this.init1((FileObject)enumeration.nextElement());
        }
    }

    private void init1(FileObject fileObject) {
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            this.init2((FileObject)enumeration.nextElement());
        }
    }

    private void init2(FileObject fileObject) {
        if (fileObject.getNameExt().equals("Defaults") && fileObject.isFolder() && fileObject.getFileObject(HIGHLIGHTING_FILE_NAME) != null) {
            this.addFontColorsProfile(fileObject, true);
        } else if (fileObject.getNameExt().equals(HIGHLIGHTING_FILE_NAME)) {
            this.addFontColorsProfile(fileObject, false);
        } else if (fileObject.getFileObject("NetBeans/Defaults/coloring.xml") != null) {
            this.addMimeType(fileObject);
        } else if (fileObject.getPath().endsWith("text/base") && fileObject.isFolder()) {
            if (fileObject.getFileObject("Defaults/keybindings.xml") != null) {
                this.addKeyMapProfile(fileObject, true);
            } else if (fileObject.getFileObject(KEYBINDING_FILE_NAME) != null) {
                this.addKeyMapProfile(fileObject, false);
            }
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                this.init3((FileObject)enumeration.nextElement());
            }
        }
    }

    private void init3(FileObject fileObject) {
        if (fileObject.getFileObject("Defaults/keybindings.xml") != null) {
            this.addKeyMapProfile(fileObject, true);
        } else if (fileObject.getFileObject(KEYBINDING_FILE_NAME) != null) {
            this.addKeyMapProfile(fileObject, false);
        }
    }

    private void addMimeType(FileObject fileObject) {
        String string = fileObject.getPath();
        string = string.substring(8);
        String string2 = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
        String string3 = string;
        if (string2 != null) {
            try {
                string3 = NbBundle.getBundle((String)string2).getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.mimeToLanguage.put(string, string3);
    }

    private void addFontColorsProfile(FileObject fileObject, boolean bl) {
        String string = fileObject.getParent().getNameExt();
        String string2 = (String)fileObject.getParent().getAttribute("SystemFileSystem.localizingBundle");
        String string3 = string;
        if (string2 != null) {
            try {
                string3 = NbBundle.getBundle((String)string2).getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (bl) {
            this.systemFontColorProfiles.add(string3);
        }
        this.fontColorProfiles.put(string3, string);
    }

    private void addKeyMapProfile(FileObject fileObject, boolean bl) {
        String string = fileObject.getNameExt();
        if (string.equals("base")) {
            string = "NetBeans";
        }
        String string2 = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
        String string3 = string;
        if (string2 != null) {
            try {
                string3 = NbBundle.getBundle((String)string2).getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (bl) {
            this.systemKeymapProfiles.add(string3);
        }
        this.keyMapProfiles.put(string3, string);
    }

    String getInternalFontColorProfile(String string) {
        String string2;
        if (this.fontColorProfiles == null) {
            this.init();
        }
        if ((string2 = (String)this.fontColorProfiles.get(string)) != null) {
            return string2;
        }
        return string;
    }

    String getInternalKeymapProfile(String string) {
        String string2;
        if (this.keyMapProfiles == null) {
            this.init();
        }
        if ((string2 = (String)this.keyMapProfiles.get(string)) != null) {
            return string2;
        }
        this.keyMapProfiles.put(string, string);
        return string;
    }

    public KeyBindingSettingsFactory getKeyBindingSettings(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        WeakReference weakReference = (WeakReference)this.keyBindingsMap.get(list);
        KeyBindingSettingsImpl keyBindingSettingsImpl = null;
        if (weakReference != null) {
            keyBindingSettingsImpl = (KeyBindingSettingsImpl)weakReference.get();
        }
        if (keyBindingSettingsImpl == null) {
            keyBindingSettingsImpl = new KeyBindingSettingsImpl(stringArray);
            this.keyBindingsMap.put(list, new WeakReference<KeyBindingSettingsImpl>(keyBindingSettingsImpl));
        }
        return keyBindingSettingsImpl;
    }

    public FontColorSettingsFactory getFontColorSettings(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        WeakReference weakReference = (WeakReference)this.fontColorsMap.get(list);
        FontColorSettingsFactory fontColorSettingsFactory = null;
        if (weakReference != null) {
            fontColorSettingsFactory = (FontColorSettingsFactory)weakReference.get();
        }
        if (fontColorSettingsFactory == null) {
            fontColorSettingsFactory = new FontColorSettingsImpl(stringArray);
            this.fontColorsMap.put(list, new WeakReference<FontColorSettingsFactory>(fontColorSettingsFactory));
        }
        return fontColorSettingsFactory;
    }
}

