/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.MimeLookupInitializerImpl;
import org.netbeans.modules.editor.settings.storage.SimpleAttributeSet;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.openide.ErrorManager;

public class FontColorSettingsImpl
extends FontColorSettingsFactory
implements MimeLookupInitializerImpl.Factory {
    private String[] mimeTypes;
    private String mimeType;
    private PropertyChangeSupport pcs;
    private String test;
    private ErrorManager logger;
    private static final String DEFAULT = "default";
    private EditorSettingsImpl editorSettingsImpl;
    private Map colorings = new HashMap();
    private Map defaults = new HashMap();
    private static Font defaultSystemFont;

    FontColorSettingsImpl(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].startsWith("test")) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            int n = stringArray[0].indexOf(95);
            this.test = stringArray2[0].substring(0, n);
            stringArray2[0] = stringArray2[0].substring(n + 1);
            this.mimeTypes = stringArray2;
        } else {
            this.mimeTypes = stringArray;
        }
        this.mimeType = this.getMimeType();
        this.logger = ErrorManager.getDefault().getInstance(FontColorSettingsImpl.class.getName() + '.' + (this.test == null ? this.mimeType : this.test + "_" + this.mimeType));
        this.pcs = new PropertyChangeSupport(this);
        new Listener(this);
    }

    public AttributeSet getFontColors(String string) {
        if (string.equals(DEFAULT)) {
            return this.getTokenFontColors(string);
        }
        String string2 = this.test != null ? this.test : this.getEditorColoringImpl().getCurrentFontColorProfile();
        AttributeSet attributeSet = (AttributeSet)this.getEditorColoringImpl().getHighlightings(string2).get(string);
        if (attributeSet == null) {
            this.logger.log("highlighting2 " + string + " : null");
            return null;
        }
        SimpleAttributeSet simpleAttributeSet = this.resolveDefaults(attributeSet, string2);
        this.logger.log("highlighting3 " + string + " : " + simpleAttributeSet);
        return simpleAttributeSet;
    }

    public AttributeSet getTokenFontColors(String string) {
        String string2 = null;
        String string3 = null;
        if (this.test != null) {
            string3 = string2 = this.test;
        } else {
            string2 = this.getEditorColoringImpl().getCurrentFontColorProfile();
            string3 = this.getEditorColoringImpl().getInternalFontColorProfile(string2);
        }
        Map map = this.getColorings(string3);
        if (map == null) {
            this.logger.log("syntax1 " + string + " : null");
            return null;
        }
        AttributeSet attributeSet = (AttributeSet)map.get(string);
        if (attributeSet == null) {
            if (string.equals(DEFAULT)) {
                attributeSet = new SimpleAttributeSet();
                ((SimpleAttributeSet)attributeSet).addAttribute(EditorStyleConstants.Default, DEFAULT);
            } else {
                this.logger.log("syntax2 " + string + " : null");
                return null;
            }
        }
        SimpleAttributeSet simpleAttributeSet = this.resolveDefaults(attributeSet, string2);
        if (string.equals(DEFAULT)) {
            if (simpleAttributeSet.getAttribute(StyleConstants.Foreground) == null) {
                simpleAttributeSet.addAttribute(StyleConstants.Foreground, Color.black);
            }
            if (simpleAttributeSet.getAttribute(StyleConstants.Background) == null) {
                simpleAttributeSet.addAttribute(StyleConstants.Background, Color.white);
            }
            if (simpleAttributeSet.getAttribute(StyleConstants.FontFamily) == null) {
                simpleAttributeSet.addAttribute(StyleConstants.FontFamily, FontColorSettingsImpl.getDefaultSystemFont().getName());
            }
            if (simpleAttributeSet.getAttribute(StyleConstants.FontSize) == null) {
                simpleAttributeSet.addAttribute(StyleConstants.FontSize, new Integer(FontColorSettingsImpl.getDefaultSystemFont().getSize()));
            }
            this.logger.log("syntax3 " + string + " : " + simpleAttributeSet);
            return simpleAttributeSet;
        }
        if (!simpleAttributeSet.isDefined(StyleConstants.FontFamily) && (simpleAttributeSet.isDefined(StyleConstants.FontSize) || simpleAttributeSet.isDefined(StyleConstants.Bold) || simpleAttributeSet.isDefined(StyleConstants.Italic))) {
            AttributeSet attributeSet2 = this.getTokenFontColors(DEFAULT);
            simpleAttributeSet.addAttribute(StyleConstants.FontFamily, attributeSet2.getAttribute(StyleConstants.FontFamily));
            if (!simpleAttributeSet.isDefined(StyleConstants.FontSize)) {
                simpleAttributeSet.addAttribute(StyleConstants.FontSize, attributeSet2.getAttribute(StyleConstants.FontSize));
            }
        }
        this.logger.log("syntax4 " + string + " : " + simpleAttributeSet);
        return simpleAttributeSet;
    }

    public Collection getAllFontColors(String string) {
        string = this.test != null ? this.test : this.getEditorColoringImpl().getInternalFontColorProfile(string);
        Map map = this.getColorings(string);
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(map.values());
    }

    public Collection getAllFontColorDefaults(String string) {
        string = this.test != null ? this.test : this.getEditorColoringImpl().getInternalFontColorProfile(string);
        Map map = this.getDefaults(string);
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(map.values());
    }

    public void setAllFontColors(String string, Collection collection) {
        Map map;
        this.logger.log("set " + string);
        String string2 = string = this.test != null ? this.test : this.getEditorColoringImpl().getInternalFontColorProfile(string);
        if (collection == null) {
            ColoringStorage.deleteColorings(this.mimeTypes, string, "coloring.xml");
            this.colorings.remove(string);
            this.pcs.firePropertyChange("fontColors", null, null);
            return;
        }
        if (this.test == null) {
            ColoringStorage.saveColorings(this.mimeTypes, string, "coloring.xml", collection);
        }
        if ((map = this.getColorings(string)) == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            String string3 = (String)attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (!bl && !attributeSet.equals(map.get(string3))) {
                bl = true;
            }
            map.put(string3, attributeSet);
            this.logger.log("set " + string3 + " : " + attributeSet);
        }
        if (bl) {
            this.pcs.firePropertyChange("fontColors", null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private EditorSettingsImpl getEditorColoringImpl() {
        if (this.editorSettingsImpl == null) {
            this.editorSettingsImpl = (EditorSettingsImpl)EditorSettings.getDefault();
        }
        return this.editorSettingsImpl;
    }

    private Map getColorings(String string) {
        if (!this.colorings.containsKey(string)) {
            Map map = ColoringStorage.loadColorings(this.mimeTypes, this.test != null ? "NetBeans" : string, "coloring.xml", false);
            if (map == null) {
                map = ColoringStorage.loadColorings(this.mimeTypes, "NetBeans", "coloring.xml", false);
            }
            this.colorings.put(string, map);
        }
        return (Map)this.colorings.get(string);
    }

    private Map getDefaults(String string) {
        if (!this.defaults.containsKey(string)) {
            Map map = ColoringStorage.loadColorings(this.mimeTypes, string, "coloring.xml", true);
            this.defaults.put(string, map);
        }
        return (Map)this.defaults.get(string);
    }

    private String getMimeType() {
        int n = this.mimeTypes.length;
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return this.mimeTypes[0];
        }
        StringBuffer stringBuffer = new StringBuffer(this.mimeTypes[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append('+').append(this.mimeTypes[i]);
        }
        return stringBuffer.toString();
    }

    private SimpleAttributeSet resolveDefaults(AttributeSet attributeSet, String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Background, string);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Foreground, string);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Underline, string);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.StrikeThrough, string);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, EditorStyleConstants.WaveUnderlineColor, string);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Bold, string);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Italic, string);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.FontFamily, string);
        this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.FontSize, string);
        return simpleAttributeSet;
    }

    private void resolveDefaults(SimpleAttributeSet simpleAttributeSet, AttributeSet attributeSet, Object object, String string) {
        Object object2;
        Object object3;
        Object object4 = attributeSet.getAttribute(object);
        if (object4 != null) {
            simpleAttributeSet.addAttribute(object, object4);
            return;
        }
        String string2 = (String)attributeSet.getAttribute(EditorStyleConstants.Default);
        if (string2 == null) {
            return;
        }
        if (!string2.equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) {
            object3 = this.getAllFontColors(string).iterator();
            while (object3.hasNext()) {
                object2 = (AttributeSet)object3.next();
                if (!string2.equals(object2.getAttribute(StyleConstants.NameAttribute))) continue;
                this.resolveDefaults(simpleAttributeSet, (AttributeSet)object2, object, string);
            }
        }
        if ((object3 = this.getEditorColoringImpl().getDefaultFontColors(this.test == null ? string : this.test)) == null) {
            return;
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            AttributeSet attributeSet2 = (AttributeSet)object2.next();
            if (!string2.equals(attributeSet2.getAttribute(StyleConstants.NameAttribute))) continue;
            this.resolveDefaults(simpleAttributeSet, attributeSet2, object, string);
        }
    }

    private static Font getDefaultSystemFont() {
        if (defaultSystemFont == null) {
            int n;
            Integer n2 = (Integer)UIManager.get("customFontSize");
            int n3 = n = n2 != null ? n2.intValue() : UIManager.getFont("TextField.font").getSize();
            if (n < 12) {
                n = 12;
            }
            defaultSystemFont = new Font("Monospaced", 0, n);
        }
        return defaultSystemFont;
    }

    public Object createInstance() {
        ArrayList arrayList;
        ArrayList arrayList2;
        String string = this.test != null ? this.test : this.getEditorColoringImpl().getCurrentFontColorProfile();
        String string2 = null;
        string2 = this.test != null ? (string = this.test) : this.getEditorColoringImpl().getInternalFontColorProfile(string);
        Map map = this.getEditorColoringImpl().getHighlightings(string);
        map = map != null ? new HashMap(map) : Collections.EMPTY_MAP;
        HashMap hashMap = this.getColorings(string2);
        if (hashMap != null) {
            hashMap = new HashMap(hashMap);
        }
        if ((arrayList2 = this.getEditorColoringImpl().getDefaultFontColors(string)) != null) {
            arrayList2 = new ArrayList(arrayList2);
        }
        if ((arrayList = this.getAllFontColors(string)) != null) {
            arrayList = new ArrayList(arrayList);
        }
        return new Immutable(this.logger, this.test, string, map, hashMap, arrayList2, arrayList);
    }

    private static final class Immutable
    extends FontColorSettings {
        private final ErrorManager logger;
        private final String test;
        private final String profile;
        private final Map highlightings;
        private final Map colorings;
        private final Collection defFC;
        private final Collection allFC;

        public Immutable(ErrorManager errorManager, String string, String string2, Map map, Map map2, Collection collection, Collection collection2) {
            this.logger = errorManager;
            this.test = string;
            this.profile = string2;
            this.highlightings = map;
            this.colorings = map2;
            this.defFC = collection;
            this.allFC = collection2;
        }

        public AttributeSet getFontColors(String string) {
            if (string.equals(FontColorSettingsImpl.DEFAULT)) {
                return this.getTokenFontColors(string);
            }
            AttributeSet attributeSet = (AttributeSet)this.highlightings.get(string);
            if (attributeSet == null) {
                this.logger.log("highlighting2 " + string + " : null");
                return null;
            }
            SimpleAttributeSet simpleAttributeSet = this.resolveDefaults(attributeSet, this.profile);
            this.logger.log("highlighting3 " + string + " : " + simpleAttributeSet);
            return simpleAttributeSet;
        }

        public AttributeSet getTokenFontColors(String string) {
            Map map = this.colorings;
            if (map == null) {
                this.logger.log("syntax1 " + string + " : null");
                return null;
            }
            AttributeSet attributeSet = (AttributeSet)map.get(string);
            if (attributeSet == null) {
                if (string.equals(FontColorSettingsImpl.DEFAULT)) {
                    attributeSet = new SimpleAttributeSet();
                    ((SimpleAttributeSet)attributeSet).addAttribute(EditorStyleConstants.Default, FontColorSettingsImpl.DEFAULT);
                } else {
                    this.logger.log("syntax2 " + string + " : null");
                    return null;
                }
            }
            SimpleAttributeSet simpleAttributeSet = this.resolveDefaults(attributeSet, this.profile);
            if (string.equals(FontColorSettingsImpl.DEFAULT)) {
                if (simpleAttributeSet.getAttribute(StyleConstants.Foreground) == null) {
                    simpleAttributeSet.addAttribute(StyleConstants.Foreground, Color.black);
                }
                if (simpleAttributeSet.getAttribute(StyleConstants.Background) == null) {
                    simpleAttributeSet.addAttribute(StyleConstants.Background, Color.white);
                }
                if (simpleAttributeSet.getAttribute(StyleConstants.FontFamily) == null) {
                    simpleAttributeSet.addAttribute(StyleConstants.FontFamily, FontColorSettingsImpl.getDefaultSystemFont().getName());
                }
                if (simpleAttributeSet.getAttribute(StyleConstants.FontSize) == null) {
                    simpleAttributeSet.addAttribute(StyleConstants.FontSize, new Integer(FontColorSettingsImpl.getDefaultSystemFont().getSize()));
                }
                this.logger.log("syntax3 " + string + " : " + simpleAttributeSet);
                return simpleAttributeSet;
            }
            if (!simpleAttributeSet.isDefined(StyleConstants.FontFamily) && (simpleAttributeSet.isDefined(StyleConstants.FontSize) || simpleAttributeSet.isDefined(StyleConstants.Bold) || simpleAttributeSet.isDefined(StyleConstants.Italic))) {
                AttributeSet attributeSet2 = this.getTokenFontColors(FontColorSettingsImpl.DEFAULT);
                simpleAttributeSet.addAttribute(StyleConstants.FontFamily, attributeSet2.getAttribute(StyleConstants.FontFamily));
                if (!simpleAttributeSet.isDefined(StyleConstants.FontSize)) {
                    simpleAttributeSet.addAttribute(StyleConstants.FontSize, attributeSet2.getAttribute(StyleConstants.FontSize));
                }
            }
            this.logger.log("syntax4 " + string + " : " + simpleAttributeSet);
            return simpleAttributeSet;
        }

        private SimpleAttributeSet resolveDefaults(AttributeSet attributeSet, String string) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Background, string);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Foreground, string);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Underline, string);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.StrikeThrough, string);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, EditorStyleConstants.WaveUnderlineColor, string);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Bold, string);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.Italic, string);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.FontFamily, string);
            this.resolveDefaults(simpleAttributeSet, simpleAttributeSet, StyleConstants.FontSize, string);
            return simpleAttributeSet;
        }

        private void resolveDefaults(SimpleAttributeSet simpleAttributeSet, AttributeSet attributeSet, Object object, String string) {
            Object object2;
            Object object3;
            Object object4 = attributeSet.getAttribute(object);
            if (object4 != null) {
                simpleAttributeSet.addAttribute(object, object4);
                return;
            }
            String string2 = (String)attributeSet.getAttribute(EditorStyleConstants.Default);
            if (string2 == null) {
                return;
            }
            if (!string2.equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) {
                object3 = this.allFC.iterator();
                while (object3.hasNext()) {
                    object2 = (AttributeSet)object3.next();
                    if (!string2.equals(object2.getAttribute(StyleConstants.NameAttribute))) continue;
                    this.resolveDefaults(simpleAttributeSet, (AttributeSet)object2, object, string);
                }
            }
            if ((object3 = this.defFC) == null) {
                return;
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                AttributeSet attributeSet2 = (AttributeSet)object2.next();
                if (!string2.equals(attributeSet2.getAttribute(StyleConstants.NameAttribute))) continue;
                this.resolveDefaults(simpleAttributeSet, attributeSet2, object, string);
            }
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference fontColorSettings;
        private EditorSettingsImpl editorSettings;
        private String test;

        Listener(FontColorSettingsImpl fontColorSettingsImpl) {
            this.fontColorSettings = new WeakReference<FontColorSettingsImpl>(fontColorSettingsImpl);
            this.editorSettings = fontColorSettingsImpl.getEditorColoringImpl();
            this.editorSettings.addPropertyChangeListener("currentFontColorProfile", this);
            this.test = fontColorSettingsImpl.test;
            if (this.test != null) {
                this.editorSettings.addPropertyChangeListener(this.test, this);
            } else {
                this.editorSettings.addPropertyChangeListener("defaultFontColors", this);
                this.editorSettings.addPropertyChangeListener("editorFontColors", this);
            }
        }

        private FontColorSettingsImpl getFontColorSettings() {
            FontColorSettingsImpl fontColorSettingsImpl = (FontColorSettingsImpl)this.fontColorSettings.get();
            if (fontColorSettingsImpl != null) {
                return fontColorSettingsImpl;
            }
            this.editorSettings.removePropertyChangeListener("currentFontColorProfile", this);
            if (this.test != null) {
                this.editorSettings.removePropertyChangeListener(this.test, this);
            } else {
                this.editorSettings.removePropertyChangeListener("defaultFontColors", this);
                this.editorSettings.removePropertyChangeListener("editorFontColors", this);
            }
            return null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FontColorSettingsImpl fontColorSettingsImpl = this.getFontColorSettings();
            fontColorSettingsImpl.pcs.firePropertyChange("fontColors", null, null);
        }
    }
}

