/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyMapsStorage;
import org.netbeans.modules.editor.settings.storage.MimeLookupInitializerImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;

public class KeyBindingSettingsImpl
extends KeyBindingSettingsFactory
implements MimeLookupInitializerImpl.Factory {
    private String[] mimeTypes;
    private PropertyChangeSupport pcs;
    private Map keyMaps = new HashMap();
    private KeyBindingSettingsFactory baseKBS;
    private Listener listener;
    private boolean init = false;
    private EditorSettingsImpl editorSettingsImpl;
    private Map defaults = new HashMap();
    private boolean isLoggable = false;
    private String logActionName = null;

    KeyBindingSettingsImpl(String[] stringArray) {
        this.mimeTypes = stringArray;
        this.pcs = new PropertyChangeSupport(this);
        String string = KeyBindingSettingsImpl.class.getName();
        if (System.getProperty(string) != null) {
            this.isLoggable = true;
            if (!"true".equals(System.getProperty(string))) {
                this.logActionName = System.getProperty(string);
            }
            return;
        }
        if (stringArray.length != 1) {
            return;
        }
        String string2 = System.getProperty(string + '.' + stringArray[0]);
        if (string2 == null) {
            return;
        }
        this.isLoggable = true;
        this.logActionName = string2;
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (this.mimeTypes.length != 1 || !this.mimeTypes[0].equals("text/base")) {
            this.baseKBS = this.getEditorSettingsImpl().getKeyBindingSettings(new String[]{"text/base"});
        }
        this.listener = new Listener(this, this.mimeTypes, this.baseKBS, this.getEditorSettingsImpl());
    }

    public List getKeyBindings() {
        List list = this.getKeyBindings(this.getEditorSettingsImpl().getCurrentKeyMapProfile());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeyBindings(String string) {
        Object object;
        this.init();
        String string2 = this.getEditorSettingsImpl().getInternalKeymapProfile(string);
        if (string2 == null) {
            string2 = string;
        }
        ArrayList arrayList = new ArrayList();
        if (!this.keyMaps.containsKey(string)) {
            object = this;
            synchronized (object) {
                HashMap hashMap = new HashMap(this.getDefaults(string));
                Object[] objectArray = KeyMapsStorage.loadKeyMaps(this.mimeTypes, string, "keybindings.xml");
                Map map = (Map)objectArray[0];
                Set set = (Set)objectArray[1];
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    hashMap.remove(iterator.next());
                }
                hashMap.putAll(map);
                ArrayList arrayList2 = new ArrayList(hashMap.values());
                this.keyMaps.put(string, arrayList2);
                arrayList.addAll(arrayList2);
            }
        } else {
            arrayList.addAll((List)this.keyMaps.get(string));
        }
        this.log("getKeyBindings", arrayList);
        if (this.baseKBS != null) {
            object = this.baseKBS.getKeyBindings(string);
            this.log("", Collections.EMPTY_LIST);
            arrayList.addAll(object);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getKeyBindingDefaults(String string) {
        return Collections.unmodifiableList(new ArrayList(this.getDefaults(string).values()));
    }

    public synchronized void setKeyBindings(String string, List list) {
        Object object;
        this.log("setKeyBindings", list);
        this.init();
        if (list == null) {
            this.keyMaps.remove(string);
            KeyMapsStorage.deleteProfile(this.mimeTypes, string, "keybindings.xml");
            return;
        }
        this.keyMaps.put(string, list);
        HashMap<List, Object> hashMap = new HashMap<List, Object>();
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (MultiKeyBinding)iterator.next();
            hashMap.put(object.getKeyStrokeList(), object);
        }
        object = this.getDefaults(string);
        HashSet<List> hashSet = new HashSet<List>();
        iterator = object.keySet().iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)object.get(list2);
            if (!hashMap.containsKey(list2)) {
                hashSet.add(list2);
                continue;
            }
            MultiKeyBinding multiKeyBinding2 = (MultiKeyBinding)hashMap.get(list2);
            if (!multiKeyBinding2.getActionName().equals(multiKeyBinding.getActionName())) continue;
            hashMap.remove(list2);
        }
        this.log("  changed:", hashMap.values());
        this.log("  removed:", hashSet);
        this.log("", Collections.EMPTY_LIST);
        this.listener.removeListeners();
        KeyMapsStorage.saveKeyMaps(this.mimeTypes, string, "keybindings.xml", hashMap.values(), hashSet);
        this.listener.addListeners();
        this.pcs.firePropertyChange(null, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private EditorSettingsImpl getEditorSettingsImpl() {
        if (this.editorSettingsImpl == null) {
            this.editorSettingsImpl = (EditorSettingsImpl)EditorSettings.getDefault();
        }
        return this.editorSettingsImpl;
    }

    private Map getDefaults(String string) {
        if (!this.defaults.containsKey(string)) {
            FileObject fileObject = Utils.getFileObject(this.mimeTypes, "NetBeans".equals(string) ? null : string, "Defaults/keybindings.xml");
            if (fileObject != null) {
                this.defaults.put(string, (Map)KeyMapsStorage.loadKeyMaps(fileObject)[0]);
            } else {
                this.defaults.put(string, Collections.EMPTY_MAP);
            }
        }
        return (Map)this.defaults.get(string);
    }

    private void refresh() {
        this.keyMaps = new HashMap();
        this.log("refresh", Collections.EMPTY_SET);
        this.pcs.firePropertyChange(null, null, null);
    }

    private void log(String string, Collection collection) {
        if (!this.isLoggable) {
            return;
        }
        if (!string.equals("")) {
            if (this.mimeTypes.length == 1) {
                string = string + " " + this.mimeTypes[0];
            }
            string = string + " " + this.getEditorSettingsImpl().getCurrentKeyMapProfile();
        }
        if (collection == null) {
            System.out.println(string + " : null");
            return;
        }
        System.out.println(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.logActionName == null || !(e instanceof MultiKeyBinding)) {
                System.out.println("  " + e);
                continue;
            }
            if (!(e instanceof MultiKeyBinding) || !this.logActionName.equals(((MultiKeyBinding)e).getActionName())) continue;
            System.out.println("  " + e);
        }
    }

    public Object createInstance() {
        List list = this.getKeyBindings();
        return new Immutable(new ArrayList(list));
    }

    private static final class Immutable
    extends KeyBindingSettings {
        private List keyBindings;

        public Immutable(List list) {
            this.keyBindings = list;
        }

        public List getKeyBindings() {
            return Collections.unmodifiableList(this.keyBindings);
        }
    }

    private static class Listener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private WeakReference wr;
        private FileObject fo;
        private String[] mimeTypes;
        private KeyBindingSettingsFactory baseKBS;
        private EditorSettings editorSettings;

        Listener(KeyBindingSettingsImpl keyBindingSettingsImpl, String[] stringArray, KeyBindingSettingsFactory keyBindingSettingsFactory, EditorSettings editorSettings) {
            this.mimeTypes = stringArray;
            this.editorSettings = editorSettings;
            this.baseKBS = keyBindingSettingsFactory;
            this.addListeners();
            this.wr = new WeakReference<KeyBindingSettingsImpl>(keyBindingSettingsImpl);
        }

        private KeyBindingSettingsImpl getSettings() {
            KeyBindingSettingsImpl keyBindingSettingsImpl = (KeyBindingSettingsImpl)this.wr.get();
            if (keyBindingSettingsImpl != null) {
                return keyBindingSettingsImpl;
            }
            this.removeListeners();
            return null;
        }

        private void addListeners() {
            this.editorSettings.addPropertyChangeListener("currentKeyMapProfile", this);
            if (this.baseKBS != null) {
                this.baseKBS.addPropertyChangeListener(this);
            }
            this.setFolderListener();
        }

        private void removeListeners() {
            this.fo.removeFileChangeListener((FileChangeListener)this);
            if (this.baseKBS != null) {
                this.baseKBS.removePropertyChangeListener(this);
            }
            this.editorSettings.removePropertyChangeListener("currentKeyMapProfile", this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            KeyBindingSettingsImpl keyBindingSettingsImpl = this.getSettings();
            if (keyBindingSettingsImpl == null) {
                return;
            }
            if ("currentKeyMapProfile".equals(propertyChangeEvent.getPropertyName())) {
                this.setFolderListener();
            }
            keyBindingSettingsImpl.log("refresh2", Collections.EMPTY_SET);
            keyBindingSettingsImpl.pcs.firePropertyChange(null, null, null);
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            KeyBindingSettingsImpl keyBindingSettingsImpl = this.getSettings();
            if (keyBindingSettingsImpl == null) {
                return;
            }
            if (fileEvent.getFile().getNameExt().equals("keybindings.xml")) {
                keyBindingSettingsImpl.refresh();
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            KeyBindingSettingsImpl keyBindingSettingsImpl = this.getSettings();
            if (keyBindingSettingsImpl == null) {
                return;
            }
            if (fileEvent.getFile().getNameExt().equals("keybindings.xml")) {
                keyBindingSettingsImpl.refresh();
            }
        }

        private void setFolderListener() {
            String string;
            if (this.fo != null) {
                this.fo.removeFileChangeListener((FileChangeListener)this);
            }
            if ((string = this.editorSettings.getCurrentKeyMapProfile()).equals("NetBeans")) {
                string = null;
            }
            this.fo = Utils.createFileObject(this.mimeTypes, string, null);
            this.fo.addFileChangeListener((FileChangeListener)this);
        }
    }
}

