/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class KeyMapsStorage {
    public static Object[] loadKeyMaps(String[] stringArray, String string, String string2) {
        FileObject fileObject;
        if (string.equals("NetBeans")) {
            string = null;
        }
        if ((fileObject = Utils.getFileObject(stringArray, string, string2)) == null) {
            return new Object[]{Collections.EMPTY_MAP, Collections.EMPTY_SET};
        }
        return KeyMapsStorage.loadKeyMaps(fileObject);
    }

    public static Object[] loadKeyMaps(FileObject fileObject) {
        return (Object[])XMLStorage.load(fileObject, new KeyMapsReader());
    }

    public static void deleteProfile(String[] stringArray, String string, String string2) {
        Utils.deleteFileObject(stringArray, string, string2);
    }

    public static void saveKeyMaps(String[] stringArray, String string, String string2, Collection collection, Collection collection2) {
        if (string.equals("NetBeans")) {
            string = null;
        }
        FileObject fileObject = Utils.createFileObject(stringArray, string, string2);
        KeyMapsStorage.saveKeyMaps(fileObject, collection, collection2);
    }

    private static void saveKeyMaps(FileObject fileObject, Collection collection, Collection collection2) {
        XMLStorage.Attribs attribs;
        Object object;
        StringBuffer stringBuffer = XMLStorage.generateHeader();
        XMLStorage.generateFolderStart(stringBuffer, "bindings", null, "");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (MultiKeyBinding)iterator.next();
            attribs = new XMLStorage.Attribs(true);
            attribs.add("actionName", object.getActionName());
            attribs.add("key", Utils.keyStrokesToString(object.getKeyStrokeList()));
            XMLStorage.generateLeaf(stringBuffer, "bind", attribs, "    ");
        }
        iterator = collection2.iterator();
        while (iterator.hasNext()) {
            object = Utils.keyStrokesToString((List)iterator.next());
            attribs = new XMLStorage.Attribs(true);
            attribs.add("key", (String)object);
            attribs.add("remove", "true");
            XMLStorage.generateLeaf(stringBuffer, "bind", attribs, "    ");
        }
        XMLStorage.generateFolderEnd(stringBuffer, "bindings", "");
        XMLStorage.save(fileObject, new String(stringBuffer));
    }

    private static class KeyMapsReader
    extends XMLStorage.Handler {
        private Map keyMap = new HashMap();
        private Set removedShortcuts = new HashSet();

        private KeyMapsReader() {
        }

        Object getResult() {
            return new Object[]{this.keyMap, this.removedShortcuts};
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (!string3.equals("bindings") && string3.equals("bind")) {
                    String string4 = attributes.getValue("actionName");
                    String string5 = attributes.getValue("key");
                    KeyStroke[] keyStrokeArray = Utils.stringToKeyStrokes(string5);
                    String string6 = attributes.getValue("remove");
                    if (string6 != null && string6.equals("true")) {
                        this.removedShortcuts.add(Arrays.asList(keyStrokeArray));
                        return;
                    }
                    MultiKeyBinding multiKeyBinding = new MultiKeyBinding(keyStrokeArray, string4);
                    this.keyMap.put(Arrays.asList(keyStrokeArray), multiKeyBinding);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

