/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLStorage {
    private static final Map colorToName = new HashMap();
    private static final Map nameToColor = new HashMap();
    private static final Map nameToFontStyle = new HashMap();
    private static final Map fontStyleToName = new HashMap();
    private static RequestProcessor requestProcessor;

    static String colorToString(Color color) {
        if (colorToName.containsKey(color)) {
            return (String)colorToName.get(color);
        }
        return Integer.toHexString(color.getRGB());
    }

    static Color stringToColor(String string) throws Exception {
        if (nameToColor.containsKey(string)) {
            return (Color)nameToColor.get(string);
        }
        try {
            return new Color((int)Long.parseLong(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(FileObject fileObject, String string) {
        if (fileObject == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            FileLock fileLock = fileObject.lock();
            try {
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                try {
                    outputStreamWriter.write(string);
                }
                finally {
                    ((Writer)outputStreamWriter).close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object load(FileObject fileObject, Handler handler) {
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            xMLReader.setEntityResolver(handler);
            xMLReader.setContentHandler(handler);
            InputStream inputStream = fileObject.getInputStream();
            if (fileObject.getSize() < 2L) {
                ErrorManager.getDefault().notify((Throwable)new InternalError());
                return handler.getResult();
            }
            try {
                xMLReader.parse(new InputSource(inputStream));
            }
            finally {
                inputStream.close();
            }
            return handler.getResult();
        }
        catch (SAXException sAXException) {
            if (System.getProperty("org.netbeans.optionsDialog") != null) {
                System.out.println("File: " + fileObject);
                sAXException.printStackTrace();
            }
            return handler.getResult();
        }
        catch (IOException iOException) {
            if (System.getProperty("org.netbeans.optionsDialog") != null) {
                System.out.println("File: " + fileObject);
                iOException.printStackTrace();
            }
            return handler.getResult();
        }
        catch (Exception exception) {
            if (System.getProperty("org.netbeans.optionsDialog") != null) {
                System.out.println("File: " + fileObject);
                exception.printStackTrace();
            }
            return handler.getResult();
        }
    }

    static StringBuffer generateHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>\n\n");
        return stringBuffer;
    }

    static void generateFolderStart(StringBuffer stringBuffer, String string, Attribs attribs, String string2) {
        stringBuffer.append(string2).append('<').append(string);
        if (attribs != null) {
            if (!attribs.oneLine) {
                stringBuffer.append('\n');
            } else {
                stringBuffer.append(' ');
            }
            XMLStorage.generateAttributes(stringBuffer, attribs, string2 + "    ");
            if (!attribs.oneLine) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(">\n");
        } else {
            stringBuffer.append(">\n");
        }
    }

    static void generateFolderEnd(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string2).append("</").append(string).append(">\n");
    }

    static void generateLeaf(StringBuffer stringBuffer, String string, Attribs attribs, String string2) {
        stringBuffer.append(string2).append('<').append(string);
        if (attribs != null) {
            if (!attribs.oneLine) {
                stringBuffer.append('\n');
            } else {
                stringBuffer.append(' ');
            }
            XMLStorage.generateAttributes(stringBuffer, attribs, string2 + "    ");
            if (!attribs.oneLine) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("/>\n");
        } else {
            stringBuffer.append("/>\n");
        }
    }

    private static void generateAttributes(StringBuffer stringBuffer, Attribs attribs, String string) {
        if (attribs == null) {
            return;
        }
        int n = attribs.names.size();
        for (int i = 0; i < n; ++i) {
            if (!attribs.oneLine) {
                stringBuffer.append(string);
            }
            stringBuffer.append(attribs.names.get(i)).append("=\"").append(attribs.values.get(i)).append('\"');
            if (!attribs.oneLine) {
                stringBuffer.append("\n");
                continue;
            }
            if (i >= n - 1) continue;
            stringBuffer.append(' ');
        }
    }

    static {
        colorToName.put(Color.black, "black");
        nameToColor.put("black", Color.black);
        colorToName.put(Color.blue, "blue");
        nameToColor.put("blue", Color.blue);
        colorToName.put(Color.cyan, "cyan");
        nameToColor.put("cyan", Color.cyan);
        colorToName.put(Color.darkGray, "darkGray");
        nameToColor.put("darkGray", Color.darkGray);
        colorToName.put(Color.gray, "gray");
        nameToColor.put("gray", Color.gray);
        colorToName.put(Color.green, "green");
        nameToColor.put("green", Color.green);
        colorToName.put(Color.lightGray, "lightGray");
        nameToColor.put("lightGray", Color.lightGray);
        colorToName.put(Color.magenta, "magenta");
        nameToColor.put("magenta", Color.magenta);
        colorToName.put(Color.orange, "orange");
        nameToColor.put("orange", Color.orange);
        colorToName.put(Color.pink, "pink");
        nameToColor.put("pink", Color.pink);
        colorToName.put(Color.red, "red");
        nameToColor.put("red", Color.red);
        colorToName.put(Color.white, "white");
        nameToColor.put("white", Color.white);
        colorToName.put(Color.yellow, "yellow");
        nameToColor.put("yellow", Color.yellow);
        nameToFontStyle.put("plain", new Integer(0));
        fontStyleToName.put(new Integer(0), "plain");
        nameToFontStyle.put("bold", new Integer(1));
        fontStyleToName.put(new Integer(1), "bold");
        nameToFontStyle.put("italic", new Integer(2));
        fontStyleToName.put(new Integer(2), "italic");
        nameToFontStyle.put("bold+italic", new Integer(3));
        fontStyleToName.put(new Integer(3), "bold+italic");
        requestProcessor = new RequestProcessor("XMLStorage");
    }

    static class Attribs {
        private List names = new ArrayList();
        private List values = new ArrayList();
        private boolean oneLine;

        Attribs(boolean bl) {
            this.oneLine = bl;
        }

        void add(String string, String string2) {
            int n = this.names.indexOf(string);
            if (n >= 0) {
                this.names.remove(n);
                this.values.remove(n);
            }
            this.names.add(string);
            this.values.add(string2);
        }

        void clear() {
            this.names.clear();
            this.values.clear();
        }
    }

    static class Handler
    extends DefaultHandler {
        private Object result;

        Handler() {
        }

        void setResult(Object object) {
            this.result = object;
        }

        Object getResult() {
            return this.result;
        }
    }
}

