/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.client;

import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.client.WebServicesClientViewAccessor;
import org.netbeans.modules.websvc.spi.client.WebServicesClientViewImpl;
import org.netbeans.modules.websvc.spi.client.WebServicesClientViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class WebServicesClientView {
    private WebServicesClientViewImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebServicesClientViewProvider.class));

    private WebServicesClientView(WebServicesClientViewImpl webServicesClientViewImpl) {
        if (webServicesClientViewImpl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = webServicesClientViewImpl;
    }

    public static WebServicesClientView getWebServicesClientView(FileObject fileObject) {
        WebServicesClientView webServicesClientView;
        WebServicesClientViewProvider webServicesClientViewProvider;
        if (fileObject == null) {
            throw new NullPointerException("Passed null to WebServicesClientView.getWebServicesClientView(FileObject)");
        }
        Iterator iterator = implementations.allInstances().iterator();
        while (iterator.hasNext()) {
            webServicesClientViewProvider = (WebServicesClientViewProvider)iterator.next();
            webServicesClientView = webServicesClientViewProvider.findWebServicesClientView(fileObject);
            if (webServicesClientView == null) continue;
            return webServicesClientView;
        }
        webServicesClientViewProvider = (WebServicesClientViewProvider)Lookup.getDefault().lookup(WebServicesClientViewProvider.class);
        if (webServicesClientViewProvider != null) {
            webServicesClientView = webServicesClientViewProvider.findWebServicesClientView(fileObject);
            return webServicesClientView;
        }
        return null;
    }

    public Node createWebServiceClientView(Project project) {
        return this.impl.createWebServiceClientView(project);
    }

    public Node createWebServiceClientView(SourceGroup sourceGroup) {
        return this.impl.createWebServiceClientView(sourceGroup);
    }

    public Node createWebServiceClientView(FileObject fileObject) {
        return this.impl.createWebServiceClientView(fileObject);
    }

    static {
        WebServicesClientViewAccessor.DEFAULT = new WebServicesClientViewAccessor(){

            public WebServicesClientView createWebServicesClientView(WebServicesClientViewImpl webServicesClientViewImpl) {
                return new WebServicesClientView(webServicesClientViewImpl);
            }

            public WebServicesClientViewImpl getWebServicesClientViewImpl(WebServicesClientView webServicesClientView) {
                return webServicesClientView == null ? null : webServicesClientView.impl;
            }
        };
    }
}

