/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.tasklist.docscan.Settings;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class Cache {
    private static Map cache;

    Cache() {
    }

    public static void put(SuggestionContext suggestionContext, List list) {
        FileObject fileObject = suggestionContext.getFileObject();
        String string = Cache.createKey(fileObject);
        if (string == null) {
            return;
        }
        if (list == null || list.isEmpty()) {
            long l = fileObject.lastModified().getTime();
            Cache.cache().put(string, new long[]{l, System.currentTimeMillis()});
        } else {
            Cache.cache().remove(string);
        }
    }

    public static List get(SuggestionContext suggestionContext) {
        FileObject fileObject = suggestionContext.getFileObject();
        String string = Cache.createKey(fileObject);
        if (string == null) {
            return null;
        }
        Object v = Cache.cache().get(string);
        if (v != null) {
            if (((long[])v)[0] >= fileObject.lastModified().getTime()) {
                return Collections.EMPTY_LIST;
            }
            Cache.cache().remove(string);
        }
        return null;
    }

    private static String createKey(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private static Map cache() {
        if (cache == null) {
            Cache.load();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void load() {
        block18: {
            var0 = null;
            try {
                block17: {
                    var1_1 = Cache.getCacheFile(false);
                    var2_5 = new BufferedInputStream(new FileInputStream(var1_1));
                    var0 = new ObjectInputStream(var2_5);
                    if (var0.readInt() != 1) break block17;
                    Cache.cache = (Map)var0.readObject();
                }
                var4_6 = null;
                ** if (var0 == null) goto lbl-1000
            }
            catch (Throwable var3_10) {
                var4_7 = null;
                if (var0 != null) {
                    try {
                        var0.close();
                    }
                    catch (IOException var5_9) {
                        // empty catch block
                    }
                }
                throw var3_10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var0.close();
                }
                catch (IOException var5_8) {}
            }
lbl-1000:
            // 2 sources

            {
                break block18;
                catch (IOException var1_2) {
                    var4_6 = null;
                    if (var0 != null) {
                        try {
                            var0.close();
                        }
                        catch (IOException var5_8) {}
                    }
                    break block18;
                }
                catch (ClassNotFoundException var1_3) {
                    var4_6 = null;
                    if (var0 != null) {
                        try {
                            var0.close();
                        }
                        catch (IOException var5_8) {}
                    }
                }
            }
        }
        if (Cache.cache == null) {
            Cache.cache = new HashMap<K, V>(1113);
        }
        var1_4 = System.currentTimeMillis() - 1468800000L;
        if (Settings.getDefault().getModificationTime() > var1_4) {
            var1_4 = Settings.getDefault().getModificationTime();
        }
        var3_11 = Cache.cache.entrySet().iterator();
        while (var3_11.hasNext()) {
            var4_6 = var3_11.next();
            if (((long[])var4_6.getValue())[1] >= var1_4) continue;
            var3_11.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() {
        if (cache == null) {
            return;
        }
        try {
            File file = Cache.getCacheFile(true);
            OutputStream outputStream = new FileOutputStream(file);
            outputStream = new BufferedOutputStream(outputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeInt(1);
            objectOutputStream.writeObject(cache);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        finally {
            cache = null;
        }
    }

    private static File getCacheFile(boolean bl) throws IOException {
        String string = System.getProperty("netbeans.user") + File.separatorChar + "var" + File.separatorChar + "cache" + File.separatorChar + "all-todos.ser";
        File file = new File(string);
        if (bl && !file.exists()) {
            File file2 = file.getParentFile();
            file2.mkdirs();
            file.createNewFile();
        }
        return file;
    }
}

