/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.MissingResourceException;
import org.netbeans.modules.javahelp.Installer;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class NbDocsStreamHandler
extends URLStreamHandler {
    static /* synthetic */ Class class$org$netbeans$modules$javahelp$NbDocsStreamHandler;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    NbDocsStreamHandler() {
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("nbdocs")) {
            return new NbDocsURLConnection(uRL);
        }
        throw new IOException("mismatched protocol");
    }

    private static final class InfoURLConnection
    extends URLConnection {
        private ByteArrayInputStream stream;
        private String moduleName;

        public InfoURLConnection(URL uRL, String string) {
            super(uRL);
            this.moduleName = string;
        }

        public synchronized void connect() throws IOException {
            if (!this.connected) {
                InputStream inputStream = this.url.openStream();
                if (inputStream == null) {
                    throw new IOException("Info file not found.");
                }
                byte[] byArray = this.readData(inputStream);
                String string = new String(byArray, "UTF-8");
                String string2 = string.replaceAll("\\{0\\}", this.moduleName);
                byArray = string2.getBytes("UTF-8");
                this.stream = new ByteArrayInputStream(byArray);
                this.connected = true;
            }
        }

        private byte[] readData(InputStream inputStream) throws IOException {
            int n = 4096;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[]{};
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if ((n2 = inputStream.read(byArray)) == -1) {
                    byte[] byArray3 = new byte[n3];
                    System.arraycopy(byArray2, 0, byArray3, 0, n3);
                    return byArray3;
                }
                if (n4 < n3 + n2) {
                    byte[] byArray4 = new byte[byArray2.length];
                    System.arraycopy(byArray2, 0, byArray4, 0, n3);
                    byArray2 = new byte[n4 + n];
                    n4 += n;
                    System.arraycopy(byArray4, 0, byArray2, 0, n3);
                }
                System.arraycopy(byArray, 0, byArray2, n3, n2);
                n3 += n2;
            }
        }

        private void tryToConnect() {
            if (this.connected) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.stream;
        }

        public String getContentType() {
            return "text/html";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.stream.available();
            }
            return 0;
        }
    }

    private static final class NbDocsURLConnection
    extends URLConnection {
        private URLConnection real = null;
        private IOException exception = null;

        public NbDocsURLConnection(URL uRL) {
            super(uRL);
        }

        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException iOException = this.exception;
                this.exception = null;
                throw iOException;
            }
            if (!this.connected) {
                URL uRL;
                String string;
                String string2;
                int n;
                Object object;
                String string3 = this.url.getHost();
                if (string3.length() > 0) {
                    object = NbDocsURLConnection.findModule(string3);
                    if (object != null) {
                        if (!object.isEnabled()) {
                            URL uRL2 = new URL("nbdocs:/org/netbeans/modules/javahelp/resources/notEnabledModule.html");
                            String string4 = object.getDisplayName();
                            this.real = new InfoURLConnection(uRL2, string4);
                            this.real.connect();
                            this.connected = true;
                            return;
                        }
                    } else {
                        URL uRL3 = new URL("nbdocs:/org/netbeans/modules/javahelp/resources/notInstalledModule.html");
                        String string5 = "";
                        try {
                            string5 = NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$NbDocsStreamHandler == null ? (class$org$netbeans$modules$javahelp$NbDocsStreamHandler = NbDocsStreamHandler.class$("org.netbeans.modules.javahelp.NbDocsStreamHandler")) : class$org$netbeans$modules$javahelp$NbDocsStreamHandler), (String)string3);
                        }
                        catch (MissingResourceException missingResourceException) {
                            string5 = string3;
                        }
                        this.real = new InfoURLConnection(uRL3, string5);
                        this.real.connect();
                        this.connected = true;
                        return;
                    }
                }
                if (((String)(object = this.url.getFile())).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                if ((n = ((String)object).lastIndexOf(46)) != -1 && n > ((String)object).lastIndexOf(47)) {
                    string2 = ((String)object).substring(n + 1);
                    string = ((String)object).substring(0, n).replace('/', '.');
                } else {
                    string2 = null;
                    string = ((String)object).replace('/', '.');
                }
                try {
                    uRL = NbBundle.getLocalizedFile((String)string, (String)string2);
                }
                catch (MissingResourceException missingResourceException) {
                    File file = InstalledFileLocator.getDefault().locate("docs/" + (String)object, null, true);
                    if (file != null) {
                        uRL = file.toURI().toURL();
                    }
                    IOException iOException = new IOException("cannot connect to " + this.url + ": " + missingResourceException);
                    Installer.err.annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$NbDocsStreamHandler == null ? (class$org$netbeans$modules$javahelp$NbDocsStreamHandler = NbDocsStreamHandler.class$("org.netbeans.modules.javahelp.NbDocsStreamHandler")) : class$org$netbeans$modules$javahelp$NbDocsStreamHandler), (String)"EXC_nbdocs_cannot_connect", (Object)this.url));
                    Installer.err.annotate((Throwable)iOException, (Throwable)missingResourceException);
                    throw iOException;
                }
                this.real = uRL.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private static ModuleInfo findModule(String string) {
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = NbDocsStreamHandler.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo));
            Collection collection = result.allInstances();
            ModuleInfo moduleInfo = null;
            boolean bl = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                moduleInfo = (ModuleInfo)iterator.next();
                if (!moduleInfo.getCodeNameBase().equals(string)) continue;
                return moduleInfo;
            }
            return null;
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        public String getHeaderField(String string) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(string);
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }
    }

    public static final class Factory
    implements URLStreamHandlerFactory {
        public URLStreamHandler createURLStreamHandler(String string) {
            if (string.equals("nbdocs")) {
                return new NbDocsStreamHandler();
            }
            return null;
        }
    }
}

