/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.netbeans.modules.image.ImageOpenSupport;
import org.netbeans.modules.image.ImagePrintSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ImageDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = -6035788991669336965L;
    private static final String IMAGE_ICON_BASE = "org/netbeans/modules/image/imageObject.png";
    private transient ImageOpenSupport openSupport;
    private transient ImagePrintSupport printSupport;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageDataObject;

    public ImageDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().add(ImageOpenSupport.class, (CookieSet.Factory)this);
        this.getCookieSet().add(ImagePrintSupport.class, (CookieSet.Factory)this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(ImageOpenSupport.class)) {
            return this.getOpenSupport();
        }
        if (clazz.isAssignableFrom(ImagePrintSupport.class)) {
            return this.getPrintSupport();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageOpenSupport getOpenSupport() {
        if (this.openSupport == null) {
            ImageDataObject imageDataObject = this;
            synchronized (imageDataObject) {
                if (this.openSupport == null) {
                    this.openSupport = new ImageOpenSupport(this.getPrimaryEntry());
                }
            }
        }
        return this.openSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImagePrintSupport getPrintSupport() {
        if (this.printSupport == null) {
            ImageDataObject imageDataObject = this;
            synchronized (imageDataObject) {
                if (this.printSupport == null) {
                    this.printSupport = new ImagePrintSupport(this);
                }
            }
        }
        return this.printSupport;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    URL getImageURL() {
        try {
            return this.getPrimaryFile().getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
    }

    private byte[] getImageData() {
        try {
            FileObject fileObject = this.getPrimaryFile();
            byte[] byArray = new byte[(int)fileObject.getSize()];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
            bufferedInputStream.read(byArray, 0, (int)fileObject.getSize());
            bufferedInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public Image getImage() throws IOException {
        return ImageIO.read(this.getPrimaryFile().getInputStream());
    }

    protected Node createNodeDelegate() {
        return new ImageNode(this);
    }

    private static final class ImageNode
    extends DataNode {
        public ImageNode(ImageDataObject imageDataObject) {
            super((DataObject)imageDataObject, Children.LEAF);
            this.setIconBaseWithExtension(ImageDataObject.IMAGE_ICON_BASE);
            this.setDefaultAction(SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = ImageDataObject.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)));
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = sheet.get("properties");
            if (set == null) {
                set = Sheet.createPropertiesSet();
                sheet.put(set);
            }
            set.put((Node.Property)new ThumbnailProperty(this.getDataObject()));
            return sheet;
        }

        private static final class ThumbnailProperty
        extends PropertySupport.ReadOnly {
            private final DataObject obj;

            public ThumbnailProperty(DataObject dataObject) {
                super("thumbnail", class$javax$swing$Icon == null ? (class$javax$swing$Icon = ImageDataObject.class$("javax.swing.Icon")) : class$javax$swing$Icon, NbBundle.getMessage((Class)(class$org$netbeans$modules$image$ImageDataObject == null ? (class$org$netbeans$modules$image$ImageDataObject = ImageDataObject.class$("org.netbeans.modules.image.ImageDataObject")) : class$org$netbeans$modules$image$ImageDataObject), (String)"PROP_Thumbnail"), NbBundle.getMessage((Class)(class$org$netbeans$modules$image$ImageDataObject == null ? (class$org$netbeans$modules$image$ImageDataObject = ImageDataObject.class$("org.netbeans.modules.image.ImageDataObject")) : class$org$netbeans$modules$image$ImageDataObject), (String)"HINT_Thumbnail"));
                this.obj = dataObject;
            }

            public Object getValue() throws InvocationTargetException {
                try {
                    return new ImageIcon(this.obj.getPrimaryFile().getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    throw new InvocationTargetException(fileStateInvalidException);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new ThumbnailPropertyEditor();
            }

            private final class ThumbnailPropertyEditor
            extends PropertyEditorSupport {
                private ThumbnailPropertyEditor() {
                }

                public boolean isPaintable() {
                    return true;
                }

                public void paintValue(Graphics graphics, Rectangle rectangle) {
                    ImageIcon imageIcon;
                    block5: {
                        imageIcon = null;
                        try {
                            imageIcon = (ImageIcon)ThumbnailProperty.this.getValue();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block5;
                            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                        }
                    }
                    if (imageIcon != null) {
                        int n = imageIcon.getIconWidth();
                        int n2 = imageIcon.getIconHeight();
                        double d = (double)n / (double)n2;
                        if (n > rectangle.width) {
                            n = rectangle.width;
                            n2 = (int)((double)n / d);
                        }
                        if (n2 > rectangle.height) {
                            n2 = rectangle.height;
                            n = (int)((double)n2 * d);
                        }
                        int n3 = n < rectangle.x ? (rectangle.x - n) / 2 : 5;
                        int n4 = n2 < rectangle.y ? (rectangle.y - n2) / 2 : 0;
                        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        graphics.drawImage(imageIcon.getImage(), n3, n4, n, n2, null);
                    }
                }

                public String getAsText() {
                    return null;
                }
            }
        }
    }
}

