/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.modules.image.CustomZoomAction;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageOpenSupport;
import org.netbeans.modules.image.NBImageIcon;
import org.netbeans.modules.image.ZoomInAction;
import org.netbeans.modules.image.ZoomOutAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ImageViewer
extends CloneableTopComponent {
    static final long serialVersionUID = 6960127954234034486L;
    private ImageDataObject storedObject;
    private NBImageIcon storedImage;
    private JPanel panel;
    private double scale = 1.0;
    private boolean showGrid = false;
    private final double changeFactor = Math.sqrt(2.0);
    private final Color gridColor = Color.black;
    private PropertyChangeListener nameChangeL;
    private final Collection toolbarButtons = new ArrayList(11);
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImageViewer() {
    }

    public ImageViewer(ImageDataObject imageDataObject) {
        this.initialize(imageDataObject);
    }

    public int getPersistenceType() {
        return 1;
    }

    protected void reloadIcon() {
        this.resizePanel();
        this.panel.repaint();
    }

    private void initialize(ImageDataObject imageDataObject) {
        Component component;
        TopComponent.NodeName.connect((TopComponent)this, (Node)imageDataObject.getNodeDelegate());
        this.setToolTipText(FileUtil.getFileDisplayName((FileObject)imageDataObject.getPrimaryFile()));
        this.storedObject = imageDataObject;
        this.setCloseOperation(0);
        String string = this.loadImage(this.storedObject);
        JToolBar jToolBar = this.createToolBar();
        if (this.storedImage != null) {
            component = this.createImageView();
        } else {
            component = this.createMessagePanel(string);
            this.setToolbarButtonsEnabled(false);
        }
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.add(jToolBar, "North");
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_ImageViewer"));
        this.nameChangeL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("cookie".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName())) {
                    ImageViewer.this.updateName();
                }
            }
        };
        imageDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.nameChangeL, (Object)((Object)imageDataObject)));
    }

    private Component createImageView() {
        this.panel = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.drawImage(ImageViewer.this.storedImage.getImage(), 0, 0, (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconWidth()), (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconHeight()), 0, 0, ImageViewer.this.storedImage.getIconWidth(), ImageViewer.this.storedImage.getIconHeight(), this);
                if (ImageViewer.this.showGrid) {
                    int n = (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconWidth());
                    int n2 = (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconHeight());
                    double d = ImageViewer.this.getScale();
                    if (d < 2.0) {
                        return;
                    }
                    graphics.setColor(ImageViewer.this.gridColor);
                    double d2 = d;
                    int n3 = (int)d2;
                    while (n3 < n) {
                        graphics.drawLine(n3, 0, n3, n2 - 1);
                        n3 = (int)(d2 += d);
                    }
                    d2 = d;
                    n3 = (int)d2;
                    while (n3 < n2) {
                        graphics.drawLine(0, n3, n - 1, n3);
                        n3 = (int)(d2 += d);
                    }
                }
            }
        };
        this.storedImage.setImageObserver(this.panel);
        this.panel.setPreferredSize(new Dimension(this.storedImage.getIconWidth(), this.storedImage.getIconHeight()));
        JScrollPane jScrollPane = new JScrollPane(this.panel);
        return jScrollPane;
    }

    private Component createMessagePanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(string), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 10, 10));
        return jPanel;
    }

    void updateView(ImageDataObject imageDataObject) {
        boolean bl;
        boolean bl2 = this.storedImage != null;
        String string = this.loadImage(imageDataObject);
        boolean bl3 = bl = this.storedImage != null;
        if (bl2 && bl) {
            this.reloadIcon();
            return;
        }
        Component component = this.storedImage != null ? this.createImageView() : this.createMessagePanel(string);
        this.remove(0);
        this.add(component, "Center", 0);
        if (bl2 != bl) {
            this.setToolbarButtonsEnabled(bl);
        }
    }

    private void setToolbarButtonsEnabled(boolean bl) {
        if (!$assertionsDisabled && this.toolbarButtons == null) {
            throw new AssertionError();
        }
        Iterator iterator = this.toolbarButtons.iterator();
        while (iterator.hasNext()) {
            ((JButton)iterator.next()).setEnabled(bl);
        }
    }

    private String loadImage(ImageDataObject imageDataObject) {
        String string;
        try {
            this.storedImage = NBImageIcon.load(imageDataObject);
            string = this.storedImage != null ? null : NbBundle.getMessage((Class)ImageViewer.class, (String)"MSG_CouldNotLoad");
        }
        catch (IOException iOException) {
            this.storedImage = null;
            string = NbBundle.getMessage((Class)ImageViewer.class, (String)"MSG_ErrorWhileLoading");
        }
        if (!$assertionsDisabled && this.storedImage == null == (string == null)) {
            throw new AssertionError();
        }
        return string;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setName(NbBundle.getBundle((Class)ImageViewer.class).getString("ACSN_Toolbar"));
        jToolBar.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACSD_Toolbar"));
        JButton jButton = new JButton((Action)SystemAction.get((Class)ZoomOutAction.class));
        jButton.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ZoomOut"));
        jButton.setMnemonic(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Out_BTN_Mnem").charAt(0));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACSD_Out_BTN"));
        jButton.setLabel("");
        jToolBar.add(jButton);
        this.toolbarButtons.add(jButton);
        jToolBar.addSeparator(new Dimension(2, 2));
        JButton jButton2 = new JButton((Action)SystemAction.get((Class)ZoomInAction.class));
        jButton2.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ZoomIn"));
        jButton2.setMnemonic(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_In_BTN_Mnem").charAt(0));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACSD_In_BTN"));
        jButton2.setLabel("");
        jToolBar.add(jButton2);
        this.toolbarButtons.add(jButton2);
        jToolBar.addSeparator(new Dimension(11, 2));
        JButton jButton3 = this.getZoomButton(1, 1);
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        jToolBar.addSeparator(new Dimension(11, 2));
        jButton3 = this.getZoomButton(1, 3);
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        jToolBar.addSeparator(new Dimension(2, 2));
        jButton3 = this.getZoomButton(1, 5);
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        jToolBar.addSeparator(new Dimension(2, 2));
        jButton3 = this.getZoomButton(1, 7);
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        jToolBar.addSeparator(new Dimension(11, 2));
        jButton3 = this.getZoomButton(3, 1);
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        jToolBar.addSeparator(new Dimension(2, 2));
        jButton3 = this.getZoomButton(5, 1);
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        jToolBar.addSeparator(new Dimension(2, 2));
        jButton3 = this.getZoomButton(7, 1);
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        jToolBar.addSeparator(new Dimension(11, 2));
        jButton3 = this.getZoomButton();
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        jToolBar.addSeparator(new Dimension(11, 2));
        jButton3 = this.getGridButton();
        jToolBar.add(jButton3);
        this.toolbarButtons.add(jButton3);
        return jToolBar;
    }

    private void updateName() {
        String string = this.storedObject.getNodeDelegate().getDisplayName();
        this.setName(string);
        FileObject fileObject = this.storedObject.getPrimaryFile();
        this.setToolTipText(FileUtil.getFileDisplayName((FileObject)fileObject));
    }

    public void open(Workspace workspace) {
        if (this.discard()) {
            return;
        }
        Workspace workspace2 = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
        this.dockIfNeeded(workspace2);
        boolean bl = false;
        TopComponent[] topComponentArray = this.editorMode(workspace2).getTopComponents();
        for (int i = 0; i < topComponentArray.length; ++i) {
            if (!topComponentArray[i].isOpened(workspace2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.openOtherEditors(workspace2);
        }
        super.open(workspace);
        this.openOnOtherWorkspaces(workspace2);
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void superOpen(Workspace workspace) {
        super.open(workspace);
    }

    private void openOnOtherWorkspaces(Workspace workspace) {
        Workspace[] workspaceArray = WindowManager.getDefault().getWorkspaces();
        Mode mode = null;
        Mode mode2 = null;
        block0: for (int i = 0; i < workspaceArray.length; ++i) {
            if (workspaceArray[i].equals(workspace)) continue;
            mode = workspaceArray[i].findMode("editor");
            mode2 = workspaceArray[i].findMode((TopComponent)this);
            if (this.isOpened(workspaceArray[i]) || mode == null || mode2 != null && !mode2.equals(mode)) continue;
            TopComponent[] topComponentArray = mode.getTopComponents();
            for (int j = 0; j < topComponentArray.length; ++j) {
                if (!topComponentArray[j].isOpened(workspaceArray[i])) continue;
                this.pureOpen((TopComponent)this, workspaceArray[i]);
                continue block0;
            }
        }
    }

    private void openOtherEditors(Workspace workspace) {
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>(15);
        Workspace[] workspaceArray = WindowManager.getDefault().getWorkspaces();
        Mode mode = null;
        TopComponent[] topComponentArray = null;
        for (int i = 0; i < workspaceArray.length; ++i) {
            mode = workspaceArray[i].findMode("editor");
            if (mode == null) continue;
            topComponentArray = mode.getTopComponents();
            for (int j = 0; j < topComponentArray.length; ++j) {
                if (!topComponentArray[j].isOpened(workspaceArray[i])) continue;
                hashSet.add(topComponentArray[j]);
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.pureOpen((TopComponent)iterator.next(), workspace);
        }
    }

    private void pureOpen(TopComponent topComponent, Workspace workspace) {
        if (topComponent instanceof ImageViewer) {
            ((ImageViewer)topComponent).dockIfNeeded(workspace);
            ((ImageViewer)topComponent).superOpen(workspace);
        } else {
            topComponent.open(workspace);
        }
    }

    private void dockIfNeeded(Workspace workspace) {
        Mode mode = workspace.findMode((TopComponent)this);
        if (mode == null) {
            this.editorMode(workspace).dockInto((TopComponent)this);
        }
    }

    private Mode editorMode(Workspace workspace) {
        Mode mode = workspace.findMode((TopComponent)this);
        if (mode == null) {
            mode = workspace.createMode("editor", this.getName(), CloneableEditorSupport.class.getResource("/org/openide/resources/editorMode.gif"));
        }
        return mode;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private boolean discard() {
        return this.storedObject == null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.storedObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.storedObject = (ImageDataObject)((Object)objectInput.readObject());
        ((ImageOpenSupport)this.storedObject.getCookie(ImageOpenSupport.class)).prepareViewer();
        this.initialize(this.storedObject);
    }

    protected CloneableTopComponent createClonedObject() {
        return new ImageViewer(this.storedObject);
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] systemActionArray = super.getSystemActions();
        return SystemAction.linkActions((SystemAction[])new SystemAction[]{SystemAction.get((Class)ZoomInAction.class), SystemAction.get((Class)ZoomOutAction.class), SystemAction.get((Class)CustomZoomAction.class), null}, (SystemAction[])systemActionArray);
    }

    public Image getIcon() {
        return Utilities.loadImage((String)"org/netbeans/modules/image/imageObject.png");
    }

    public void zoomIn() {
        this.scaleIn();
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public void zoomOut() {
        double d = this.scale;
        this.scaleOut();
        if (!this.isNewSizeOK()) {
            this.scale = d;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private void resizePanel() {
        this.panel.setPreferredSize(new Dimension((int)(this.getScale() * (double)this.storedImage.getIconWidth()), (int)(this.getScale() * (double)this.storedImage.getIconHeight())));
        this.panel.revalidate();
    }

    private boolean isNewSizeOK() {
        return this.getScale() * (double)this.storedImage.getIconWidth() > 1.0 && this.getScale() * (double)this.storedImage.getIconWidth() > 1.0;
    }

    public void customZoom(int n, int n2) {
        double d = this.scale;
        this.scale = (double)n / (double)n2;
        if (!this.isNewSizeOK()) {
            this.scale = d;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private double getScale() {
        return this.scale;
    }

    private void scaleOut() {
        this.scale /= this.changeFactor;
    }

    private void scaleIn() {
        double d = this.getScale();
        this.scale = this.changeFactor * this.scale;
        double d2 = this.getScale();
        if (d2 == d) {
            this.scale = d2 + 1.0;
        }
    }

    private JButton getZoomButton(final int n, final int n2) {
        JButton jButton = new JButton("" + n + ":" + n2);
        if (n < n2) {
            jButton.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ZoomOut") + " " + n + " : " + n2);
        } else {
            jButton.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ZoomIn") + " " + n + " : " + n2);
        }
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Zoom_BTN"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.customZoom(n, n2);
            }
        });
        return jButton;
    }

    private JButton getZoomButton() {
        JButton jButton = new JButton(NbBundle.getBundle((Class)CustomZoomAction.class).getString("LBL_XtoY"));
        jButton.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_CustomZoom"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Zoom_BTN"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomZoomAction customZoomAction = (CustomZoomAction)SystemAction.get((Class)(class$org$netbeans$modules$image$CustomZoomAction == null ? (class$org$netbeans$modules$image$CustomZoomAction = ImageViewer.class$("org.netbeans.modules.image.CustomZoomAction")) : class$org$netbeans$modules$image$CustomZoomAction));
                customZoomAction.performAction();
            }
        });
        return jButton;
    }

    private JButton getGridButton() {
        JButton jButton = new JButton(" # ");
        jButton.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ShowHideGrid"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Grid_BTN"));
        jButton.setMnemonic(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Grid_BTN_Mnem").charAt(0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.showGrid = !ImageViewer.this.showGrid;
                ImageViewer.this.panel.repaint(0, 0, ImageViewer.this.panel.getWidth(), ImageViewer.this.panel.getHeight());
            }
        });
        return jButton;
    }

    static {
        $assertionsDisabled = !ImageViewer.class.desiredAssertionStatus();
    }
}

