/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public final class ClassNameTextField
extends JTextField {
    public static final int STATUS_VALID = 0;
    public static final int STATUS_EMPTY = 1;
    public static final int STATUS_INVALID = 2;
    public static final int STATUS_VALID_NOT_DEFAULT = 3;
    static final int STATUS_BEFORE_PART = 3;
    private TextListener documentListener;
    private int externalStatus = 0;
    private boolean externalStatusValid = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private String defaultText;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassNameTextField() {
        this(null);
        this.setupDocumentListener();
    }

    public ClassNameTextField(String string) {
        super(string == null ? "" : string);
        this.setupDocumentListener();
    }

    public void setDefaultText(String string) {
        if (string == null && this.defaultText == null || string != null && string.equals(this.defaultText)) {
            return;
        }
        this.defaultText = string;
        if (string != null || this.externalStatusValid && this.externalStatus == 3) {
            this.statusMaybeChanged();
        }
    }

    private void setupDocumentListener() {
        this.documentListener = new TextListener();
        this.getDocument().addDocumentListener(this.documentListener);
    }

    int determineStatus() {
        String string = this.getText();
        int n = 3;
        char[] cArray = string.toCharArray();
        block4: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (n) {
                case 3: {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return 2;
                    }
                    n = 0;
                    continue block4;
                }
                case 0: {
                    if (c == '.') {
                        n = 3;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        n = 0;
                        continue block4;
                    }
                    return 2;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block4;
                }
            }
        }
        return n;
    }

    public int getStatus() {
        if (!this.externalStatusValid) {
            this.updateExternalStatus();
        }
        return this.externalStatus;
    }

    private void updateExternalStatus() {
        if (!$assertionsDisabled && this.externalStatusValid) {
            throw new AssertionError();
        }
        int n = this.documentListener.status;
        switch (n) {
            case 0: {
                this.externalStatus = this.defaultText == null || this.defaultText.equals(this.getText()) ? 0 : 3;
                break;
            }
            case 3: {
                this.externalStatus = this.getText().length() == 0 ? 1 : 2;
                break;
            }
            case 2: {
                this.externalStatus = 2;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                this.externalStatus = 2;
            }
        }
        this.externalStatusValid = true;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeEvent = new ChangeEvent(this);
        this.changeListener = changeListener;
    }

    private void statusMaybeChanged() {
        this.externalStatusValid = false;
        if (this.changeListener != null) {
            int n = this.externalStatus;
            this.externalStatus = this.getStatus();
            if (this.externalStatus != n) {
                this.changeListener.stateChanged(this.changeEvent);
            }
        }
    }

    static {
        $assertionsDisabled = !ClassNameTextField.class.desiredAssertionStatus();
    }

    private final class TextListener
    implements DocumentListener {
        private int status;
        private int length;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TextListener() {
            this.status = ClassNameTextField.this.determineStatus();
            this.length = ClassNameTextField.this.getText().length();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.length = documentEvent.getDocument().getLength();
            int n = ClassNameTextField.this.determineStatus();
            if (n != this.status) {
                this.status = n;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            if (!$assertionsDisabled && this.length != ClassNameTextField.this.getDocument().getLength()) {
                throw new AssertionError();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n;
            boolean bl;
            boolean bl2 = bl = this.length == 0;
            if (documentEvent.getLength() != 1 || documentEvent.getOffset() != this.length) {
                this.length += documentEvent.getLength();
                n = ClassNameTextField.this.determineStatus();
            } else {
                try {
                    char c = documentEvent.getDocument().getText(this.length++, 1).charAt(0);
                    switch (this.status) {
                        case 0: {
                            n = c == '.' ? (n = 3) : (Character.isJavaIdentifierPart(c) ? 0 : 2);
                            break;
                        }
                        case 3: {
                            n = Character.isJavaIdentifierStart(c) ? 0 : 2;
                            break;
                        }
                        case 2: {
                            n = ClassNameTextField.this.determineStatus();
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            n = ClassNameTextField.this.determineStatus();
                            break;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    this.length = documentEvent.getDocument().getLength();
                    n = ClassNameTextField.this.determineStatus();
                }
            }
            if (n != this.status || bl) {
                this.status = n;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            if (!$assertionsDisabled && this.length != ClassNameTextField.this.getDocument().getLength()) {
                throw new AssertionError();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            int n;
            if (documentEvent.getLength() != 1 || documentEvent.getOffset() != this.length - 1) {
                this.length -= documentEvent.getLength();
                n = ClassNameTextField.this.determineStatus();
            } else {
                --this.length;
                switch (this.status) {
                    case 0: {
                        try {
                            n = this.length == 0 || documentEvent.getDocument().getText(this.length - 1, 1).charAt(0) == '.' ? 3 : 0;
                        }
                        catch (BadLocationException badLocationException) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            n = ClassNameTextField.this.determineStatus();
                            this.length = documentEvent.getDocument().getLength();
                        }
                        break;
                    }
                    case 3: {
                        n = 0;
                        break;
                    }
                    case 2: {
                        n = this.length == 0 ? 0 : ClassNameTextField.this.determineStatus();
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        n = ClassNameTextField.this.determineStatus();
                    }
                }
            }
            if (n != this.status || this.length == 0) {
                this.status = n;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            if (!$assertionsDisabled && this.length != ClassNameTextField.this.getDocument().getLength()) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$junit$ClassNameTextField == null ? (class$org$netbeans$modules$junit$ClassNameTextField = ClassNameTextField.class$("org.netbeans.modules.junit.ClassNameTextField")) : class$org$netbeans$modules$junit$ClassNameTextField).desiredAssertionStatus();
        }
    }
}

