/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.junit.JUnitCfgOfCreate;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.ProgressIndicator;
import org.netbeans.modules.junit.TestAction;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class CreateTestAction
extends TestAction {
    static final /* synthetic */ boolean $assertionsDisabled;

    public CreateTestAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)CreateTestAction.class, (String)"LBL_Action_CreateTest");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateTestAction.class);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage((Class)CreateTestAction.class, (String)"HINT_Action_CreateTest"));
    }

    protected String iconResource() {
        return "org/netbeans/modules/junit/resources/CreateTestActionIcon.gif";
    }

    private static void noTemplateMessage(String string) {
        String string2 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_template_not_found", (Object)string);
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private static String checkNodesValidity(Node[] nodeArray) {
        FileObject[] fileObjectArray = CreateTestAction.getFiles(nodeArray);
        Project project = CreateTestAction.getProject(fileObjectArray);
        if (project == null) {
            return NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_multiproject_selection");
        }
        if (!CreateTestAction.checkPackages(fileObjectArray)) {
            return NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_invalid_packages");
        }
        return null;
    }

    private static boolean checkPackages(FileObject[] fileObjectArray) {
        if (fileObjectArray.length == 0) {
            return true;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObjectArray[0]);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string = CreateTestAction.getPackage(project, fileObjectArray[i]);
            if (string != null && TestUtil.isValidPackageName(string)) continue;
            return false;
        }
        return true;
    }

    private static String getPackage(Project project, FileObject fileObject) {
        SourceGroup sourceGroup = TestUtil.findSourceGroupOwner(project, fileObject);
        if (sourceGroup != null) {
            ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{sourceGroup.getRootFolder()});
            return classPath.getResourceName(fileObject, '.', false);
        }
        return null;
    }

    private static FileObject[] getFiles(Node[] nodeArray) {
        FileObject[] fileObjectArray = new FileObject[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            fileObjectArray[i] = TestUtil.getFileObjectFromNode(nodeArray[i]);
        }
        return fileObjectArray;
    }

    private static Project getProject(FileObject[] fileObjectArray) {
        Project project = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObjectArray[i]);
            if (project == null) {
                project = project2;
                continue;
            }
            if (project == project2) continue;
            return null;
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodeArray) {
        Object object;
        CreationResults creationResults;
        Object object2;
        String string = CreateTestAction.checkNodesValidity(nodeArray);
        if (string != null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        JUnitCfgOfCreate jUnitCfgOfCreate = new JUnitCfgOfCreate(nodeArray);
        if (!jUnitCfgOfCreate.configure()) {
            return;
        }
        boolean bl = nodeArray.length == 1 && jUnitCfgOfCreate.isSingleClass();
        String string2 = bl ? jUnitCfgOfCreate.getTestClassName() : null;
        FileObject fileObject = jUnitCfgOfCreate.getTargetFolder();
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject});
        DataObject dataObject = CreateTestAction.loadTestTemplate("PROP_testClassTemplate");
        if (dataObject == null) {
            return;
        }
        DataObject dataObject2 = null;
        if (!bl && (dataObject2 = CreateTestAction.loadTestTemplate("PROP_testSuiteTemplate")) == null) {
            return;
        }
        ProgressIndicator progressIndicator = new ProgressIndicator();
        progressIndicator.show();
        String string3 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_StatusBar_CreateTest_Begin");
        progressIndicator.displayStatusText(string3);
        TestCreator testCreator = new TestCreator(true);
        try {
            if (bl) {
                if (!$assertionsDisabled && string2 == null) {
                    throw new AssertionError();
                }
                object2 = CreateTestAction.getTestFileObject(nodeArray[0]);
                if (object2 != null) {
                    try {
                        creationResults = CreateTestAction.createSingleTest(testCreator, classPath, object2, string2, dataObject, null, progressIndicator, false);
                    }
                    catch (CreationError creationError) {
                        ErrorManager.getDefault().notify((Throwable)creationError);
                        creationResults = new CreationResults();
                    }
                } else {
                    creationResults = new CreationResults();
                }
            } else {
                creationResults = new CreationResults();
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (this.hasParentAmongNodes(nodeArray, i) || (object = CreateTestAction.getTestFileObject(nodeArray[i])) == null) continue;
                    try {
                        creationResults.combine(this.createTests(testCreator, nodeArray[i], classPath, dataObject, dataObject2, null, progressIndicator));
                        continue;
                    }
                    catch (CreationError creationError) {
                        ErrorManager.getDefault().notify((Throwable)creationError);
                    }
                }
            }
        }
        finally {
            progressIndicator.hide();
        }
        if (!creationResults.getSkipped().isEmpty()) {
            if (creationResults.getSkipped().size() == 1) {
                object = (CreationResults.SkippedClass)creationResults.getSkipped().iterator().next();
                object2 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_skipped_class", (Object)((CreationResults.SkippedClass)object).cls.getName(), (Object)CreateTestAction.strReason(((CreationResults.SkippedClass)object).reason, "COMMA", "AND"));
            } else {
                object = creationResults.getSkipped().iterator();
                TestCreator.TesteableResult testeableResult = TestCreator.TesteableResult.OK;
                while (object.hasNext()) {
                    CreationResults.SkippedClass skippedClass = (CreationResults.SkippedClass)object.next();
                    testeableResult = TestCreator.TesteableResult.combine(testeableResult, skippedClass.reason);
                }
                object2 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_skipped_classes", (Object)CreateTestAction.strReason(testeableResult, "COMMA", "OR"));
            }
            TestUtil.notifyUser((String)object2, 1);
        } else {
            int n = creationResults.getCreated().size();
            if (n == 1) {
                object = (DataObject)creationResults.getCreated().iterator().next();
                EditorCookie editorCookie = (EditorCookie)object.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    editorCookie.open();
                }
            } else if (n == 0) {
                Mutex.EVENT.writeAccess(new Runnable(){

                    public void run() {
                        TestUtil.notifyUser(NbBundle.getMessage((Class)(class$org$netbeans$modules$junit$CreateTestAction == null ? (class$org$netbeans$modules$junit$CreateTestAction = CreateTestAction.class$("org.netbeans.modules.junit.CreateTestAction")) : class$org$netbeans$modules$junit$CreateTestAction), (String)"MSG_No_test_created"), 1);
                    }
                });
            }
        }
    }

    private static String strReason(TestCreator.TesteableResult testeableResult, String string, String string2) {
        String string3 = NbBundle.getMessage((Class)CreateTestAction.class, (String)string);
        String string4 = NbBundle.getMessage((Class)CreateTestAction.class, (String)string2);
        String string5 = testeableResult.getReason(string3.substring(1, string3.length() - 1), string4.substring(1, string4.length() - 1));
        return string5;
    }

    private static DataObject loadTestTemplate(String string) {
        String string2 = NbBundle.getMessage((Class)CreateTestAction.class, (String)string);
        try {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string2);
            if (fileObject == null) {
                CreateTestAction.noTemplateMessage(string2);
                return null;
            }
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            CreateTestAction.noTemplateMessage(string2);
            return null;
        }
    }

    private static FileObject getTestFileObject(Node node) {
        FileObject fileObject = TestUtil.getFileObjectFromNode(node);
        if (fileObject == null) {
            TestUtil.notifyUser(NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_file_from_node_failed"));
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            TestUtil.notifyUser(NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_no_project", (Object)fileObject));
            return null;
        }
        return fileObject;
    }

    public static DataObject createSuiteTest(TestCreator testCreator, ClassPath classPath, DataFolder dataFolder, String string, LinkedList linkedList, DataObject dataObject, LinkedList linkedList2, ProgressIndicator progressIndicator) throws CreationError {
        FileObject fileObject = dataFolder.getPrimaryFile();
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (!$assertionsDisabled && classPath2 == null) {
            throw new AssertionError((Object)("SOURCE classpath was not found for " + fileObject));
        }
        if (classPath2 == null) {
            return null;
        }
        String string2 = classPath2.getResourceName(fileObject, '/', false);
        String string3 = string2.replace('/', '.');
        String string4 = string != null ? string2 + '/' + string : TestUtil.convertPackage2SuiteName(string2);
        try {
            DataObject dataObject2 = CreateTestAction.getTestClass(classPath, string4, dataObject);
            Collection collection = TestUtil.getAllClassesFromFile(dataObject2.getPrimaryFile());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass = (JavaClass)iterator.next();
                if (progressIndicator != null) {
                    progressIndicator.setMessage(CreateTestAction.getCreatingMsg(javaClass.getName()), false);
                }
                try {
                    testCreator.createTestSuite(linkedList, string3, javaClass);
                    CreateTestAction.save(dataObject2);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().log(65536, exception.toString());
                    return null;
                }
                if (null == linkedList2) continue;
                linkedList2.add(javaClass.getName());
            }
            return dataObject2;
        }
        catch (IOException iOException) {
            throw new CreationError(iOException);
        }
    }

    private CreationResults createTests(TestCreator testCreator, Node node, ClassPath classPath, DataObject dataObject, DataObject dataObject2, LinkedList linkedList, ProgressIndicator progressIndicator) throws CreationError {
        FileObject fileObject = TestUtil.getFileObjectFromNode(node);
        if (fileObject.isFolder()) {
            Node[] nodeArray = node.getChildren().getNodes(true);
            CreationResults creationResults = new CreationResults();
            LinkedList linkedList2 = new LinkedList();
            progressIndicator.setMessage(CreateTestAction.getScanningMsg(fileObject.getName()), false);
            for (int i = 0; i < nodeArray.length; ++i) {
                if (progressIndicator.isCanceled()) {
                    creationResults.setAbborted();
                    break;
                }
                creationResults.combine(this.createTests(testCreator, nodeArray[i], classPath, dataObject, dataObject2, linkedList2, progressIndicator));
                if (creationResults.isAbborted()) break;
            }
            if (!creationResults.isAbborted() && 0 < linkedList2.size() & JUnitSettings.getDefault().isGenerateSuiteClasses()) {
                CreateTestAction.createSuiteTest(testCreator, classPath, DataFolder.findFolder((FileObject)fileObject), null, linkedList2, dataObject2, linkedList, progressIndicator);
            }
            return creationResults;
        }
        if (fileObject.isData() && !"java".equals(fileObject.getExt())) {
            return CreationResults.EMPTY;
        }
        return CreateTestAction.createSingleTest(testCreator, classPath, fileObject, null, dataObject, linkedList, progressIndicator, true);
    }

    public static CreationResults createSingleTest(TestCreator testCreator, ClassPath classPath, FileObject fileObject, String string, DataObject dataObject, LinkedList linkedList, ProgressIndicator progressIndicator, boolean bl) throws CreationError {
        Resource resource = JavaModel.getResource((FileObject)fileObject);
        String string2 = string == null ? resource.getPackageName() : null;
        List list = resource.getChildren();
        CreationResults creationResults = new CreationResults(list.size());
        boolean bl2 = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TestCreator.TesteableResult testeableResult;
            Element element = (Element)iterator.next();
            if (!(element instanceof JavaClass) || element instanceof AnnotationType) continue;
            JavaClass javaClass = (JavaClass)element;
            if (bl && (testeableResult = testCreator.isClassTestable(javaClass)).isFailed()) {
                if (progressIndicator == null) continue;
                progressIndicator.setMessage(CreateTestAction.getIgnoringMsg(javaClass.getName(), testeableResult.toString()), false);
                creationResults.addSkipped(javaClass, testeableResult);
                continue;
            }
            try {
                DataObject dataObject2;
                Resource resource2;
                JavaClass javaClass2;
                String string3;
                String string4 = javaClass.getSimpleName();
                if (string == null) {
                    string3 = TestUtil.getTestClassFullName(string4, string2);
                } else if (!bl2 && string4.equals(fileObject.getName())) {
                    string3 = string.replace('.', '/');
                    bl2 = true;
                } else {
                    if (string2 == null) {
                        string2 = CreateTestAction.packageName(string);
                    }
                    string3 = TestUtil.getTestClassFullName(string4, string2);
                }
                if ((javaClass2 = TestUtil.getMainJavaClass(resource2 = JavaModel.getResource((FileObject)(dataObject2 = CreateTestAction.getTestClass(classPath, string3, dataObject)).getPrimaryFile()))) == null) continue;
                if (progressIndicator != null) {
                    progressIndicator.setMessage(CreateTestAction.getCreatingMsg(javaClass2.getName()), false);
                }
                testCreator.createTestClass(resource, javaClass, resource2, javaClass2);
                CreateTestAction.save(dataObject2);
                creationResults.addCreated(dataObject2);
                if (null == linkedList) continue;
                linkedList.add(javaClass2.getName());
            }
            catch (IOException iOException) {
                throw new CreationError(iOException);
            }
        }
        return creationResults;
    }

    private static String packageName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n > 0 ? n : 0);
    }

    private static DataObject getTestClass(ClassPath classPath, String string, DataObject dataObject) throws DataObjectNotFoundException, IOException {
        String string2;
        FileObject fileObject = classPath.findResource(string + ".java");
        if (fileObject != null) {
            return DataObject.find((FileObject)fileObject);
        }
        if (!$assertionsDisabled && classPath.getRoots().length != 1) {
            throw new AssertionError();
        }
        FileObject fileObject2 = classPath.getRoots()[0];
        int n = string.lastIndexOf(47);
        String string3 = n > -1 ? string.substring(0, n) : "";
        String string4 = string2 = n > -1 ? string.substring(n + 1) : string;
        if (string3.length() > 0) {
            fileObject2 = FileUtil.createFolder((FileObject)fileObject2, (String)string3);
        }
        return dataObject.createFromTemplate(DataFolder.findFolder((FileObject)fileObject2), string2);
    }

    private boolean hasParentAmongNodes(Node[] nodeArray, int n) {
        for (Node node = nodeArray[n].getParentNode(); null != node; node = node.getParentNode()) {
            for (int i = 0; i < nodeArray.length; ++i) {
                if (i == n || node != nodeArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    private static void save(DataObject dataObject) throws IOException {
        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
        if (null != saveCookie) {
            saveCookie.save();
        }
    }

    private static String getCreatingMsg(String string) {
        String string2 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"FMT_generator_status_creating");
        return MessageFormat.format(string2, string);
    }

    private static String getScanningMsg(String string) {
        String string2 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"FMT_generator_status_scanning");
        return MessageFormat.format(string2, string);
    }

    private static String getIgnoringMsg(String string, String string2) {
        String string3 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"FMT_generator_status_ignoring");
        return MessageFormat.format(string3, string);
    }

    static {
        $assertionsDisabled = !CreateTestAction.class.desiredAssertionStatus();
    }

    public static class CreationResults {
        public static final CreationResults EMPTY = new CreationResults();
        Set created;
        Set skipped;
        boolean abborted = false;

        public CreationResults() {
            this(20);
        }

        public CreationResults(int n) {
            this.created = new HashSet(n * 2, 0.5f);
            this.skipped = new HashSet(n * 2, 0.5f);
        }

        public void setAbborted() {
            this.abborted = true;
        }

        public boolean isAbborted() {
            return this.abborted;
        }

        public boolean addCreated(DataObject dataObject) {
            return this.created.add(dataObject);
        }

        public boolean addSkipped(JavaClass javaClass, TestCreator.TesteableResult testeableResult) {
            return this.skipped.add(new SkippedClass(javaClass, testeableResult));
        }

        public Set getSkipped() {
            return this.skipped;
        }

        public Set getCreated() {
            return this.created;
        }

        public void combine(CreationResults creationResults) {
            if (creationResults.abborted) {
                this.abborted = true;
            }
            this.created.addAll(creationResults.created);
            this.skipped.addAll(creationResults.skipped);
        }

        public static final class SkippedClass {
            public final JavaClass cls;
            public final TestCreator.TesteableResult reason;

            public SkippedClass(JavaClass javaClass, TestCreator.TesteableResult testeableResult) {
                this.cls = javaClass;
                this.reason = testeableResult;
            }
        }
    }

    public static final class CreationError
    extends Exception {
        public CreationError() {
        }

        public CreationError(Throwable throwable) {
            super(throwable);
        }
    }
}

