/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.junit.NamedObject;
import org.netbeans.modules.junit.SizeRestrictedPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public final class GuiUtils {
    public static final String TEMPLATES_DIR = "Templates/JUnit";
    public static final String CHK_PUBLIC = "Public";
    public static final String CHK_PROTECTED = "Protected";
    public static final String CHK_PACKAGE = "Package";
    public static final String CHK_PACKAGE_PRIVATE_CLASSES = "PackagePrivateClasses";
    public static final String CHK_ABSTRACT_CLASSES = "AbstractImpl";
    public static final String CHK_EXCEPTION_CLASSES = "Exceptions";
    public static final String CHK_SUITES = "GenerateSuites";
    public static final String CHK_SETUP = "SetUp";
    public static final String CHK_TEARDOWN = "TearDown";
    public static final String CHK_METHOD_BODIES = "Content";
    public static final String CHK_JAVADOC = "JavaDoc";
    public static final String CHK_HINTS = "Comments";

    public static JComboBox createTemplateChooser(String string) {
        JComboBox<Object> jComboBox;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(TEMPLATES_DIR);
        if (fileObject == null) {
            throw new RuntimeException("Not found: Templates/JUnit");
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        ArrayList<NamedObject> arrayList = new ArrayList<NamedObject>(fileObjectArray.length);
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            if (!fileObject2.getExt().equals("java")) continue;
            arrayList.add(new NamedObject(fileObject2, fileObject2.getName()));
            if (n == -1 && string != null && fileObject2.getPath().equals(string)) {
                n = n2;
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            jComboBox = new JComboBox();
        } else {
            jComboBox = new JComboBox<Object>(arrayList.toArray());
            if (n != -1) {
                jComboBox.setSelectedIndex(n);
            }
        }
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public static JCheckBox[] createCheckBoxes(String[] stringArray) {
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArray.length];
        if (jCheckBoxArray.length == 0) {
            return jCheckBoxArray;
        }
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)GuiUtils.class);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) {
                jCheckBoxArray[i] = null;
                continue;
            }
            JCheckBox jCheckBox = new JCheckBox();
            String string2 = "JUnitCfgOfCreate.chk" + string;
            AccessibleContext accessibleContext = jCheckBox.getAccessibleContext();
            Mnemonics.setLocalizedText((AbstractButton)jCheckBox, (String)resourceBundle.getString(string2 + ".text"));
            jCheckBox.setToolTipText(resourceBundle.getString(string2 + ".toolTip"));
            accessibleContext.setAccessibleName(resourceBundle.getString(string2 + ".AN"));
            accessibleContext.setAccessibleDescription(resourceBundle.getString(string2 + ".AD"));
            jCheckBoxArray[i] = jCheckBox;
        }
        return jCheckBoxArray;
    }

    public static JComponent createChkBoxGroup(String string, JCheckBox[] jCheckBoxArray) {
        JComponent jComponent;
        if (jCheckBoxArray.length == 1) {
            jComponent = jCheckBoxArray[0];
        } else {
            jComponent = new JPanel(new GridLayout(0, 1, 0, 5));
            for (int i = 0; i < jCheckBoxArray.length; ++i) {
                jComponent.add(jCheckBoxArray[i]);
            }
        }
        SizeRestrictedPanel sizeRestrictedPanel = new SizeRestrictedPanel(new BorderLayout(), true, true);
        sizeRestrictedPanel.add((Component)new JLabel(string), "North");
        GuiUtils.addBorder(jComponent, BorderFactory.createEmptyBorder(6, 12, 0, 0));
        sizeRestrictedPanel.add((Component)jComponent, "Center");
        return sizeRestrictedPanel;
    }

    public static JComponent createMultilineLabel(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        Color color = UIManager.getColor("Label.background");
        if (color == null) {
            color = UIManager.getColor("Panel.background");
        }
        if (color != null) {
            jTextArea.setBackground(color);
        } else {
            jTextArea.setOpaque(false);
        }
        color = UIManager.getColor("Label.foreground");
        if (color != null) {
            jTextArea.setForeground(color);
        }
        return jTextArea;
    }

    private static void addBorder(JComponent jComponent, Border border) {
        Border border2 = jComponent.getBorder();
        if (border2 == null) {
            jComponent.setBorder(border);
        } else {
            jComponent.setBorder(BorderFactory.createCompoundBorder(border, border2));
        }
    }
}

