/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.EventQueue;
import java.lang.reflect.Method;
import org.netbeans.modules.junit.JUnitProgress;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

class ProgressIndicator {
    private String initialMessage;
    private JUnitProgress progressPanel;
    private boolean guiCreationScheduled;

    ProgressIndicator() {
    }

    synchronized boolean isCanceled() {
        return this.progressPanel != null ? this.progressPanel.isCanceled() : false;
    }

    void displayStatusText(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    synchronized void setMessage(final String string, final boolean bl) {
        if (this.guiCreationScheduled) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ProgressIndicator.this.progressPanel.setMessage(string, bl);
                }
            });
        } else {
            this.initialMessage = string;
        }
    }

    synchronized void show() {
        if (!this.guiCreationScheduled) {
            this.sendToAwtQueue("createAndShowDialog");
            this.guiCreationScheduled = true;
        } else {
            this.sendToAwtQueue("showDialog");
        }
    }

    synchronized void hide() {
        if (this.guiCreationScheduled) {
            this.sendToAwtQueue("hideDialog");
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    synchronized void createAndShowDialog() {
        String string = NbBundle.getMessage((Class)ProgressIndicator.class, (String)"LBL_generator_progress_title");
        this.progressPanel = new JUnitProgress(string);
        if (this.initialMessage != null) {
            this.progressPanel.setMessage(this.initialMessage);
            this.initialMessage = null;
        }
        this.showDialog();
    }

    synchronized void showDialog() {
        this.progressPanel.showMe(true);
    }

    synchronized void hideDialog() {
        this.progressPanel.hideMe();
    }

    private void sendToAwtQueue(String string) {
        Method method;
        try {
            method = this.getClass().getDeclaredMethod(string, new Class[0]);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(65536, (Throwable)exception);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    method.invoke((Object)ProgressIndicator.this, null);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(65536, (Throwable)exception);
                }
            }
        });
    }
}

