/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.actions.CookieAction;

abstract class TestAction
extends CookieAction {
    protected Class[] cookieClasses() {
        return new Class[]{DataFolder.class, SourceCookie.class};
    }

    protected int mode() {
        return 7;
    }

    public boolean asynchronous() {
        return true;
    }

    protected boolean enable(Node[] nodeArray) {
        if (!super.enable(nodeArray)) {
            return false;
        }
        if (nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (TestAction.isEnabledOnNode(nodeArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isEnabledOnNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = null;
        if (dataObject != null) {
            fileObject = dataObject.getPrimaryFile();
        }
        if (fileObject == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        return TestAction.getSourceGroup(fileObject, project) != null;
    }

    private static SourceGroup getSourceGroup(FileObject fileObject, Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject2 = sourceGroupArray[i].getRootFolder();
            if (fileObject != fileObject2 && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) || !sourceGroupArray[i].contains(fileObject)) continue;
            return sourceGroupArray[i];
        }
        return null;
    }
}

