/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestUtil;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class TestCreator {
    private static final String JUNIT_SUPER_CLASS_NAME = "TestCase";
    private static final String JUNIT_FRAMEWORK_PACKAGE_NAME = "junit.framework";
    private static final String METHOD_NAME_SETUP = "setUp";
    private static final String METHOD_NAME_TEARDOWN = "tearDown";
    private static final String CLASS_COMMENT_LINE1 = "TestCreator.javaClass.addTestsHereComment.l1";
    private static final String CLASS_COMMENT_LINE2 = "TestCreator.javaClass.addTestsHereComment.l2";
    private static final String INSTANCE_VAR_NAME = "instance";
    private static final String RESULT_VAR_NAME = "result";
    private static final String EXP_RESULT_VAR_NAME = "expResult";
    private static final String ARTIFICAL_VAR_NAME_BASE = "arg";
    private static final int ACCESS_MODIFIERS = 7;
    private boolean skipTestClasses = true;
    private boolean skipPkgPrivateClasses = false;
    private boolean skipAbstractClasses = false;
    private boolean skipExceptionClasses = false;
    private boolean generateSuiteClasses = true;
    private int methodAccessModifiers = 5;
    private boolean testPkgPrivateMethods = true;
    private boolean generateDefMethodBody = true;
    private boolean generateMethodJavadoc = true;
    private boolean generateSourceCodeHints = true;
    private boolean generateSetUp = true;
    private boolean generateTearDown = true;
    private boolean generateMainMethod = true;
    private String initialMainMethodBody;
    private final Pattern javaIdFullPattern;
    static /* synthetic */ Class class$org$netbeans$jmi$javamodel$Constructor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TestCreator(boolean bl) {
        if (bl) {
            this.loadDefaults();
        }
        this.javaIdFullPattern = Pattern.compile("(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*(?:\\.(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*)*");
    }

    private void loadDefaults() {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        this.skipTestClasses = JUnitSettings.GENERATE_TESTS_FROM_TEST_CLASSES;
        this.skipPkgPrivateClasses = !jUnitSettings.isIncludePackagePrivateClasses();
        this.skipAbstractClasses = !jUnitSettings.isGenerateAbstractImpl();
        this.skipExceptionClasses = !jUnitSettings.isGenerateExceptionClasses();
        this.generateSuiteClasses = jUnitSettings.isGenerateSuiteClasses();
        this.methodAccessModifiers = 0;
        if (jUnitSettings.isMembersPublic()) {
            this.methodAccessModifiers |= 1;
        }
        if (jUnitSettings.isMembersProtected()) {
            this.methodAccessModifiers |= 4;
        }
        this.testPkgPrivateMethods = jUnitSettings.isMembersPackage();
        this.generateDefMethodBody = jUnitSettings.isBodyContent();
        this.generateMethodJavadoc = jUnitSettings.isJavaDoc();
        this.generateSourceCodeHints = jUnitSettings.isBodyComments();
        this.generateSetUp = jUnitSettings.isGenerateSetUp();
        this.generateTearDown = jUnitSettings.isGenerateTearDown();
        this.generateMainMethod = jUnitSettings.isGenerateMainMethod();
    }

    public void setSkipTestClasses(boolean bl) {
        this.skipTestClasses = bl;
    }

    public void setSkipPackagePrivateClasses(boolean bl) {
        this.skipPkgPrivateClasses = bl;
    }

    public void setSkipAbstractClasses(boolean bl) {
        this.skipAbstractClasses = bl;
    }

    public void setSkipExceptionClasses(boolean bl) {
        this.skipExceptionClasses = bl;
    }

    public void setGenerateSuiteClasses(boolean bl) {
        this.generateSuiteClasses = bl;
    }

    public void setTestPublicMethods(boolean bl) {
        this.methodAccessModifiers = bl ? (this.methodAccessModifiers |= 1) : (this.methodAccessModifiers &= 0xFFFFFFFE);
    }

    public void setTestProtectedMethods(boolean bl) {
        this.methodAccessModifiers = bl ? (this.methodAccessModifiers |= 4) : (this.methodAccessModifiers &= 0xFFFFFFFB);
    }

    public void setTestPackagePrivateMethods(boolean bl) {
        this.testPkgPrivateMethods = bl;
    }

    public void setGenerateDefMethodBody(boolean bl) {
        this.generateDefMethodBody = bl;
    }

    public void setGenerateMethodJavadoc(boolean bl) {
        this.generateMethodJavadoc = bl;
    }

    public void setGenerateMethodBodyComment(boolean bl) {
        this.generateSourceCodeHints = bl;
    }

    public void setGenerateSetUp(boolean bl) {
        this.generateSetUp = bl;
    }

    public void setGenerateTearDown(boolean bl) {
        this.generateTearDown = bl;
    }

    public void setGenerateMainMethod(boolean bl) {
        this.generateMainMethod = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestClass(Resource resource, JavaClass javaClass, Resource resource2, JavaClass javaClass2) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            new SingleResourceTestCreator(resource, resource2).createTest(javaClass, javaClass2);
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestSuite(List list, String string, JavaClass javaClass) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            new SingleResourceTestCreator(null, javaClass.getResource()).createTestSuite(list, string, javaClass);
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmptyTest(Resource resource, JavaClass javaClass) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            new SingleResourceTestCreator(null, resource).createEmptyTest(javaClass);
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        if (this.generateSourceCodeHints) {
            JavaModel.getJavaRepository().beginTrans(true);
            try {
                TestCreator.addClassBodyComment(javaClass);
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TesteableResult isClassTestable(JavaClass javaClass) {
        if (!$assertionsDisabled && javaClass == null) {
            throw new AssertionError();
        }
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            Object object;
            TesteableResult testeableResult = this.isClassTestableSingle(javaClass);
            if (testeableResult.isTesteable()) {
                TesteableResult testeableResult2 = TesteableResult.OK;
                return testeableResult2;
            }
            List list = TestUtil.collectFeatures(javaClass, JavaClass.class, 0, true);
            if (list.isEmpty()) {
                TesteableResult testeableResult3 = testeableResult;
                return testeableResult3;
            }
            ArrayList arrayList = new ArrayList(Math.max(10, list.size()));
            arrayList.addAll(list);
            int n = arrayList.size();
            HashSet<JavaClass> hashSet = new HashSet<JavaClass>(64);
            hashSet.add(javaClass);
            do {
                if (!hashSet.add((JavaClass)(object = (JavaClass)arrayList.remove(--n)))) continue;
                TesteableResult testeableResult4 = this.isClassTestableSingle((JavaClass)object);
                if (testeableResult4.isTesteable()) {
                    TesteableResult testeableResult5 = TesteableResult.OK;
                    return testeableResult5;
                }
                testeableResult = TesteableResult.combine(testeableResult, testeableResult4);
                list = TestUtil.collectFeatures(object, class$org$netbeans$jmi$javamodel$JavaClass == null ? TestCreator.class$("org.netbeans.jmi.javamodel.JavaClass") : class$org$netbeans$jmi$javamodel$JavaClass, 0, true);
                if (list.isEmpty()) continue;
                arrayList.addAll(list);
                n = arrayList.size();
            } while (n != 0);
            object = testeableResult;
            return object;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    private TesteableResult isClassTestableSingle(JavaClass javaClass) {
        if (!$assertionsDisabled && javaClass == null) {
            throw new AssertionError();
        }
        TesteableResult testeableResult = TesteableResult.OK;
        int n = javaClass.getModifiers();
        if (Modifier.isPrivate(n)) {
            testeableResult = TesteableResult.combine(testeableResult, TesteableResult.PRIVATE_CLASS);
        }
        if (this.skipTestClasses && TestUtil.isClassImplementingTestInterface(javaClass)) {
            testeableResult = TesteableResult.combine(testeableResult, TesteableResult.TEST_CLASS);
        }
        if (this.skipPkgPrivateClasses && !Modifier.isPublic(n) && !Modifier.isPrivate(n)) {
            testeableResult = TesteableResult.combine(testeableResult, TesteableResult.PACKAGE_PRIVATE_CLASS);
        }
        if (this.skipAbstractClasses && Modifier.isAbstract(n)) {
            testeableResult = TesteableResult.combine(testeableResult, TesteableResult.ABSTRACT_CLASS);
        }
        if (!Modifier.isStatic(n) && javaClass.isInner()) {
            testeableResult = TesteableResult.combine(testeableResult, TesteableResult.NONSTATIC_INNER_CLASS);
        }
        if (!this.hasTestableMethods(javaClass)) {
            testeableResult = TesteableResult.combine(testeableResult, TesteableResult.NO_TESTEABLE_METHODS);
        }
        if (this.skipExceptionClasses && TestUtil.isClassException(javaClass)) {
            testeableResult = TesteableResult.combine(testeableResult, TesteableResult.EXCEPTION_CLASS);
        }
        return testeableResult;
    }

    private static boolean hasSuiteMethod(JavaClass javaClass) {
        return javaClass.getMethod("suite", Collections.EMPTY_LIST, false) != null;
    }

    private static String createTestMethodName(String string) {
        return "test" + string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static String getDefaultValue(Type type) {
        String string = type.getName();
        if (string.equals("void")) {
            return null;
        }
        if (string.equals("int")) {
            return "0";
        }
        if (string.equals("float")) {
            return "0.0F";
        }
        if (string.equals("long")) {
            return "0L";
        }
        if (string.equals("double")) {
            return "0.0";
        }
        if (string.equals("boolean")) {
            return "true";
        }
        if (string.equals("java.lang.String")) {
            return "\"\"";
        }
        if (string.equals("short")) {
            return "0";
        }
        if (string.equals("byte")) {
            return "0";
        }
        if (string.equals("char")) {
            return "' '";
        }
        if (!$assertionsDisabled && type instanceof PrimitiveType) {
            throw new AssertionError();
        }
        return "null";
    }

    private static String[] getTestSkeletonVarNames(List list) {
        String string;
        int n;
        if (list.isEmpty()) {
            return new String[0];
        }
        int n2 = list.size();
        String[] stringArray = new String[n2];
        boolean[] blArray = new boolean[n2];
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>((int)((double)(n2 + 2) * 1.4));
        hashSet.add(INSTANCE_VAR_NAME);
        hashSet.add(RESULT_VAR_NAME);
        hashSet.add(EXP_RESULT_VAR_NAME);
        Iterator iterator = list.iterator();
        for (n = 0; n < n2; ++n) {
            stringArray[n] = string = ((Parameter)iterator.next()).getName();
            if (string == null) {
                bl = true;
                continue;
            }
            if (!hashSet.add(string)) {
                blArray[n] = true;
                bl = true;
                continue;
            }
            blArray[n] = false;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                if (stringArray[n] == null) {
                    string = ARTIFICAL_VAR_NAME_BASE + n;
                    if (hashSet.add(string)) {
                        stringArray[n] = string;
                        continue;
                    }
                    blArray[n] = true;
                }
                if (!blArray[n]) continue;
                String string2 = stringArray[n] + '_';
                int n3 = 2;
                while (!hashSet.add(string = string2 + n3++)) {
                }
                stringArray[n] = string;
            }
        }
        return stringArray;
    }

    private static boolean hasInitMethod(JavaClass javaClass, String string) {
        return javaClass.getMethod(string, Collections.EMPTY_LIST, false) != null;
    }

    private static String getParameterString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(parameter.getName());
        }
        return stringBuffer.toString();
    }

    private static void addClassBodyComment(JavaClass javaClass) {
        int n = javaClass.getEndOffset() - 1;
        String string = NbBundle.getMessage((Class)TestCreator.class, (String)CLASS_COMMENT_LINE1);
        String string2 = NbBundle.getMessage((Class)TestCreator.class, (String)CLASS_COMMENT_LINE2);
        String string3 = TestCreator.getIndentString();
        DiffElement diffElement = new DiffElement(n, n, string3 + string + '\n' + string3 + string2 + '\n' + '\n');
        ((ResourceImpl)javaClass.getResource()).addExtDiff(diffElement);
    }

    private static String getIndentString() {
        String string;
        int n = MetadataElement.getIndentSpace();
        if (n < 0) {
            n = 0;
        }
        if (MetadataElement.isExpandTab()) {
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            string = new String(cArray);
        } else {
            string = "\t";
        }
        return string;
    }

    private boolean hasTestableMethods(JavaClass javaClass) {
        Iterator iterator = TestUtil.collectFeatures(javaClass, Method.class, 0, true).iterator();
        while (iterator.hasNext()) {
            if (!this.isMethodAcceptable((Method)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodAcceptable(Method method) {
        int n = method.getModifiers();
        return (n & this.methodAccessModifiers) != 0 || this.testPkgPrivateMethods && (n & 7) == 0;
    }

    private String getInitialMainMethodBody() {
        if (this.initialMainMethodBody == null) {
            this.initialMainMethodBody = JUnitSettings.getDefault().getGenerateMainMethodBody();
            if (this.initialMainMethodBody == null) {
                this.initialMainMethodBody = "";
            }
        }
        return this.initialMainMethodBody;
    }

    static {
        $assertionsDisabled = !TestCreator.class.desiredAssertionStatus();
    }

    public static final class TesteableResult {
        private long reason;
        public static final TesteableResult OK = new TesteableResult(0L);
        public static final TesteableResult PACKAGE_PRIVATE_CLASS = new TesteableResult(1L);
        public static final TesteableResult NO_TESTEABLE_METHODS = new TesteableResult(2L);
        public static final TesteableResult TEST_CLASS = new TesteableResult(4L);
        public static final TesteableResult ABSTRACT_CLASS = new TesteableResult(8L);
        public static final TesteableResult NONSTATIC_INNER_CLASS = new TesteableResult(16L);
        public static final TesteableResult EXCEPTION_CLASS = new TesteableResult(32L);
        public static final TesteableResult PRIVATE_CLASS = new TesteableResult(64L);
        private static final String[] reasonBundleKeys = new String[]{"TesteableResult_PkgPrivate", "TesteableResult_NoTesteableMethods", "TesteableResult_TestClass", "TesteableResult_AbstractClass", "TesteableResult_NonstaticInnerClass", "TesteableResult_ExceptionClass", "TesteableResult_Private"};

        private TesteableResult(long l) {
            this.reason = l;
        }

        public static TesteableResult combine(TesteableResult testeableResult, TesteableResult testeableResult2) {
            return new TesteableResult(testeableResult.reason | testeableResult2.reason);
        }

        public boolean isTesteable() {
            return this.reason == 0L;
        }

        public boolean isFailed() {
            return this.reason != 0L;
        }

        public String getReason() {
            return this.getReason(", ", ", ");
        }

        public String toString() {
            return this.getReason(", ", ", ");
        }

        public String getReason(String string, String string2) {
            try {
                ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$junit$TestCreator == null ? (class$org$netbeans$modules$junit$TestCreator = TestCreator.class$("org.netbeans.modules.junit.TestCreator")) : class$org$netbeans$modules$junit$TestCreator));
                if (this.reason == 0L) {
                    return resourceBundle.getString("TesteableResult_OK");
                }
                String string3 = "";
                boolean bl = true;
                long l = 0L;
                long l2 = this.reason;
                while (l2 > 0L) {
                    if ((l2 & 1L) != 0L) {
                        if (string3.length() > 0) {
                            if (bl) {
                                string3 = string2 + string3;
                                bl = false;
                            } else {
                                string3 = string + string3;
                            }
                        }
                        string3 = resourceBundle.getString(reasonBundleKeys[(int)l]) + string3;
                    }
                    l2 >>= 1;
                    ++l;
                }
                return string3;
            }
            catch (MissingResourceException missingResourceException) {
                ErrorManager.getDefault().notify((Throwable)missingResourceException);
                return "";
            }
        }
    }

    final class SingleResourceTestCreator {
        private final Resource srcRc;
        private final Resource tstRc;
        private final JavaModelPackage tgtPkg;
        private final String tstPkgNameDot;
        private final List tstImports;
        private Map clsNames;
        private Collection simpleImports;
        private Collection importedClsTypes;
        private ClassDefinition runtimeException;
        static final /* synthetic */ boolean $assertionsDisabled;

        SingleResourceTestCreator(Resource resource, Resource resource2) {
            this.srcRc = resource;
            this.tstRc = resource2;
            this.tgtPkg = (JavaModelPackage)resource2.refImmediatePackage();
            this.tstPkgNameDot = resource2.getPackageName() + '.';
            this.tstImports = resource2.getImports();
            this.clsNames = new HashMap(20);
        }

        void createTest(JavaClass javaClass, JavaClass javaClass2) {
            this.tstRc.setPackageName(this.srcRc.getPackageName());
            this.addFrameworkImport();
            this.copySourceImports();
            this.fillTestClass(javaClass, javaClass2);
            if (TestCreator.this.generateMainMethod && !TestUtil.hasMainMethod(javaClass2)) {
                this.addMainMethod(javaClass2);
            }
        }

        void createEmptyTest(JavaClass javaClass) {
            this.addFrameworkImport();
            this.fillGeneral(javaClass);
        }

        void createTestSuite(List list, String string, JavaClass javaClass) {
            this.tstRc.setPackageName(string);
            this.addFrameworkImport();
            this.fillSuiteClass(list, string, javaClass);
            if (TestCreator.this.generateMainMethod && !TestUtil.hasMainMethod(javaClass)) {
                this.addMainMethod(javaClass);
            }
        }

        private void addFrameworkImport() {
            Iterator iterator = this.tstRc.getImports().iterator();
            while (iterator.hasNext()) {
                Import import_ = (Import)iterator.next();
                if (!import_.getName().equals(TestCreator.JUNIT_FRAMEWORK_PACKAGE_NAME) || !import_.isOnDemand() || import_.isStatic()) continue;
                return;
            }
            this.tstRc.getImports().add(this.tgtPkg.getImport().createImport(TestCreator.JUNIT_FRAMEWORK_PACKAGE_NAME, null, false, true));
        }

        private void copySourceImports() {
            List list = this.srcRc.getImports();
            List list2 = this.tstRc.getImports();
            HashSet<ImpEq> hashSet = new HashSet<ImpEq>((int)((float)list2.size() * 1.4f));
            ImportClass importClass = list2.iterator();
            while (importClass.hasNext()) {
                hashSet.add(new ImpEq((Import)importClass.next()));
            }
            importClass = this.tgtPkg.getImport();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Import import_ = (Import)iterator.next();
                if (hashSet.contains(new ImpEq(import_))) continue;
                list2.add(importClass.createImport(import_.getName(), null, import_.isStatic(), import_.isOnDemand()));
            }
        }

        private void addMainMethod(JavaClass javaClass) {
            Method method = this.createMainMethod();
            if (method != null) {
                javaClass.getFeatures().add(method);
            }
        }

        private void fillTestClass(JavaClass javaClass, JavaClass javaClass2) {
            JavaClass javaClass3;
            String string;
            Object object;
            this.fillGeneral(javaClass2);
            List list = TestUtil.filterFeatures(javaClass, class$org$netbeans$jmi$javamodel$JavaClass == null ? (class$org$netbeans$jmi$javamodel$JavaClass = TestCreator.class$("org.netbeans.jmi.javamodel.JavaClass")) : class$org$netbeans$jmi$javamodel$JavaClass);
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                object = (JavaClass)object2.next();
                if (!TestCreator.this.isClassTestable((JavaClass)object).isTesteable()) continue;
                string = TestUtil.getTestClassName(object.getSimpleName());
                javaClass3 = TestUtil.getClassBySimpleName(javaClass2, string);
                if (javaClass3 == null) {
                    javaClass3 = this.tgtPkg.getJavaClass().createJavaClass();
                    javaClass3.setSimpleName(javaClass2.getName() + '.' + string);
                    javaClass2.getFeatures().add(javaClass3);
                }
                this.fillTestClass((JavaClass)object, javaClass3);
                javaClass3.setModifiers(javaClass3.getModifiers() | 8);
            }
            if (TestCreator.this.generateSuiteClasses && !TestCreator.hasSuiteMethod(javaClass2)) {
                javaClass2.getFeatures().add(this.createTestClassSuiteMethod(javaClass2));
            }
            object2 = TestUtil.filterFeatures(javaClass, class$org$netbeans$jmi$javamodel$Method == null ? (class$org$netbeans$jmi$javamodel$Method = TestCreator.class$("org.netbeans.jmi.javamodel.Method")) : class$org$netbeans$jmi$javamodel$Method);
            object = object2.iterator();
            while (object.hasNext()) {
                string = (Method)object.next();
                if (!TestCreator.this.isMethodAcceptable((Method)string) || javaClass2.getMethod(TestCreator.createTestMethodName(string.getName()), Collections.EMPTY_LIST, false) != null) continue;
                javaClass3 = this.createTestMethod(javaClass, (Method)string);
                javaClass2.getFeatures().add(javaClass3);
            }
            if (!TestCreator.this.skipAbstractClasses && (Modifier.isAbstract(javaClass.getModifiers()) || javaClass.isInterface())) {
                this.createAbstractImpl(javaClass, javaClass2);
            }
        }

        private void fillSuiteClass(List list, String string, JavaClass javaClass) {
            this.fillGeneral(javaClass);
            Method method = javaClass.getMethod("suite", Collections.EMPTY_LIST, false);
            javaClass.getFeatures().remove(method);
            method = this.createSuiteMethod(javaClass, list);
            javaClass.getFeatures().add(method);
        }

        private void fillGeneral(JavaClass javaClass) {
            javaClass.setSuperClassName(this.tgtPkg.getMultipartId().createMultipartId(TestCreator.JUNIT_SUPER_CLASS_NAME, null, Collections.EMPTY_LIST));
            javaClass.setModifiers(1);
            List<Type> list = Collections.singletonList(this.tgtPkg.getType().resolve("java.lang.String"));
            if (javaClass.getConstructor(list, false) == null) {
                javaClass.getFeatures().add(this.createTestConstructor(javaClass.getSimpleName()));
            }
            if (TestCreator.this.generateSetUp && !TestCreator.hasInitMethod(javaClass, TestCreator.METHOD_NAME_SETUP)) {
                javaClass.getFeatures().add(this.createInitMethod(TestCreator.METHOD_NAME_SETUP));
            }
            if (TestCreator.this.generateTearDown && !TestCreator.hasInitMethod(javaClass, TestCreator.METHOD_NAME_TEARDOWN)) {
                javaClass.getFeatures().add(this.createInitMethod(TestCreator.METHOD_NAME_TEARDOWN));
            }
        }

        private Constructor createTestConstructor(String string) {
            Constructor constructor = this.tgtPkg.getConstructor().createConstructor(string, Collections.EMPTY_LIST, 1, null, null, null, "super(testName);\n", Collections.EMPTY_LIST, this.createTestConstructorParams(), null);
            return constructor;
        }

        private List createTestConstructorParams() {
            Parameter parameter = this.tgtPkg.getParameter().createParameter("testName", Collections.EMPTY_LIST, false, TestUtil.getTypeReference(this.tgtPkg, "String"), 0, false);
            return Collections.singletonList(parameter);
        }

        private Method createTestClassSuiteMethod(JavaClass javaClass) {
            StringBuffer stringBuffer = new StringBuffer(1024);
            stringBuffer.append("TestSuite suite = new TestSuite(");
            stringBuffer.append(javaClass.getSimpleName());
            stringBuffer.append(".class);\n");
            List list = TestUtil.filterFeatures(javaClass, class$org$netbeans$jmi$javamodel$JavaClass == null ? (class$org$netbeans$jmi$javamodel$JavaClass = TestCreator.class$("org.netbeans.jmi.javamodel.JavaClass")) : class$org$netbeans$jmi$javamodel$JavaClass);
            Method method = list.iterator();
            while (method.hasNext()) {
                JavaClass javaClass2 = (JavaClass)method.next();
                if (!TestUtil.isClassTest(javaClass2)) continue;
                stringBuffer.append("suite.addTest(");
                stringBuffer.append(javaClass2.getSimpleName());
                stringBuffer.append(".suite());\n");
            }
            stringBuffer.append("\nreturn suite;\n");
            method = this.createPublicNoargMethod(null, true, "Test", "suite", stringBuffer.toString());
            return method;
        }

        private Method createTestMethod(JavaClass javaClass, Method method) {
            JavaClass javaClass2;
            Object object;
            String string = TestCreator.createTestMethodName(method.getName());
            String string2 = TestCreator.this.generateMethodJavadoc ? this.generateJavadoc(javaClass, method) : null;
            String string3 = this.generateMethodBody(javaClass, method);
            boolean bl = false;
            List list = method.getExceptions();
            if (!list.isEmpty()) {
                object = list.iterator();
                while (object.hasNext()) {
                    javaClass2 = (JavaClass)object.next();
                    if (javaClass2.isSubTypeOf(this.getRuntimeException())) continue;
                    bl = true;
                    break;
                }
            }
            object = bl ? Collections.singletonList(this.tgtPkg.getMultipartId().createMultipartId("Exception", null, Collections.EMPTY_LIST)) : Collections.EMPTY_LIST;
            javaClass2 = this.tgtPkg.getMethod().createMethod(string, Collections.EMPTY_LIST, 1, string2, null, null, string3, Collections.EMPTY_LIST, Collections.EMPTY_LIST, (List)object, TestUtil.getTypeReference(this.tgtPkg, "void"), 0);
            return javaClass2;
        }

        private Method createSuiteMethod(JavaClass javaClass, List list) {
            String string = "suite";
            String string2 = TestCreator.this.generateSourceCodeHints ? NbBundle.getMessage((Class)(class$org$netbeans$modules$junit$TestCreator == null ? (class$org$netbeans$modules$junit$TestCreator = TestCreator.class$("org.netbeans.modules.junit.TestCreator")) : class$org$netbeans$modules$junit$TestCreator), (String)"TestCreator.suiteMethod.JavaDoc.comment") : null;
            String string3 = this.generateSuiteBody(javaClass, list);
            Method method = this.createPublicNoargMethod(string2, true, "Test", string, string3);
            return method;
        }

        private Method createInitMethod(String string) {
            Method method = this.tgtPkg.getMethod().createMethod(string, Collections.EMPTY_LIST, 4, null, null, null, "\n", Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.singletonList(TestUtil.getTypeReference(this.tgtPkg, "Exception")), TestUtil.getTypeReference(this.tgtPkg, "void"), 0);
            return method;
        }

        private Method createMainMethod() {
            String string = TestCreator.this.getInitialMainMethodBody();
            if (string.length() == 0) {
                return null;
            }
            String string2 = '\n' + string + '\n';
            Array array = this.tgtPkg.getArray().resolveArray(TestUtil.getStringType(this.tgtPkg));
            Parameter parameter = this.tgtPkg.getParameter().createParameter("argList", Collections.EMPTY_LIST, false, null, 0, false);
            parameter.setType((Type)array);
            Method method = this.tgtPkg.getMethod().createMethod("main", Collections.EMPTY_LIST, 9, null, null, null, string2, Collections.EMPTY_LIST, Collections.singletonList(parameter), Collections.EMPTY_LIST, TestUtil.getTypeReference(this.tgtPkg, "void"), 0);
            return method;
        }

        private Method createPublicNoargMethod(String string, boolean bl, String string2, String string3, String string4) {
            return this.tgtPkg.getMethod().createMethod(string3, Collections.EMPTY_LIST, bl ? 9 : 1, string, null, null, string4, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, TestUtil.getTypeReference(this.tgtPkg, string2), 0);
        }

        private void createAbstractImpl(JavaClass javaClass, JavaClass javaClass2) {
            MultipartId multipartId;
            Object object;
            String string = javaClass.getSimpleName() + "Impl";
            JavaClass javaClass3 = javaClass2.getInnerClass(string, false);
            if (javaClass3 == null) {
                object = TestCreator.this.generateMethodJavadoc ? (object = NbBundle.getMessage((Class)(class$org$netbeans$modules$junit$TestCreator == null ? (class$org$netbeans$modules$junit$TestCreator = TestCreator.class$("org.netbeans.modules.junit.TestCreator")) : class$org$netbeans$modules$junit$TestCreator), (String)"TestCreator.abstracImpl.JavaDoc.comment", (Object)javaClass.getName())) : null;
                multipartId = this.tgtPkg.getMultipartId().createMultipartId(javaClass.isInner() ? javaClass.getName() : javaClass.getSimpleName(), null, Collections.EMPTY_LIST);
                javaClass3 = this.tgtPkg.getJavaClass().createJavaClass(string, Collections.EMPTY_LIST, 2, (String)object, null, Collections.EMPTY_LIST, null, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
                if (javaClass.isInterface()) {
                    javaClass3.getInterfaceNames().add(multipartId);
                } else {
                    javaClass3.setSuperClassName(multipartId);
                }
                this.createImpleConstructors(javaClass, javaClass3);
                javaClass2.getFeatures().add(javaClass3);
            }
            object = TestUtil.collectFeatures(javaClass, class$org$netbeans$jmi$javamodel$Method == null ? (class$org$netbeans$jmi$javamodel$Method = TestCreator.class$("org.netbeans.jmi.javamodel.Method")) : class$org$netbeans$jmi$javamodel$Method, 1024, true);
            multipartId = object.iterator();
            while (multipartId.hasNext()) {
                Method method = (Method)multipartId.next();
                if (javaClass3.getMethod(method.getName(), TestUtil.getParameterTypes(method.getParameters()), false) != null) continue;
                Method method2 = this.createMethodImpl(method);
                javaClass3.getFeatures().add(method2);
            }
        }

        private void createImpleConstructors(JavaClass javaClass, JavaClass javaClass2) {
            List list = TestUtil.filterFeatures(javaClass, class$org$netbeans$jmi$javamodel$Constructor == null ? (class$org$netbeans$jmi$javamodel$Constructor = TestCreator.class$("org.netbeans.jmi.javamodel.Constructor")) : class$org$netbeans$jmi$javamodel$Constructor);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Constructor constructor = (Constructor)iterator.next();
                if (Modifier.isPrivate(constructor.getModifiers())) continue;
                Constructor constructor2 = this.tgtPkg.getConstructor().createConstructor();
                constructor2.setBodyText("super(" + TestCreator.getParameterString(constructor.getParameters()) + ");\n");
                constructor2.getParameters().addAll(TestUtil.cloneParams(constructor.getParameters(), this.tgtPkg));
                javaClass2.getFeatures().add(constructor2);
            }
        }

        private Method createMethodImpl(Method method) {
            Method method2 = this.tgtPkg.getMethod().createMethod();
            method2.setName(method.getName());
            int n = method.getModifiers() & 0xFFFFFBFF;
            if (((JavaClass)method.getDeclaringClass()).isInterface()) {
                n |= 1;
            }
            method2.setModifiers(n);
            StringBuffer stringBuffer = new StringBuffer(200);
            if (TestCreator.this.generateSourceCodeHints) {
                stringBuffer.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$junit$TestCreator == null ? (class$org$netbeans$modules$junit$TestCreator = TestCreator.class$("org.netbeans.modules.junit.TestCreator")) : class$org$netbeans$modules$junit$TestCreator), (String)"TestCreator.methodImpl.bodyComment"));
                stringBuffer.append("\n\n");
            }
            method2.setType(method.getType());
            Type type = method.getType();
            if (type != null) {
                String string = null;
                if (type instanceof JavaClass || type instanceof Array) {
                    string = "null";
                } else if (type instanceof PrimitiveType) {
                    PrimitiveTypeKindEnum primitiveTypeKindEnum = (PrimitiveTypeKindEnum)((PrimitiveType)type).getKind();
                    if (primitiveTypeKindEnum.equals((Object)PrimitiveTypeKindEnum.BOOLEAN)) {
                        string = "false";
                    } else if (!primitiveTypeKindEnum.equals((Object)PrimitiveTypeKindEnum.VOID)) {
                        string = "0";
                    }
                }
                if (string != null) {
                    stringBuffer.append("return ").append(string).append(";\n");
                }
            }
            method2.setBodyText(stringBuffer.toString());
            method2.getParameters().addAll(TestUtil.cloneParams(method.getParameters(), this.tgtPkg));
            return method2;
        }

        private String generateJavadoc(JavaClass javaClass, Method method) {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$junit$TestCreator == null ? (class$org$netbeans$modules$junit$TestCreator = TestCreator.class$("org.netbeans.modules.junit.TestCreator")) : class$org$netbeans$modules$junit$TestCreator), (String)"TestCreator.variantMethods.JavaDoc.comment", (Object)method.getName(), (Object)javaClass.getName());
        }

        private String generateMethodBody(JavaClass javaClass, Method method) {
            boolean bl = (method.getModifiers() & 8) != 0;
            String string = this.getTypeNameString((Type)javaClass);
            StringBuffer stringBuffer = new StringBuffer(512);
            boolean bl2 = false;
            if (TestCreator.this.generateDefMethodBody) {
                boolean bl3;
                Object object;
                Object object2;
                int n;
                stringBuffer.append("System.out.println(\"").append(method.getName()).append("\");\n\n");
                List list = method.getParameters();
                String[] stringArray = TestCreator.getTestSkeletonVarNames(list);
                Iterator iterator = list.iterator();
                for (n = 0; n < stringArray.length; ++n) {
                    object2 = (Parameter)iterator.next();
                    Type type = object2.getType();
                    object = this.getTypeNameString(type);
                    stringBuffer.append((String)object).append(' ').append(stringArray[n]).append(" = ").append(TestCreator.getDefaultValue(type)).append(";\n");
                }
                if (!$assertionsDisabled && iterator.hasNext()) {
                    throw new AssertionError();
                }
                bl2 |= stringArray.length != 0;
                if (!bl) {
                    n = 0;
                    object2 = javaClass.getConstructor(Collections.EMPTY_LIST, false);
                    if (object2 == null) {
                        boolean bl4 = false;
                        object = javaClass.getContents().iterator();
                        while (object.hasNext()) {
                            if (!(object.next() instanceof Constructor)) continue;
                            bl4 = true;
                            break;
                        }
                        n = !bl4 ? 1 : 0;
                    } else {
                        n = (object2.getModifiers() & 2) == 0 ? 1 : 0;
                    }
                    stringBuffer.append(string).append(' ').append(TestCreator.INSTANCE_VAR_NAME).append(" = ");
                    if (n != 0) {
                        stringBuffer.append("new ").append(string).append("()");
                    } else {
                        stringBuffer.append("null");
                    }
                    stringBuffer.append(";\n");
                    bl2 |= true;
                }
                if (bl2) {
                    stringBuffer.append('\n');
                    bl2 = false;
                }
                Type type = method.getType();
                object2 = this.getTypeNameString(type);
                String string2 = TestCreator.getDefaultValue(type);
                boolean bl5 = bl3 = string2 == null;
                if (!bl3) {
                    stringBuffer.append((String)object2).append(' ').append(TestCreator.EXP_RESULT_VAR_NAME).append(" = ").append(string2).append(";\n");
                    stringBuffer.append((String)object2).append(' ').append(TestCreator.RESULT_VAR_NAME).append(" = ");
                }
                stringBuffer.append(bl ? string : TestCreator.INSTANCE_VAR_NAME).append('.').append(method.getName()).append('(');
                if (stringArray.length != 0) {
                    stringBuffer.append(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuffer.append(", ").append(stringArray[i]);
                    }
                }
                stringBuffer.append(");\n");
                if (!bl3) {
                    stringBuffer.append("assertEquals(").append(TestCreator.EXP_RESULT_VAR_NAME).append(", ").append(TestCreator.RESULT_VAR_NAME).append(");\n");
                }
                bl2 = true;
            }
            if (TestCreator.this.generateSourceCodeHints) {
                if (bl2) {
                    stringBuffer.append('\n');
                    bl2 = false;
                }
                stringBuffer.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$junit$TestCreator == null ? (class$org$netbeans$modules$junit$TestCreator = TestCreator.class$("org.netbeans.modules.junit.TestCreator")) : class$org$netbeans$modules$junit$TestCreator), (String)(TestCreator.this.generateDefMethodBody ? "TestCreator.variantMethods.defaultComment" : "TestCreator.variantMethods.onlyComment"))).append('\n');
            }
            if (TestCreator.this.generateDefMethodBody) {
                if (bl2) {
                    stringBuffer.append('\n');
                    bl2 = false;
                }
                stringBuffer.append(NbBundle.getMessage((Class)(class$org$netbeans$modules$junit$TestCreator == null ? (class$org$netbeans$modules$junit$TestCreator = TestCreator.class$("org.netbeans.modules.junit.TestCreator")) : class$org$netbeans$modules$junit$TestCreator), (String)"TestCreator.variantMethods.defaultBody")).append('\n');
            }
            return stringBuffer.toString();
        }

        private String generateSuiteBody(JavaClass javaClass, List list) {
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("TestSuite suite = new TestSuite(\"").append(javaClass.getSimpleName()).append("\");\n");
            TypeClass typeClass = this.tgtPkg.getType();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Method method;
                String string = (String)iterator.next();
                Type type = typeClass.resolve(string);
                if (!(type instanceof ClassDefinition) || (method = ((ClassDefinition)type).getMethod("suite", Collections.EMPTY_LIST, true)) == null || !Modifier.isStatic(method.getModifiers())) continue;
                stringBuffer.append("suite.addTest(").append(string).append(".suite());\n");
            }
            stringBuffer.append("return suite;\n");
            return stringBuffer.toString();
        }

        private String getTypeNameString(Type type) {
            if (!(type instanceof ClassDefinition)) {
                return type.getName();
            }
            if (type instanceof Array) {
                return this.getTypeNameString(((Array)type).getType()) + "[]";
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                String string = this.getTypeNameString((Type)parameterizedType.getDefinition());
                List list = parameterizedType.getParameters();
                if (list.isEmpty()) {
                    return string;
                }
                StringBuffer stringBuffer = new StringBuffer(60);
                stringBuffer.append(string).append('<');
                stringBuffer.append(this.getTypeNameString((Type)list.get(0)));
                if (list.size() > 1) {
                    Iterator iterator = list.iterator();
                    iterator.next();
                    do {
                        stringBuffer.append(", ");
                        stringBuffer.append(this.getTypeNameString((Type)iterator.next()));
                    } while (iterator.hasNext());
                }
                stringBuffer.append('>');
                return stringBuffer.toString();
            }
            if (type instanceof AnnotationType) {
                return type.getName();
            }
            if (!(type instanceof JavaClass)) {
                return type.getName();
            }
            String string = type.getName();
            if (!TestCreator.this.javaIdFullPattern.matcher(string).matches()) {
                return type.getName();
            }
            return this.getJavaClassTypeNameString((JavaClass)type, string, string.startsWith("java.lang."), string.startsWith(this.tstPkgNameDot));
        }

        private String getJavaClassTypeNameString(JavaClass javaClass, String string, boolean bl, boolean bl2) {
            ClassDefinition classDefinition;
            String string2;
            if (string == null) {
                string = javaClass.getName();
            }
            if ((string2 = (String)this.clsNames.get(string)) != null) {
                return string2;
            }
            String string3 = javaClass.getSimpleName();
            string2 = bl2 && this.checkIsFromThisPkg(string3, string) || bl && this.checkIsFromJavaLang(string3, string) || this.checkIsImported(javaClass) ? string3 : (javaClass.isInner() ? ((classDefinition = javaClass.getDeclaringClass()) instanceof JavaClass ? this.getJavaClassTypeNameString((JavaClass)classDefinition, null, bl, bl2) + '.' + string3 : string) : string);
            this.clsNames.put(string, string2);
            return string2;
        }

        private boolean checkIsFromThisPkg(String string, String string2) {
            return string2.length() == this.tstPkgNameDot.length() + string.length();
        }

        private boolean checkIsFromJavaLang(String string, String string2) {
            return string2.length() == 10 + string.length();
        }

        private boolean checkIsImported(JavaClass javaClass) {
            if (this.simpleImports == null) {
                this.prepareImports();
            }
            return this.simpleImports.contains(javaClass) || this.importedClsTypes.contains(javaClass);
        }

        private void prepareImports() {
            this.simpleImports = new ArrayList(this.tstImports.size());
            this.importedClsTypes = new ArrayList(20);
            Iterator iterator = this.tstImports.iterator();
            while (iterator.hasNext()) {
                Import import_ = (Import)iterator.next();
                if (import_.isStatic()) continue;
                if (!import_.isOnDemand()) {
                    this.simpleImports.add(import_.getImportedNamespace());
                    continue;
                }
                Collection collection = import_.getImportedElements();
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!(e instanceof JavaClass)) continue;
                    this.importedClsTypes.add(e);
                }
            }
            if (!$assertionsDisabled && !(this.simpleImports instanceof ArrayList)) {
                throw new AssertionError();
            }
            if (this.simpleImports.isEmpty()) {
                this.simpleImports = Collections.EMPTY_LIST;
            } else {
                ((ArrayList)this.simpleImports).trimToSize();
            }
            if (!$assertionsDisabled && !(this.importedClsTypes instanceof ArrayList)) {
                throw new AssertionError();
            }
            if (this.importedClsTypes.isEmpty()) {
                this.importedClsTypes = Collections.EMPTY_LIST;
            } else {
                ((ArrayList)this.importedClsTypes).trimToSize();
            }
        }

        private ClassDefinition getRuntimeException() {
            if (this.runtimeException == null) {
                Type type = this.tgtPkg.getType().resolve("java.lang.RuntimeException");
                this.runtimeException = (ClassDefinition)type;
            }
            if (!$assertionsDisabled && this.runtimeException == null) {
                throw new AssertionError();
            }
            return this.runtimeException;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$junit$TestCreator == null ? (class$org$netbeans$modules$junit$TestCreator = TestCreator.class$("org.netbeans.modules.junit.TestCreator")) : class$org$netbeans$modules$junit$TestCreator).desiredAssertionStatus();
        }
    }

    private static class ImpEq {
        Import imp;

        ImpEq(Import import_) {
            this.imp = import_;
        }

        public boolean equals(Object object) {
            if (object instanceof ImpEq) {
                Import import_ = ((ImpEq)object).imp;
                return import_.isStatic() == this.imp.isStatic() && import_.isOnDemand() == this.imp.isOnDemand() && import_.getName().equals(this.imp.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.imp.getName().hashCode();
        }
    }
}

